/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.procgen.MarkovNames;
import com.fs.starfarer.api.impl.campaign.procgen.NameGenData;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ProcgenUsedNames {
    public static final String KEY = "ProcgenUsedNames_key";
    private Set<String> names = new HashSet<String>();

    public static void notifyUsed(String name) {
        ProcgenUsedNames.getUsed().names.add(name);
    }

    public static boolean isUsed(String name) {
        return ProcgenUsedNames.getUsed().names.contains(name);
    }

    public static ProcgenUsedNames getUsed() {
        Object test = Global.getSector().getPersistentData().get(KEY);
        if (test == null) {
            test = new ProcgenUsedNames();
            Global.getSector().getPersistentData().put(KEY, test);
        }
        return (ProcgenUsedNames)test;
    }

    public static NamePick pickName(String tag, String parent, StarSystemGenerator.LagrangePointType lagrangePoint) {
        NamePick pick;
        WeightedRandomPicker<NamePick> picker = new WeightedRandomPicker<NamePick>(StarSystemGenerator.random);
        Collection<NameGenData> all = Global.getSettings().getAllSpecs(NameGenData.class);
        if (parent != null) {
            for (NameGenData spec : all) {
                if (ProcgenUsedNames.isUsed(spec.getName()) || !spec.hasTag(tag) || parent == null && spec.getName().contains("$parent") || !spec.hasParent(parent)) continue;
                picker.add(new NamePick(spec, spec.getName(), spec.getSecondary()), spec.getFrequency());
            }
        }
        if (picker.isEmpty()) {
            for (NameGenData spec : all) {
                if (ProcgenUsedNames.isUsed(spec.getName()) || !spec.hasTag(tag) || !spec.getParents().isEmpty() || parent == null && spec.getName().contains("$parent")) continue;
                picker.add(new NamePick(spec, spec.getName(), spec.getSecondary()), spec.getFrequency());
            }
        }
        if (picker.isEmpty()) {
            int attempts = 10;
            int i = 0;
            while (i < attempts) {
                MarkovNames.MarkovNameResult name = MarkovNames.generate(picker.getRandom());
                if (name != null && name.name != null && !ProcgenUsedNames.isUsed(name.name)) {
                    NameGenData data = new NameGenData(name.name, null);
                    NamePick pick2 = new NamePick(data, name.name, null);
                    return pick2;
                }
                ++i;
            }
        }
        if (picker.isEmpty()) {
            block3: for (NameGenData obj : all) {
                NameGenData spec = obj;
                if (!spec.hasTag(tag)) continue;
                String base = spec.getName();
                int i = 2;
                while (i < 4000) {
                    String name = String.valueOf(base) + " " + Global.getSettings().getRoman(i);
                    if (!(ProcgenUsedNames.isUsed(name) || parent == null && spec.getName().contains("$parent"))) {
                        String secondary = null;
                        if (spec.getSecondary() != null) {
                            secondary = String.valueOf(spec.getSecondary()) + " " + Global.getSettings().getRoman(i);
                        }
                        picker.add(new NamePick(spec, name, secondary), (4000.0f - (float)i) * spec.getFrequency());
                        continue block3;
                    }
                    ++i;
                }
            }
        }
        if ((pick = (NamePick)picker.pick()) != null) {
            pick.nameWithRomanSuffixIfAny = ProcgenUsedNames.doTokenReplacement(pick.nameWithRomanSuffixIfAny, parent, lagrangePoint);
            if (pick.secondaryWithRomanSuffixIfAny != null) {
                pick.secondaryWithRomanSuffixIfAny = ProcgenUsedNames.doTokenReplacement(pick.secondaryWithRomanSuffixIfAny, parent, lagrangePoint);
            }
        }
        return pick;
    }

    public static String doTokenReplacement(String name, String parent, StarSystemGenerator.LagrangePointType lagrange) {
        if (parent != null) {
            name = name.replaceAll("\\$parent", parent);
            name = name.replaceAll("s's", "s'");
        }
        name = lagrange != null ? name.replaceAll("\\$L", lagrange.name()) : name.replaceAll("\\$L ", "");
        return name;
    }

    public static class NamePick {
        public NameGenData spec;
        public String nameWithRomanSuffixIfAny;
        public String secondaryWithRomanSuffixIfAny;

        public NamePick(NameGenData spec, String nameWithRomanSuffixIfAny, String secondaryWithRomanSuffixIfAny) {
            this.spec = spec;
            this.nameWithRomanSuffixIfAny = nameWithRomanSuffixIfAny;
            this.secondaryWithRomanSuffixIfAny = secondaryWithRomanSuffixIfAny;
        }
    }
}

