/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomProductionPickerDelegateImpl;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.impl.items.ShroudedHullmodItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.ShroudedSubstratePlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.AbyssalLightEntityPlugin;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DwellerCMD
extends BaseCommandPlugin {
    public static String SHROUDED_TENDRIL = "shrouded_tendril";
    public static String SHROUDED_EYE = "shrouded_eye";
    public static String SHROUDED_MAELSTROM = "shrouded_maelstrom";
    public static String SHROUDED_MAW = "shrouded_maw";
    public static ListMap<String> GUARANTEED_FIRST_TIME_ITEMS = new ListMap();
    public static ListMap<String> DROP_GROUPS;

    static {
        GUARANTEED_FIRST_TIME_ITEMS.add(SHROUDED_EYE, "shrouded_lens");
        GUARANTEED_FIRST_TIME_ITEMS.add(SHROUDED_MAELSTROM, "shrouded_thunderhead");
        GUARANTEED_FIRST_TIME_ITEMS.add(SHROUDED_MAW, "shrouded_mantle");
        DROP_GROUPS = new ListMap();
        DROP_GROUPS.add(SHROUDED_EYE, "drops_shrouded_eye");
        DROP_GROUPS.add(SHROUDED_MAELSTROM, "drops_shrouded_maelstrom");
        DROP_GROUPS.add(SHROUDED_MAW, "drops_shrouded_maw");
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        SectorEntityToken entity = dialog.getInteractionTarget();
        long seed = Misc.getSalvageSeed(entity);
        Random random = Misc.getRandom(seed, 11);
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        if ("smallFleet".equals(action)) {
            return this.engageFleet(dialog, memoryMap, memory, DwellerStrength.LOW, random);
        }
        if ("mediumFleet".equals(action)) {
            return this.engageFleet(dialog, memoryMap, memory, DwellerStrength.MEDIUM, random);
        }
        if ("largeFleet".equals(action)) {
            return this.engageFleet(dialog, memoryMap, memory, DwellerStrength.HIGH, random);
        }
        if ("hugeFleet".equals(action)) {
            return this.engageFleet(dialog, memoryMap, memory, DwellerStrength.EXTREME, random);
        }
        if ("showWeaponPicker".equals(action)) {
            this.showWeaponPicker(dialog, memoryMap);
            return true;
        }
        if ("unlockHullmod".equals(action)) {
            this.unlockHullmod(dialog, memoryMap);
            return true;
        }
        return false;
    }

    protected void unlockHullmod(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        String modId = Global.getSector().getPlayerMemoryWithoutUpdate().getString(ShroudedHullmodItemPlugin.SHROUDED_HULLMOD_ID);
        HullModSpecAPI modSpec = Global.getSettings().getHullModSpec(modId);
        Global.getSoundPlayer().playUISound("ui_acquired_hullmod", 1.0f, 1.0f);
        TextPanelAPI text = dialog.getTextPanel();
        text.setFontSmallInsignia();
        String str = modSpec.getDisplayName();
        text.addParagraph("Acquired hull mod: " + str, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
        Global.getSector().getPlayerFaction().addKnownHullMod(modId);
    }

    public static int getSubstrateCost(WeaponSpecAPI spec) {
        if (!spec.hasTag("dweller")) {
            return 0;
        }
        String substrate = "substrate_";
        for (String tag : spec.getTags()) {
            if (!tag.startsWith(substrate)) continue;
            String num = tag.replaceFirst(substrate, "");
            return Integer.parseInt(num);
        }
        return 0;
    }

    protected void showWeaponPicker(final InteractionDialogAPI dialog, final Map<String, MemoryAPI> memoryMap) {
        final int substrate = Global.getSector().getPlayerMemoryWithoutUpdate().getInt(ShroudedSubstratePlugin.SHROUDED_SUBSTRATE_AVAILABLE);
        final LinkedHashSet<String> weapons = new LinkedHashSet<String>();
        for (WeaponSpecAPI spec : Global.getSettings().getAllWeaponSpecs()) {
            int cost = DwellerCMD.getSubstrateCost(spec);
            if (cost <= 0 || cost > substrate) continue;
            weapons.add(spec.getWeaponId());
        }
        dialog.showCustomProductionPicker(new BaseCustomProductionPickerDelegateImpl(){

            @Override
            public Set<String> getAvailableFighters() {
                return new LinkedHashSet<String>();
            }

            @Override
            public Set<String> getAvailableShipHulls() {
                return new LinkedHashSet<String>();
            }

            @Override
            public Set<String> getAvailableWeapons() {
                return weapons;
            }

            @Override
            public float getCostMult() {
                return 1.0f;
            }

            @Override
            public float getMaximumValue() {
                return substrate;
            }

            @Override
            public String getWeaponColumnNameOverride() {
                return "Weapon";
            }

            @Override
            public String getNoMatchingBlueprintsLabelOverride() {
                return "No matching weapons";
            }

            @Override
            public String getMaximumOrderValueLabelOverride() {
                return "Shrouded Substrate available";
            }

            @Override
            public String getCurrentOrderValueLabelOverride() {
                return "Shrouded Substrate required";
            }

            @Override
            public String getItemGoesOverMaxValueStringOverride() {
                return "Not enough Shrouded Substrate";
            }

            @Override
            public String getCustomOrderLabelOverride() {
                return "Weapon assembly";
            }

            @Override
            public String getNoProductionOrdersLabelOverride() {
                return "No assembly orders";
            }

            @Override
            public boolean withQuantityLimits() {
                return false;
            }

            @Override
            public boolean isUseCreditSign() {
                return false;
            }

            @Override
            public int getCostOverride(Object item) {
                if (item instanceof WeaponSpecAPI) {
                    return DwellerCMD.getSubstrateCost((WeaponSpecAPI)item);
                }
                return -1;
            }

            @Override
            public void notifyProductionSelected(FactionProductionAPI production) {
                if (!(dialog.getPlugin() instanceof RuleBasedInteractionDialogPluginImpl)) {
                    return;
                }
                RuleBasedInteractionDialogPluginImpl plugin = (RuleBasedInteractionDialogPluginImpl)dialog.getPlugin();
                if (!(plugin.getCustom1() instanceof SpecialItemPlugin.RightClickActionHelper)) {
                    return;
                }
                SpecialItemPlugin.RightClickActionHelper helper = (SpecialItemPlugin.RightClickActionHelper)plugin.getCustom1();
                int cost = production.getTotalCurrentCost();
                helper.removeFromClickedStackFirst(cost);
                int substrate2 = (int)helper.getNumItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_substrate", null));
                Global.getSector().getPlayerMemoryWithoutUpdate().set(ShroudedSubstratePlugin.SHROUDED_SUBSTRATE_AVAILABLE, substrate2);
                for (FactionProductionAPI.ItemInProductionAPI item : production.getCurrent()) {
                    if (item.getType() != FactionProductionAPI.ProductionItemType.WEAPON) continue;
                    helper.addItems(CargoAPI.CargoItemType.WEAPONS, item.getSpecId(), item.getQuantity());
                    AddRemoveCommodity.addWeaponGainText(item.getSpecId(), item.getQuantity(), dialog.getTextPanel());
                }
                FireBest.fire(null, dialog, memoryMap, "SubstrateWeaponsPicked");
                Global.getSoundPlayer().playUISound("ui_cargo_machinery_drop", 1.0f, 1.0f);
            }
        });
    }

    protected boolean engageFleet(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, MemoryAPI memory, DwellerStrength str, Random random) {
        CampaignFleetAPI fleet = DwellerCMD.createDwellerFleet(str, random);
        if (fleet == null) {
            return false;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        fleet.setContainingLocation(pf.getContainingLocation());
        final SectorEntityToken entity = dialog.getInteractionTarget();
        dialog.setInteractionTarget(fleet);
        Global.getSector().getCampaignUI().restartEncounterMusic(fleet);
        FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
        config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

            @Override
            public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
                    return;
                }
                float mult = context.computePlayerContribFraction();
                CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
                FleetEncounterContextPlugin.DataForEncounterSide data = context.getDataFor(fleet);
                ArrayList<FleetMemberAPI> losses = new ArrayList<FleetMemberAPI>();
                for (FleetEncounterContextPlugin.FleetMemberData fmd : data.getOwnCasualties()) {
                    losses.add(fmd.getMember());
                }
                float min = 0.0f;
                float max = 0.0f;
                boolean gotGuaranteed = false;
                for (FleetMemberAPI member : losses) {
                    if (!member.getHullSpec().hasTag("dweller")) continue;
                    String key = "substrate_";
                    float[] sDrops = Misc.getFloatArray(String.valueOf(key) + member.getHullSpec().getHullId());
                    if (sDrops == null) {
                        sDrops = Misc.getFloatArray(String.valueOf(key) + member.getHullSpec().getHullSize().name());
                    }
                    if (sDrops == null) continue;
                    min += sDrops[0];
                    max += sDrops[1];
                    String hullId = member.getHullSpec().getRestoredToHullId();
                    String defeatedKey = "$defeatedDweller_" + hullId;
                    boolean firstTime = !Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(defeatedKey);
                    Global.getSector().getPlayerMemoryWithoutUpdate().set(defeatedKey, true);
                    if (!firstTime || gotGuaranteed) continue;
                    Object drops = GUARANTEED_FIRST_TIME_ITEMS.get(hullId);
                    Iterator iterator = drops.iterator();
                    while (iterator.hasNext()) {
                        boolean add;
                        String itemId = (String)iterator.next();
                        SpecialItemData sid = new SpecialItemData(itemId, null);
                        boolean bl = add = firstTime && salvage.getQuantity(CargoAPI.CargoItemType.SPECIAL, sid) <= 0.0f;
                        if (!add) continue;
                        salvage.addItems(CargoAPI.CargoItemType.SPECIAL, sid, 1.0f);
                        gotGuaranteed = true;
                    }
                }
                long seed = Misc.getSalvageSeed(entity);
                Random random = Misc.getRandom(seed, 50);
                int substrate = 0;
                if (min + max < 1.0f) {
                    if (random.nextFloat() < (min + max) / 2.0f) {
                        substrate = 1;
                    }
                } else {
                    substrate = Math.round(min + (max - min) * random.nextFloat());
                }
                if (substrate > 0) {
                    salvage.addItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_substrate", null), substrate);
                }
            }

            @Override
            public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                bcc.aiRetreatAllowed = false;
                bcc.fightToTheLast = true;
                bcc.objectivesAllowed = false;
                bcc.enemyDeployAll = true;
                if (entity.getCustomPlugin() instanceof AbyssalLightEntityPlugin) {
                    AbyssalLightEntityPlugin plugin = (AbyssalLightEntityPlugin)entity.getCustomPlugin();
                    plugin.despawn(AbyssalLightEntityPlugin.DespawnType.FADE_OUT);
                }
            }
        };
        config.alwaysAttackVsAttack = true;
        config.alwaysHarry = true;
        config.showTransponderStatus = false;
        config.lootCredits = false;
        config.showCommLinkOption = false;
        config.showEngageText = false;
        config.showFleetAttitude = false;
        config.showTransponderStatus = false;
        config.showWarningDialogWhenNotHostile = false;
        config.impactsAllyReputation = false;
        config.impactsEnemyReputation = false;
        config.pullInAllies = false;
        config.pullInEnemies = false;
        config.pullInStations = false;
        config.showCrRecoveryText = false;
        config.firstTimeEngageOptionText = "\"Battle stations!\"";
        config.afterFirstTimeEngageOptionText = "Move in to re-engage";
        if (str == DwellerStrength.LOW) {
            config.firstTimeEngageOptionText = null;
            config.leaveAlwaysAvailable = true;
        } else {
            config.leaveAlwaysAvailable = true;
            config.noLeaveOptionOnFirstEngagement = true;
        }
        long seed = Misc.getSalvageSeed(entity);
        config.salvageRandom = Misc.getRandom(seed, 75);
        Global.getSector().getPlayerMemoryWithoutUpdate().set("$encounteredDweller", true);
        Global.getSector().getPlayerMemoryWithoutUpdate().set("$encounteredMonster", true);
        Global.getSector().getPlayerMemoryWithoutUpdate().set("$encounteredWeird", true);
        FleetInteractionDialogPluginImpl plugin = new FleetInteractionDialogPluginImpl(config);
        dialog.setPlugin(plugin);
        plugin.init(dialog);
        return true;
    }

    public static CampaignFleetAPI createDwellerFleet(DwellerStrength str, Random random) {
        CampaignFleetAPI f = Global.getFactory().createEmptyFleet("dweller", "Manifestation", true);
        FactionAPI faction = Global.getSector().getFaction("dweller");
        String typeKey = "patrolSmall";
        if (str == DwellerStrength.MEDIUM) {
            typeKey = "patrolMedium";
        }
        if (str == DwellerStrength.HIGH) {
            typeKey = "patrolLarge";
        }
        if (str == DwellerStrength.EXTREME) {
            typeKey = "patrolLarge";
        }
        f.setName(faction.getFleetTypeName(typeKey));
        f.setInflater(null);
        if (str == DwellerStrength.LOW) {
            DwellerCMD.addShips(f, 6, 8, random, "dwellerTendril");
            DwellerCMD.addShips(f, 1, 1, random, "dwellerEye");
            DwellerCMD.addShips(f, 1, 2, random, "dwellerMaelstrom");
        } else if (str == DwellerStrength.MEDIUM) {
            DwellerCMD.addShips(f, 9, 12, random, "dwellerTendril");
            eyes = DwellerCMD.addShips(f, 1, 1, random, "dwellerEye");
            DwellerCMD.addShips(f, 2 - eyes, 3 - eyes, random, "dwellerMaelstrom");
            DwellerCMD.addShips(f, 1, 1, random, "dwellerMaw");
        } else if (str == DwellerStrength.HIGH) {
            DwellerCMD.addShips(f, 11, 14, random, "dwellerTendril");
            eyes = DwellerCMD.addShips(f, 2, 3, random, "dwellerEye");
            DwellerCMD.addShips(f, 3 - eyes, 5 - eyes, random, "dwellerMaelstrom");
            DwellerCMD.addShips(f, 1, 1, random, "dwellerMaw");
        } else if (str == DwellerStrength.EXTREME) {
            DwellerCMD.addShips(f, 12, 15, random, "dwellerTendril");
            eyes = DwellerCMD.addShips(f, 2, 3, random, "dwellerEye");
            DwellerCMD.addShips(f, 3 - eyes, 5 - eyes, random, "dwellerMaelstrom");
            DwellerCMD.addShips(f, 2, 2, random, "dwellerMaw");
        }
        f.getFleetData().setSyncNeeded();
        f.getFleetData().syncIfNeeded();
        f.getFleetData().sort();
        for (FleetMemberAPI curr : f.getFleetData().getMembersListCopy()) {
            curr.getRepairTracker().setCR(curr.getRepairTracker().getMaxCR());
        }
        f.getMemoryWithoutUpdate().set("$cfai_makeHostile", true);
        f.getMemoryWithoutUpdate().set("$mayGoIntoAbyss", true);
        return f;
    }

    public static int addShips(CampaignFleetAPI fleet, int min, int max, Random random, Object ... roles) {
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>();
        if (roles.length == 1) {
            picker.add((String)roles[0], 1.0f);
        } else {
            int i = 0;
            while (i < roles.length) {
                picker.add((String)roles[i], ((Float)roles[i + 1]).floatValue());
                i += 2;
            }
        }
        int num = min + random.nextInt(max - min + 1);
        FactionAPI faction = Global.getSector().getFaction("dweller");
        FactionAPI.ShipPickParams p = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.ALL);
        p.blockFallback = true;
        p.maxFP = 1000000;
        int i = 0;
        while (i < num) {
            String role = (String)picker.pick();
            List<ShipRolePick> picks = faction.pickShip(role, p, null, random);
            for (ShipRolePick pick : picks) {
                fleet.getFleetData().addFleetMember(pick.variantId);
                ShipVariantAPI variant = Global.getSettings().getVariant(pick.variantId);
                if (variant == null) continue;
                String hullId = variant.getHullSpec().getRestoredToHullId();
                Object dropGroups = DROP_GROUPS.get(hullId);
                Iterator iterator = dropGroups.iterator();
                while (iterator.hasNext()) {
                    String group = (String)iterator.next();
                    fleet.addDropRandom(group, 1);
                }
            }
            ++i;
        }
        return num;
    }

    public static enum DwellerStrength {
        LOW,
        MEDIUM,
        HIGH,
        EXTREME;

    }
}

