/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.GensHannanMachinations;
import com.fs.starfarer.api.impl.campaign.intel.LuddicChurchImmigrationDeal;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.SindrianDiktatFuelDeal;
import com.fs.starfarer.api.impl.campaign.intel.TriTachyonDeal;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HALuddicPathDealFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPirateKingDealFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardPerseanLeagueActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TriTachyonCommerceRaiding;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.KnightsOfLuddTakeoverExpedition;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeagueBlockade;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeaguePunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.intel.group.SindrianDiktatPunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.intel.group.TTMercenaryAttack;
import com.fs.starfarer.api.impl.campaign.intel.group.TTMercenaryReversedAttack;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HA_CMD
extends BaseCommandPlugin {
    public static final String PATHER_AGREEMENT = "$patherAgreement";
    public static final String PATHER_AGREEMENT_PERMANENT = "$patherAgreementPermanent";
    protected SectorEntityToken other;

    public static void setPatherAgreement(boolean agreement, float duration) {
        if (!agreement) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(PATHER_AGREEMENT);
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(PATHER_AGREEMENT_PERMANENT);
            return;
        }
        if (duration <= 0.0f) {
            Global.getSector().getPlayerMemoryWithoutUpdate().set(PATHER_AGREEMENT_PERMANENT, true);
        }
        Global.getSector().getPlayerMemoryWithoutUpdate().set(PATHER_AGREEMENT, true, duration);
    }

    public static boolean playerHasPatherAgreement() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT) || Global.getSector().getMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT);
    }

    public static boolean playerPatherAgreementIsPermanent() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT_PERMANENT) || Global.getSector().getMemoryWithoutUpdate().getBoolean(PATHER_AGREEMENT_PERMANENT);
    }

    public static float getPlayerPatherAgreementDays() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getExpire(PATHER_AGREEMENT);
    }

    public static int computePirateProtectionPaymentPerMonth(PirateBaseIntel intel) {
        int perTick = HA_CMD.computePirateProtectionPaymentPerTick(intel);
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        return (int)((float)perTick * numIter);
    }

    public static int computePirateProtectionPaymentPerTick(PirateBaseIntel intel) {
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        int payment = 0;
        float feeFraction = Global.getSettings().getFloat("pirateProtectionPaymentFraction");
        for (MarketAPI market : PirateBasePirateActivityCause2.getColoniesAffectedBy(intel)) {
            if (!market.isPlayerOwned()) continue;
            payment = (int)((float)payment + (float)((int)(market.getGrossIncome() * f)) * feeFraction);
        }
        return payment;
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        this.other = dialog.getInteractionTarget();
        CargoAPI cargo = pf.getCargo();
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        StarSystemAPI system = null;
        if (dialog.getInteractionTarget().getContainingLocation() instanceof StarSystemAPI) {
            system = (StarSystemAPI)dialog.getInteractionTarget().getContainingLocation();
        }
        if ("baseInvolved".equals(action)) {
            if (system == null) {
                return false;
            }
            PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
            if (base == null) {
                return false;
            }
            return HA_CMD.baseInvolved(system, base);
        }
        if ("addStationKingScript".equals(action)) {
            Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0f, 1.0f);
            PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
            if (base == null) {
                return false;
            }
            base.getSystem().addScript(new StationKingScript(base));
            HostileActivityEventIntel ha = HostileActivityEventIntel.get();
            if (ha != null) {
                int tier = base.getTier().ordinal();
                if (tier < 0) {
                    tier = 0;
                }
                if (tier > 4) {
                    tier = 4;
                }
                int points = -1 * Global.getSettings().getIntFromArray("HA_pirateBase", tier);
                HAPirateKingDealFactor factor = new HAPirateKingDealFactor(points);
                ha.addFactor(factor, dialog);
            }
            Misc.adjustRep(base.getBaseCommander(), 0.05f, text);
            Misc.adjustRep(base.getBaseCommander().getFaction().getId(), 0.03f, text);
        } else {
            if ("endStationKingDeal".equals(action)) {
                PirateBaseIntel base = PirateBaseIntel.getIntelFor(dialog.getInteractionTarget());
                if (base == null) {
                    return false;
                }
                for (EveryFrameScript curr : base.getSystem().getScripts()) {
                    if (!(curr instanceof StationKingScript)) continue;
                    StationKingScript script = (StationKingScript)curr;
                    script.endDeal(true, dialog);
                    return true;
                }
                return false;
            }
            if ("playerColoniesHavePatherActvity".equals(action)) {
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
                    if (!market.hasCondition("pather_cells") || !(interest > 0.0f)) continue;
                    return true;
                }
            } else {
                if ("payMegaTithe".equals(action)) {
                    int megaTithe = memory.getInt("$LP_megaTithe");
                    int dur = memory.getInt("$LP_megaTitheDuration");
                    cargo.getCredits().subtract(megaTithe);
                    AddRemoveCommodity.addCreditsLossText(megaTithe, text);
                    if (cargo.getCredits().get() <= 0.0f) {
                        cargo.getCredits().set(0.0f);
                    }
                    HA_CMD.setPatherAgreement(true, dur);
                    LuddicPathHostileActivityFactor.avertOrAbortAttack();
                    String factionId = "luddic_path";
                    float range = 100000.0f;
                    List<CampaignFleetAPI> fleets = Misc.findNearbyFleets(pf, range, new Misc.FleetFilter(){

                        @Override
                        public boolean accept(CampaignFleetAPI curr) {
                            return curr.getFaction().getId().equals("luddic_path");
                        }
                    });
                    for (CampaignFleetAPI curr : fleets) {
                        if (curr.getAI() != null) {
                            curr.getAI().setActionTextOverride(null);
                        }
                        if (curr.getAI() instanceof ModularFleetAIAPI) {
                            ModularFleetAIAPI mAI = (ModularFleetAIAPI)curr.getAI();
                            mAI.getTacticalModule().forceTargetReEval();
                        }
                        Misc.giveStandardReturnToSourceAssignments(curr, true);
                    }
                    HostileActivityEventIntel ha = HostileActivityEventIntel.get();
                    if (ha != null) {
                        int points = -1 * Global.getSettings().getInt("HA_megaTithe");
                        HALuddicPathDealFactor factor = new HALuddicPathDealFactor(points);
                        ha.addFactor(factor, dialog);
                    }
                    return true;
                }
                if ("gavePKToPather".equals(action)) {
                    HostileActivityEventIntel ha = HostileActivityEventIntel.get();
                    if (ha != null) {
                        int points = -1 * Global.getSettings().getInt("HA_givePK");
                        HALuddicPathDealFactor factor = new HALuddicPathDealFactor(points);
                        ha.addFactor(factor, dialog);
                    }
                    LuddicPathHostileActivityFactor.avertOrAbortAttack();
                } else {
                    if ("computeMegaTithe".equals(action)) {
                        float credits = cargo.getCredits().get();
                        float normalTithe = Global.getSector().getPlayerFleet().getFleetPoints() * 200;
                        int tithe = 0;
                        float tithePerPointPerColonySize = Global.getSettings().getFloat("luddicPathTithePerPointOfInterestPerColonySize");
                        int titheDuration = Global.getSettings().getInt("luddicPathTitheDurationDays");
                        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                            float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
                            tithe = (int)((float)tithe + (interest += (float)market.getSize()) * (float)market.getSize() * tithePerPointPerColonySize);
                        }
                        tithe = (int)((float)tithe + normalTithe);
                        tithe = (int)Misc.getRounded(tithe);
                        memoryMap.get("local").set("$LP_megaTithe", tithe, 0.0f);
                        memoryMap.get("local").set("$LP_megaTitheDGS", Misc.getWithDGS(tithe), 0.0f);
                        memoryMap.get("local").set("$LP_megaTitheDuration", titheDuration, 0.0f);
                        return tithe > 0;
                    }
                    if ("kazeronInstallNanoforge".equals(action)) {
                        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
                        if (kazeron != null) {
                            SpecialItemData data = new SpecialItemData("pristine_nanoforge", null);
                            for (Industry ind : kazeron.getIndustries()) {
                                if (!ind.wantsToUseSpecialItem(data)) continue;
                                ind.setSpecialItem(data);
                                break;
                            }
                        }
                    } else {
                        if ("kazeronNanoforgeMissing".equals(action)) {
                            MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
                            if (kazeron == null) {
                                return true;
                            }
                            for (Industry ind : kazeron.getIndustries()) {
                                if (ind.getSpecialItem() == null || !ind.getSpecialItem().getId().equals("pristine_nanoforge")) continue;
                                return false;
                            }
                            return true;
                        }
                        if ("stopPayingHouseHannan".equals(action)) {
                            PerseanLeagueMembership.stopPayingHouseHannan(params.get(1).getBoolean(memoryMap), dialog);
                        } else if ("leaveLeague".equals(action)) {
                            PerseanLeagueMembership m = PerseanLeagueMembership.get();
                            if (m != null) {
                                PerseanLeagueMembership.stopPayingHouseHannan(false, dialog);
                                m.endMembership(PerseanLeagueMembership.AgreementEndingType.ENDED, dialog);
                            }
                        } else if ("printTriTachDealRepReq".equals(action)) {
                            FactionAPI triTach = Global.getSector().getFaction("tritachyon");
                            CoreReputationPlugin.addRequiredStanding(triTach, RepLevel.INHOSPITABLE, null, dialog.getTextPanel(), null, null, 0.0f, true);
                            CoreReputationPlugin.addCurrentStanding(triTach, null, dialog.getTextPanel(), null, null, 0.0f);
                        } else {
                            if ("isTTCRInProgress".equals(action)) {
                                return TriTachyonCommerceRaiding.get() != null;
                            }
                            if ("isTTRaidingPlayerCommerce".equals(action)) {
                                EventFactor factor;
                                HostileActivityEventIntel intel = HostileActivityEventIntel.get();
                                if (intel != null && (factor = intel.getFactorOfClass(TriTachyonHostileActivityFactor.class)) instanceof TriTachyonHostileActivityFactor) {
                                    TriTachyonHostileActivityFactor ttFactor = (TriTachyonHostileActivityFactor)factor;
                                    return ttFactor.getProgress(intel) > 0;
                                }
                            } else if ("makeTriTachDeal".equals(action)) {
                                if (TriTachyonDeal.get() == null) {
                                    new TriTachyonDeal(dialog);
                                }
                            } else if ("breakTriTachDeal".equals(action)) {
                                if (TriTachyonDeal.get() != null) {
                                    TriTachyonDeal.get().endAgreement(TriTachyonDeal.AgreementEndingType.BROKEN, dialog);
                                }
                            } else if ("printLCDealRepReq".equals(action)) {
                                FactionAPI luddicChurch = Global.getSector().getFaction("luddic_church");
                                CoreReputationPlugin.addRequiredStanding(luddicChurch, RepLevel.INHOSPITABLE, null, dialog.getTextPanel(), null, null, 0.0f, true);
                                CoreReputationPlugin.addCurrentStanding(luddicChurch, null, dialog.getTextPanel(), null, null, 0.0f);
                            } else if ("breakLCDeal".equals(action)) {
                                if (LuddicChurchImmigrationDeal.get() != null) {
                                    LuddicChurchImmigrationDeal.get().endAgreement(LuddicChurchImmigrationDeal.AgreementEndingType.BROKEN, dialog);
                                }
                            } else {
                                if ("KOLTakeoverInProgress".equals(action)) {
                                    return HA_CMD.isKOLTakeoverInProgress();
                                }
                                if ("makeLuddicChurchDeal".equals(action)) {
                                    if (LuddicChurchImmigrationDeal.get() == null) {
                                        new LuddicChurchImmigrationDeal(dialog);
                                    }
                                } else if ("joinLeague".equals(action)) {
                                    new PerseanLeagueMembership(dialog);
                                    HA_CMD.avertOrEndPLBlockadeAsNecessary();
                                    HegemonyHostileActivityFactor.avertInspectionIfNotInProgress();
                                } else {
                                    if ("canJoinLeague".equals(action)) {
                                        return HA_CMD.canPlayerJoinTheLeague();
                                    }
                                    if ("isPLExpeditionInProgress".equals(action)) {
                                        return HA_CMD.isPLExpeditionInProgress();
                                    }
                                    if ("isPLProtectingPlayerSpace".equals(action)) {
                                        EventFactor factor;
                                        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
                                        if (intel != null && (factor = intel.getFactorOfClass(PerseanLeagueHostileActivityFactor.class)) instanceof PerseanLeagueHostileActivityFactor) {
                                            PerseanLeagueHostileActivityFactor plFactor = (PerseanLeagueHostileActivityFactor)factor;
                                            return plFactor.getProgress(intel) > 0;
                                        }
                                    } else {
                                        if ("canSendPLPunitiveExpedition".equals(action)) {
                                            return HA_CMD.canSendPerseanLeaguePunitiveExpedition();
                                        }
                                        if ("updateLeagueData".equals(action)) {
                                            float duesF = Global.getSettings().getFloat("perseanLeagueFeeFraction");
                                            float hannanF = Global.getSettings().getFloat("houseHannanFeeFraction");
                                            memoryMap.get("local").set("$plDuesPercent", String.valueOf(Math.round(duesF * 100.0f)) + "%", 0.0f);
                                            memoryMap.get("local").set("$hannanBribePercent", String.valueOf(Math.round(hannanF * 100.0f)) + "%", 0.0f);
                                            return HA_CMD.canPlayerJoinTheLeague();
                                        }
                                        if ("canRemakeDealWithHouseHannan".equals(action)) {
                                            return GensHannanMachinations.canRemakeDealWithHouseHannan();
                                        }
                                        if ("endGHMachinations".equals(action)) {
                                            GensHannanMachinations m = GensHannanMachinations.get();
                                            if (m != null) {
                                                m.endMachinations(text);
                                            }
                                        } else if ("doKOLTTakeover".equals(action)) {
                                            KnightsOfLuddTakeoverExpedition takeover = KnightsOfLuddTakeoverExpedition.get();
                                            if (takeover != null) {
                                                takeover.performTakeover(true);
                                            }
                                        } else if ("updateKOLTArmadaData".equals(action)) {
                                            KnightsOfLuddTakeoverExpedition takeover = KnightsOfLuddTakeoverExpedition.get();
                                            if (takeover != null) {
                                                MemoryAPI mem = memoryMap.get("local");
                                                mem.set("$KOLT_target", takeover.getBlockadeParams().specificMarket.getName());
                                                return true;
                                            }
                                        } else {
                                            if ("updateTTMAData".equals(action)) {
                                                MemoryAPI mem = memoryMap.get("local");
                                                TTMercenaryAttack attack = TTMercenaryAttack.get();
                                                StarSystemAPI target = TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem();
                                                boolean reversible = attack != null && !attack.isSpawning() && !attack.isFailed() && !attack.isSucceeded() && !attack.isAborted() && !attack.isEnding() && !attack.isEnded() && target != null;
                                                mem.set("$attackReversible", reversible);
                                                if (target != null) {
                                                    mem.set("$triTachSystem", target.getNameWithLowercaseTypeShort());
                                                }
                                                return true;
                                            }
                                            if ("retargetTTMA".equals(action)) {
                                                TTMercenaryReversedAttack.sendReversedAttack(dialog);
                                            } else {
                                                HostileActivityCause2 cause;
                                                HostileActivityEventIntel intel;
                                                if ("computeSacredProtectorsData".equals(action)) {
                                                    MemoryAPI mem = memoryMap.get("local");
                                                    int supplies = Global.getSector().getPlayerFleet().getFleetPoints() * 1;
                                                    mem.set("$SP_supplies", supplies, 0.0f);
                                                    return true;
                                                }
                                                if ("sacredProtectorsCheckCargoPods".equals(action)) {
                                                    MemoryAPI mem = memoryMap.get("local");
                                                    int supplies = mem.getInt("$SP_supplies");
                                                    return this.sacredProtectorsCheckCargoPods(supplies);
                                                }
                                                if ("knightsHasslingPlayerColonies".equals(action)) {
                                                    HostileActivityCause2 cause2;
                                                    HostileActivityEventIntel intel2 = HostileActivityEventIntel.get();
                                                    if (intel2 != null && (cause2 = intel2.getActivityCause(LuddicChurchHostileActivityFactor.class, LuddicChurchStandardActivityCause.class)) instanceof LuddicChurchStandardActivityCause) {
                                                        LuddicChurchStandardActivityCause lcCause = (LuddicChurchStandardActivityCause)cause2;
                                                        return lcCause.getProgress() > 0;
                                                    }
                                                } else if ("printSDDealRepReq".equals(action)) {
                                                    FactionAPI diktat = Global.getSector().getFaction("derelict");
                                                    CoreReputationPlugin.addRequiredStanding(diktat, RepLevel.INHOSPITABLE, null, dialog.getTextPanel(), null, null, 0.0f, true);
                                                    CoreReputationPlugin.addCurrentStanding(diktat, null, dialog.getTextPanel(), null, null, 0.0f);
                                                } else if ("breakSDDeal".equals(action)) {
                                                    if (SindrianDiktatFuelDeal.get() != null) {
                                                        SindrianDiktatFuelDeal.get().endAgreement(SindrianDiktatFuelDeal.AgreementEndingType.BROKEN, dialog);
                                                    }
                                                } else if ("makeDiktatDeal".equals(action)) {
                                                    if (SindrianDiktatFuelDeal.get() == null) {
                                                        new SindrianDiktatFuelDeal(dialog);
                                                    }
                                                } else if ("diktatConcernedByFuelProd".equals(action) && (intel = HostileActivityEventIntel.get()) != null && (cause = intel.getActivityCause(SindrianDiktatHostileActivityFactor.class, SindrianDiktatStandardActivityCause.class)) instanceof SindrianDiktatStandardActivityCause) {
                                                    SindrianDiktatStandardActivityCause lcCause = (SindrianDiktatStandardActivityCause)cause;
                                                    return lcCause.getProgress() > 0;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean sacredProtectorsCheckCargoPods(int remove) {
        float maxPodsDist = 1500.0f;
        for (SectorEntityToken entity : this.other.getContainingLocation().getAllEntities()) {
            float supplies;
            CargoPodsEntityPlugin plugin;
            float dist;
            if (!"cargo_pods".equals(entity.getCustomEntityType())) continue;
            SectorEntityToken.VisibilityLevel vLevel = entity.getVisibilityLevelTo(this.other);
            if (!(entity.getCustomPlugin() instanceof CargoPodsEntityPlugin) || (dist = Misc.getDistance(this.other, entity)) > maxPodsDist || vLevel != SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS && vLevel != SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || !((plugin = (CargoPodsEntityPlugin)entity.getCustomPlugin()).getElapsed() <= 1.0f) || entity.getCargo() == null || !((supplies = entity.getCargo().getSupplies()) >= (float)remove)) continue;
            entity.getCargo().removeSupplies(remove * 2);
            return true;
        }
        return false;
    }

    public static boolean isKOLTakeoverInProgress() {
        return KnightsOfLuddTakeoverExpedition.get() != null && !KnightsOfLuddTakeoverExpedition.get().isSucceeded() && !KnightsOfLuddTakeoverExpedition.get().isAborted() && !KnightsOfLuddTakeoverExpedition.get().isFailed();
    }

    public static boolean isPLExpeditionInProgress() {
        return PerseanLeaguePunitiveExpedition.get() != null && !PerseanLeaguePunitiveExpedition.get().isSucceeded() && !PerseanLeaguePunitiveExpedition.get().isAborted() && !PerseanLeaguePunitiveExpedition.get().isFailed();
    }

    public static void avertOrEndKOLTakeoverAsNecessary() {
        HostileActivityEventIntel.HAERandomEventData data;
        HostileActivityEventIntel intel;
        KnightsOfLuddTakeoverExpedition takeover = KnightsOfLuddTakeoverExpedition.get();
        if (takeover != null) {
            takeover.finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) != null && (data = intel.getRollDataForEvent()) != null && data.factor instanceof LuddicChurchHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    public static void avertOrEndDiktatAttackAsNecessary() {
        HostileActivityEventIntel.HAERandomEventData data;
        HostileActivityEventIntel intel;
        SindrianDiktatPunitiveExpedition attack = SindrianDiktatPunitiveExpedition.get();
        if (attack != null) {
            attack.finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) != null && (data = intel.getRollDataForEvent()) != null && data.factor instanceof SindrianDiktatHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    public static void avertOrEndPLBlockadeAsNecessary() {
        HostileActivityEventIntel.HAERandomEventData data;
        HostileActivityEventIntel intel;
        PerseanLeaguePunitiveExpedition expedition;
        PerseanLeagueBlockade blockade = PerseanLeagueBlockade.get();
        if (blockade != null) {
            blockade.finish(false);
        }
        if ((expedition = PerseanLeaguePunitiveExpedition.get()) != null) {
            expedition.finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) != null && (data = intel.getRollDataForEvent()) != null && data.factor instanceof PerseanLeagueHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    public static boolean canPlayerJoinTheLeague() {
        if (HA_CMD.isPLExpeditionInProgress()) {
            return false;
        }
        if (PerseanLeagueMembership.isLeagueMember()) {
            return false;
        }
        if (PerseanLeagueMembership.isLeftLeagueWhenGoodDeal()) {
            return false;
        }
        if (PerseanLeagueHostileActivityFactor.wasPLEverSatBombardedByPlayer()) {
            return false;
        }
        if (PerseanLeagueHostileActivityFactor.getKazeron(false) == null) {
            return false;
        }
        if (PerseanLeagueMembership.getNumTimesLeftLeague() >= PerseanLeagueMembership.TIMES_LEFT_LEAGUE_FOR_NO_REJOIN) {
            return false;
        }
        int large = 0;
        int count = 0;
        int medium = 0;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            int size = market.getSize();
            if (size >= StandardPerseanLeagueActivityCause.LARGE_COLONY) {
                ++large;
            }
            if (size >= StandardPerseanLeagueActivityCause.MEDIUM_COLONY) {
                ++medium;
            }
            ++count;
        }
        return large > 0 || medium > 0 && count >= StandardPerseanLeagueActivityCause.COUNT_IF_MEDIUM;
    }

    public static boolean baseInvolved(StarSystemAPI system, PirateBaseIntel base) {
        if (system == null) {
            return false;
        }
        if (base == null) {
            return false;
        }
        return !PirateBasePirateActivityCause2.getColoniesAffectedBy(base).isEmpty();
    }

    public static boolean canSendPerseanLeaguePunitiveExpedition() {
        return HA_CMD.computePerseanLeaguePunitiveExpeditionData() != null;
    }

    public static PLPunExData computePerseanLeaguePunitiveExpeditionData() {
        if (PerseanLeagueMembership.isDefeatedBlockadeOrPunEx()) {
            return null;
        }
        if (HA_CMD.isPLExpeditionInProgress()) {
            return null;
        }
        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
        if (intel == null) {
            return null;
        }
        StarSystemAPI target = PerseanLeagueHostileActivityFactor.findBlockadeTarget(intel, null);
        if (target == null) {
            return null;
        }
        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(true);
        if (kazeron == null) {
            return null;
        }
        PLPunExData data = new PLPunExData();
        data.intel = intel;
        data.target = target;
        data.kazeron = kazeron;
        return data;
    }

    public static void sendPerseanLeaguePunitiveExpedition(InteractionDialogAPI dialog) {
        float f;
        PLPunExData data = HA_CMD.computePerseanLeaguePunitiveExpeditionData();
        if (data == null) {
            return;
        }
        HA_CMD.avertOrEndPLBlockadeAsNecessary();
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(), true);
        params.factionId = data.kazeron.getFactionId();
        params.source = data.kazeron;
        Random random = new Random();
        params.prepDays = 14.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = data.target;
        LinkedHashSet<String> disrupt = new LinkedHashSet<String>();
        for (MarketAPI market : Misc.getMarketsInLocation(data.target, "player")) {
            params.raidParams.allowedTargets.add(market);
            params.raidParams.allowNonHostileTargets = true;
            for (Industry ind : market.getIndustries()) {
                if (ind.getSpec().hasTag("unraidable")) continue;
                disrupt.add(ind.getId());
            }
        }
        params.raidParams.disrupt.addAll(disrupt);
        params.raidParams.raidsPerColony = Math.min(disrupt.size(), 4);
        if (disrupt.isEmpty()) {
            params.raidParams.raidsPerColony = 2;
        }
        if (params.raidParams.allowedTargets.isEmpty()) {
            return;
        }
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float fleetSizeMult = data.kazeron.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
        float totalDifficulty = fleetSizeMult * 50.0f * (0.5f + 0.5f * (f = data.intel.getMarketPresenceFactor(data.target)));
        if (totalDifficulty < 30.0f) {
            return;
        }
        if (totalDifficulty > 100.0f) {
            totalDifficulty = 100.0f;
        }
        Random r = data.intel.getRandom();
        while (totalDifficulty > 0.0f) {
            float max = 6.0f;
            float min = 3.0f;
            if (r.nextFloat() > 0.3f) {
                min = (int)Math.min(totalDifficulty, 8.0f);
                max = (int)Math.min(totalDifficulty, 10.0f);
            }
            int diff = Math.round(StarSystemGenerator.getNormalRandom(r, min, max));
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        PerseanLeaguePunitiveExpedition punex = new PerseanLeaguePunitiveExpedition(params);
        punex.setPreFleetDeploymentDelay(30.0f + random.nextFloat() * 60.0f);
        TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
        Global.getSector().getIntelManager().addIntel(punex, false, text);
    }

    public static class PLPunExData {
        public HostileActivityEventIntel intel;
        public StarSystemAPI target;
        public MarketAPI kazeron;
    }

    public static class StationKingScript
    implements EveryFrameScript,
    TooltipMakerAPI.TooltipCreator,
    EconomyTickListener,
    FleetEventListener,
    CurrentLocationChangedListener,
    ColonyPlayerHostileActListener {
        protected boolean done = false;
        protected PirateBaseIntel intel;
        protected Random random = new Random();
        protected float untilMercCheck = 0.0f;
        protected float mercProbMult = 1.0f;
        protected transient boolean spawnMerc = false;

        public StationKingScript(PirateBaseIntel intel) {
            this.intel = intel;
            Global.getSector().getListenerManager().addListener(this);
            this.resetMercCheckDelay();
        }

        protected Object readResolve() {
            if (this.random == null) {
                this.random = new Random();
            }
            return this;
        }

        protected void resetMercCheckDelay() {
            this.untilMercCheck = Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 0) + (Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 1) - Global.getSettings().getFloatFromArray("pirateProtectionMercSpawnInterval", 0)) * Misc.random.nextFloat();
        }

        protected void setDone() {
            this.done = true;
            Global.getSector().getListenerManager().removeListener(this);
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void reportEconomyTick(int iterIndex) {
            MonthlyReport report = SharedData.getData().getCurrentReport();
            MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
            int payment = HA_CMD.computePirateProtectionPaymentPerTick(this.intel);
            if (payment <= 0) {
                return;
            }
            MonthlyReport.FDNode paymentNode = report.getNode(marketsNode, "pirate_payment");
            paymentNode.name = "Protection payment";
            paymentNode.upkeep += (float)payment;
            paymentNode.tooltipCreator = this;
            paymentNode.mapEntity = this.intel.getEntity();
            paymentNode.icon = Global.getSettings().getSpriteName("income_report", "generic_expense");
        }

        @Override
        public void reportEconomyMonthEnd() {
        }

        @Override
        public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
            float opad = 10.0f;
            tooltip.addSpacer(-10.0f);
            tooltip.addPara("Protection payment to the " + this.intel.getBaseCommander().getPost() + " of " + this.intel.getEntity().getName() + ". The pirate base is located in the " + this.intel.getSystem().getNameWithLowercaseTypeShort() + ".", opad);
        }

        @Override
        public float getTooltipWidth(Object tooltipParam) {
            return 450.0f;
        }

        @Override
        public boolean isTooltipExpandable(Object tooltipParam) {
            return false;
        }

        @Override
        public void advance(float amount) {
            if (this.isDone()) {
                return;
            }
            if (this.intel.isEnded() || this.intel.isEnding()) {
                if (this.intel.playerHasDealWithBaseCommander()) {
                    this.intel.setPlayerHasDealWithBaseCommander(false);
                }
                this.setDone();
                return;
            }
            if (this.intel.playerHasDealWithBaseCommander() && this.intel.getSystem().isCurrentLocation()) {
                CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
                ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>(this.intel.getSystem().getFleets());
                fleets.add(station);
                for (CampaignFleetAPI fleet : fleets) {
                    MarketAPI source = Misc.getSourceMarket(fleet);
                    if (source != this.intel.getMarket() && fleet != station) continue;
                    Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$cfai_makeNonHostile", "psk_deal", true, 0.1f);
                    fleet.getMemoryWithoutUpdate().set("$cfai_allowPlayerBattleJoinTOff", true, 0.1f);
                }
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.untilMercCheck -= days;
            if (this.untilMercCheck < 0.0f) {
                this.untilMercCheck = 0.0f;
            }
            if (this.spawnMerc) {
                this.spawnMerc();
                this.spawnMerc = false;
            }
        }

        @Override
        public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        }

        @Override
        public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
            if (!battle.isPlayerInvolved()) {
                return;
            }
            CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
            if (station == null) {
                return;
            }
            if (this.intel.getEntity() == null) {
                return;
            }
            LocationAPI cLoc = null;
            if (fleet != null) {
                cLoc = fleet.getContainingLocation();
            }
            if (cLoc == null && primaryWinner != null) {
                cLoc = primaryWinner.getContainingLocation();
            }
            if (this.intel.getEntity().getContainingLocation() != cLoc) {
                return;
            }
            for (CampaignFleetAPI curr : battle.getNonPlayerSideSnapshot()) {
                MarketAPI source;
                if (!curr.knowsWhoPlayerIs() && curr != station || (source = Misc.getSourceMarket(curr)) != this.intel.getMarket() && curr != station) continue;
                this.endDeal(false, null);
                return;
            }
        }

        @Override
        public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
            if (market == this.intel.getMarket() && !actionData.secret && !cargo.isEmpty()) {
                this.endDeal(false, dialog);
            }
        }

        @Override
        public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        @Override
        public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        @Override
        public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
            if (market == this.intel.getMarket() && !actionData.secret) {
                this.endDeal(false, dialog);
            }
        }

        public void endDeal(boolean amicable, InteractionDialogAPI dialog) {
            if (!this.intel.playerHasDealWithBaseCommander()) {
                return;
            }
            TextPanelAPI textPanel = dialog == null ? null : dialog.getTextPanel();
            this.intel.setPlayerHasDealWithBaseCommander(false);
            if (amicable) {
                this.intel.sendUpdateIfPlayerHasIntel(PirateBaseIntel.DEAL_CANCELLED_PARAM, textPanel);
            } else {
                this.intel.sendUpdateIfPlayerHasIntel(PirateBaseIntel.DEAL_BROKEN_PARAM, textPanel);
            }
            if (!amicable) {
                Misc.incrUntrustwortyCount();
            }
            if (amicable) {
                Misc.adjustRep(this.intel.getBaseCommander(), -0.060000002f, textPanel);
                Misc.adjustRep(this.intel.getBaseCommander().getFaction().getId(), -0.04f, textPanel);
            } else {
                Misc.adjustRep(this.intel.getBaseCommander(), -0.1f, textPanel);
                Misc.adjustRep(this.intel.getBaseCommander().getFaction().getId(), -0.06f, textPanel);
            }
            CampaignFleetAPI station = Misc.getStationFleet(this.intel.getEntity());
            ArrayList<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>(this.intel.getSystem().getFleets());
            fleets.add(station);
            for (CampaignFleetAPI fleet : fleets) {
                MarketAPI source = Misc.getSourceMarket(fleet);
                if (source != this.intel.getMarket() && fleet != station) continue;
                Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$cfai_makeNonHostile", "psk_deal", false, 0.0f);
                fleet.getMemoryWithoutUpdate().unset("$cfai_allowPlayerBattleJoinTOff");
            }
            this.setDone();
        }

        @Override
        public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
            if (curr == this.intel.getSystem()) {
                float prob = Global.getSettings().getFloat("pirateProtectionMercSpawnChance");
                prob *= this.mercProbMult;
                if (this.untilMercCheck <= 0.0f && this.random.nextFloat() < prob) {
                    this.mercProbMult *= Global.getSettings().getFloat("pirateProtectionMercSpawnChanceMult");
                    this.spawnMerc = true;
                    this.resetMercCheckDelay();
                }
            }
        }

        public void spawnMerc() {
            JumpPointAPI jp;
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            float dist = Misc.getDistance(pf, jp = Misc.findNearestJumpPointTo(pf));
            if (dist > 500.0f) {
                return;
            }
            float f = 10.0f;
            StarSystemAPI system = this.intel.getSystem();
            int difficulty = 0;
            PirateBaseIntel.PirateBaseTier tier = this.intel.getTier();
            switch (tier) {
                case TIER_1_1MODULE: {
                    difficulty = 3;
                    break;
                }
                case TIER_2_1MODULE: {
                    difficulty = 4;
                    break;
                }
                case TIER_3_2MODULE: {
                    difficulty = 5;
                    break;
                }
                case TIER_4_3MODULE: {
                    difficulty = 6;
                    break;
                }
                case TIER_5_3MODULE: {
                    difficulty = 7;
                }
            }
            FleetCreatorMission m = new FleetCreatorMission(this.random);
            m.beginFleet();
            Vector2f hLoc = system.getLocation();
            m.createQualityFleet(difficulty += this.random.nextInt(3), "mercenary", hLoc);
            m.triggerSetFleetFaction("independent");
            m.triggerMakeLowRepImpact();
            m.triggerFleetSetAllWeapons();
            m.triggerFleetMakeImportantPermanent(null);
            m.triggerSetFleetMemoryValue("$psk_merc", true);
            CampaignFleetAPI fleet = m.createFleet();
            if (fleet != null) {
                system.addEntity(fleet);
                Vector2f loc = new Vector2f((ReadableVector2f)pf.getLocation());
                loc = Misc.getPointAtRadius(loc, 400.0f);
                fleet.setLocation(loc.x, loc.y);
                SectorEntityToken e = system.createToken(loc);
                fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 2.0f + 3.0f * this.random.nextFloat(), "preparing to attack " + this.intel.getEntity().getName());
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.intel.getEntity(), 20.0f, "moving to attack " + this.intel.getEntity().getName());
                fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
                fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, pf, 1.0f, null);
            }
        }
    }
}

