/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.RecoverAPlanetkiller;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddShip;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class PK_CMD
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        if ("removePKDefenses".equals(action)) {
            return this.removePKDefenses(dialog, memory);
        }
        if ("convertSentinelToColony".equals(action)) {
            return this.convertSentinelToColony(text, cargo);
        }
        if ("rightPostToAcceptPK".equals(action)) {
            return this.rightPostToAcceptPK(dialog);
        }
        if ("rightPostToTellAboutSentinel".equals(action)) {
            return this.rightPostToTellAboutSentinel(dialog);
        }
        if ("giveExecutor".equals(action)) {
            this.giveExecutor(dialog, params, memoryMap);
        }
        return false;
    }

    protected boolean convertSentinelToColony(TextPanelAPI text, CargoAPI cargo) {
        PlanetAPI planet = RecoverAPlanetkiller.getTundra();
        MarketAPI market = planet.getMarket();
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        for (MarketConditionAPI mc : market.getConditions()) {
            mc.setSurveyed(true);
        }
        market.setName(planet.getName());
        planet.setFaction("hegemony");
        market.setDaysInExistence(0.0f);
        market.setPlanetConditionMarketOnly(false);
        market.setFactionId("hegemony");
        market.addCondition("population_3");
        market.addIndustry("population");
        market.addIndustry("farming");
        market.setSize(3);
        market.addSubmarket("open_market");
        market.addSubmarket("black_market");
        market.addSubmarket("storage");
        market.getSubmarket("open_market").getPlugin().updateCargoPrePlayerInteraction();
        market.getSubmarket("open_market").getPlugin().getCargo().clear();
        if (market.getSubmarket("open_market").getPlugin().getCargo().getMothballedShips() != null) {
            market.getSubmarket("open_market").getPlugin().getCargo().getMothballedShips().clear();
        }
        market.getSubmarket("black_market").getPlugin().updateCargoPrePlayerInteraction();
        market.getSubmarket("black_market").getPlugin().getCargo().clear();
        if (market.getSubmarket("black_market").getPlugin().getCargo().getMothballedShips() != null) {
            market.getSubmarket("black_market").getPlugin().getCargo().getMothballedShips().clear();
        }
        market.getTariff().modifyFlat("default_tariff", market.getFaction().getTariffFraction());
        planet.setMarket(market);
        market.setPrimaryEntity(planet);
        market.setPlayerOwned(false);
        Global.getSector().getEconomy().addMarket(market, false);
        Global.getSector().getEconomy().tripleStep();
        market.advance(0.0f);
        market.getConstructionQueue().addToEnd("spaceport", 0);
        SharedData.getData().getMarketsWithoutTradeFleetSpawn().add(market.getId());
        PersonAPI skiron = People.getPerson(People.SKIRON);
        market.setAdmin(skiron);
        market.getCommDirectory().addPerson(skiron, 0);
        market.addPerson(skiron);
        market.getPrimaryEntity().setInteractionImage("illustrations", "sentinel2");
        return true;
    }

    protected void giveExecutor(InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        boolean removeSpecial = params.get(1).getBoolean(memoryMap);
        ShipVariantAPI v = Global.getSettings().getVariant("executor_Hull").clone();
        if (removeSpecial) {
            v.addSuppressedMod("andrada_mods");
        }
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, v);
        Global.getSector().getPlayerFleet().getFleetData().addFleetMember(member);
        AddShip.addShipGainText(member, dialog.getTextPanel());
    }

    protected boolean rightPostToAcceptPK(InteractionDialogAPI dialog) {
        PersonAPI person = dialog.getInteractionTarget().getActivePerson();
        if (person.getMemoryWithoutUpdate().getBoolean("$patherBaseCommander")) {
            return true;
        }
        return Ranks.POST_BASE_COMMANDER.equals(person.getPostId()) || Ranks.POST_STATION_COMMANDER.equals(person.getPostId()) || Ranks.POST_OUTPOST_COMMANDER.equals(person.getPostId());
    }

    protected boolean rightPostToTellAboutSentinel(InteractionDialogAPI dialog) {
        PersonAPI person = dialog.getInteractionTarget().getActivePerson();
        return Ranks.POST_BASE_COMMANDER.equals(person.getPostId()) || Ranks.POST_STATION_COMMANDER.equals(person.getPostId()) || Ranks.POST_ADMINISTRATOR.equals(person.getPostId()) || Ranks.POST_OUTPOST_COMMANDER.equals(person.getPostId());
    }

    protected boolean removePKDefenses(InteractionDialogAPI dialog, MemoryAPI memory) {
        CampaignFleetAPI defenders = memory.getFleet("$defenderFleet");
        if (defenders != null) {
            memory.unset("$defenderFleet");
            memory.set("$defenderFleetDefeated", true);
            memory.set("$hasDefenders", false, 0.0f);
            dialog.getInteractionTarget().getContainingLocation().addEntity(defenders);
            defenders.setAI(null);
            defenders.setNullAIActionText("dormant");
            Vector2f loc = dialog.getInteractionTarget().getLocation();
            defenders.setLocation(loc.x, loc.y + 100.0f);
            defenders.setCircularOrbit(dialog.getInteractionTarget().getOrbitFocus(), 90.0f, 100.0f, 20.0f);
            defenders.getMemoryWithoutUpdate().set("$pkDefenderFleet", true);
            defenders.getMemoryWithoutUpdate().set("$cfai_ignoredByOtherFleets", true);
            defenders.getMemoryWithoutUpdate().set("$noShipDerelictsPostBattle", true);
            Misc.makeNoRepImpact(defenders, "pk");
        }
        return true;
    }
}

