/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.util.Misc;
import java.util.EnumSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;

public class RadioChatterTerrainPlugin
extends BaseRingTerrain {
    protected RadioChatterParams params;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.noneOf(CampaignEngineLayers.class);
    protected transient float phase = 0.0f;

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (RadioChatterParams)param;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.noneOf(CampaignEngineLayers.class);
        return this;
    }

    @Override
    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float period = (float)Math.PI * 2;
        this.phase += period / 10.0f * amount;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        float prox;
        if (!entity.isPlayerFleet()) {
            return;
        }
        float volumeMult = prox = this.getProximitySoundFactor();
        float suppressionMult = prox;
        if (volumeMult <= 0.0f) {
            return;
        }
        volumeMult = (float)Math.sqrt(volumeMult);
        Global.getSector().getCampaignUI().suppressMusic(this.getSpec().getMusicSuppression() * suppressionMult);
        float dirToEntity = Misc.getAngleInDegrees(entity.getLocation(), this.entity.getLocation());
        Vector2f playbackLoc = Misc.getUnitVectorAtDegreeAngle(dirToEntity);
        playbackLoc.scale(500.0f);
        Vector2f.add((Vector2f)entity.getLocation(), (Vector2f)playbackLoc, (Vector2f)playbackLoc);
        try {
            JSONArray sounds = this.getSpec().getCustom().getJSONArray("chatter");
            float num = sounds.length();
            float period = (float)Math.PI * 2;
            int i = 0;
            while (i < sounds.length()) {
                JSONObject sound = sounds.getJSONObject(i);
                float threshold = (float)sound.getDouble("threshold");
                float phaseMult = (float)sound.getDouble("phaseMult");
                String soundId = sound.getString("sound");
                float offset = period / num * (float)i;
                float cos = (float)Math.cos(this.phase * phaseMult + offset);
                float volume = 0.0f;
                if (cos > threshold) {
                    volume = (cos - threshold) / (1.0f - threshold);
                    if (volume < 0.0f) {
                        volume = 0.0f;
                    }
                    if (volume > 1.0f) {
                        volume = 1.0f;
                    }
                }
                Global.getSoundPlayer().playLoop(soundId, this.params.relatedEntity, 1.0f, volume * volumeMult, playbackLoc, Misc.ZERO);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public float getProximitySoundFactor() {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(player.getLocation(), this.entity.getLocation());
        float radSum = this.params.relatedEntity.getRadius() + player.getRadius();
        float f = 1.0f - (dist -= radSum) / Math.max(1.0f, this.params.bandWidthInEngine - this.params.relatedEntity.getRadius());
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    protected float getExtraSoundRadius() {
        return 0.0f;
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        return super.containsPoint(point, radius);
    }

    @Override
    public boolean hasTooltip() {
        return false;
    }

    @Override
    public String getTerrainName() {
        return null;
    }

    @Override
    public String getNameForTooltip() {
        return null;
    }

    @Override
    public String getEffectCategory() {
        return "radio_chatter";
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return false;
    }

    public static class RadioChatterParams
    extends BaseRingTerrain.RingParams {
        public RadioChatterParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity) {
            super(bandWidthInEngine, middleRadius, relatedEntity);
        }
    }
}

