/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.dweller.ConvulsiveLungeSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatStrategyAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class ConvulsiveLungeSystemAI
implements ShipSystemAIScript {
    public static float HULL_LOSS_FOR_PULLBACK = 0.25f;
    public static float MAW_LUNGE_ARC = 30.0f;
    public static float MIN_AGGRO_USE_INTERVAL = 5.0f;
    public static float USE_SCORE_PER_USE = 20.0f;
    public static float USE_SCORE_THRESHOLD = 45.0f;
    protected ShipAPI ship;
    protected CombatEngineAPI engine;
    protected ShipwideAIFlags flags;
    protected ShipSystemAPI system;
    protected ConvulsiveLungeSystemScript script;
    protected float sinceUsedForAttackOrMove = 100.0f;
    protected float recentAggroUseScore = 0.0f;
    protected boolean allowAggroUse = true;
    protected IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);
    protected float hullLevelAtPrevSystemUse = 1.0f;
    protected float prevHardFluxLevel = 0.0f;

    public static SharedLungeAIData getSharedData() {
        String key = "lunge_AI_shared";
        SharedLungeAIData data = (SharedLungeAIData)Global.getCombatEngine().getCustomData().get(key);
        if (data == null) {
            data = new SharedLungeAIData();
            Global.getCombatEngine().getCustomData().put(key, data);
        }
        return data;
    }

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
        this.system = system;
        this.script = (ConvulsiveLungeSystemScript)system.getScript();
    }

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        boolean forceUseForAttack;
        if (this.ship == null) {
            return;
        }
        this.tracker.advance(amount);
        this.sinceUsedForAttackOrMove += amount;
        boolean isMaw = DwellerCombatStrategyAI.isMaw(this.ship);
        if (isMaw) {
            this.recentAggroUseScore -= amount;
            if (this.recentAggroUseScore < 0.0f) {
                this.recentAggroUseScore = 0.0f;
            }
            if (!this.allowAggroUse && this.recentAggroUseScore <= 0.0f) {
                this.allowAggroUse = true;
            } else if (this.allowAggroUse && this.recentAggroUseScore >= USE_SCORE_THRESHOLD) {
                this.allowAggroUse = false;
            }
        }
        SharedLungeAIData data = ConvulsiveLungeSystemAI.getSharedData();
        float now = Global.getCombatEngine().getTotalElapsedTime(false);
        boolean forceUseForPullback = !isMaw && data.usedByMawToPullBack + 0.1f > now;
        boolean bl = forceUseForAttack = !isMaw && data.usedByMawToAttack + 0.1f > now;
        if (this.ship.getFluxLevel() > 0.95f && this.ship.getHullLevel() > 0.25f && this.ship.getShield() != null && this.ship.getShield().isOn()) {
            this.ship.getShield().toggleOff();
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_SHIELDS, 3.0f);
            forceUseForPullback = true;
        }
        if (this.tracker.intervalElapsed() || forceUseForPullback || forceUseForAttack) {
            boolean useSystemForPullback;
            if (!this.isSystemUsable()) {
                return;
            }
            if (this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            float hullLevel = this.ship.getHullLevel();
            this.hullLevelAtPrevSystemUse = Math.max(this.hullLevelAtPrevSystemUse, hullLevel);
            float hardFluxLevel = this.ship.getHardFluxLevel();
            float fluxLevel = this.ship.getFluxLevel();
            boolean bl2 = useSystemForPullback = hullLevel <= this.hullLevelAtPrevSystemUse - HULL_LOSS_FOR_PULLBACK;
            if ((hardFluxLevel >= this.prevHardFluxLevel && hardFluxLevel >= 0.33f || fluxLevel > 0.65f) && this.ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) && target != null) {
                float dist = Misc.getDistance(this.ship.getLocation(), target.getLocation());
                if ((dist -= this.ship.getCollisionRadius() + target.getCollisionRadius()) < 1000.0f || hardFluxLevel > this.prevHardFluxLevel + 0.02f) {
                    useSystemForPullback = true;
                }
            }
            this.prevHardFluxLevel = hardFluxLevel;
            if (useSystemForPullback |= forceUseForPullback) {
                float angle = this.ship.getFacing() + 180.0f;
                if (target != null) {
                    angle = Misc.getAngleInDegrees(target.getLocation(), this.ship.getLocation());
                }
                if (missileDangerDir != null) {
                    angle = Misc.getAngleInDegrees(missileDangerDir) + 180.0f;
                }
                if (isMaw && Misc.getAngleDiff(this.ship.getFacing() + 180.0f, angle) > MAW_LUNGE_ARC * 0.5f) {
                    return;
                }
                Vector2f point = Misc.getUnitVectorAtDegreeAngle(angle);
                point.scale(2000.0f);
                Vector2f.add((Vector2f)point, (Vector2f)this.ship.getLocation(), (Vector2f)point);
                this.giveCommand(point);
                this.hullLevelAtPrevSystemUse = hullLevel;
                if (isMaw) {
                    data.usedByMawToPullBack = now;
                }
                return;
            }
            boolean useSystemForAttackOrMovement = false;
            float arc = 30.0f;
            float checkDist = 700.0f;
            if (!isMaw && forceUseForAttack) {
                checkDist = 300.0f;
            }
            boolean blocked = false;
            float angle = this.ship.getFacing();
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
            if (target != null) {
                angle = Misc.getAngleInDegrees(this.ship.getLocation(), target.getLocation());
            }
            for (ShipAPI other : Global.getCombatEngine().getShips()) {
                if (other.isFighter() || other.getOwner() != this.ship.getOwner() && (!other.isHulk() || isMaw && other.getMassWithModules() < this.ship.getMass() * 0.25f) && (this.ship.getHullSize().ordinal() > other.getHullSize().ordinal() || !isMaw && forceUseForAttack) && this.ship.getHullLevel() > 0.5f && other != target) continue;
                float dist = Misc.getDistance(this.ship.getLocation(), other.getLocation());
                if ((dist -= (this.ship.getCollisionRadius() + other.getCollisionRadius()) * 0.6f) > checkDist || !Misc.isInArc(angle, arc, this.ship.getLocation(), other.getLocation())) continue;
                blocked = true;
                break;
            }
            float speed = this.ship.getVelocity().length();
            float speedInDir = Vector2f.dot((Vector2f)dir, (Vector2f)this.ship.getVelocity());
            boolean aligned = speedInDir > speed * 0.65f && speed >= this.ship.getMaxSpeed() * 0.9f;
            boolean bl3 = useSystemForAttackOrMovement = !blocked && aligned;
            if (this.sinceUsedForAttackOrMove < MIN_AGGRO_USE_INTERVAL || !this.allowAggroUse) {
                useSystemForAttackOrMovement = false;
            }
            if (!isMaw) {
                useSystemForAttackOrMovement = false;
            }
            if (useSystemForAttackOrMovement |= forceUseForAttack && !blocked) {
                if (isMaw && Misc.getAngleDiff(this.ship.getFacing(), angle) > MAW_LUNGE_ARC * 0.5f) {
                    return;
                }
                Vector2f point = Misc.getUnitVectorAtDegreeAngle(angle);
                point.scale(2000.0f);
                Vector2f.add((Vector2f)point, (Vector2f)this.ship.getLocation(), (Vector2f)point);
                this.giveCommand(point);
                if (isMaw) {
                    data.usedByMawToAttack = now;
                }
                this.sinceUsedForAttackOrMove = 0.0f;
                this.recentAggroUseScore += USE_SCORE_PER_USE;
                return;
            }
        }
    }

    public boolean isSystemUsable() {
        if (this.system.getCooldownRemaining() > 0.0f) {
            return false;
        }
        if (this.system.isOutOfAmmo()) {
            return false;
        }
        return !this.system.isActive();
    }

    public void giveCommand(Vector2f target) {
        if (this.ship.getAIFlags() != null) {
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS, 1.0f, target);
        }
        this.ship.giveCommand(ShipCommand.USE_SYSTEM, null, 0);
    }

    public static class SharedLungeAIData {
        public float usedByMawToAttack;
        public float usedByMawToPullBack;
    }
}

