/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedEyeShipCreator
extends BaseDwellerShipCreator {
    public static float BEAM_RANGE_BONUS = 1200.0f;
    public static float HARD_FLUX_DISSIPATION_PERCENT = 100.0f;
    public static float DAMAGE_MULT = 0.75f;

    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.initBeforeShipCreation(hullSize, stats, id);
        stats.getBallisticWeaponFluxCostMod().modifyMult(id, 0.0f);
        stats.getEnergyWeaponFluxCostMod().modifyMult(id, 0.0f);
        stats.getMissileWeaponFluxCostMod().modifyMult(id, 0.0f);
        stats.getBeamWeaponRangeBonus().modifyFlat(id, BEAM_RANGE_BONUS);
        stats.getBeamWeaponDamageMult().modifyMult(id, DAMAGE_MULT);
        stats.getShieldUnfoldRateMult().modifyPercent(id, 10000.0f);
        stats.getHardFluxDissipationFraction().modifyFlat(id, HARD_FLUX_DISSIPATION_PERCENT * 0.01f);
    }

    @Override
    protected DwellerCombatPlugin createPlugin(ShipAPI ship) {
        DwellerCombatPlugin plugin = super.createPlugin(ship);
        List<DwellerShipPart> parts = plugin.getParts();
        parts.clear();
        DwellerCombatPlugin.WobblyPart part = new DwellerCombatPlugin.WobblyPart("shrouded_eye_base_dark", 1.0f, 5, 5, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        parts.add(part);
        Color glow = DwellerCombatPlugin.STANDARD_PART_GLOW_COLOR;
        part = new DwellerCombatPlugin.WobblyPart("shrouded_eye_iris", 0.6f, 3, 3, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.color = glow;
        part.additiveBlend = true;
        part.alphaMult = 0.5f;
        parts.add(part);
        PlasmaEyePart eyePart = new PlasmaEyePart(new Vector2f(0.0f, 0.0f), 0.0f, ship, 110.0f);
        parts.add(eyePart);
        return plugin;
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
        params.maxOffset = 130.0f;
        params.negativeParticleClearCenterAreaRadius = 50.0f;
    }

    public static class PlasmaEyePart
    extends BaseDwellerShipPart {
        public float radius;
        public IntervalUtil interval = new IntervalUtil(0.75f, 1.25f);
        public ShipAPI ship;
        public NegativeExplosionVisual visual;

        public PlasmaEyePart(Vector2f offset, float facingOffset, ShipAPI ship, float radius) {
            super(offset, facingOffset);
            this.ship = ship;
            this.radius = radius;
            NegativeExplosionVisual.NEParams p = new NegativeExplosionVisual.NEParams();
            p.hitGlowSizeMult = 0.75f;
            p.noiseMag = 1.0f;
            p.radius = 15.0f;
            p.noiseMult = 2.0f;
            p.color = new Color(255, 55, 255, 155);
            p.blackColor = new Color(255, 155, 255, 255);
            p.color = new Color(255, 55, 55, 155);
            p.blackColor = new Color(255, 155, 155, 255);
            p.underglow = null;
            p.spawnHitGlowAt = 0.0f;
            p.withHitGlow = false;
            this.visual = new NegativeExplosionVisual(p);
            this.visual.init(ship);
            this.visual.getFader().forceIn();
        }

        @Override
        public void advance(float amount) {
            super.advance(amount);
            this.visual.getFader().fadeIn();
            this.visual.advance(amount * 0.5f);
            this.interval.advance(amount * 30.0f);
            if (this.interval.intervalElapsed() && !this.ship.getFluxTracker().isOverloadedOrVenting()) {
                EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
                params.segmentLengthMult = 4.0f;
                params.glowSizeMult = 2.5f;
                if ((float)Math.random() < 0.1f) {
                    params.glowSizeMult = 7.0f;
                }
                params.flickerRateMult = 0.5f + (float)Math.random() * 0.5f;
                params.fadeOutDist = 30.0f;
                params.minFadeOutMult = 5.0f;
                params.flickerRateMult *= 0.3f;
                params.movementDurOverride = 0.3f;
                Color fringe = DwellerShroud.SHROUD_OVERLOAD_FRINGE_COLOR;
                fringe = new Color(150, 30, 40, 255);
                Color core = Color.white;
                fringe = new Color(150, 30, 40, 255);
                core = new Color(255, 150, 190, 255);
                fringe = new Color(150, 30, 30, 255);
                core = new Color(255, 150, 150, 255);
                float thickness = 80.0f;
                thickness = 40.0f;
                Vector2f loc = this.ship.getLocation();
                float r = this.radius * 1.1f;
                r = r * 0.5f + r * 0.5f * (float)Math.random();
                Vector2f from = Misc.getPointAtRadius(loc, r);
                Vector2f to = new Vector2f((ReadableVector2f)loc);
                to = Misc.getPointWithinRadius(to, this.radius * 0.1f);
                boolean goingOutside = false;
                Math.random();
                CombatEngineAPI engine = Global.getCombatEngine();
                EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, this.ship, to, this.ship, thickness, fringe, core, params);
                arc.setCoreWidthOverride(60.0f);
                arc.setCoreWidthOverride(20.0f);
                arc.setCoreWidthOverride(25.0f);
                if (goingOutside) {
                    arc.setRenderGlowAtEnd(false);
                } else {
                    arc.setRenderGlowAtStart(false);
                    arc.setFadedOutAtStart(true);
                }
                arc.setSingleFlickerMode(true);
                if (this.ship.getSystem() != null && this.ship.getSystem().getEffectLevel() > 0.0f) {
                    float level = this.ship.getSystem().getEffectLevel();
                    Vector2f pt = Misc.getPointWithinRadius(loc, 20.0f * level);
                    engine.addNebulaParticle(pt, this.ship.getVelocity(), 35.0f + 30.0f * level, 2.0f, 0.0f, 0.0f, 1.0f, core);
                }
            }
            if (!this.ship.getFluxTracker().isOverloadedOrVenting()) {
                Global.getSoundPlayer().playLoop("shrouded_eye_loop", this.ship, 1.0f, 0.5f + 0.5f * this.ship.getFluxLevel(), this.ship.getLocation(), this.ship.getVelocity());
            }
        }

        @Override
        protected void renderImpl(float x, float y, float alphaMult, float angle, CombatEngineLayers layer) {
            super.renderImpl(x, y, alphaMult, angle, layer);
            ViewportAPI viewport = Global.getCombatEngine().getViewport();
            float vAlpha = viewport.getAlphaMult();
            viewport.setAlphaMult(alphaMult);
            if (layer == CombatEngineLayers.BELOW_INDICATORS_LAYER) {
                this.visual.render(CombatEngineLayers.ABOVE_PARTICLES_LOWER, viewport);
                this.visual.render(CombatEngineLayers.ABOVE_PARTICLES, viewport);
            }
            viewport.setAlphaMult(vAlpha);
        }
    }
}

