/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.FragmentSwarmHullmod;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.SwarmLaunchingWeapon;
import com.fs.starfarer.api.impl.combat.threat.ThreatShipConstructionScript;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SwarmLauncherEffect
implements OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin,
SwarmLaunchingWeapon {
    public static String CONSTRUCTION_SWARM_WING = "construction_swarm_wing";
    public static String CONSTRUCTION_SWARM_VARIANT = "attack_swarm_Construction";
    public static String RECLAMATION_SWARM_WING = "reclamation_swarm_wing";
    public static String RECLAMATION_SWARM_VARIANT = "attack_swarm_Reclamation";
    public static String ATTACK_SWARM_HULL = "attack_swarm";
    public static String ATTACK_SWARM_WING = "attack_swarm_wing";
    public static String ATTACK_SWARM_VARIANT = "attack_swarm_Attack";
    public static String SWARM_LAUNCHER = "swarm_launcher";
    public static float IMPACT_VOLUME_MULT = 0.33f;
    public static float INITIAL_SPAWN_DELAY = 1.0f;
    public static Map<String, Integer> FRAGMENT_NUM = new HashMap<String, Integer>();
    public static Map<String, Integer> SWARM_RADIUS = new HashMap<String, Integer>();
    public static Map<String, Integer> WING_SIZE = new HashMap<String, Integer>();
    public static Map<String, String> WING_IDS = new HashMap<String, String>();
    protected FighterWingAPI currWing = null;
    protected boolean waitUntilOneLeft = false;
    protected float elapsed = 0.0f;

    static {
        FRAGMENT_NUM.put(ATTACK_SWARM_WING, 50);
        SWARM_RADIUS.put(ATTACK_SWARM_WING, 20);
        WING_SIZE.put(ATTACK_SWARM_WING, 4);
        WING_IDS.put(SWARM_LAUNCHER, ATTACK_SWARM_WING);
        FRAGMENT_NUM.put(CONSTRUCTION_SWARM_WING, 50);
        SWARM_RADIUS.put(CONSTRUCTION_SWARM_WING, 50);
    }

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        boolean playerShip;
        float dist;
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return;
        }
        if (weapon.usesAmmo() && weapon.getAmmo() <= 0) {
            return;
        }
        this.elapsed += amount;
        if (this.elapsed < INITIAL_SPAWN_DELAY || ship.hasTag(ThreatShipConstructionScript.SHIP_UNDER_CONSTRUCTION)) {
            weapon.setForceDisabled(true);
            return;
        }
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        int active = swarm == null ? 0 : swarm.getNumActiveMembers();
        int required = FRAGMENT_NUM.get(this.getWingId(weapon));
        boolean disable = active < required;
        int max = this.getWingSize(weapon);
        int swarmsActive = 0;
        if (this.currWing != null) {
            swarmsActive = this.currWing.getWingMembers().size();
        }
        this.waitUntilOneLeft |= this.currWing != null && swarmsActive >= max;
        if (this.currWing != null && this.currWing.getWingMembers().size() == 1 && this.currWing.getLeader() != null && (dist = Misc.getDistance(this.currWing.getLeader().getLocation(), weapon.getLocation())) > 1000.0f) {
            this.waitUntilOneLeft = true;
        }
        if (this.waitUntilOneLeft) {
            if (this.currWing != null && (swarmsActive <= 1 && max > 1 || swarmsActive <= 0 && max <= 1)) {
                this.waitUntilOneLeft = false;
                this.currWing = null;
            } else {
                disable = true;
            }
        }
        if (this.currWing == null && swarm != null) {
            int preferred = this.getPreferredNumFragmentsToFireConsideringAllWeapons(ship);
            if (active < (preferred = (int)Math.min((float)preferred, (float)swarm.params.baseMembersToMaintain * 0.9f))) {
                disable = true;
            }
        }
        weapon.setForceDisabled(disable);
        boolean bl = playerShip = Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == ship;
        if (playerShip) {
            Global.getCombatEngine().maintainStatusForPlayerShip(this, Global.getSettings().getSpriteName("ui", "icon_tactical_swarm_launcher"), weapon.getDisplayName(), "SWARMS ACTIVE: " + swarmsActive, swarmsActive <= 0);
        }
        weapon.setCustom(this.currWing);
        if (ship.getVariant().hasHullMod("threat_hullmod")) {
            weapon.setAmmo(weapon.getMaxAmmo());
        }
        if (disable) {
            return;
        }
        weapon.setForceFireOneFrame(true);
    }

    public String getWingId(WeaponAPI weapon) {
        String wingId = WING_IDS.get(weapon.getId());
        if (wingId != null) {
            return wingId;
        }
        return ATTACK_SWARM_WING;
    }

    public int getWingSize(WeaponAPI weapon) {
        float wingSize = WING_SIZE.get(this.getWingId(weapon)).intValue();
        if (weapon.getShip() != null) {
            wingSize = weapon.getShip().getMutableStats().getDynamic().getValue("swarm_launcher_wing_size_mod", wingSize);
        }
        return Math.round(wingSize);
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        CombatFleetManagerAPI manager = engine.getFleetManager(projectile.getOwner());
        manager.setSuppressDeploymentMessages(true);
        ShipAPI leader = manager.spawnShipOrWing(this.getWingId(weapon), projectile.getLocation(), projectile.getFacing(), 0.0f, null);
        leader.getWing().setSourceShip(projectile.getSource());
        manager.setSuppressDeploymentMessages(false);
        Vector2f takeoffVel = Misc.getUnitVectorAtDegreeAngle(projectile.getFacing());
        takeoffVel.scale(leader.getMaxSpeed() * 1.0f);
        for (ShipAPI curr : leader.getWing().getWingMembers()) {
            curr.setDoNotRender(true);
            curr.setExplosionScale(0.0f);
            curr.setHulkChanceOverride(0.0f);
            curr.setImpactVolumeMult(IMPACT_VOLUME_MULT);
            curr.getArmorGrid().clearComponentMap();
            if (this.currWing != null) {
                if (curr.getWing() != null) {
                    curr.getWing().removeMember(curr);
                    manager.removeDeployed(curr.getWing(), false);
                }
                curr.setWing(this.currWing);
                this.currWing.addMember(curr);
            }
            Vector2f.add((Vector2f)curr.getVelocity(), (Vector2f)takeoffVel, (Vector2f)curr.getVelocity());
        }
        this.currWing = leader.getWing();
        RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(weapon.getShip());
        if (sourceSwarm != null) {
            RoilingSwarmEffect swarm = FragmentSwarmHullmod.createSwarmFor(leader);
            int required = FRAGMENT_NUM.get(this.getWingId(weapon));
            int transfer = required;
            if (transfer > 0) {
                Vector2f loc = new Vector2f((ReadableVector2f)takeoffVel);
                loc.scale(0.5f);
                Vector2f.add((Vector2f)loc, (Vector2f)leader.getLocation(), (Vector2f)loc);
                sourceSwarm.transferMembersTo(swarm, transfer, loc, 100.0f);
            }
        }
        engine.removeEntity(projectile);
    }

    public int getPreferredNumFragmentsToFireConsideringAllWeapons(ShipAPI ship) {
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        if (swarm == null) {
            return 0;
        }
        int req = 0;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (!(w.getEffectPlugin() instanceof SwarmLaunchingWeapon) || w.isFiring()) continue;
            SwarmLaunchingWeapon effect = (SwarmLaunchingWeapon)((Object)w.getEffectPlugin());
            req += effect.getPreferredNumFragmentsToFire(w);
        }
        return req;
    }

    @Override
    public int getPreferredNumFragmentsToFire(WeaponAPI weapon) {
        Integer required = FRAGMENT_NUM.get(this.getWingId(weapon));
        if (required == null) {
            return 0;
        }
        int wingSize = this.getWingSize(weapon);
        int num = Math.min(wingSize, 2);
        return required * num;
    }
}

