/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class Automated
extends BaseHullMod {
    public static float MAX_CR_PENALTY = 1.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMinCrewMod().modifyMult(id, 0.0f);
        stats.getMaxCrewMod().modifyMult(id, 0.0f);
        if (this.isInPlayerFleet(stats) && !Automated.isAutomatedNoPenalty(stats)) {
            stats.getMaxCombatReadiness().modifyFlat(id, -MAX_CR_PENALTY, "Automated ship penalty");
        }
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.setInvalidTransferCommandTarget(true);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        boolean noPenalty;
        float opad = 10.0f;
        if (ship == null || ship.getHullSpec().hasTag("auto_rec")) {
            tooltip.addPara("Automated ships usually require specialized equipment and expertise to maintain, resulting in a maximum combat readiness penalty of %s. This penalty can be offset by a fleet commander skilled in the use of automated ships.", opad, Misc.getHighlightColor(), Math.round(MAX_CR_PENALTY * 100.0f) + "%");
        }
        if (this.isInPlayerFleet(ship) && (noPenalty = Automated.isAutomatedNoPenalty(ship))) {
            tooltip.addPara("However, this ship was automated in a fashion that does not require special expertise to maintain. Some of the techniques used are poorly understood, likely dating to an earlier period.", opad, Misc.getHighlightColor(), "does not require special expertise");
        }
    }

    public static boolean isAutomatedNoPenalty(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }

    public static boolean isAutomatedNoPenalty(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        FleetMemberAPI member = ship.getFleetMember();
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }

    public static boolean isAutomatedNoPenalty(FleetMemberAPI member) {
        if (member == null) {
            return false;
        }
        return member.getHullSpec().hasTag("no_auto_penalty") || member.getVariant().hasTag("no_auto_penalty");
    }
}

