/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class FlickerUtilV2 {
    public static final float UP_RATE = 25.0f;
    public static final float DOWN_RATE = 5.0f;
    public static final float END_PROB_PER_BURST = 0.1f;
    private float brightness;
    private float dir = 1.0f;
    private float wait;
    private float maxWait;
    private boolean stopBursts = false;
    private boolean stopAll = false;
    private float angle;
    private float currMax;
    private float currDur;
    private int numBursts = 0;
    private boolean peakFrame = false;

    public FlickerUtilV2() {
        this(4.0f);
    }

    public FlickerUtilV2(float maxWait) {
        this.maxWait = maxWait;
        this.angle = (float)Math.random() * 360.0f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void newBurst() {
        this.currMax = 0.75f + (float)Math.random() * 0.5f;
        if (this.currMax > 1.0f) {
            this.currMax = 1.0f;
        }
        if (this.currMax < this.brightness) {
            this.currMax = this.brightness;
        }
        this.dir = 1.0f;
        this.currDur = 0.0f + (float)Math.random() * 0.5f;
        this.currDur *= this.currDur;
        this.currDur += 0.05f;
        ++this.numBursts;
        this.peakFrame = true;
    }

    public void newWait() {
        this.wait = (float)Math.random() * this.maxWait;
        this.numBursts = 0;
        this.stopBursts = false;
        this.angle = (float)Math.random() * 360.0f;
    }

    public void setWait(float wait) {
        this.wait = wait;
    }

    public void setNumBursts(int numBursts) {
        this.numBursts = numBursts;
    }

    public boolean isPeakFrame() {
        return this.peakFrame;
    }

    public int getNumBursts() {
        return this.numBursts;
    }

    public float getWait() {
        return this.wait;
    }

    public void advance(float amount) {
        this.peakFrame = false;
        if (this.wait > 0.0f) {
            this.wait -= amount;
            if (this.wait > 0.0f) {
                return;
            }
            this.newBurst();
        }
        this.brightness = this.dir > 0.0f ? (this.brightness += amount * 25.0f) : (this.brightness -= amount * 5.0f);
        if (this.brightness < 0.0f) {
            this.brightness = 0.0f;
        }
        if (this.brightness >= this.currMax) {
            this.brightness = this.currMax;
            this.dir = -1.0f;
        }
        this.currDur -= amount;
        if (this.currDur <= 0.0f) {
            if (!this.stopBursts && !this.stopAll) {
                if ((float)Math.random() < 0.1f * (float)this.numBursts) {
                    this.stopBursts = true;
                } else {
                    this.newBurst();
                }
            } else if (!this.stopAll && this.brightness <= 0.0f) {
                this.newWait();
            }
        }
    }

    public void stop() {
        this.stopAll = true;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public static void main(String[] args) {
        FlickerUtilV2 test = new FlickerUtilV2();
        int i = 0;
        while (i < 1000) {
            test.advance(0.016f);
            System.out.println(test.getBrightness());
            ++i;
        }
    }
}

