/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;

public class WeightedRandomPicker<T>
implements Cloneable {
    private List<T> items = new ArrayList<T>();
    private transient List<Float> weights = new ArrayList<Float>();
    private String w;
    private float total = 0.0f;
    private final boolean ignoreWeights;
    private Random random = null;

    public WeightedRandomPicker<T> clone() {
        try {
            WeightedRandomPicker copy = (WeightedRandomPicker)super.clone();
            copy.items = new ArrayList<T>(this.items);
            copy.weights = new ArrayList<Float>(this.weights);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public WeightedRandomPicker() {
        this(false);
    }

    public WeightedRandomPicker(boolean ignoreWeights) {
        this.ignoreWeights = ignoreWeights;
    }

    public WeightedRandomPicker(Random random) {
        this(false);
        this.random = random;
    }

    Object readResolve() {
        try {
            this.weights = new ArrayList<Float>();
            if (this.w != null) {
                JSONArray arr = new JSONArray(this.w);
                int i = 0;
                while (i < arr.length()) {
                    this.weights.add(Float.valueOf((float)arr.getDouble(i)));
                    ++i;
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    Object writeReplace() {
        JSONArray arr = new JSONArray();
        for (Float f : this.weights) {
            arr.put((Object)f);
        }
        this.w = arr.toString();
        return this;
    }

    public void clear() {
        this.items.clear();
        this.weights.clear();
        this.total = 0.0f;
    }

    public void addAll(Collection<T> items) {
        for (T item : items) {
            this.add(item);
        }
    }

    public void addAll(WeightedRandomPicker<T> other) {
        int i = 0;
        while (i < other.items.size()) {
            this.add(other.items.get(i), other.weights.get(i).floatValue());
            ++i;
        }
    }

    public void add(T item) {
        this.add(item, 1.0f);
    }

    public void add(T item, float weight) {
        if (weight <= 0.0f) {
            return;
        }
        this.items.add(item);
        this.weights.add(Float.valueOf(weight));
        this.total += weight;
    }

    public void remove(T item) {
        if (item == null) {
            return;
        }
        int index = this.items.indexOf(item);
        if (index != -1) {
            this.items.remove(index);
            float weight = this.weights.remove(index).floatValue();
            this.total -= weight;
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public List<T> getItems() {
        return this.items;
    }

    public float getWeight(T item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            return 0.0f;
        }
        return this.getWeight(index);
    }

    public float getWeight(int index) {
        return this.weights.get(index).floatValue();
    }

    public void setWeight(int index, float weight) {
        float w = this.getWeight(index);
        this.weights.set(index, Float.valueOf(weight));
        this.total += weight - w;
    }

    public T getItemWithHighestWeight() {
        float maxW = 0.0f;
        int i = 0;
        while (i < this.items.size()) {
            float w = this.getWeight(i);
            if (w > maxW) {
                maxW = w;
            }
            ++i;
        }
        if (maxW <= 0.0f) {
            return null;
        }
        WeightedRandomPicker<T> other = new WeightedRandomPicker<T>();
        int i2 = 0;
        while (i2 < this.items.size()) {
            float w = this.getWeight(i2);
            if (w >= maxW) {
                other.add(this.items.get(i2));
            }
            ++i2;
        }
        return other.pick();
    }

    public T pickAndRemove() {
        T pick = this.pick();
        this.remove(pick);
        return pick;
    }

    public T pick(Random random) {
        Random orig = this.random;
        this.random = random;
        T pick = this.pick();
        this.random = orig;
        return pick;
    }

    public T pick() {
        if (this.items.isEmpty()) {
            return null;
        }
        if (this.ignoreWeights) {
            int index = this.random != null ? (int)(this.random.nextDouble() * (double)this.items.size()) : (int)(Math.random() * (double)this.items.size());
            return this.items.get(index);
        }
        float random = this.random != null ? this.random.nextFloat() * this.total : (float)(Math.random() * (double)this.total);
        if (random > this.total) {
            random = this.total;
        }
        float weightSoFar = 0.0f;
        int index = 0;
        for (Float weight : this.weights) {
            if (random <= (weightSoFar += weight.floatValue())) break;
            ++index;
        }
        return this.items.get(Math.min(index, this.items.size() - 1));
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void print(String title) {
        System.out.println(title);
        HashMap<T, Integer> indices = new HashMap<T, Integer>();
        int i = 0;
        while (i < this.items.size()) {
            Object item = this.items.get(i);
            indices.put(item, i);
            ++i;
        }
        ArrayList<T> sorted = new ArrayList<T>(this.items);
        Collections.sort(sorted, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Object item : sorted) {
            int index = (Integer)indices.get(item);
            float weight = this.weights.get(index).floatValue();
            String percent = (int)(weight / this.total * 100.0f) + "%";
            String itemStr = "";
            itemStr = item instanceof MarketAPI ? ((MarketAPI)item).getName() : item.toString();
            System.out.println(String.format("    %-30s%10s%10s", itemStr, percent, Misc.getRoundedValue(weight)));
        }
    }

    public float getTotal() {
        return this.total;
    }
}

