/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.Sprite;
import com.fs.starfarer.O0OO;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.OrbitalStationAPI;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.util.oOOO;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.oo0O;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class CampaignOrbitalStation
extends BaseCampaignEntity
implements DoNotObfuscate,
OrbitalStationAPI {
    private transient Sprite shadowMask;
    private transient Sprite sprite;
    private float width;
    private float height;
    private float radius;
    private CampaignEntity lightSource;
    private CargoData cargo = new CargoData(false);
    private final String category;
    private final String key;
    private EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.STATIONS);

    public CampaignOrbitalStation(String string, String string2, String string3, CampaignEntity campaignEntity) {
        this(string, string2, string3, "stations", "default_station", 75.0f, campaignEntity);
    }

    public CampaignOrbitalStation(String string, String string2, String string3, String string4, String string5, float f2, CampaignEntity campaignEntity) {
        super(string);
        this.category = string4;
        this.key = string5;
        this.setName(string2);
        this.lightSource = campaignEntity;
        if (string3 == null) {
            string3 = "neutral";
        }
        this.setFaction(CampaignEngine.getInstance().getFaction(string3));
        this.radius = f2;
        this.height = this.width = (float)Math.sqrt(f2 * f2 / 2.0f);
        this.readResolve();
        oOOO.o o2 = oOOO.o.\u00d200000;
        Color color = O0OO.new.String;
        this.cargo.initMothballedShips(string3);
        this.getIndicator().o00000(this.getFaction().getSpec().getColor(), this.getFaction().getSecondaryUIColor(), this.getFaction().getSecondarySegments());
        this.addTag("station");
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.getIndicator().o00000(this.getFaction().getSpec().getColor(), this.getFaction().getSpec().getSecondaryUIColor(), this.getFaction().getSecondarySegments());
        String string = StarfarerSettings.\u00d200000(this.category, this.key);
        this.sprite = new Sprite(string);
        this.sprite.setSize(this.width, this.height);
        this.shadowMask = new Sprite("graphics/fx/ship_shadow_mask.png");
        this.shadowMask.setSize(this.height * 1.5f, this.height * 1.5f);
        return this;
    }

    @Override
    public CargoData getCargo() {
        return this.cargo;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
    }

    public float getSelectionSize() {
        return this.radius;
    }

    @Override
    public float getRadius() {
        return this.getSelectionSize();
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), Math.max(this.width, this.height) + 100.0f)) {
            return;
        }
        if (campaignEngineLayers == CampaignEngineLayers.STATIONS) {
            float f2 = combatViewport.getAlphaMult();
            this.sprite.setAngle(this.getFacing() - 90.0f);
            Vector2f vector2f = this.getLocation();
            this.sprite.setNormalBlend();
            this.sprite.setAlphaMult(f2);
            this.sprite.renderAtCenter(vector2f.x, vector2f.y);
            if (this.lightSource != null) {
                float f3;
                float f4 = f3 = this.shadowMask.getWidth() * 1.41f;
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
                oo0O.\u00d500000(0.0f - f3 / 2.0f - 1.0f, 0.0f - f4 / 2.0f - 1.0f, f3 + 2.0f, f4 + 2.0f, oo0O.o00000, 0.0f);
                GL11.glPopMatrix();
                this.sprite.setBlendFunc(1, 0);
                this.sprite.renderAtCenter(vector2f.x, vector2f.y);
                float f5 = Utils.class(this.getLocation(), this.lightSource.getLocation());
                this.shadowMask.setAlphaMult(f2);
                this.shadowMask.setAngle(f5);
                this.shadowMask.setBlendFunc(0, 770);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.shadowMask.setBlendFunc(772, 773);
                this.shadowMask.renderAtCenter(vector2f.x, vector2f.y);
            }
        }
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public FleetData getAvailableShips() {
        return this.cargo.getMothballedShips();
    }

    @Override
    public boolean isInHyperspace() {
        if (this.getContainingLocation() == null) {
            return false;
        }
        return this.getContainingLocation().isHyperspaceMode();
    }

    public boolean isStar() {
        return false;
    }
}

