/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.entities.terrain.Planet;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.PlanetSpec;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class CampaignPlanet
extends BaseCampaignEntity
implements DoNotObfuscate,
PlanetAPI {
    private transient Planet graphics;
    private float angle;
    private float cloudAngle;
    private float radius;
    private String type;
    private transient PlanetSpec spec = null;
    private PlanetSpec.PlanetSpecDiff diff = null;
    private Color lightColorOverrideIfStar = null;
    protected Color secondLightColor = null;
    protected Vector3f secondLightLocation = null;
    private EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.PLANETS, CampaignEngineLayers.ABOVE);
    protected String descriptionIdOverride = null;

    public CampaignPlanet(String string, String string2, String string3, float f2, float f3, float f4, CampaignEntity campaignEntity) {
        super(string);
        this.setName(string2);
        this.type = string3;
        this.radius = f2;
        this.setLightSource(campaignEntity);
        this.graphics = new Planet(string3, f2, 0.0f, new Vector2f());
        this.getLocation().set(f3, f4);
        this.graphics.setAngle((float)Math.random() * 360.0f);
        if (this.graphics.isStar()) {
            this.addTag("star");
        } else {
            if (this.graphics.isGasGiant()) {
                this.addTag("gas_giant");
            }
            this.addTag("planet");
        }
    }

    public void changeType(String string, Random random) {
        PlanetGenDataSpec planetGenDataSpec = SpecStore.o00000(PlanetGenDataSpec.class, string);
        if (planetGenDataSpec == null) {
            return;
        }
        this.type = string;
        if (random == null) {
            random = new Random();
        }
        this.spec = SpecStore.o00000(PlanetSpec.class, string).clone();
        Color color = CampaignPlanet.getColor(planetGenDataSpec.getMinColor(), planetGenDataSpec.getMaxColor(), random);
        this.spec.setPlanetColor(color);
        if (this.spec.getAtmosphereThickness() > 0.0f) {
            Color color2 = Misc.interpolateColor((Color)this.spec.getAtmosphereColor(), (Color)color, (float)0.25f);
            color2 = Misc.setAlpha((Color)color2, (int)this.spec.getAtmosphereColor().getAlpha());
            this.spec.setAtmosphereColor(color2);
            if (this.spec.getCloudTexture() != null) {
                Color color3 = Misc.interpolateColor((Color)this.spec.getCloudColor(), (Color)color, (float)0.25f);
                color3 = Misc.setAlpha((Color)color3, (int)this.spec.getCloudColor().getAlpha());
                this.spec.setAtmosphereColor(color2);
            }
        }
        float f2 = this.spec.getTilt();
        float f3 = this.spec.getPitch();
        float f4 = Math.signum(random.nextFloat() - 0.5f);
        double d2 = random.nextFloat();
        f2 = f4 > 0.0f ? (float)((double)f2 + d2 * 45.0) : (float)((double)f2 + d2 * -45.0);
        f4 = Math.signum(random.nextFloat() - 0.5f);
        d2 = random.nextFloat();
        if (f4 > 0.0f) {
            f3 = (float)((double)f3 + d2 * 45.0);
        } else {
            f2 = (float)((double)f2 + d2 * -15.0);
        }
        this.spec.setTilt(f2);
        this.spec.setPitch(f3);
        this.applySpecChanges();
        try {
            this.diff = PlanetSpec.createDiff(string, this.spec);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.graphics = new Planet(string, this.radius, 0.0f, new Vector2f());
        this.removeTag("star");
        this.removeTag("planet");
        this.removeTag("gas_giant");
        if (this.graphics.isStar()) {
            this.addTag("star");
        } else {
            if (this.graphics.isGasGiant()) {
                this.addTag("gas_giant");
            }
            this.addTag("planet");
        }
    }

    public static Color getColor(Color color, Color color2, Random random) {
        Color color3 = new Color((int)((double)color.getRed() + (double)(color2.getRed() - color.getRed()) * random.nextDouble()), (int)((double)color.getGreen() + (double)(color2.getGreen() - color.getGreen()) * random.nextDouble()), (int)((double)color.getBlue() + (double)(color2.getBlue() - color.getBlue()) * random.nextDouble()), 255);
        return color3;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.graphics = new Planet(this.type, this.radius, 0.0f, new Vector2f());
        this.graphics.setAngle(this.angle % 360.0f);
        this.graphics.setCloudAngle(this.cloudAngle % 360.0f);
        if (this.diff != null) {
            try {
                if (this.spec == null) {
                    this.spec = this.getSpec();
                }
                PlanetSpec.updateFromDiff(this.spec, this.diff);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.spec != null) {
            this.graphics.setSpec(this.spec);
        }
        return this;
    }

    @Override
    protected Object writeReplace() {
        super.writeReplace();
        if (this.spec != null) {
            try {
                this.diff = PlanetSpec.createDiff(this.type, this.spec);
                if (this.diff.data != null && this.diff.data.isEmpty()) {
                    this.diff = null;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this;
    }

    public Color getLightColorOverrideIfStar() {
        return this.lightColorOverrideIfStar;
    }

    public void setLightColorOverrideIfStar(Color color) {
        this.lightColorOverrideIfStar = color;
    }

    public boolean isBlackHole() {
        return this.getSpec().isBlackHole();
    }

    public boolean isStar() {
        return this.graphics.isStar();
    }

    public boolean isGasGiant() {
        return this.graphics.isGasGiant();
    }

    public boolean isMoon() {
        if (!(this.getContainingLocation() instanceof StarSystem)) {
            return false;
        }
        if (this.getOrbit() == null) {
            return false;
        }
        if (this.getOrbit().getFocus() instanceof PlanetAPI) {
            PlanetAPI planetAPI = (PlanetAPI)this.getOrbit().getFocus();
            return !planetAPI.isStar();
        }
        return false;
    }

    public CampaignPlanet(String string, String string2, String string3, float f2, CampaignEntity campaignEntity) {
        this(string, string2, string3, f2, 0.0f, 0.0f, campaignEntity);
    }

    public CampaignPlanet(String string, String string2, String string3, float f2) {
        this(string, string2, string3, f2, 0.0f, 0.0f, null);
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        this.graphics.advance(f2);
        this.angle = this.graphics.getAngle();
        this.cloudAngle = this.graphics.getCloudAngle();
        this.graphics.getLocation().set((ReadableVector2f)this.getLocation());
        if (f2 > 0.0f) {
            this.setSecondLight(null, null);
        }
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!this.graphics.isStar() && !combatViewport.isNearViewport(this.getLocation(), this.radius + 1000.0f)) {
            return;
        }
        float f2 = combatViewport.getAlphaMult();
        if (this.getLightSource() != null) {
            Vector2f vector2f = this.getLightSource().getLocation();
            if (this.isStar()) {
                this.graphics.resetLightLocation();
            } else {
                float f3 = Utils.\u00d800000(this.getLocation(), vector2f);
                float f4 = 1.0f;
                if (this.getContainingLocation() != null && this.getContainingLocation().getLightHeight() != null) {
                    float f5 = this.getContainingLocation().getLightHeight().getBrightness();
                    f4 = 1.5f * f5 - 0.5f;
                }
                Color color = this.getLightColor();
                if (this.getLightSource().hasTag("ambient_ls")) {
                    this.graphics.setLightSourceLocation(this.getLocation().x, this.getLocation().y, this.getRadius() * 2.0f);
                } else {
                    this.graphics.setLightSourceLocation(vector2f.x, vector2f.y, f3 * 0.75f * f4);
                }
                this.graphics.setLightColorOverride(color);
            }
        } else {
            this.graphics.resetLightLocation();
            this.graphics.setLightColorOverride(null);
        }
        this.graphics.setSecondLight(this.secondLightLocation, this.secondLightColor);
        if (campaignEngineLayers == CampaignEngineLayers.PLANETS) {
            this.graphics.renderSphere(combatViewport);
        } else if (campaignEngineLayers == CampaignEngineLayers.ABOVE) {
            this.graphics.renderStarGlow(combatViewport);
        }
    }

    public void setSecondLight(Vector3f vector3f, Color color) {
        this.secondLightColor = color;
        this.secondLightLocation = vector3f;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f2) {
        this.radius = f2;
        if (this.graphics != null) {
            this.graphics.setRadius(f2);
        }
    }

    public Planet getGraphics() {
        return this.graphics;
    }

    public String getTypeId() {
        return this.graphics.getType();
    }

    public void setTypeId(String string) {
        this.type = string;
    }

    public String getDescriptionIdOverride() {
        return this.descriptionIdOverride;
    }

    public void setDescriptionIdOverride(String string) {
        this.descriptionIdOverride = string;
    }

    public String getDescriptionId() {
        if (this.descriptionIdOverride != null) {
            return this.descriptionIdOverride;
        }
        return this.graphics.getSpec().getDescriptionId();
    }

    public PlanetSpec getSpec() {
        if (this.spec == null) {
            this.spec = this.graphics.getSpec().clone();
        }
        return this.spec;
    }

    public void applySpecChanges() {
        this.graphics.setSpec(this.spec);
        this.spec = this.spec.clone();
    }

    public boolean hasCondition(String string) {
        return this.getMarket() != null && this.getMarket().hasCondition(string);
    }

    public String getTypeNameWithWorld() {
        if (this.isGasGiant() || this.isStar()) {
            return this.getSpec().getName();
        }
        return String.valueOf(this.getSpec().getName()) + " World";
    }

    public String getTypeNameWithWorldLowerCase() {
        if (this.isGasGiant() || this.isStar()) {
            return this.getSpec().getName().toLowerCase();
        }
        return (String.valueOf(this.getSpec().getName()) + " World").toLowerCase();
    }

    public String getTypeNameWithLowerCaseWorld() {
        if (this.isGasGiant() || this.isStar()) {
            return this.getSpec().getName();
        }
        return String.valueOf(this.getSpec().getName()) + " world";
    }

    public boolean isNormalStar() {
        return this.isStar() && !this.getSpec().isBlackHole() && !this.getSpec().isPulsar() && !this.getSpec().isNebulaCenter();
    }
}

