/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignClock;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import org.lwjgl.util.vector.Vector2f;

public class CircularFleetOrbit
implements OrbitAPI,
DoNotObfuscate {
    private CampaignFleet fleet;
    private SectorEntityToken focus;
    private float radius;
    private float orbitalPeriod = 365.0f;
    private float currAngle;
    private IntervalTracker it = new IntervalTracker(0.25f, 0.75f);
    private Vector2f temp = new Vector2f();

    public CircularFleetOrbit(CampaignFleet campaignFleet, SectorEntityToken sectorEntityToken) {
        this.fleet = campaignFleet;
        this.focus = sectorEntityToken;
        this.radius = Utils.\u00d800000(campaignFleet.getLocation(), sectorEntityToken.getLocation());
        this.currAngle = Utils.class(sectorEntityToken.getLocation(), campaignFleet.getLocation());
    }

    public CircularFleetOrbit(CampaignFleet campaignFleet, SectorEntityToken sectorEntityToken, float f2) {
        this(campaignFleet, sectorEntityToken, f2, (float)Math.random() * 360.0f);
    }

    public CircularFleetOrbit(CampaignFleet campaignFleet, SectorEntityToken sectorEntityToken, float f2, float f3) {
        this.fleet = campaignFleet;
        this.focus = sectorEntityToken;
        this.radius = f2;
        this.currAngle = f3;
    }

    protected Object readResolve() {
        if (this.it == null) {
            this.it = new IntervalTracker(0.25f, 0.75f);
        }
        return this;
    }

    public void setEntity(SectorEntityToken sectorEntityToken) {
        this.fleet = (CampaignFleet)sectorEntityToken;
    }

    public void setFocus(SectorEntityToken sectorEntityToken) {
        this.focus = sectorEntityToken;
    }

    public SectorEntityToken getFleet() {
        return this.fleet;
    }

    public SectorEntityToken getFocus() {
        return this.focus;
    }

    public void advance(float f2) {
        this.it.advance(f2);
        if (this.it.intervalElapsed()) {
            this.ungroup();
        }
        float f3 = (float)Math.PI * 2 * this.radius;
        float f4 = f3 / this.orbitalPeriod;
        float f5 = 360.0f / (f3 / f4);
        CampaignClock campaignClock = CampaignEngine.getInstance().getClock();
        float f6 = this.currAngle - f5 * campaignClock.convertToDays(f2);
        Vector2f.add((Vector2f)this.focus.getLocation(), (Vector2f)((Vector2f)Utils.\u00d300000(f6).scale(this.radius)), (Vector2f)this.temp);
        this.currAngle = Utils.o00000(f6);
        this.fleet.setMoveDestination(this.temp.x, this.temp.y);
    }

    private void ungroup() {
        float f2;
        float f3;
        if (this.fleet.getContainingLocation() == null) {
            return;
        }
        ArrayList<CampaignFleetAPI> arrayList = new ArrayList<CampaignFleetAPI>();
        arrayList.add(this.fleet);
        Vector2f vector2f = new Vector2f();
        CampaignFleetAPI campaignFleetAPI = null;
        float f4 = 100000.0f;
        float f5 = 0.0f;
        for (CampaignFleetAPI campaignFleetAPI2 : this.fleet.getContainingLocation().getFleets()) {
            if (campaignFleetAPI2 == this.fleet || !(campaignFleetAPI2.getOrbit() instanceof CircularFleetOrbit)) continue;
            f3 = this.fleet.getRadius() + campaignFleetAPI2.getRadius() + 10.0f;
            f2 = Misc.getDistance((SectorEntityToken)this.fleet, (SectorEntityToken)campaignFleetAPI2);
            if (!(f2 < f3)) continue;
            arrayList.add(campaignFleetAPI2);
            Vector2f.add((Vector2f)vector2f, (Vector2f)campaignFleetAPI2.getLocation(), (Vector2f)vector2f);
            f5 += 1.0f;
            if (!(f2 < f4)) continue;
            campaignFleetAPI = campaignFleetAPI2;
            f4 = f2;
        }
        if (f5 > 0.0f) {
            vector2f.scale(1.0f / f5);
            float f6 = Misc.getAngleInDegrees((Vector2f)this.focus.getLocation(), (Vector2f)vector2f);
            float f7 = Utils.new(f6, this.currAngle);
            if (f7 < 0.0f) {
                this.currAngle += f7 * 5.0f * this.it.getIntervalDuration();
                f3 = 0.0f;
                f2 = arrayList.size();
                for (CampaignFleetAPI campaignFleetAPI3 : arrayList) {
                    CircularFleetOrbit circularFleetOrbit = (CircularFleetOrbit)campaignFleetAPI3.getOrbit();
                    f3 += circularFleetOrbit.getOrbitalPeriod();
                }
                if (f2 >= 2.0f) {
                    float f8 = f3 / f2;
                    for (CampaignFleetAPI campaignFleetAPI4 : arrayList) {
                        if (!(campaignFleetAPI4.getOrbit() instanceof CircularFleetOrbit)) continue;
                        CircularFleetOrbit circularFleetOrbit = (CircularFleetOrbit)campaignFleetAPI4.getOrbit();
                        circularFleetOrbit.setPeriod(f8);
                    }
                }
                if (campaignFleetAPI != null) {
                    float f9 = this.focus.getRadius() + 50.0f;
                    float f10 = Math.max(this.radius, this.focus.getRadius() + 250.0f);
                    float f11 = 1.0f;
                    if (campaignFleetAPI.getRadius() > this.fleet.getRadius()) {
                        f11 = -1.0f;
                    }
                    this.radius += f11 * 20.0f * this.it.getIntervalDuration();
                    if (this.radius < f9) {
                        this.radius = f9;
                    }
                    if (this.radius > f10) {
                        this.radius = f10;
                    }
                }
            }
        }
    }

    public CircularFleetOrbit setSpeed(float f2) {
        float f3 = (float)Math.PI * 2 * this.radius;
        float f4 = 10.0f;
        this.orbitalPeriod = f3 / f2 / f4;
        return this;
    }

    public CircularFleetOrbit setPeriod(float f2) {
        this.orbitalPeriod = f2;
        return this;
    }

    public CircularFleetOrbit setCurrAngle(float f2) {
        this.currAngle = f2;
        return this;
    }

    public OrbitAPI makeCopy() {
        CircularFleetOrbit circularFleetOrbit = new CircularFleetOrbit(this.fleet, this.focus);
        circularFleetOrbit.currAngle = this.currAngle;
        circularFleetOrbit.orbitalPeriod = this.orbitalPeriod;
        circularFleetOrbit.radius = this.radius;
        return circularFleetOrbit;
    }

    public Vector2f computeCurrentLocation() {
        return null;
    }

    public float getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public void updateLocation() {
    }
}

