/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CircularOrbitWithSpinAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.campaign.CampaignClock;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.Vector2f;

public class CircularOrbitWithSpin
implements OrbitAPI,
CircularOrbitWithSpinAPI,
DoNotObfuscate {
    private SectorEntityToken entity;
    private SectorEntityToken focus;
    private float radius;
    private float orbitalPeriod = 365.0f;
    private float currAngle;
    private float currFacing;
    private float spinVel;

    public OrbitAPI makeCopy() {
        CircularOrbitWithSpin circularOrbitWithSpin = new CircularOrbitWithSpin(this.entity, this.focus);
        circularOrbitWithSpin.radius = this.radius;
        circularOrbitWithSpin.currAngle = this.currAngle;
        circularOrbitWithSpin.orbitalPeriod = this.orbitalPeriod;
        circularOrbitWithSpin.spinVel = this.spinVel;
        circularOrbitWithSpin.currFacing = this.currFacing;
        return circularOrbitWithSpin;
    }

    public CircularOrbitWithSpin(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2) {
        this.entity = sectorEntityToken;
        this.focus = sectorEntityToken2;
    }

    public CircularOrbitWithSpin(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, float f2, float f3, float f4, float f5) {
        this.entity = sectorEntityToken;
        this.focus = sectorEntityToken2;
        this.radius = f2;
        this.currAngle = f3;
        this.currFacing = (float)Math.random() * 360.0f;
        this.spinVel = f4 + (float)Math.random() * (f5 - f4);
        if ((float)Math.random() > 0.5f) {
            this.spinVel = -this.spinVel;
        }
        this.updateLocation();
    }

    public void setEntity(SectorEntityToken sectorEntityToken) {
        this.entity = sectorEntityToken;
    }

    public void setFocus(SectorEntityToken sectorEntityToken) {
        this.focus = sectorEntityToken;
        this.updateLocation();
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public SectorEntityToken getFocus() {
        return this.focus;
    }

    public void advance(float f2) {
        float f3 = (float)Math.PI * 2 * this.radius;
        float f4 = f3 / this.orbitalPeriod;
        float f5 = 360.0f / (f3 / f4);
        CampaignClock campaignClock = CampaignEngine.getInstance().getClock();
        float f6 = campaignClock.convertToDays(f2);
        float f7 = this.currAngle - f5 * f6;
        Vector2f.add((Vector2f)this.focus.getLocation(), (Vector2f)((Vector2f)Utils.\u00d300000(f7).scale(this.radius)), (Vector2f)this.entity.getLocation());
        if (this.entity instanceof CampaignFleetAPI) {
            ((CampaignFleetAPI)this.entity).setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
        }
        this.currAngle = Utils.o00000(f7);
        this.currFacing += this.spinVel * f6;
        this.currFacing = Utils.o00000(this.currFacing);
        this.entity.setFacing(this.currFacing);
    }

    public void updateLocation() {
        if (this.focus == null || this.entity == null) {
            return;
        }
        Vector2f.add((Vector2f)this.focus.getLocation(), (Vector2f)((Vector2f)Utils.\u00d300000(this.currAngle).scale(this.radius)), (Vector2f)this.entity.getLocation());
    }

    public Vector2f computeCurrentLocation() {
        if (this.focus == null) {
            return new Vector2f();
        }
        Vector2f vector2f = new Vector2f();
        Vector2f.add((Vector2f)this.focus.getLocation(), (Vector2f)((Vector2f)Utils.\u00d300000(this.currAngle).scale(this.radius)), (Vector2f)vector2f);
        return vector2f;
    }

    public CircularOrbitWithSpin setSpeed(float f2) {
        float f3 = (float)Math.PI * 2 * this.radius;
        float f4 = 10.0f;
        this.orbitalPeriod = f3 / f2 / f4;
        return this;
    }

    public CircularOrbitWithSpin setPeriod(float f2) {
        this.orbitalPeriod = f2;
        return this;
    }

    public CircularOrbitWithSpin setCurrAngle(float f2) {
        this.currAngle = f2;
        this.updateLocation();
        return this;
    }

    public float getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getCurrAngle() {
        return this.currAngle;
    }

    public float getSpinVel() {
        return this.spinVel;
    }

    public void setSpinVel(float f2) {
        this.spinVel = f2;
    }
}

