/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignMissionPlugin;
import com.fs.starfarer.api.campaign.MissionBoardAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MissionBoard
implements MissionBoardAPI,
DoNotObfuscate {
    private List<MissionAvailability> missions = new ArrayList<MissionAvailability>();

    public void advance(float f2) {
        if (Global.getSector().isPaused()) {
            return;
        }
        for (MissionAvailability missionAvailability : new ArrayList<MissionAvailability>(this.missions)) {
            missionAvailability.mission.advance(f2);
        }
    }

    public int getNumMissions(Class<?> clazz) {
        int n2 = 0;
        for (MissionAvailability missionAvailability : new ArrayList<MissionAvailability>(this.missions)) {
            if (!clazz.isInstance(missionAvailability.getMission())) continue;
            ++n2;
        }
        return n2;
    }

    public List<MissionBoardAPI.MissionAvailabilityAPI> getMissionsCopy() {
        return new ArrayList<MissionBoardAPI.MissionAvailabilityAPI>(this.missions);
    }

    public List<MissionAvailability> getMissions() {
        return this.missions;
    }

    public void makeAvailableAt(CampaignMissionPlugin campaignMissionPlugin, MarketAPI marketAPI) {
        for (SectorEntityToken sectorEntityToken : marketAPI.getConnectedEntities()) {
            this.makeAvailableAt(campaignMissionPlugin, CampaignEngine.getInstance().getEntityById(sectorEntityToken.getId()));
        }
    }

    public void makeAvailableAt(CampaignMissionPlugin campaignMissionPlugin, String string) {
        this.makeAvailableAt(campaignMissionPlugin, CampaignEngine.getInstance().getEntityById(string));
    }

    public void makeUnavailableAt(CampaignMissionPlugin campaignMissionPlugin, String string) {
        this.makeUnavailableAt(campaignMissionPlugin, CampaignEngine.getInstance().getEntityById(string));
    }

    public void makeAvailableAt(CampaignMissionPlugin campaignMissionPlugin, SectorEntityToken sectorEntityToken) {
        MissionAvailability missionAvailability = this.getDataForMission(campaignMissionPlugin);
        missionAvailability.availableAt.add(sectorEntityToken);
    }

    public void makeUnavailableAt(CampaignMissionPlugin campaignMissionPlugin, SectorEntityToken sectorEntityToken) {
        MissionAvailability missionAvailability = this.getDataForMission(campaignMissionPlugin);
        missionAvailability.availableAt.remove(sectorEntityToken);
    }

    public void removeMission(CampaignMissionPlugin campaignMissionPlugin, boolean bl) {
        this.removeMission(campaignMissionPlugin.getId(), bl);
    }

    public void removeMission(String string, boolean bl) {
        for (MissionAvailability missionAvailability : this.missions) {
            if (!string.equals(missionAvailability.mission.getId())) continue;
            this.missions.remove(missionAvailability);
            if (bl) {
                missionAvailability.getMission().cleanup();
            }
            return;
        }
    }

    public MissionBoardAPI.MissionAvailabilityAPI getAvailabilityForMission(String string) {
        return this.getDataForMission(string);
    }

    public MissionAvailability getDataForMission(String string) {
        for (MissionAvailability missionAvailability : this.missions) {
            if (!string.equals(missionAvailability.mission.getId())) continue;
            return missionAvailability;
        }
        return null;
    }

    public MissionAvailability getDataForMission(CampaignMissionPlugin campaignMissionPlugin) {
        MissionAvailability missionAvailability2;
        for (MissionAvailability missionAvailability2 : this.missions) {
            if (missionAvailability2.mission != campaignMissionPlugin) continue;
            return missionAvailability2;
        }
        missionAvailability2 = new MissionAvailability();
        missionAvailability2.mission = campaignMissionPlugin;
        this.missions.add(missionAvailability2);
        return missionAvailability2;
    }

    public static class MissionAvailability
    implements MissionBoardAPI.MissionAvailabilityAPI,
    DoNotObfuscate {
        private Set<SectorEntityToken> availableAt = new HashSet<SectorEntityToken>();
        private CampaignMissionPlugin mission;

        public Set<SectorEntityToken> getAvailableAt() {
            return this.availableAt;
        }

        public CampaignMissionPlugin getMission() {
            return this.mission;
        }
    }
}

