/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract.iter;

import com.fs.starfarer.campaign.econ.contract.ContractEconomy;
import com.fs.util.DoNotObfuscate;

public abstract class MultiFrameTask
implements DoNotObfuscate {
    private static double ticksPerSecond = 1.0E9;
    protected double maxBudgetPerFrame;

    public MultiFrameTask() {
        this(0.001);
    }

    public MultiFrameTask(double d2) {
        this.maxBudgetPerFrame = d2;
    }

    public void advance(float f2) {
        double d2 = (double)System.nanoTime() / ticksPerSecond;
        double d3 = 0.0;
        double d4 = 0.0;
        float f3 = 1.0f;
        while (!this.isDone()) {
            this.doNextBatch();
            double d5 = (double)System.nanoTime() / ticksPerSecond;
            d4 = d5 - d2;
            if (d4 < this.maxBudgetPerFrame * (double)f3 && this.maxBudgetPerFrame * (double)f3 - d4 >= d4 / (d3 += 1.0)) continue;
        }
        if (ContractEconomy.DEBUG && d4 > this.maxBudgetPerFrame) {
            int n2 = (int)Math.round((d4 / this.maxBudgetPerFrame - 0.0) * 100.0);
            System.out.println("Exceeded frame budget: " + this.getLoggingIdentifier() + ", " + n2 + "%, " + (int)d3 + " iterations");
        }
    }

    public abstract void doNextBatch();

    public abstract boolean isDone();

    public abstract String getLoggingIdentifier();
}

