/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.util.DoNotObfuscate;

public class CrewComposition
implements DoNotObfuscate,
CrewCompositionAPI {
    private float crew;
    private float marines;

    public int getCrewInt() {
        return (int)this.crew;
    }

    public void removeAllCrew() {
        this.crew = 0.0f;
        this.marines = 0.0f;
    }

    public void addCrew(float f2) {
        this.crew += f2;
        if (this.crew < 0.0f) {
            this.crew = 0.0f;
        }
    }

    public float getCrew() {
        return this.crew;
    }

    public void setCrew(float f2) {
        this.crew = f2;
    }

    public void transfer(float f2, CrewCompositionAPI crewCompositionAPI) {
        f2 = Math.round(f2);
        float f3 = Math.min(f2, this.crew);
        this.crew -= f3;
        if (crewCompositionAPI != null) {
            crewCompositionAPI.addCrew(f3);
        }
    }

    public void addMarines(float f2) {
        this.marines += f2;
        if (this.marines < 0.0f) {
            this.marines = 0.0f;
        }
    }

    public float getMarines() {
        return this.marines;
    }

    public void setMarines(float f2) {
        this.marines = f2;
    }

    public void addAll(CrewCompositionAPI crewCompositionAPI) {
        this.addCrew(crewCompositionAPI.getCrew());
        this.addMarines(crewCompositionAPI.getMarines());
    }

    public void removeAll(CrewCompositionAPI crewCompositionAPI) {
        this.addCrew(-crewCompositionAPI.getCrew());
        this.addMarines(-crewCompositionAPI.getMarines());
    }

    public void multiplyBy(float f2) {
        this.setCrew((int)Math.ceil(this.getCrew() * f2));
        this.setMarines((int)Math.ceil(this.getMarines() * f2));
    }

    public void addToCargo(CargoAPI cargoAPI) {
        cargoAPI.addCrew((int)this.getCrew());
        cargoAPI.addMarines((int)this.getMarines());
    }

    public void removeFromCargo(CargoAPI cargoAPI) {
        cargoAPI.removeCrew((int)this.getCrew());
        cargoAPI.removeMarines((int)this.getMarines());
    }

    public void clear() {
        this.marines = 0.0f;
        this.crew = 0.0f;
    }
}

