/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BuffManager;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.fleet.CrewComposition;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.fleet.FleetMemberStatus;
import com.fs.starfarer.campaign.fleet.RepairTracker;
import com.fs.starfarer.combat.CombatFleetManager;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.E;
import com.fs.starfarer.coreui.refit.U;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.loading.specs.O;
import com.fs.starfarer.loading.specs.g;
import com.fs.starfarer.loading.specs.intsuper;
import com.fs.starfarer.rpg.A;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.Vector2f;

public class FleetMember
implements FleetMemberAPI,
DoNotObfuscate {
    private int owner;
    private String specId;
    private String shipName;
    private FleetMemberType type;
    private transient String personalityOverride = null;
    private transient FighterWingSpec wingSpec;
    private transient HullVariantSpec variant = null;
    private transient E stats;
    private HullVariantSpec savedVariant = null;
    private boolean isFlagship = false;
    private Person captain = null;
    private CrewComposition crewComposition = new CrewComposition();
    private FleetMemberStatus status;
    private String id = Misc.genUID();
    private RepairTracker repairTracker;
    private transient boolean isAlly = false;
    private String spriteOverride = null;
    private Vector2f overrideSpriteSize = null;
    private BuffManager buffManager;
    private boolean statUpdateNeeded = false;
    private transient boolean forceNoMoreStatsUpdates = false;
    private transient PersonAPI fleetCommanderForStats = null;
    private transient FleetDataAPI fleetDataForStats = null;
    private transient float cachedStrength = -1.0f;
    private FleetData fleetData = null;
    private boolean civilian = false;
    private boolean computedCivilian = false;

    public void setSpriteOverride(String string) {
        this.spriteOverride = string;
    }

    public String getSpriteOverride() {
        return this.spriteOverride;
    }

    public Vector2f getOverrideSpriteSize() {
        return this.overrideSpriteSize;
    }

    public void setOverrideSpriteSize(Vector2f vector2f) {
        this.overrideSpriteSize = vector2f;
    }

    public boolean isAlly() {
        return this.isAlly;
    }

    public void setAlly(boolean bl) {
        this.isAlly = bl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public FleetMember(int n2, HullVariantSpec hullVariantSpec, FleetMemberType fleetMemberType) {
        this.variant = hullVariantSpec;
        this.init(n2, hullVariantSpec.getHullVariantId(), fleetMemberType, null);
        this.updateStats();
    }

    public FleetMember(int n2, String string, FleetMemberType fleetMemberType) {
        this(n2, string, fleetMemberType, null);
    }

    public FleetMember(int n2, String string, FleetMemberType fleetMemberType, String string2) {
        this.init(n2, string, fleetMemberType, string2);
    }

    private void init(int n2, String string, FleetMemberType fleetMemberType, String string2) {
        this.shipName = string2;
        this.owner = n2;
        this.specId = string;
        this.type = fleetMemberType;
        this.buffManager = new BuffManager(this);
        this.captain = new Person("steady");
        this.updateVariantIfNeeded();
        this.status = new FleetMemberStatus(this);
        this.repairTracker = new RepairTracker(this);
        this.updateStats();
    }

    public int getNumFightersInWing() {
        return this.wingSpec.getNumFighters();
    }

    public RepairTracker getRepairTracker() {
        return this.repairTracker;
    }

    public float getCR() {
        return this.repairTracker.getCR();
    }

    private void updateVariantIfNeeded() {
        if (this.variant == null && this.savedVariant != null) {
            this.variant = this.savedVariant;
            return;
        }
        if (this.variant == null || this.type == FleetMemberType.FIGHTER_WING && this.wingSpec == null) {
            switch (this.type) {
                case FIGHTER_WING: {
                    this.wingSpec = SpecStore.o00000(FighterWingSpec.class, this.specId);
                    if (this.wingSpec == null) {
                        throw new RuntimeException(String.format("[%s] is not a valid fighter wing id", this.specId));
                    }
                    this.variant = SpecStore.o00000(HullVariantSpec.class, this.wingSpec.getVariantId());
                    break;
                }
                case SHIP: {
                    this.variant = SpecStore.o00000(HullVariantSpec.class, this.specId);
                    if (this.variant == null) {
                        new RuntimeException(String.format("[%s] is not a valid ship variant id", this.specId)).printStackTrace();
                        this.variant = SpecStore.o00000(HullVariantSpec.class, StarfarerSettings.\u00d2O0000("errorShipVariant"));
                    }
                    this.variant = this.variant.clone();
                    if (this.variant.getWeaponGroups().size() <= 1) break;
                    this.variant.setMayAutoAssignWeapons(false);
                }
            }
        }
    }

    Object readResolve() {
        this.variant = this.savedVariant;
        this.cachedStrength = -1.0f;
        this.savedVariant = null;
        if (this.repairTracker == null) {
            this.repairTracker = new RepairTracker(this);
        }
        if (this.buffManager == null) {
            this.buffManager = new BuffManager(this);
        }
        CrewComposition crewComposition = new CrewComposition();
        crewComposition.addCrew(100000.0f);
        this.crewComposition = crewComposition;
        this.updateVariantIfNeeded();
        this.updateStats();
        return this;
    }

    public void setBuffManager(BuffManager buffManager) {
        this.buffManager = buffManager;
    }

    public BuffManager getBuffManager() {
        if (this.buffManager == null) {
            this.buffManager = new BuffManager(this);
        }
        return this.buffManager;
    }

    Object writeReplace() {
        this.savedVariant = this.variant != null && !this.variant.isStockVariant() && this.variant.getSource() != VariantSource.HULL ? this.variant : null;
        if (this.status != null && !this.status.needsRepairs()) {
            this.status = null;
        }
        if (this.buffManager != null && this.buffManager.getBuffs().isEmpty()) {
            this.buffManager = null;
        }
        if (this.captain != null && this.captain.getPersonality().getId().equals("steady") && this.captain.getName().getFirst().isEmpty() && this.captain.getName().getLast().isEmpty() && this.captain.getStats().getLevel() <= 1) {
            this.captain = null;
        }
        if (this.crewComposition != null && this.crewComposition.getCrew() + this.crewComposition.getMarines() <= 0.0f) {
            this.crewComposition = null;
        }
        if (this.fleetData != null && this.fleetData.getFleet() != null && this.fleetData.getFleet().isAIMode()) {
            this.crewComposition = null;
        }
        return this;
    }

    public HullVariantSpec getSavedVariant() {
        return this.savedVariant;
    }

    public void setSavedVariant(HullVariantSpec hullVariantSpec) {
        this.savedVariant = hullVariantSpec;
    }

    public FleetMemberStatus getStatus() {
        if (this.status == null) {
            this.status = new FleetMemberStatus(this);
        }
        return this.status;
    }

    public E getStats() {
        if (this.statUpdateNeeded) {
            this.updateStats();
        }
        return this.stats;
    }

    public int getReplacementChassisCount() {
        float f2 = this.getStats().getCRPerDeploymentPercent().computeEffective(this.getHullSpec().getCRToDeploy()) / 100.0f;
        if (f2 < 0.0025f) {
            f2 = 0.0025f;
        }
        return Math.round(this.getCR() / f2);
    }

    public boolean isStatUpdateNeeded() {
        return this.statUpdateNeeded;
    }

    public void setStatUpdateNeeded(boolean bl) {
        this.statUpdateNeeded = bl;
        if (bl) {
            this.cachedStrength = -1.0f;
        }
    }

    public boolean isForceNoMoreStatsUpdates() {
        return this.forceNoMoreStatsUpdates;
    }

    public void setForceNoMoreStatsUpdates(boolean bl) {
        this.forceNoMoreStatsUpdates = bl;
    }

    public PersonAPI getFleetCommanderForStats() {
        return this.fleetCommanderForStats;
    }

    public FleetDataAPI getFleetDataForStats() {
        return this.fleetDataForStats;
    }

    public void setFleetCommanderForStats(PersonAPI personAPI, FleetDataAPI fleetDataAPI) {
        this.setStatUpdateNeeded(this.fleetCommanderForStats != personAPI);
        this.fleetCommanderForStats = personAPI;
    }

    public void updateStats() {
        this.cachedStrength = -1.0f;
        if (this.forceNoMoreStatsUpdates) {
            return;
        }
        if (this.repairTracker == null) {
            return;
        }
        this.statUpdateNeeded = false;
        if (this.variant == null) {
            this.variant = this.getVariant();
        }
        if (this.variant == null) {
            this.stats = null;
            return;
        }
        this.stats = E.create(this.variant);
        this.stats.setFleetMember(this);
        if (this.captain != null && this.captain.getStats() != null && this.getFleetData() != null && this.getFleetData().getMembersNoSync() != null) {
            this.captain.getStats().applyPersonalToStats(this.stats, this.variant.getHullSize());
        }
        if (this.getFleetCommanderForStats() != null) {
            ((Person)this.getFleetCommanderForStats()).getStats().applyFleetwideToStats(this.stats, this.variant.getHullSize());
        } else if (this.fleetData != null && this.fleetData.getCommander() != null) {
            this.fleetData.getCommander().getStats().applyFleetwideToStats(this.stats, this.variant.getHullSize());
        }
        for (O object2 : this.variant.getAllMods()) {
            if (object2.getEffect() == null) continue;
            object2.getEffect().applyEffectsBeforeShipCreation(this.variant.getHullSize(), (MutableShipStatsAPI)this.stats, object2.getId());
        }
        this.stats.getFluxCapacity().modifyFlat("flux_capacitors", (float)this.variant.getNumFluxCapacitors() * Ship.FLUX_PER_CAPACITOR);
        this.stats.getFluxDissipation().modifyFlat("flux_vents", (float)this.variant.getNumFluxVents() * Ship.DISSIPATION_PER_VENT);
        this.updateOnlyStatsThatCanRelyOnCROrCrew();
        String string = "mothballed_mod_id";
        if (this.isMothballed()) {
            this.stats.getSuppliesPerMonth().modifyMult(string, StarfarerSettings.Object.return());
            this.stats.getCargoMod().modifyMult(string, 0.0f);
            this.stats.getFuelMod().modifyMult(string, 0.0f);
            this.stats.getMaxCrewMod().modifyMult(string, 0.0f);
            this.stats.getMinCrewMod().modifyMult(string, 0.0f);
        } else {
            this.stats.getSuppliesPerMonth().unmodify(string);
            this.stats.getCargoMod().unmodify(string);
            this.stats.getFuelMod().unmodify(string);
            this.stats.getMaxCrewMod().unmodify(string);
            this.stats.getMinCrewMod().unmodify(string);
        }
        this.stats.getDynamic().removeUmodified();
        this.repairTracker.updateRates();
        if (this.getVariant() != null && this.getVariant().getWings() != null && this.getNumFlightDecks() <= 0) {
            this.getVariant().getWings().clear();
        }
        if (this.fleetData != null) {
            this.fleetData.setSyncNeeded();
        }
    }

    public void updateOnlyStatsThatCanRelyOnCROrCrew() {
        if (this.forceNoMoreStatsUpdates) {
            return;
        }
        this.updateStatsBasedOnCrew(this.stats);
        if (this.getHullSpec() != null && this.repairTracker != null && this.getHullSpec() != null) {
            RepairTracker.applyCRToStats(this.repairTracker.getCR(), this.getStats(), this.getHullSpec().getHullSize());
        }
    }

    public void setFleetData(FleetData fleetData) {
        this.fleetData = fleetData;
    }

    public FleetData getFleetData() {
        return this.fleetData;
    }

    public Person getCaptain() {
        if (this.isFlagship && this.fleetData != null && CampaignEngine.getInstance().getPlayerFleet() != null && CampaignEngine.getInstance().getPlayerFleet().getFlagship() == this) {
            return CampaignEngine.getInstance().getCharacterData().getPerson();
        }
        if (this.captain == null) {
            this.captain = new Person("steady");
            if (this.getFleetData() != null && this.getFleetData().getFleet() != null) {
                this.captain.setFaction(this.getFleetData().getFleet().getFaction().getId());
            }
        }
        return this.captain;
    }

    public void setCaptain(PersonAPI personAPI) {
        this.setCaptain(personAPI, true);
    }

    public void setCaptain(PersonAPI personAPI, boolean bl) {
        boolean bl2 = this.captain != personAPI;
        this.captain = (Person)personAPI;
        if (bl2 && bl) {
            this.updateStats();
        }
    }

    public int getNumFlightDecks() {
        return (int)this.getStats().getNumFighterBays().getModifiedValue();
    }

    public A getPersonality() {
        return this.getCaptain().getPersonality();
    }

    public boolean isCarrier() {
        return this.variant.isCarrier();
    }

    public boolean isStation() {
        if (this.variant == null) {
            this.updateVariantIfNeeded();
            if (this.variant == null) {
                return false;
            }
        }
        return this.variant.isStation();
    }

    public boolean isCivilian() {
        return this.variant.isCivilian();
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL MEMBER (spacer)";
        }
        return String.valueOf(this.variant.getDisplayName()) + "," + this.variant.getHullSpec().getHullName() + ", owner: " + this.owner + ", name: " + this.shipName;
    }

    public String getShipName() {
        return this.shipName;
    }

    public void setShipName(String string) {
        this.shipName = string;
    }

    public Person getFleetCommander() {
        if (this.fleetData != null) {
            return this.fleetData.getCommander();
        }
        return null;
    }

    public Ship instantiateForCombat(String string, int n2, CombatFleetManager combatFleetManager) {
        Profiler.new((String)"Instantiating ship");
        Person person = this.getFleetCommander();
        if (this.getFleetCommanderForStats() != null) {
            person = (Person)this.getFleetCommanderForStats();
        }
        if (person == null) {
            person = (Person)combatFleetManager.getDefaultCommander();
        }
        Ship ship = this.shipName != null || string != null ? intsuper.o00000(this.variant, this.shipName, string, true, true, this.getCaptain(), person, this) : intsuper.o00000(this.variant, true, this.getCaptain(), this.getFleetCommander(), this);
        this.updateStatsBasedOnCrew(ship.getStats());
        if (this.getRepairTracker().isCrashMothballed() || this.getRepairTracker().isMothballed()) {
            ship.setControlsLocked(true);
        }
        if (!this.canBeDeployedForCombat()) {
            ship.setControlsLocked(true);
        }
        float f2 = this.repairTracker.getCR();
        RepairTracker.applyCRToStats(f2, ship.getStats(), ship.getHullSize());
        RepairTracker.applyCRToShip(f2, ship);
        this.getStatus().applyToShip(ship, n2);
        ship.setOwner(this.owner);
        if (this.owner == 0) {
            ship.setFacing(90.0f);
        } else {
            ship.setFacing(270.0f);
        }
        Profiler.o00000();
        return ship;
    }

    public boolean needsRepairs() {
        return this.getStatus().needsRepairs();
    }

    public boolean canBeRepaired() {
        return !this.isMothballed() && !this.isSuspendRepairs() && !this.isFighterWing();
    }

    public boolean isSuspendRepairs() {
        return this.repairTracker.isSuspendRepairs();
    }

    public void updateStatsBasedOnCrew(E e2) {
        if (this.forceNoMoreStatsUpdates) {
            return;
        }
        CombatReadinessPlugin combatReadinessPlugin = (CombatReadinessPlugin)StarfarerSettings.return("combatReadinessPlugin");
        combatReadinessPlugin.applyMaxCRCrewModifiers((FleetMemberAPI)this);
        float f2 = this.getCrewFraction();
        if (f2 < 1.0f) {
            float f3 = f2;
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            e2.getBaseCRRecoveryRatePercentPerDay().modifyMult("crew understrength", f3);
        } else {
            e2.getBaseCRRecoveryRatePercentPerDay().unmodify("crew understrength");
        }
    }

    public static float getBaseCRForCrewXPLevel() {
        return 0.7f;
    }

    public String getSpecId() {
        return this.specId;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int n2) {
        this.owner = n2;
    }

    public HullVariantSpec getVariant() {
        if (this.variant == null && this.savedVariant != null) {
            return this.savedVariant;
        }
        if (this.variant == null) {
            return SpecStore.o00000(HullVariantSpec.class, this.specId);
        }
        return this.variant;
    }

    public g getHullSpec() {
        if (this.variant == null) {
            if (this.savedVariant != null) {
                return this.savedVariant.getHullSpec();
            }
            return SpecStore.o00000(HullVariantSpec.class, this.specId).getHullSpec();
        }
        return this.variant.getHullSpec();
    }

    public void setVariant(HullVariantSpec hullVariantSpec, U u2) {
        this.setVariant(hullVariantSpec, true, true, u2.getOtherEntity() == null);
    }

    public void setVariant(ShipVariantAPI shipVariantAPI, boolean bl, boolean bl2) {
        this.setVariant((HullVariantSpec)shipVariantAPI, bl, bl2);
    }

    public void setVariant(HullVariantSpec hullVariantSpec, boolean bl, boolean bl2) {
        this.setVariant(hullVariantSpec, bl, bl2, true);
    }

    public void setVariant(HullVariantSpec hullVariantSpec, boolean bl, boolean bl2, boolean bl3) {
        CharacterStats characterStats;
        float f2;
        if (bl && (f2 = HullVariantSpec.computeVariantDiffCRImpact(characterStats = this.getFleetCommander() != null ? this.getFleetCommander().getStats() : null, this.getStats(), this.getBaseCR(), this.variant, hullVariantSpec)) != 0.0f && bl3) {
            this.getRepairTracker().applyCREvent(-f2, "field refit");
        }
        this.computedCivilian = false;
        this.variant = hullVariantSpec;
        if (this.variant != null && !this.isFighterWing()) {
            this.specId = this.variant.getHullVariantId();
        }
        if (bl2) {
            this.updateStats();
        }
    }

    public FleetMemberType getType() {
        return this.type;
    }

    public FighterWingSpec getWingSpec() {
        return this.wingSpec;
    }

    public boolean isFlagship() {
        return this.isFlagship || this.fleetData != null && this.fleetData.getCommander() == this.getCaptain();
    }

    public void setFlagship(boolean bl) {
        this.setFlagship(bl, true);
    }

    public void setFlagship(boolean bl, boolean bl2) {
        this.isFlagship = bl;
        if (this.isFlagship && this.fleetData != null && bl2) {
            this.setCaptain(this.fleetData.getCommander());
        }
    }

    public int getFleetPointCost() {
        if (this.type == FleetMemberType.FIGHTER_WING) {
            return this.wingSpec.getFleetPoints();
        }
        return this.variant.getHullSpec().getFleetPoints();
    }

    public float getMemberStrength() {
        if (this.cachedStrength >= 0.0f) {
            return this.cachedStrength;
        }
        if (this.isMothballed()) {
            this.cachedStrength = 0.0f;
            return this.cachedStrength;
        }
        float f2 = this.variant.getHullSpec().getOrdnancePoints(null);
        float f3 = f2 <= 0.0f || f2 >= 1000.0f || this.isFighterWing() ? (float)this.getFleetPointCost() : (float)this.getFleetPointCost() * (0.2f + 0.8f * (float)this.variant.computeOPCost(null) / f2);
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f8\u00d50000();
        float f4 = this.getRepairTracker().getCR();
        if (f4 < combatReadinessPlugin.getMalfunctionThreshold((MutableShipStatsAPI)this.getStats())) {
            f3 *= 0.2f + 0.8f * f4 / combatReadinessPlugin.getMalfunctionThreshold((MutableShipStatsAPI)this.getStats());
        }
        if (this.isCivilian()) {
            f3 *= 0.25f;
        }
        this.cachedStrength = f3;
        return f3;
    }

    public boolean isFighterWing() {
        return this.type == FleetMemberType.FIGHTER_WING;
    }

    public boolean isFrigate() {
        return this.variant.getHullSize() == ShipAPI.HullSize.FRIGATE;
    }

    public boolean isDestroyer() {
        return this.variant.getHullSize() == ShipAPI.HullSize.DESTROYER;
    }

    public boolean isCruiser() {
        return this.variant.getHullSize() == ShipAPI.HullSize.CRUISER;
    }

    public boolean isCapital() {
        return this.variant.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP;
    }

    public boolean isPhaseShip() {
        return this.variant.getHullSpec().isPhase();
    }

    public CrewComposition getCrewComposition() {
        if (this.crewComposition == null) {
            this.crewComposition = new CrewComposition();
        }
        return this.crewComposition;
    }

    public float getCrewFraction() {
        boolean bl = false;
        if (this.fleetCommanderForStats != null && this.fleetCommanderForStats.isPlayer()) {
            bl = true;
        }
        if (this.getMinCrew() <= 0.0f || !bl && this.fleetData != null && this.fleetData.getFleet() != null && this.fleetData.getFleet().isAIMode()) {
            return 1.0f;
        }
        if (this.status != null && this.status.getHullFraction() <= 0.0f) {
            return 1.0f;
        }
        return Math.min(1.0f, this.getCrewComposition().getCrew() / this.getMinCrew());
    }

    public void setCrewComposition(CrewComposition crewComposition) {
        this.crewComposition = crewComposition;
        this.getStats().getMaxCombatReadiness().unmodify("crew_fraction");
    }

    public boolean canBeDeployedForCombat() {
        if (this.isMothballed()) {
            return false;
        }
        float f2 = StarfarerSettings.\u00f600000("noDeployCRPercent") * 0.01f;
        float f3 = StarfarerSettings.\u00f600000("noDeployCrewPercent") * 0.01f;
        if (this.isFighterWing() && this.getCR() <= 0.0f) {
            return false;
        }
        return this.getCR() >= f2 && this.getCrewFraction() >= f3;
    }

    public float getFuelCapacity() {
        return (int)this.stats.getFuelMod().computeEffective(this.getHullSpec().getCapacity().\u00d600000());
    }

    public float getCargoCapacity() {
        return (int)this.stats.getCargoMod().computeEffective(this.getHullSpec().getCapacity().class());
    }

    public float getMinCrew() {
        float f2 = 1.0f;
        if (this.isFighterWing()) {
            f2 = this.wingSpec.getNumFighters();
        }
        return (float)Math.ceil(this.stats.getMinCrewMod().computeEffective(this.getHullSpec().getCapacity().\u00d800000()) * f2);
    }

    public float getNeededCrew() {
        return (int)Math.max(0.0f, this.getMinCrew() - this.getCrewComposition().getCrew());
    }

    public float getMaxCrew() {
        float f2 = 1.0f;
        if (this.isFighterWing()) {
            f2 = this.wingSpec.getNumFighters();
        }
        return (float)((int)this.stats.getMaxCrewMod().computeEffective(this.getHullSpec().getCapacity().\u00d300000())) * f2;
    }

    public float getFuelUse() {
        float f2 = 1.0f;
        if (this.isFighterWing()) {
            f2 = this.wingSpec.getNumFighters();
        }
        return this.stats.getFuelUseMod().computeEffective(this.getHullSpec().getCapacity().\u00d400000()) * f2;
    }

    public float computeTravelSpeed() {
        return this.stats.getMaxSpeed().getModifiedValue() * 0.5f + 100.0f;
    }

    public float getBaseValue() {
        Object object;
        float f2 = 0.0f;
        for (String string : this.variant.getNonBuiltInWeaponSlots()) {
            object = this.variant.getWeaponSpec(string);
            f2 += ((BaseWeaponSpec)object).getBaseValue();
        }
        for (String string : this.variant.getNonBuiltInWings()) {
            if (string == null || string.isEmpty()) continue;
            object = SpecStore.o00000(FighterWingSpec.class, string);
            f2 += ((FighterWingSpec)object).getBaseValue();
        }
        return this.variant.getHullSpec().getBaseValue() + f2;
    }

    public float getBaseSellValue() {
        Object object;
        if (this.isFighterWing()) {
            return this.wingSpec.getBaseValue() * StarfarerSettings.\u00f600000("shipSellPriceMult");
        }
        float f2 = StarfarerSettings.\u00f600000("shipWeaponSellPriceMult");
        float f3 = 0.0f;
        for (String string : this.variant.getNonBuiltInWeaponSlots()) {
            object = this.variant.getWeaponSpec(string);
            f3 += ((BaseWeaponSpec)object).getBaseValue() * f2;
        }
        for (String string : this.variant.getNonBuiltInWings()) {
            if (string == null || string.isEmpty()) continue;
            object = SpecStore.o00000(FighterWingSpec.class, string);
            f3 += ((FighterWingSpec)object).getBaseValue() * f2;
        }
        float f4 = StarfarerSettings.\u00f600000("hullWithDModsSellPriceMult");
        float f5 = 1.0f;
        int n2 = DModManager.getNumDMods((ShipVariantAPI)this.getVariant());
        if (n2 > 0) {
            f5 = f4;
        }
        CommoditySpecAPI commoditySpecAPI = Global.getSettings().getCommoditySpec("supplies");
        float f6 = this.getSuppliesPerPercentCR() * this.getRepairTracker().getBaseCR() * 100.0f * commoditySpecAPI.getBasePrice();
        float f7 = this.getRepairTracker().computeRepairednessFraction();
        float f8 = Math.max(0.1f, f7);
        return this.variant.getHullSpec().getBaseValue() * StarfarerSettings.\u00f600000("shipSellPriceMult") * f8 * f5 + f3 + f6;
    }

    public float getBaseBuyValue() {
        Object object;
        String string2;
        if (this.isFighterWing()) {
            return this.wingSpec.getBaseValue() * StarfarerSettings.\u00f600000("shipBuyPriceMult");
        }
        float f2 = StarfarerSettings.\u00f600000("shipWeaponBuyPriceMult");
        float f3 = 0.0f;
        for (String string2 : this.variant.getNonBuiltInWeaponSlots()) {
            object = this.variant.getWeaponSpec(string2);
            f3 += ((BaseWeaponSpec)object).getBaseValue() * f2;
        }
        for (String string2 : this.variant.getNonBuiltInWings()) {
            if (string2 == null || string2.isEmpty()) continue;
            object = SpecStore.o00000(FighterWingSpec.class, string2);
            f3 += ((FighterWingSpec)object).getBaseValue() * f2;
        }
        string2 = Global.getSettings().getCommoditySpec("supplies");
        float f4 = this.getSuppliesPerPercentCR() * this.getRepairTracker().getBaseCR() * 100.0f * string2.getBasePrice();
        float f5 = this.getRepairTracker().computeRepairednessFraction();
        float f6 = Math.max(0.1f, f5);
        return this.variant.getHullSpec().getBaseValue() * StarfarerSettings.\u00f600000("shipBuyPriceMult") * f6 + f3 + f4;
    }

    public float getSuppliesPerPercentCR() {
        float f2 = this.getDeploymentCostSupplies();
        float f3 = this.getDeployCost();
        return f2 / (f3 * 100.0f);
    }

    public String getShortName() {
        if (this.isFighterWing()) {
            return this.variant.getFullDesignationForFighter();
        }
        return this.getShipName();
    }

    public boolean isNull() {
        return this.type == FleetMemberType.NULL;
    }

    public String getHullId() {
        if (this.variant == null) {
            if (this.savedVariant != null) {
                return this.savedVariant.getHullSpec().getHullId();
            }
            return null;
        }
        return this.variant.getHullSpec().getHullId();
    }

    public boolean isMothballed() {
        return this.repairTracker.isMothballed();
    }

    public float getBaseCR() {
        return this.repairTracker.getBaseCR();
    }

    public float getDeployCost() {
        float f2 = this.getStats().getCRPerDeploymentPercent().computeEffective(this.getHullSpec().getCRToDeploy()) / 100.0f;
        if (this.isFighterWing()) {
            f2 *= (float)this.getNumFightersInWing();
        }
        return f2;
    }

    public float getBaseDeployCost() {
        float f2 = this.getHullSpec().getCRToDeploy() / 100.0f;
        if (this.isFighterWing()) {
            f2 *= (float)this.getNumFightersInWing();
        }
        return f2;
    }

    public float getUnmodifiedDeploymentPointsCost() {
        float f2 = this.stats.getSuppliesToRecover().getBaseValue();
        float f3 = 1.0f;
        if (this.isFighterWing()) {
            f3 = this.getWingSpec().getNumFighters();
        }
        return f2 * f3;
    }

    public float getDeploymentPointsCost() {
        float f2 = this.stats.getSuppliesToRecover().getBaseValue();
        f2 = Math.round(this.stats.getDynamic().getMod("deployment_points_mod").computeEffective(f2));
        float f3 = 1.0f;
        if (this.isFighterWing()) {
            f3 = this.getWingSpec().getNumFighters();
        }
        return f2 * f3;
    }

    public float getDeploymentCostSupplies() {
        float f2 = this.stats.getSuppliesToRecover().getModifiedValue();
        float f3 = 1.0f;
        if (this.isFighterWing()) {
            f3 = this.getWingSpec().getNumFighters();
        }
        float f4 = this.stats.getSuppliesToRecover().getBaseValue();
        float f5 = Math.round(f2 * f3);
        if (f4 > 0.0f && f5 < 1.0f) {
            f5 = 1.0f;
        } else if (f4 > 1.0f && f5 == f4 && f2 < f4) {
            f5 = f4 - 1.0f;
        }
        return f5;
    }

    public float getBaseDeploymentCostSupplies() {
        float f2 = this.stats.getSuppliesToRecover().getBaseValue();
        float f3 = 1.0f;
        if (this.isFighterWing()) {
            f3 = this.getWingSpec().getNumFighters();
        }
        return f2 * f3;
    }

    public int getRestorationCost() {
        if (!this.getVariant().isDHull()) {
            return 0;
        }
        g g2 = this.getHullSpec();
        g g3 = g2.getBaseHull();
        if (g3 == null) {
            g3 = g2;
        }
        float f2 = StarfarerSettings.\u00f600000("baseRestoreCostMult");
        float f3 = StarfarerSettings.\u00f600000("baseRestoreCostMultPerDMod");
        float f4 = Math.max(g2.getBaseValue(), g3.getBaseValue()) * f2;
        int n2 = DModManager.getNumDMods((ShipVariantAPI)this.getVariant());
        int n3 = 0;
        while (n3 < n2) {
            f4 *= f3;
            ++n3;
        }
        return (int)f4;
    }

    public String getPersonalityOverride() {
        return this.personalityOverride;
    }

    public void setPersonalityOverride(String string) {
        this.personalityOverride = string;
    }

    public ModSpecAPI getSourceMod() {
        if (this.variant != null && this.getHullSpec() != null) {
            return this.getHullSpec().getSourceMod();
        }
        return null;
    }
}

