/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.util.DynamicStats;
import com.fs.util.DoNotObfuscate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MutableFleetStats
implements DoNotObfuscate,
MutableFleetStatsAPI,
Cloneable {
    private Map<String, TemporaryStatMod> tempMods = new LinkedHashMap<String, TemporaryStatMod>();
    private DynamicStats dynamic = new DynamicStats();
    private MutableStat accelerationMult = new MutableStat(1.0f);
    private MutableStat fuelUseHyperMult = new MutableStat(1.0f);
    private MutableStat fuelUseNormalMult = new MutableStat(0.0f);
    private StatBonus movementSpeedMod = new StatBonus();
    private StatBonus fleetwideMaxBurnMod = new StatBonus();
    private StatBonus sensorStrengthMod = new StatBonus();
    private StatBonus sensorProfileMod = new StatBonus();
    private StatBonus sensorRangeMod = new StatBonus();
    private StatBonus detectedRangeMod = new StatBonus();

    public MutableFleetStats clone() {
        try {
            MutableFleetStats mutableFleetStats = (MutableFleetStats)super.clone();
            mutableFleetStats.tempMods = new LinkedHashMap<String, TemporaryStatMod>();
            mutableFleetStats.tempMods.putAll(this.tempMods);
            return mutableFleetStats;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void removeTemporaryMod(String string) {
        TemporaryStatMod temporaryStatMod = this.tempMods.remove(string);
        if (temporaryStatMod == null) {
            return;
        }
        if (temporaryStatMod.stat != null) {
            temporaryStatMod.stat.unmodify(temporaryStatMod.source);
        }
        if (temporaryStatMod.mStat != null) {
            temporaryStatMod.mStat.unmodify(temporaryStatMod.source);
        }
    }

    public void addTemporaryModFlat(float f2, String string, String string2, float f3, StatBonus statBonus) {
        this.getMod(string, f2, statBonus);
        statBonus.modifyFlat(string, f3, string2);
    }

    public void addTemporaryModMult(float f2, String string, String string2, float f3, StatBonus statBonus) {
        this.getMod(string, f2, statBonus);
        statBonus.modifyMult(string, f3, string2);
    }

    public void addTemporaryModFlat(float f2, String string, float f3, StatBonus statBonus) {
        this.getMod(string, f2, statBonus);
        statBonus.modifyFlat(string, f3);
    }

    public void addTemporaryModPercent(float f2, String string, String string2, float f3, StatBonus statBonus) {
        this.getMod(string, f2, statBonus);
        statBonus.modifyPercent(string, f3, string2);
    }

    public void addTemporaryModPercent(float f2, String string, float f3, StatBonus statBonus) {
        this.getMod(string, f2, statBonus);
        statBonus.modifyPercent(string, f3);
    }

    private TemporaryStatMod getMod(String string, float f2, StatBonus statBonus) {
        TemporaryStatMod temporaryStatMod = this.tempMods.get(string);
        if (temporaryStatMod == null) {
            temporaryStatMod = new TemporaryStatMod(f2, string, statBonus);
            this.tempMods.put(string, temporaryStatMod);
        }
        temporaryStatMod.timeRemaining = f2;
        if (temporaryStatMod.stat != statBonus) {
            throw new RuntimeException("Attempting to modify multiple stats with the same source [" + string + "]");
        }
        return temporaryStatMod;
    }

    public void addTemporaryModFlat(float f2, String string, String string2, float f3, MutableStat mutableStat) {
        this.getMod(string, f2, mutableStat);
        mutableStat.modifyFlat(string, f3, string2);
    }

    public void addTemporaryModMult(float f2, String string, String string2, float f3, MutableStat mutableStat) {
        this.getMod(string, f2, mutableStat);
        mutableStat.modifyMult(string, f3, string2);
    }

    public void addTemporaryModFlat(float f2, String string, float f3, MutableStat mutableStat) {
        this.getMod(string, f2, mutableStat);
        mutableStat.modifyFlat(string, f3);
    }

    public void addTemporaryModPercent(float f2, String string, String string2, float f3, MutableStat mutableStat) {
        this.getMod(string, f2, mutableStat);
        mutableStat.modifyPercent(string, f3, string2);
    }

    public void addTemporaryModPercent(float f2, String string, float f3, MutableStat mutableStat) {
        this.getMod(string, f2, mutableStat);
        mutableStat.modifyPercent(string, f3);
    }

    private TemporaryStatMod getMod(String string, float f2, MutableStat mutableStat) {
        TemporaryStatMod temporaryStatMod = this.tempMods.get(string);
        if (temporaryStatMod == null) {
            temporaryStatMod = new TemporaryStatMod(f2, string, mutableStat);
            this.tempMods.put(string, temporaryStatMod);
        }
        temporaryStatMod.timeRemaining = f2;
        if (temporaryStatMod.mStat != mutableStat) {
            throw new RuntimeException("Attempting to modify multiple stats with the same source [" + string + "]");
        }
        return temporaryStatMod;
    }

    public boolean hasMod(String string) {
        return this.tempMods.containsKey(string);
    }

    public void advance(float f2) {
        Iterator<TemporaryStatMod> iterator = this.tempMods.values().iterator();
        while (iterator.hasNext()) {
            TemporaryStatMod temporaryStatMod = iterator.next();
            temporaryStatMod.timeRemaining -= f2;
            if (!(temporaryStatMod.timeRemaining <= 0.0f)) continue;
            iterator.remove();
            if (temporaryStatMod.stat != null) {
                temporaryStatMod.stat.unmodify(temporaryStatMod.source);
            }
            if (temporaryStatMod.mStat == null) continue;
            temporaryStatMod.mStat.unmodify(temporaryStatMod.source);
        }
    }

    public DynamicStats getDynamic() {
        return this.dynamic;
    }

    protected Object readResolve() {
        if (this.dynamic == null) {
            this.dynamic = new DynamicStats();
        }
        if (this.tempMods == null) {
            this.tempMods = new LinkedHashMap<String, TemporaryStatMod>();
        }
        if (!(this.tempMods instanceof LinkedHashMap)) {
            this.tempMods = new LinkedHashMap<String, TemporaryStatMod>(this.tempMods);
        }
        if (this.fleetwideMaxBurnMod == null) {
            this.fleetwideMaxBurnMod = new StatBonus();
        }
        if (this.sensorStrengthMod == null) {
            this.sensorStrengthMod = new StatBonus();
        }
        if (this.sensorProfileMod == null) {
            this.sensorProfileMod = new StatBonus();
        }
        if (this.sensorRangeMod == null) {
            this.sensorRangeMod = new StatBonus();
        }
        if (this.detectedRangeMod == null) {
            this.detectedRangeMod = new StatBonus();
        }
        if (this.accelerationMult == null) {
            this.accelerationMult = new MutableStat(1.0f);
        }
        if (this.fuelUseHyperMult == null) {
            this.fuelUseHyperMult = new MutableStat(1.0f);
        }
        if (this.fuelUseNormalMult == null) {
            this.fuelUseNormalMult = new MutableStat(0.0f);
        }
        if (this.movementSpeedMod == null) {
            this.movementSpeedMod = new StatBonus();
        }
        return this;
    }

    Object writeReplace() {
        MutableFleetStats mutableFleetStats = this.clone();
        this.dynamic.removeUmodified();
        if (this.isUnmodified(this.accelerationMult)) {
            mutableFleetStats.accelerationMult = null;
        }
        if (this.isUnmodified(this.fuelUseHyperMult)) {
            mutableFleetStats.fuelUseHyperMult = null;
        }
        if (this.isUnmodified(this.fuelUseNormalMult)) {
            mutableFleetStats.fuelUseNormalMult = null;
        }
        if (this.isUnmodified(this.movementSpeedMod)) {
            mutableFleetStats.movementSpeedMod = null;
        }
        if (this.isUnmodified(this.sensorStrengthMod)) {
            mutableFleetStats.sensorStrengthMod = null;
        }
        if (this.isUnmodified(this.sensorProfileMod)) {
            mutableFleetStats.sensorProfileMod = null;
        }
        if (this.isUnmodified(this.sensorRangeMod)) {
            mutableFleetStats.sensorRangeMod = null;
        }
        if (this.isUnmodified(this.detectedRangeMod)) {
            mutableFleetStats.detectedRangeMod = null;
        }
        return mutableFleetStats;
    }

    private boolean isUnmodified(StatBonus statBonus) {
        return statBonus.getFlatBonuses().isEmpty() && statBonus.getMultBonuses().isEmpty() && statBonus.getPercentBonuses().isEmpty();
    }

    private boolean isUnmodified(MutableStat mutableStat) {
        return mutableStat.getFlatMods().isEmpty() && mutableStat.getMultMods().isEmpty() && mutableStat.getPercentMods().isEmpty();
    }

    public MutableStat getFuelUseHyperMult() {
        return this.fuelUseHyperMult;
    }

    public MutableStat getFuelUseNormalMult() {
        return this.fuelUseNormalMult;
    }

    public MutableStat getAccelerationMult() {
        return this.accelerationMult;
    }

    public StatBonus getMovementSpeedMod() {
        return this.movementSpeedMod;
    }

    public StatBonus getFleetwideMaxBurnMod() {
        return this.fleetwideMaxBurnMod;
    }

    public StatBonus getSensorStrengthMod() {
        return this.sensorStrengthMod;
    }

    public StatBonus getSensorProfileMod() {
        return this.sensorProfileMod;
    }

    public StatBonus getSensorRangeMod() {
        return this.sensorRangeMod;
    }

    public StatBonus getDetectedRangeMod() {
        return this.detectedRangeMod;
    }

    public static class TemporaryStatMod
    implements DoNotObfuscate {
        float timeRemaining;
        String source;
        StatBonus stat = null;
        MutableStat mStat = null;

        public TemporaryStatMod(float f2, String string, StatBonus statBonus) {
            this.timeRemaining = f2;
            this.source = string;
            this.stat = statBonus;
        }

        public TemporaryStatMod(float f2, String string, MutableStat mutableStat) {
            this.timeRemaining = f2;
            this.source = string;
            this.mStat = mutableStat;
        }
    }
}

