/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat;

import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.Vector2f;

public class CombatViewport
implements DoNotObfuscate,
ViewportAPI {
    private float llx;
    private float lly;
    private float visibleWidth;
    private float visibleHeight;
    private float worldXtoScreenX = 1.0f;
    private float worldYtoScreenY = 1.0f;
    private float scale = 1.0f;
    private float viewMult = 1.0f;
    private float alphaMult = 1.0f;
    private CombatViewport inset;
    private boolean externalControl = false;
    private Vector2f center = new Vector2f();
    private boolean everythingNearViewport = false;

    public CombatViewport(float f2, float f3, float f4, float f5) {
        this.llx = f2;
        this.lly = f3;
        this.visibleWidth = f4;
        this.visibleHeight = f5;
        this.viewMult = f4 * this.worldXtoScreenX / StarfarerSettings.\u00d2\u00d30000();
        this.set(f2, f3, f4, f5);
    }

    public void set(float f2, float f3, float f4, float f5) {
        this.llx = f2;
        this.lly = f3;
        this.visibleWidth = f4;
        this.visibleHeight = f5;
        this.center.set(f2 + f4 / 2.0f, f3 + f5 / 2.0f);
        this.viewMult = f4 * this.worldXtoScreenX / StarfarerSettings.\u00d2\u00d30000();
    }

    public void setCenter(Vector2f vector2f) {
        this.set(vector2f.x - this.visibleWidth / 2.0f, vector2f.y - this.visibleHeight / 2.0f, this.visibleWidth, this.visibleHeight);
    }

    public CombatViewport getInset() {
        return this.inset;
    }

    public void setInset(CombatViewport combatViewport) {
        this.inset = combatViewport;
    }

    public boolean isEverythingNearViewport() {
        return this.everythingNearViewport;
    }

    public void setEverythingNearViewport(boolean bl) {
        this.everythingNearViewport = bl;
    }

    public boolean isNearViewport(Vector2f vector2f, float f2) {
        boolean bl;
        if (this.everythingNearViewport) {
            return true;
        }
        if (this.inset != null && (bl = this.inset.isNearViewport(vector2f, f2))) {
            return true;
        }
        float f3 = vector2f.x;
        float f4 = vector2f.y;
        if (f3 > this.llx + this.visibleWidth + f2) {
            return false;
        }
        if (f3 < this.llx - f2) {
            return false;
        }
        if (f4 > this.lly + this.visibleHeight + f2) {
            return false;
        }
        return !(f4 < this.lly - f2);
    }

    public Vector2f getCenter() {
        return this.center;
    }

    public float getLLX() {
        return this.llx;
    }

    public float getLLY() {
        return this.lly;
    }

    public float getVisibleWidth() {
        return this.visibleWidth;
    }

    public float getVisibleHeight() {
        return this.visibleHeight;
    }

    public float getWorldXtoScreenX() {
        return this.worldXtoScreenX;
    }

    public void setWorldXtoScreenX(float f2) {
        this.worldXtoScreenX = f2;
    }

    public float getWorldYtoScreenY() {
        return this.worldYtoScreenY;
    }

    public void setWorldYtoScreenY(float f2) {
        this.worldYtoScreenY = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getViewMult() {
        return this.viewMult;
    }

    public void setViewMult(float f2) {
        this.viewMult = f2;
    }

    public float getAlphaMult() {
        return this.alphaMult;
    }

    public void setAlphaMult(float f2) {
        this.alphaMult = f2;
    }

    public float convertScreenXToWorldX(float f2) {
        float f3 = f2 / this.worldXtoScreenX * this.viewMult + this.llx;
        return f3;
    }

    public float convertScreenYToWorldY(float f2) {
        float f3 = f2 / this.worldYtoScreenY * this.viewMult + this.lly;
        return f3;
    }

    public float convertWorldXtoScreenX(float f2) {
        float f3 = (f2 - this.llx) / this.viewMult * this.worldXtoScreenX;
        return f3;
    }

    public float convertWorldYtoScreenY(float f2) {
        float f3 = (f2 - this.lly) / this.viewMult * this.worldYtoScreenY;
        return f3;
    }

    public float convertWorldWidthToScreenWidth(float f2) {
        return f2 / this.viewMult * this.worldXtoScreenX;
    }

    public float convertWorldHeightToScreenHeight(float f2) {
        return f2 / this.viewMult * this.worldYtoScreenY;
    }

    public float convertScreenWidthToWorldWidth(float f2) {
        return f2 * this.viewMult / this.worldXtoScreenX;
    }

    public float convertScreenHeightToWorldHeight(float f2) {
        return f2 * this.viewMult / this.worldYtoScreenY;
    }

    public boolean isExternalControl() {
        return this.externalControl;
    }

    public void setExternalControl(boolean bl) {
        this.externalControl = bl;
    }
}

