/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.ProximityExplosionEffect;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.N;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.ai.missile.MissileAI;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.DamagingExplosion;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.o0OO.F;
import com.fs.starfarer.combat.o0OO.new;
import com.fs.starfarer.loading.D;
import com.fs.starfarer.loading.specs.O0ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.loading.specs.i;
import com.fs.starfarer.prototype.Utils;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;

public class GuidedProximityFuseAI
implements AI,
MissileAIPlugin,
GuidedMissileAI {
    private CombatEngine engine;
    private ProximityFuseAI.o projectile;
    private Missile missile;
    private i spec;
    private float range;
    private DamagingExplosionSpec explosionSpec;
    private static Logger log = Logger.getLogger(GuidedProximityFuseAI.class);
    private boolean slowToMaxSpeed = false;
    private MissileAI steeringAI;
    private float delay;
    private String pingSound;
    private String windupSound;
    private Color pingColor;
    private float pingRadius;
    private float pingDuration;
    private float windupDelay;
    private float flashRateMult = 1.0f;
    private boolean mineHasNoSprite;
    private boolean primed = false;
    private boolean playedWindup = false;
    private float elapsedSincePrimed = 0.0f;

    public GuidedProximityFuseAI(ProximityFuseAI.o o2) {
    }

    public GuidedProximityFuseAI(ProximityFuseAI.o o2, Vector2f vector2f, i i2) {
        this.spec = i2;
        this.projectile = o2;
        this.missile = (Missile)o2;
        this.engine = CombatEngine.getInstance();
        this.steeringAI = new MissileAI(this.missile, vector2f, false);
        this.steeringAI.setUseMineSteering(true);
        this.steeringAI.setDirectAim(true);
        this.steeringAI.setRetargetNearest(true);
        this.missile.setEmpResistance(100000);
        this.missile.setMine(true);
        this.updateDamage();
        this.missile.setMineExplosionRange(this.explosionSpec.getRadius());
        this.missile.setUntilMineExplosion(1000.0f);
        this.missile.setMinePrimed(false);
    }

    public void updateDamage() {
        try {
            this.delay = (float)this.spec.getParams().optDouble("delay", 0.0);
            if (this.delay > 0.0f) {
                this.pingRadius = (float)this.spec.getParams().optDouble("pingRadius", 0.0);
                this.pingDuration = (float)this.spec.getParams().optDouble("pingDuration", 0.0);
                this.mineHasNoSprite = this.spec.getParams().optBoolean("mineHasNoSprite", false);
                this.pingColor = D.super(this.spec.getParams(), "pingColor", Color.white);
                this.pingSound = this.spec.getParams().optString("pingSound", "");
                this.windupSound = this.spec.getParams().optString("windupSound", "");
                this.windupDelay = (float)this.spec.getParams().optDouble("windupDelay", 0.0);
                this.flashRateMult = (float)this.spec.getParams().optDouble("flashRateMult", 1.0);
            }
            this.slowToMaxSpeed = this.spec.getParams().optBoolean("slowToMaxSpeed", false);
            this.range = (float)this.spec.getParams().getDouble("range");
            this.explosionSpec = DamagingExplosionSpec.loadFromJSON((JSONObject)this.spec.getParams().getJSONObject("explosionSpec"));
            this.explosionSpec.setDamageType(this.projectile.getDamage(null, null).getType());
            this.explosionSpec.setMaxDamage(this.projectile.getDamage(null, null).getBaseDamage());
            this.explosionSpec.setMinDamage(this.projectile.getDamage(null, null).getBaseDamage() / 2.0f);
            this.explosionSpec.setEffect(this.spec.getOnHitEffect());
            if (this.explosionSpec.getCollisionClass() == CollisionClass.MISSILE_NO_FF) {
                this.missile.setNoFlameoutOnFizzling(true);
                this.missile.setNoMineFFConcerns(true);
            }
        }
        catch (JSONException jSONException) {
            log.error((Object)jSONException, (Throwable)jSONException);
        }
    }

    @Override
    public void advance(float f2) {
        float f3;
        BaseEntity baseEntity;
        this.missile.setUntilMineExplosion(this.delay + 1.0f);
        if (this.primed) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.\u00d200000, null));
            this.missile.giveCommand(new Ship.Oo(Ship.oo.\u00d600000, null));
            float f4 = this.delay - this.elapsedSincePrimed;
            this.missile.setUntilMineExplosion(f4);
            this.missile.setMinePrimed(true);
            if (!this.playedWindup && f4 < this.windupDelay) {
                this.playedWindup = true;
                if (!this.windupSound.isEmpty()) {
                    Global.getSoundPlayer().playSound(this.windupSound, 1.0f, 1.0f, this.missile.getLocation(), new Vector2f());
                }
            }
            if (f4 < 0.1f) {
                f4 = 0.1f;
            }
            float f5 = 1.0f - f4 / this.delay;
            f5 *= f5;
            this.elapsedSincePrimed += f2;
            float f6 = 0.0f;
            if (this.mineHasNoSprite) {
                f6 = 1.57f;
            }
            float f7 = (float)Math.cos(f6 + f5 * 100.0f * this.flashRateMult);
            float f8 = 0.5f;
            if (this.elapsedSincePrimed < f8) {
                float f9 = 0.0f;
                f7 = this.elapsedSincePrimed < f9 ? 0.0f : (f7 *= (this.elapsedSincePrimed - f9) / (f8 - f9));
            }
            if ((f7 *= 2.0f) > 1.0f) {
                f7 = 1.0f;
            }
            if (f7 < 0.0f) {
                f7 = 0.0f;
            }
            if (this.mineHasNoSprite) {
                this.missile.setMineHasNoSprite(true);
                this.missile.setGlowRadius(f7 * this.pingRadius * 0.25f);
                this.missile.setRenderGlowAbove(true);
                this.missile.setShineBrightness(f7 * 0.6f);
            } else {
                this.missile.setGlowRadius(f7 * this.pingRadius * 0.25f);
                this.missile.setRenderGlowAbove(true);
                this.missile.setShineBrightness(f7 * 0.4f);
            }
            if (this.elapsedSincePrimed >= this.delay) {
                this.explode();
            }
            return;
        }
        if (this.projectile.isFading() && !this.projectile.didDamage()) {
            this.trigger();
            return;
        }
        this.steeringAI.advance(f2);
        if (this.projectile instanceof Missile && this.slowToMaxSpeed && !((Missile)(baseEntity = (Missile)this.projectile)).isFizzling()) {
            ((Missile)baseEntity).giveCommand(new Ship.Oo(Ship.oo.\u00d300000, null));
        }
        baseEntity = this.projectile.getSource();
        new new_ = N.o00000(this.projectile.getLocation(), ((Ship)baseEntity).getOriginalOwner(), this.range, CollisionClass.SHIP, CollisionClass.FIGHTER, CollisionClass.MISSILE_NO_FF, CollisionClass.MISSILE_FF);
        if (new_ == null) {
            return;
        }
        float f10 = Utils.\u00d800000(new_.getLocation(), this.projectile.getLocation());
        if (f10 < this.range + new_.getCollisionRadius() && this.range > 0.0f && f10 < this.range + (f3 = N.o00000(this.projectile.getLocation(), new_, true))) {
            this.trigger();
            return;
        }
    }

    private void trigger() {
        if (this.delay <= 0.0f) {
            this.explode();
        } else {
            this.primed = true;
            this.missile.setFlightTime(0.0f);
            this.missile.setTimeSinceFizzling(0.0f);
            if (this.pingDuration > 0.0f) {
                CombatEngine.getInstance().addHitParticle(this.missile.getLocation(), new Vector2f(), this.pingRadius, 1.0f, 0.25f, this.pingColor);
                CombatEngine.getInstance().addHitParticle(this.missile.getLocation(), new Vector2f(), this.pingRadius * 0.25f, 1.0f, 0.25f, Color.white);
            }
            if (!this.pingSound.isEmpty()) {
                Global.getSoundPlayer().playSound(this.pingSound, 1.0f, 1.0f, this.missile.getLocation(), new Vector2f());
            }
        }
    }

    public DamagingExplosion explode() {
        this.engine.removeObject(this.projectile);
        if (this.explosionSpec == null) {
            return null;
        }
        DamagingExplosion damagingExplosion = (DamagingExplosion)O0ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o00000(this.projectile.getSource(), null, this.explosionSpec, this.projectile.getLocation(), 0.0f, new Vector2f(), false);
        damagingExplosion.removeDamagedAlready(this.projectile.getSource());
        F f2 = this.projectile.getDamage(null, null);
        damagingExplosion.setExtraDamageComponents(new float[]{f2.getModifier().getPercentMod(), f2.getModifier().getFlatMod(), f2.getModifier().getMult()});
        ProximityExplosionEffect proximityExplosionEffect = this.spec.getOnProximityExplosionEffect();
        if (proximityExplosionEffect != null) {
            proximityExplosionEffect.onExplosion((DamagingProjectileAPI)damagingExplosion, (DamagingProjectileAPI)this.projectile);
        }
        return damagingExplosion;
    }

    @Override
    public void render() {
    }

    public CombatEntityAPI getTarget() {
        return this.steeringAI.getTarget();
    }

    public void setTarget(CombatEntityAPI combatEntityAPI) {
        this.steeringAI.setTarget(combatEntityAPI);
    }
}

