/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.BaseParticleEmitter;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.entities.ContrailParticle;
import com.fs.starfarer.combat.entities.ship.OooO;
import com.fs.starfarer.combat.entities.void;
import com.fs.starfarer.loading.specs.EngineSlot;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.fx.DetailedSmokeParticle;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class ContrailEmitter
extends BaseParticleEmitter {
    private float width;
    private float endWidth;
    private float duration;
    private float fadeInFraction;
    private float speedMult;
    private float angVelMult;
    private Color color;
    private OooO controller;
    private OooO.Oo delegate;
    private void engineGlow;
    private EngineSlot slot;
    private DynamicParticleGroup group;
    private CombatViewport viewport;
    private EngineSlot.BlendMode mode;
    int frames = 0;

    public ContrailEmitter(float f2, float f3, float f4, float f5, float f6, float f7, Color color, void void_, OooO oooO2, EngineSlot engineSlot) {
        this.width = f2;
        this.endWidth = f3;
        this.duration = f4;
        this.fadeInFraction = f7;
        this.speedMult = f5;
        this.angVelMult = f6;
        this.color = color;
        this.slot = engineSlot;
        this.engineGlow = void_;
        this.controller = oooO2;
        this.delegate = oooO2.getDelegate();
        this.mode = engineSlot.getBlendMode();
        this.group = engineSlot.getBlendMode() == EngineSlot.BlendMode.GLOW ? CombatEngine.getInstance().getGlowyContrailParticles() : CombatEngine.getInstance().getSmokyContrailParticles();
        this.viewport = CombatEngine.getInstance().getViewport();
    }

    public void emit(float f2) {
        Object object;
        if (!(!this.slot.isSystemActivated() || this.engineGlow.new() && this.engineGlow.\u00f600000())) {
            return;
        }
        Vector2f vector2f = this.slot.computePosition(this.delegate.getLocation(), this.delegate.getFacing());
        if (!this.viewport.isNearViewport(vector2f, 100.0f)) {
            return;
        }
        float f3 = this.engineGlow.\u00d300000((EngineSlot)this.slot).class;
        if (f3 <= 0.4f) {
            return;
        }
        float f4 = (float)Math.random() * 10.0f - 5.0f;
        Vector2f vector2f2 = Utils.\u00d300000(this.slot.computeMidArcAngle(this.delegate.getFacing()) + f4);
        vector2f2.scale(this.controller.getEffectiveMaxSpeed() * this.speedMult + Math.abs(this.delegate.getAngularVelocity() * this.angVelMult));
        float f5 = this.delegate.getVelocity().length();
        float f6 = f5 / this.controller.getEffectiveMaxSpeed() * f3;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        Color color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)((float)this.color.getAlpha() * f6));
        if (this.mode == EngineSlot.BlendMode.GLOW) {
            object = new ContrailParticle(color, this.width, this.endWidth, this.mode);
        } else {
            object = new DetailedSmokeParticle(color, this.width, this.endWidth);
            object.setAngle((float)Math.random() * 360.0f);
            object.setRotationSpeed((float)Math.random() * 140.0f - 70.0f);
        }
        object.setVel(vector2f2.x, vector2f2.y);
        object.setPos(vector2f.x, vector2f.y);
        object.setMaxAge(this.duration);
        object.setRampUpPeriod(this.fadeInFraction);
        this.group.add((BaseParticle)object);
    }

    public void everyFrame(float f2) {
    }

    public float getInterval() {
        return 0.1f;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

