/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.systems;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.loading.WeaponGroupType;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.G;
import com.fs.starfarer.combat.ai.P;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.systems.Oo0O;
import com.fs.starfarer.combat.systems.interface;
import com.fs.starfarer.launcher.ModManager;
import com.fs.starfarer.loading.specs.C;
import com.fs.starfarer.loading.specs.voidsuper;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class WeaponGroup
implements G,
Oo0O.o,
WeaponGroupAPI,
DoNotObfuscate {
    private WeaponGroupType type = WeaponGroupType.LINKED;
    private List<interface> weapons = new ArrayList<interface>();
    private List<AutofireAIPlugin> ais = new ArrayList<AutofireAIPlugin>();
    private Oo0O selectionTracker = new Oo0O(null);
    private Oo0O autofireTracker;
    private Ship ship;
    private boolean quickfireMode = false;
    private o recentAction = null;
    private boolean anotherWasSelected = false;
    private boolean wasSelected = false;
    private boolean wasAutofire = true;
    private boolean wasOverrideOn = false;
    private interface active = null;
    private boolean wasDown;
    private boolean justSwitched = false;
    private float elapsed = 0.0f;
    private interface prevActive;
    private boolean selectionButtonWasDown = false;

    public void setCurrentActive(int n2) {
        if (!this.isAlternating()) {
            return;
        }
        if (n2 >= this.weapons.size()) {
            n2 = this.weapons.size() - 1;
        }
        if (n2 < 0) {
            return;
        }
        this.active = this.weapons.get(n2);
    }

    public WeaponGroup() {
        this.selectionTracker.o00000(Oo0O.oo.\u00d400000);
        this.autofireTracker = new Oo0O(this);
        this.autofireTracker.o00000(Oo0O.oo.\u00d400000);
    }

    public boolean isFiringAtWill() {
        return this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000;
    }

    public boolean isAutofiring() {
        return this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000;
    }

    public boolean usesEnergy() {
        for (interface interface_ : this.weapons) {
            if (!interface_.usesEnergy()) continue;
            return true;
        }
        return false;
    }

    public void toggleOff() {
        this.autofireTracker.\u00f600000();
        for (AutofireAIPlugin autofireAIPlugin : this.ais) {
            autofireAIPlugin.forceOff();
        }
    }

    public void toggleOn() {
        if (this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000) {
            return;
        }
        this.autofireTracker.\u00d400000(false, 0.0f);
        this.autofireTracker.\u00d400000(true, 0.0f);
        this.autofireTracker.\u00d400000(false, 0.0f);
    }

    public void addWeaponAPI(WeaponAPI weaponAPI) {
        this.addWeapon((interface)weaponAPI);
    }

    public void addWeapon(interface interface_) {
        this.weapons.add(interface_);
        this.ais.add(ModManager.getInstance().pickWeaponAIPlugin(interface_));
    }

    public WeaponAPI removeWeapon(int n2) {
        if (this.weapons.size() > n2 && n2 >= 0) {
            interface interface_ = this.weapons.remove(n2);
            if (this.ais.size() > n2) {
                this.ais.remove(n2);
            }
            return interface_;
        }
        return null;
    }

    public AutofireAIPlugin getAutofirePlugin(WeaponAPI weaponAPI) {
        int n2 = this.weapons.indexOf(weaponAPI);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= this.ais.size()) {
            return null;
        }
        return this.ais.get(n2);
    }

    public boolean isUsingDefaultAI(WeaponAPI weaponAPI) {
        return this.getAutofirePlugin(weaponAPI) instanceof P;
    }

    public boolean isOverrideActive() {
        boolean bl;
        boolean bl2 = bl = this.ship.getSelectedGroup() == this;
        return bl && this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000;
    }

    @Override
    public void advance(boolean bl, Object object, float f2) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.selectionTracker.\u00d500000() == Oo0O.Oo.\u00d300000;
        boolean bl5 = bl3 = this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000;
        if (!this.wasSelected && bl4) {
            this.recentAction = o.Object;
        } else if (!this.wasAutofire && bl3) {
            this.recentAction = o.\u00d200000;
        }
        this.wasSelected = bl4;
        this.wasAutofire = bl3;
        if (this.ship.getSelectedGroup() != this) {
            this.anotherWasSelected = true;
        }
        boolean bl6 = bl2 = this.ship == CombatEngine.getInstance().getPlayerShip() && this.ship.getAI() == null && this.ship.getSelectedGroup() == this;
        if (bl2) {
            for (AutofireAIPlugin autofireAIPlugin : this.ais) {
                autofireAIPlugin.forceOff();
            }
        }
        if (this.ship.isHulk()) {
            object = null;
        }
        this.wasOverrideOn = bl2;
        if (this.autofireTracker.\u00d500000() == Oo0O.Oo.\u00d300000 && !bl2) {
            this.advanceAuto(bl, object, f2);
        } else {
            Profiler.new((String)"Linked & alternating");
            if (this.type == WeaponGroupType.LINKED) {
                this.advanceLinked(bl, object, f2);
            } else if (this.type == WeaponGroupType.ALTERNATING) {
                this.advanceAlternating(bl, object, f2);
            }
            Profiler.o00000();
        }
    }

    private void advanceAlternating(boolean bl, Object object, float f2) {
        if (!bl) {
            if (this.wasDown && !this.justSwitched) {
                this.selectNextActive();
            }
            for (interface interface_ : this.weapons) {
                interface_.advance(false, this.getParamIfNotInactiveHardpoint(interface_, object), f2);
            }
            this.elapsed = 0.0f;
        } else if (!this.weapons.isEmpty()) {
            if (this.active == null) {
                this.active = this.getActiveWeapon();
            }
            this.active.advance(true, object, f2);
            for (interface interface_ : this.weapons) {
                if (interface_ == this.active) continue;
                interface_.advance(false, object, f2);
            }
            if (this.ship == CombatEngine.getInstance().getPlayerShip() && this.ship.getAI() == null) {
                this.elapsed += f2;
                float f3 = 3.0f;
                if (this.active.isBeam()) {
                    var5_5 = (C)this.active.getSpec();
                    if (((C)var5_5).isBurstBeam()) {
                        f3 = ((C)var5_5).getBurstDuration() + ((C)var5_5).getBurstCooldown() + ((C)var5_5).getChargeupTime() + ((C)var5_5).getChargedownTime();
                        f3 /= (float)this.weapons.size();
                        if (this.elapsed > (f3 /= this.getRoFMult(this.active))) {
                            this.selectNextActive();
                            this.elapsed = 0.0f;
                        }
                    }
                } else {
                    var5_5 = (com.fs.starfarer.loading.specs.Oo0O)this.active.getSpec();
                    f3 = (float)(((com.fs.starfarer.loading.specs.Oo0O)var5_5).getBurstSize() - 1) * ((com.fs.starfarer.loading.specs.Oo0O)var5_5).getBurstDelay() + ((com.fs.starfarer.loading.specs.Oo0O)var5_5).getRefireDelay() + ((com.fs.starfarer.loading.specs.Oo0O)var5_5).getChargeTime();
                    if (((com.fs.starfarer.loading.specs.Oo0O)var5_5).getBurstSize() > 50) {
                        f3 = 3.0f;
                    }
                    f3 /= (float)this.weapons.size();
                    if (this.elapsed > (f3 /= this.getRoFMult(this.active))) {
                        this.selectNextActive();
                        this.justSwitched = true;
                        this.elapsed = 0.0f;
                    } else {
                        this.justSwitched = false;
                    }
                }
            }
        }
        this.wasDown = bl;
    }

    private float getRoFMult(interface interface_) {
        float f2 = 1.0f;
        switch (interface_.getType()) {
            case BALLISTIC: {
                f2 = this.ship.getStats().getBallisticRoFMult().getModifiedValue();
                break;
            }
            case MISSILE: {
                f2 = this.ship.getStats().getMissileRoFMult().getModifiedValue();
                break;
            }
            case ENERGY: {
                f2 = this.ship.getStats().getEnergyRoFMult().getModifiedValue();
            }
        }
        return f2;
    }

    private void selectNextActive() {
        if (this.active == null) {
            this.active = this.findNextWeaponFrom(0);
        } else {
            int n2 = this.weapons.indexOf(this.active);
            this.active = this.findNextWeaponFrom(n2 + 1);
        }
    }

    private interface findNextWeaponFrom(int n2) {
        int n3 = 0;
        while (n3 < this.weapons.size()) {
            int n4 = (n2 + n3) % this.weapons.size();
            interface interface_ = this.weapons.get(n4);
            if (interface_.getAmmo() > 0) {
                return interface_;
            }
            ++n3;
        }
        return this.weapons.get(0);
    }

    public interface getActiveWeapon() {
        if (this.active == null) {
            this.selectNextActive();
        }
        return this.active;
    }

    public List<AutofireAIPlugin> getAIPlugins() {
        return this.ais;
    }

    public boolean isAlternating() {
        return this.type == WeaponGroupType.ALTERNATING;
    }

    private void advanceAuto(boolean bl, Object object, float f2) {
        boolean bl2 = this.ship.isHulk();
        Oo0O.Oo oo2 = this.autofireTracker.\u00d500000();
        boolean bl3 = oo2 == Oo0O.Oo.\u00d300000 && !bl2;
        Ship ship = this.getShip().getShipTarget();
        for (AutofireAIPlugin autofireAIPlugin : this.ais) {
            if (bl3) {
                Profiler.new((String)"Advancing weapon AI");
                autofireAIPlugin.advance(f2);
                Profiler.o00000();
                this.getShip().setShipTarget((Ship)autofireAIPlugin.getTargetShip());
                Profiler.new((String)"Advancing individual weapon");
                boolean bl4 = autofireAIPlugin.shouldFire();
                ((interface)autofireAIPlugin.getWeapon()).advance(bl4 && !this.ship.isHoldFire() && !this.ship.isHoldFireOneFrame(), autofireAIPlugin.getTarget(), f2);
                Profiler.o00000();
                this.getShip().setShipTarget(ship);
                continue;
            }
            ((interface)autofireAIPlugin.getWeapon()).advance(false, null, f2);
        }
        this.getShip().setShipTarget(ship);
    }

    private Object getParamIfNotInactiveHardpoint(interface interface_, Object object) {
        voidsuper voidsuper2 = interface_.getSlot();
        Vector2f vector2f = voidsuper2.computePosition(this.ship);
        boolean bl = false;
        if (object instanceof Vector2f) {
            bl = Utils.o00000(voidsuper2.computeMidArcAngle(this.ship), voidsuper2.getArc() + 30.0f, vector2f, (Vector2f)object);
            if (interface_.hasAIHint(WeaponAPI.AIHints.DO_NOT_AIM) || interface_.hasAIHint(WeaponAPI.AIHints.GUIDED_POOR)) {
                bl = true;
            }
        }
        if (this == this.ship.getSelectedGroup() || !this.isAutofiring() && bl && !voidsuper2.isHardpoint()) {
            return object;
        }
        return null;
    }

    public void advanceLinked(boolean bl, Object object, float f2) {
        if (!bl) {
            for (interface interface_ : this.weapons) {
                interface_.advance(false, this.getParamIfNotInactiveHardpoint(interface_, object), f2);
            }
        } else {
            Vector2f vector2f = new Vector2f((ReadableVector2f)((Vector2f)object));
            List<interface> list = this.weaponsThatWouldBeFiredAtPoint(vector2f, false);
            for (interface interface_ : this.weapons) {
                if (list.contains(interface_)) {
                    interface_.advance(true, object, f2);
                    continue;
                }
                interface_.advance(false, object, f2);
            }
        }
    }

    public List<interface> weaponsThatWouldBeFiredAtPoint(Vector2f vector2f, boolean bl) {
        ArrayList<interface> arrayList = new ArrayList<interface>();
        if (this.isAlternating()) {
            if (this.getActiveWeapon() != null) {
                arrayList.add(this.getActiveWeapon());
            }
            return arrayList;
        }
        interface interface_ = null;
        float f2 = Float.MAX_VALUE;
        for (interface interface_2 : this.weapons) {
            if (bl && interface_2.getAmmo() <= 0) continue;
            float f3 = interface_2.distanceFromArc(vector2f);
            if (f3 == 0.0f || interface_2.isAlwaysFire()) {
                arrayList.add(interface_2);
                continue;
            }
            if (!(f3 < f2)) continue;
            f2 = f3;
            interface_ = interface_2;
        }
        if (arrayList.isEmpty() && interface_ != null) {
            arrayList.add(interface_);
        }
        return arrayList;
    }

    @Override
    public void select(boolean bl, Object object, float f2) {
        this.selectionTracker.\u00d400000(bl, f2);
        if (bl && !this.selectionButtonWasDown && this.isAlternating()) {
            this.selectNextActive();
        }
        if (this.active != null) {
            this.active.select(bl, object, f2);
        } else {
            for (interface interface_ : this.weapons) {
                interface_.select(bl, object, f2);
            }
        }
        this.wasSelected = false;
        this.selectionButtonWasDown = bl;
    }

    public void autofire(boolean bl, Object object, float f2) {
        this.autofireTracker.\u00d400000(bl, f2);
    }

    public void flashIfNeeded() {
        if (this.ship == CombatEngine.getInstance().getPlayerShip()) {
            if (this.active != null) {
                this.active.beginSelectionFlash();
            } else {
                for (interface interface_ : this.weapons) {
                    interface_.beginSelectionFlash();
                }
            }
        }
    }

    public List<interface> getWeapons() {
        return this.weapons;
    }

    public List<WeaponAPI> getWeaponsCopy() {
        return new ArrayList<WeaponAPI>(this.weapons);
    }

    @Override
    public void cleanup() {
        for (interface interface_ : this.weapons) {
            interface_.cleanup();
        }
    }

    public WeaponGroupType getType() {
        return this.type;
    }

    public void setType(WeaponGroupType weaponGroupType) {
        this.type = weaponGroupType;
    }

    @Override
    public boolean isToggle() {
        return false;
    }

    @Override
    public Ship getShip() {
        return this.ship;
    }

    public void setShip(Ship ship) {
        this.ship = ship;
    }

    @Override
    public voidsuper getSlot() {
        return null;
    }

    @Override
    public void activeToChargingDown() {
    }

    @Override
    public void chargingDownToIdle() {
    }

    @Override
    public void chargingDownToUp() {
    }

    @Override
    public void chargingUpToActive() {
        for (AutofireAIPlugin autofireAIPlugin : this.ais) {
            autofireAIPlugin.forceOff();
        }
    }

    @Override
    public void chargingUpToDown() {
    }

    @Override
    public void chargingUpToIdle() {
    }

    @Override
    public void deductEnergy(float f2, boolean bl) {
    }

    @Override
    public float getEnergy() {
        return 0.0f;
    }

    @Override
    public void idleToChargingUp() {
    }

    public boolean isQuickfireMode() {
        return this.quickfireMode;
    }

    public void setQuickfireMode(boolean bl) {
        this.quickfireMode = bl;
    }

    private static enum o {
        Object,
        \u00d200000;

    }
}

