/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.util.DoNotObfuscate;

public class MutatingValue
implements DoNotObfuscate {
    private float value;
    private float min;
    private float max;
    private float rate;
    private float rateSign;
    private float sign = 0.0f;

    public MutatingValue() {
    }

    public MutatingValue(float f2, float f3, float f4) {
        this.min = f2;
        this.max = f3;
        this.rate = Math.abs(f4);
        this.value = f2 + (float)Math.random() * (f3 - f2);
        this.rateSign = Math.signum(f4);
    }

    public void advance(float f2) {
        this.value = this.rateSign != 0.0f ? (this.value += f2 * this.rate * this.rateSign) : (this.value += f2 * this.rate);
        if (this.value > this.max) {
            this.rateSign = -1.0f;
        } else if (this.value < this.min) {
            this.rateSign = 1.0f;
        }
    }

    public float getValue() {
        if (this.sign != 0.0f) {
            return this.value * this.sign;
        }
        return this.value;
    }

    public void setValue(float f2) {
        this.value = f2;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float f2) {
        this.min = f2;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float f2) {
        this.max = f2;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float f2) {
        this.rate = Math.abs(f2);
    }

    public float getSign() {
        return this.sign;
    }

    public void setSign(float f2) {
        this.sign = Math.signum(f2);
    }

    public void setRandomSign() {
        this.sign = (float)Math.signum(Math.random() - 0.5);
        if (this.sign == 0.0f) {
            this.sign = 1.0f;
        }
    }

    public void setRandomRateSign() {
        this.rateSign = (float)Math.signum(Math.random() - 0.5);
        if (this.rateSign == 0.0f) {
            this.rateSign = 1.0f;
        }
    }

    public float getRateSign() {
        return this.rateSign;
    }

    public void setRateSign(float f2) {
        this.rateSign = f2;
    }
}

