/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.graphics.util.Fader;
import com.fs.starfarer.api.util.ValueShifterAPI;
import com.fs.util.DoNotObfuscate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueShifter
implements DoNotObfuscate,
ValueShifterAPI {
    private float base;
    private float curr;
    private transient float averageShift;
    private Map<Object, ShiftData> data = new LinkedHashMap<Object, ShiftData>();

    public ValueShifter(float f2) {
        this.base = f2;
        this.curr = f2;
    }

    public boolean isShifted() {
        return !this.data.isEmpty();
    }

    public float getBase() {
        return this.base;
    }

    public void setBase(float f2) {
        this.base = f2;
    }

    public float getCurr() {
        return this.curr;
    }

    public void shift(Object object, float f2, float f3, float f4, float f5) {
        ShiftData shiftData = this.data.get(object);
        if (shiftData == null) {
            shiftData = new ShiftData();
            shiftData.fader = new Fader(0.0f, f3, f4);
            shiftData.fader.setBounceDown(true);
            this.data.put(object, shiftData);
        }
        shiftData.to = f2;
        shiftData.shift = f5;
        shiftData.fader.setDuration(f3, f4);
        shiftData.fader.fadeIn();
    }

    public void advance(float f2) {
        Iterator<ShiftData> iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ShiftData shiftData = iterator.next();
            shiftData.fader.advance(f2);
            if (!shiftData.fader.isFadedOut()) continue;
            iterator.remove();
        }
        this.updateCurr();
    }

    private void updateCurr() {
        if (this.data.isEmpty()) {
            this.curr = this.base;
            this.averageShift = 0.0f;
            return;
        }
        float f2 = 0.0f;
        for (ShiftData shiftData : this.data.values()) {
            float f3 = shiftData.fader.getBrightness();
            f2 += f3;
        }
        this.averageShift = f2 / (float)this.data.size();
        if (f2 <= 0.0f) {
            this.curr = this.base;
            return;
        }
        float f4 = this.base;
        for (ShiftData shiftData : this.data.values()) {
            float f5 = shiftData.fader.getBrightness();
            f4 += (shiftData.to - this.base) * shiftData.shift * f5 / (f2 - f5 + 1.0f);
        }
        this.curr = f4;
    }

    public float getAverageShift() {
        return this.averageShift;
    }

    public float getShiftProgress(Object object) {
        if (this.data.containsKey(object)) {
            return this.data.get((Object)object).fader.getBrightness();
        }
        return 0.0f;
    }

    public static void main(String[] stringArray) {
        ValueShifter valueShifter = new ValueShifter(10.0f);
        int n2 = 0;
        while (n2 < 10) {
            valueShifter.shift("c1", 25.0f, 1.0f, 1.0f, 1.0f);
            valueShifter.shift("c2", 20.0f, 1.0f, 1.0f, 1.0f);
            valueShifter.advance(0.1f);
            ++n2;
        }
        System.out.println(valueShifter.getCurr());
    }

    public static class ShiftData
    implements DoNotObfuscate {
        public float to;
        public Fader fader;
        public float shift;
    }
}

