/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.anim.AnimationManager;
import com.fs.graphics.util.Fader;
import com.fs.profiler.Profiler;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.FactoryAPI;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.AutofitVariantsAPI;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CampaignProgressIndicatorAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.GenericPluginManagerAPI;
import com.fs.starfarer.api.campaign.IntelDataAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.PluginPickerAPI;
import com.fs.starfarer.api.campaign.RenderingAffectedByAbyssalDepth;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.listeners.ListenerManagerAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.campaign.rules.RuleAPI;
import com.fs.starfarer.api.campaign.rules.RuleTokenReplacementGeneratorPlugin;
import com.fs.starfarer.api.campaign.rules.RulesAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.HintPanelAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.campaign.ActionIndicator;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.BaseLocation;
import com.fs.starfarer.campaign.BaseScript;
import com.fs.starfarer.campaign.CampaignClock;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.CampaignHelpManager;
import com.fs.starfarer.campaign.CampaignProgressIndicator;
import com.fs.starfarer.campaign.CampaignState;
import com.fs.starfarer.campaign.CampaignUIPersistentData;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.CircularOrbit;
import com.fs.starfarer.campaign.CircularOrbitPointDown;
import com.fs.starfarer.campaign.CircularOrbitWithSpin;
import com.fs.starfarer.campaign.CustomCampaignEntity;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.FactionManager;
import com.fs.starfarer.campaign.GenericPluginManager;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.ListenerManager;
import com.fs.starfarer.campaign.ModAndPluginData;
import com.fs.starfarer.campaign.NascentGravityWell;
import com.fs.starfarer.campaign.PingScript;
import com.fs.starfarer.campaign.PlayerCharacterData;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.campaign.accidents.Oo0O;
import com.fs.starfarer.campaign.ai.ModularFleetAI;
import com.fs.starfarer.campaign.comms.A;
import com.fs.starfarer.campaign.comms.CommMessage;
import com.fs.starfarer.campaign.comms.v2.IntelManager;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.PlanetConditionMarket;
import com.fs.starfarer.campaign.events.CampaignEventManager;
import com.fs.starfarer.campaign.fleet.Battle;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CampaignFleetMemberView;
import com.fs.starfarer.campaign.fleet.CampaignFloatingText;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.CrewComposition;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.FleetStub;
import com.fs.starfarer.campaign.fleet.NoFuelDriftScript;
import com.fs.starfarer.campaign.return;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.campaign.rules.Rules;
import com.fs.starfarer.campaign.ui.P;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.campaign.void;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.coreui.A.V;
import com.fs.starfarer.coreui.refit.auto.SavedVariantData;
import com.fs.starfarer.loading.OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.interface;
import com.fs.starfarer.loading.o0oO;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.rpg.ImportantPeople;
import com.fs.starfarer.rpg.OfficerData;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.newui.for;
import com.fs.starfarer.ui.o000OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.ui.oo0O;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.starfarer.util.super.B;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.repo.ObjectRepository;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class CampaignEngine
implements DoNotObfuscate,
SectorAPI,
FactoryAPI,
ObjectRepository.o {
    private static Logger log = Logger.getLogger(CampaignEngine.class);
    private static CampaignEngine instance;
    private boolean isFastForwardIteration = false;
    private Hyperspace hyperspace;
    private List<StarSystem> starSystems = new ArrayList<StarSystem>();
    private List<StarSystem> removeAsap = new ArrayList<StarSystem>();
    private LocationAPI respawnLocation = null;
    private Vector2f respawnCoordinates = new Vector2f();
    private Economy economy = new Economy(false);
    private ImportantPeople importantPeople = new ImportantPeople();
    private List<ActionIndicator> pings = new ArrayList<ActionIndicator>();
    private String difficulty = "normal";
    private IntelManager intelManager = new IntelManager();
    private String seedString = null;
    private GenericPluginManager genericPlugins = new GenericPluginManager();
    private MarketAPI currentlyOpenMarket = null;
    private long nextId = 0L;
    private long playerBattleSeed = Misc.random.nextLong();
    public static WeakHashMap<CampaignEngine, Object> allInstances;
    private String saveDirName = "default";
    private String saveDesc = "";
    private CombatViewport viewport = new CombatViewport(0.0f, 0.0f, 1000.0f, 1000.0f);
    private CampaignFleet playerFleet;
    private PlayerCharacterData characterData = new PlayerCharacterData();
    private transient void listener;
    private transient o campaignUI;
    private CampaignClock clock = new CampaignClock();
    private FactionManager factionManager;
    private boolean paused = false;
    private SavedVariantData savedVariantData = new SavedVariantData();
    private AnimationManager animationManager;
    private BaseLocation currentLocation;
    private transient return tooltipManager;
    private CampaignUIPersistentData uiData;
    private ModAndPluginData modAndPluginData = new ModAndPluginData();
    private List<EveryFrameScript> scripts = new ArrayList<EveryFrameScript>();
    private transient List<EveryFrameScript> transientScripts = new ArrayList<EveryFrameScript>();
    private CampaignHelpManager campaignHelp = new CampaignHelpManager();
    private CampaignEventManager eventManager = new CampaignEventManager();
    private long lastPlayerBattleTimestamp = Long.MIN_VALUE;
    private boolean lastPlayerBattleWon = false;
    private List<CampaignEventListener> listeners = new ArrayList<CampaignEventListener>();
    private transient List<CampaignEventListener> transientListeners = new ArrayList<CampaignEventListener>();
    private TimeoutTracker<CampaignEventListener> listenersWithTimeout = new TimeoutTracker();
    private ListenerManager listenerManager = new ListenerManager();
    private transient boolean skipNextRender = false;
    private transient long frame = 0L;
    private boolean isInNewGameAdvance = true;
    private boolean isInFastAdvance = false;
    private boolean isInSectorGen = false;
    private transient List<RuleTokenReplacementGeneratorPlugin> ruleTokenGenerators = null;
    private Memory memory;
    private transient Map<String, SectorEntityToken> idToEntity = null;

    static {
        allInstances = new WeakHashMap();
    }

    public String genUID() {
        String string = Long.toHexString(this.nextId);
        ++this.nextId;
        return string;
    }

    public MarketAPI getCurrentlyOpenMarket() {
        return this.currentlyOpenMarket;
    }

    public void setCurrentlyOpenMarket(MarketAPI marketAPI) {
        this.currentlyOpenMarket = marketAPI;
    }

    public long getPlayerBattleSeed() {
        return this.playerBattleSeed;
    }

    public void setPlayerBattleSeed(long l) {
        this.playerBattleSeed = l;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static CampaignEngine getInstance() {
        if (instance == null) {
            CampaignEngine.setInstance(new CampaignEngine());
        }
        return instance;
    }

    public static WeakHashMap<CampaignEngine, Object> getAllInstances() {
        return allInstances;
    }

    public static void setAllInstances(WeakHashMap<CampaignEngine, Object> weakHashMap) {
        allInstances = weakHashMap;
    }

    public static void setInstance(CampaignEngine campaignEngine) {
        if (instance != campaignEngine) {
            DevMenuOptions.savedOptions = null;
        }
        instance = campaignEngine;
        Global.setSector((SectorAPI)instance);
        Global.setFactory((FactoryAPI)instance);
        CombatEngine.destroyInstance();
        CombatEngine.getInstance();
        if (campaignEngine != null) {
            allInstances.put(campaignEngine, new Object());
        }
    }

    public String getSeedString() {
        return this.seedString;
    }

    public void setSeedString(String string) {
        this.seedString = string;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public o getCampaignUI() {
        if (this.campaignUI == null) {
            return new o(){

                @Override
                public void showAccidentReport(Oo0O oo0O2) {
                }

                @Override
                public void setMovementDestination(float f2, float f3) {
                }

                @Override
                public void setEngine(CampaignEngine campaignEngine) {
                }

                @Override
                public boolean isShowingDialog() {
                    return false;
                }

                @Override
                public void clearMessages() {
                }

                public void addMessage(String string, Color color, String string2, Color color2) {
                }

                public void addMessage(String string, String string2, Color color) {
                }

                @Override
                public void addMessage(String string, Color color) {
                }

                @Override
                public void addMessage(String string) {
                }

                @Override
                public void startBattle(BattleCreationContext battleCreationContext) {
                }

                public boolean showInteractionDialog(InteractionDialogPlugin interactionDialogPlugin, SectorEntityToken sectorEntityToken) {
                    return false;
                }

                @Override
                public void showNoise(float f2, float f3, float f4) {
                }

                @Override
                public void dialogDismissed(oo0O oo0O2, int n2) {
                }

                @Override
                public void setDialogType(CampaignState.o o2) {
                }

                @Override
                public CampaignState.o getDialogType() {
                    return null;
                }

                @Override
                public o000OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO getDialogParent() {
                    return null;
                }

                public void showCoreUITab(CoreUITabId coreUITabId) {
                }

                public P getMessageDisplay() {
                    return new P();
                }

                public void addMessage(CommMessage commMessage) {
                }

                @Override
                public A getMessageList() {
                    return null;
                }

                public void showCoreUITab(CoreUITabId coreUITabId, Object object) {
                }

                public boolean showInteractionDialog(SectorEntityToken sectorEntityToken) {
                    return false;
                }

                public InteractionDialogAPI getCurrentInteractionDialog() {
                    return null;
                }

                public void addMessage(String string, Color color, String string2, String string3, Color color2, Color color3) {
                }

                public void addMessage(String string, Color color, String string2, String string3, String string4, Color color2, Color color3, Color color4) {
                }

                @Override
                public void setDisallowPlayerInteractionsForOneFrame() {
                }

                public FaderUtil getSharedFader() {
                    return new FaderUtil(0.0f, 0.5f, 0.5f, true, true);
                }

                @Override
                public void suppressMusic(float f2) {
                }

                @Override
                public float getZoomFactor() {
                    return 1.0f;
                }

                public boolean isShowingMenu() {
                    return false;
                }

                public void resetViewOffset() {
                }

                public void addMessage(CommMessageAPI commMessageAPI) {
                }

                public List<HullModSpecAPI> getAvailableHullModsCopy() {
                    return new ArrayList<HullModSpecAPI>();
                }

                public List<String> getAvailableHullModIds() {
                    return null;
                }

                public boolean isHullModAvailable(String string) {
                    return false;
                }

                @Override
                public V getCourseWidget() {
                    return null;
                }

                @Override
                public for getCore() {
                    return null;
                }

                @Override
                public void followEntity(SectorEntityToken sectorEntityToken, boolean bl) {
                }

                @Override
                public boolean isFollowingDirectCommand() {
                    return false;
                }

                @Override
                public void setFollowingDirectCommand(boolean bl) {
                }

                public HintPanelAPI getHintPanel() {
                    return null;
                }

                public void quickLoad() {
                }

                public CoreUITabId getCurrentCoreTab() {
                    return null;
                }

                public void cmdCodex() {
                }

                public void cmdExitWithoutSaving() {
                }

                public void cmdLoad() {
                }

                public boolean cmdSave() {
                    return true;
                }

                public boolean cmdSaveAndExit() {
                    return true;
                }

                public void cmdSaveCopy() {
                }

                public void cmdSettings() {
                }

                public boolean showConfirmDialog(String string, String string2, String string3, Script script, Script script2) {
                    return false;
                }

                public boolean showConfirmDialog(String string, String string2, String string3, float f2, float f3, Script script, Script script2) {
                    return false;
                }

                public void addMessage(IntelInfoPlugin intelInfoPlugin) {
                }

                public void addMessage(IntelInfoPlugin intelInfoPlugin, CommMessageAPI.MessageClickAction messageClickAction) {
                }

                public void addMessage(IntelInfoPlugin intelInfoPlugin, CommMessageAPI.MessageClickAction messageClickAction, Object object) {
                }

                public void clearLaidInCourse() {
                }

                public boolean showPlayerFactionConfigDialog() {
                    return false;
                }

                public void showHelpPopupIfPossible(String string) {
                }

                public SectorEntityToken getCurrentCourseTarget() {
                    return null;
                }

                public float getLastLegDistance(SectorEntityToken sectorEntityToken) {
                    return 0.0f;
                }

                public String getNameForCourseTarget(SectorEntityToken sectorEntityToken, boolean bl) {
                    return null;
                }

                public SectorEntityToken getNextStepForCourse(SectorEntityToken sectorEntityToken) {
                    return null;
                }

                public void layInCourseForNextStep(SectorEntityToken sectorEntityToken) {
                }

                public boolean isFastForward() {
                    return false;
                }

                public boolean isPlayerFleetFollowingMouse() {
                    return false;
                }

                public void showMessageDialog(String string) {
                }

                public float getMinZoomFactor() {
                    return 0.0f;
                }

                public float getMaxZoomFactor() {
                    return 0.0f;
                }

                public void setMinZoomFactor(float f2) {
                }

                public void setMaxZoomFactor(float f2) {
                }

                public boolean isSuppressFuelRangeRenderingOneFrame() {
                    return false;
                }

                public void setSuppressFuelRangeRenderingOneFrame(boolean bl) {
                }

                public int getMaxIntelMapIcons() {
                    return 0;
                }

                public void setMaxIntelMapIcons(int n2) {
                }

                public SectorEntityToken getUltimateCourseTarget() {
                    return null;
                }

                public boolean isHideUI() {
                    return false;
                }

                public void setHideUI(boolean bl) {
                }

                public void setZoomFactor(float f2) {
                }

                public void autosave() {
                }

                @Override
                public void setNextTransitionFast(boolean bl) {
                }

                public boolean showInteractionDialogFromCargo(InteractionDialogPlugin interactionDialogPlugin, SectorEntityToken sectorEntityToken, CampaignUIAPI.DismissDialogDelegate dismissDialogDelegate) {
                    return false;
                }

                public void restartEncounterMusic(SectorEntityToken sectorEntityToken) {
                }
            };
        }
        return this.campaignUI;
    }

    public void layInCourseFor(SectorEntityToken sectorEntityToken) {
        CampaignEngine.getInstance().getCampaignUI().getCourseWidget().layInCourseForNextStep(sectorEntityToken);
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(String string) {
        this.difficulty = string;
    }

    public CampaignHelpManager getCampaignHelp() {
        return this.campaignHelp;
    }

    public Map<String, Object> getPersistentData() {
        return this.modAndPluginData.getPersistentData();
    }

    public void registerPlugin(CampaignPlugin campaignPlugin) {
        this.modAndPluginData.addPlugin(campaignPlugin);
    }

    public void unregisterPlugin(String string) {
        this.modAndPluginData.removePlugin(string);
    }

    public List<CampaignPlugin> getPlugins() {
        return this.modAndPluginData.getPlugins();
    }

    public ModAndPluginData getModAndPluginData() {
        return this.modAndPluginData;
    }

    public PluginPickerAPI getPluginPicker() {
        return this.modAndPluginData;
    }

    public CampaignUIPersistentData getUIData() {
        if (this.uiData == null) {
            this.uiData = new CampaignUIPersistentData();
        }
        return this.uiData;
    }

    public void setCampaignUI(o o2) {
        this.campaignUI = o2;
    }

    public void objectAdded(Object object) {
        if (this.idToEntity == null) {
            this.rebuildIDToEntityMap();
        }
        if (object instanceof SectorEntityToken) {
            SectorEntityToken sectorEntityToken = (SectorEntityToken)object;
            this.idToEntity.put(sectorEntityToken.getId(), sectorEntityToken);
        }
    }

    public void objectRemoved(Object object) {
        if (this.idToEntity == null) {
            this.rebuildIDToEntityMap();
        }
        if (object instanceof SectorEntityToken) {
            SectorEntityToken sectorEntityToken = (SectorEntityToken)object;
            this.idToEntity.remove(sectorEntityToken.getId());
        }
    }

    public CampaignEngine() {
        this.hyperspace = new Hyperspace();
        this.hyperspace.getObjects().setListener((ObjectRepository.o)this);
        this.hyperspace.setName("Hyperspace");
        this.factionManager = new FactionManager();
        this.animationManager = new AnimationManager();
        this.tooltipManager = new return();
        this.addScript(new NoFuelDriftScript());
    }

    public return getTooltipManager() {
        return this.tooltipManager;
    }

    public void readdChangeListeners() {
        this.hyperspace.getObjects().setListener((ObjectRepository.o)this);
        for (StarSystem starSystem : this.starSystems) {
            starSystem.getObjects().setListener((ObjectRepository.o)this);
        }
    }

    public long getLastPlayerBattleTimestamp() {
        return this.lastPlayerBattleTimestamp;
    }

    public void setLastPlayerBattleTimestamp(long l) {
        this.lastPlayerBattleTimestamp = l;
    }

    public boolean isLastPlayerBattleWon() {
        return this.lastPlayerBattleWon;
    }

    public void setLastPlayerBattleWon(boolean bl) {
        this.lastPlayerBattleWon = bl;
    }

    public boolean isIronMode() {
        return this.characterData.isIronMode();
    }

    public FactionManager getFactionManager() {
        return this.factionManager;
    }

    public List<FactionAPI> getAllFactions() {
        return this.getFactionManager().getAllFactions();
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public String getSaveDirName() {
        return this.saveDirName;
    }

    public void setSaveDirName(String string) {
        this.saveDirName = string;
    }

    public CampaignClock getClock() {
        return this.clock;
    }

    public void getListener() {
        return this.listener;
    }

    public void setListener(void void_) {
        this.listener = void_;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void setViewport(float f2, float f3, float f4, float f5) {
        this.viewport.set(f2, f3, f4, f5);
    }

    public CombatViewport getViewport() {
        return this.viewport;
    }

    public BaseLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void updateStarfield(float f2, float f3, float f4, float f5) {
        this.getCurrentLocation().updateStarfield(f2, f3, f4, f5);
    }

    public void renderBG(float f2, float f3) {
        Profiler.new((String)"CampaignEngine rendering bg and stars");
        this.getCurrentLocation().renderBG(f2, f3);
        Profiler.o00000();
    }

    public void renderStarfield(float f2, float f3) {
        Profiler.new((String)"CampaignEngine rendering starfield");
        this.getCurrentLocation().renderStarfield(f2, f3);
        Profiler.o00000();
    }

    public void setSkipNextRender(boolean bl) {
        this.skipNextRender = bl;
    }

    public boolean isSkipNextRender() {
        return this.skipNextRender;
    }

    public void render() {
        if (this.skipNextRender) {
            this.skipNextRender = false;
            return;
        }
        Profiler.new((String)"CampaignEngine rendering");
        this.getCurrentLocation().render(this.viewport);
        boolean bl = false;
        if (this.campaignUI instanceof CampaignState) {
            CampaignState object = (CampaignState)this.campaignUI;
            bl = object.isHideUI();
        }
        this.getCurrentLocation().renderIndicators(this.viewport, bl);
        for (ActionIndicator actionIndicator : this.pings) {
            actionIndicator.render(this.viewport);
        }
        Profiler.o00000();
    }

    public EveryFrameScript addPing(SectorEntityToken sectorEntityToken, CampaignPingSpec campaignPingSpec) {
        if (this.isInNewGameAdvance()) {
            return null;
        }
        PingScript pingScript = new PingScript(sectorEntityToken, campaignPingSpec);
        this.addScript(pingScript);
        return pingScript;
    }

    public EveryFrameScript addPing(SectorEntityToken sectorEntityToken, String string) {
        if (this.isInNewGameAdvance()) {
            return null;
        }
        PingScript pingScript = new PingScript(sectorEntityToken, string);
        this.addScript(pingScript);
        return pingScript;
    }

    public EveryFrameScript addPing(SectorEntityToken sectorEntityToken, String string, Color color) {
        if (this.isInNewGameAdvance()) {
            return null;
        }
        PingScript pingScript = new PingScript(sectorEntityToken, string, color);
        this.addScript(pingScript);
        return pingScript;
    }

    public void addPingInternal(SectorEntityToken sectorEntityToken, CampaignPingSpec campaignPingSpec) {
        this.pings.add(new ActionIndicator(sectorEntityToken, campaignPingSpec));
    }

    public void addPingInternal(SectorEntityToken sectorEntityToken, String string) {
        this.pings.add(new ActionIndicator(sectorEntityToken, string, null));
    }

    public void addPingInternal(SectorEntityToken sectorEntityToken, String string, Color color) {
        this.pings.add(new ActionIndicator(sectorEntityToken, string, color));
    }

    public void renderInScreenCoordsUnderUI() {
        Object object;
        Object object22;
        List list = this.getCurrentLocation().getEntities(CampaignProgressIndicator.class);
        for (Object object22 : list) {
            ((CampaignProgressIndicator)object22).renderOverlay(1.0f);
        }
        object22 = this.getCurrentLocation().getEntities(BaseCampaignEntity.class);
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (BaseCampaignEntity)iterator.next();
            if (((BaseCampaignEntity)object).getFloatingText() == null) continue;
            for (CampaignFloatingText campaignFloatingText : ((BaseCampaignEntity)object).getFloatingText()) {
                float f2 = ((BaseCampaignEntity)object).getSensorContactFader().getBrightness();
                if (campaignFloatingText.isShowWhenContact()) {
                    f2 = ((BaseCampaignEntity)object).getSensorFaderBrightness();
                }
                campaignFloatingText.renderInScreenCoords(1.0f * f2);
            }
        }
        object = this.getPlayerFleet();
        ListenerUtil.renderInUICoordsBelowUI((ViewportAPI)this.viewport);
    }

    public void renderInScreenCoords() {
        this.tooltipManager.o00000(1.0f);
        ListenerUtil.renderInUICoordsAboveUIAndTooltips((ViewportAPI)this.viewport);
    }

    public void addHitParticle(Vector2f vector2f, Vector2f vector2f2, float f2, float f3, float f4, Color color) {
        this.getCurrentLocation().addHitParticle(vector2f, vector2f2, f2, f3, f4, color);
    }

    public void advance(float f2, B b2) {
        Profiler.new((String)"CampaignEngine.advance()");
        this.isPaused();
        if (!this.isPaused()) {
            ++this.frame;
        }
        for (StarSystem starSystem : this.removeAsap) {
            this.removeStarSystem(starSystem);
        }
        this.removeAsap.clear();
        this.readdChangeListeners();
        if (!this.isPaused() && this.idToEntity == null) {
            this.rebuildIDToEntityMap();
        }
        this.tooltipManager.o00000(f2, b2);
        this.intelManager.advance(f2);
        this.eventManager.advance(f2);
        this.importantPeople.advance(f2);
        this.getUIData().advance(f2);
        float f3 = this.getClock().convertToDays(f2);
        if (!this.isPaused()) {
            this.listenersWithTimeout.advance(f3);
        }
        if (this.economy != null && !this.isPaused()) {
            Profiler.new((String)"Economy advance");
            this.economy.advance(f2);
            Profiler.o00000();
        } else {
            this.economy.advanceMarketConditionsWhenPaused(f2);
        }
        float f4 = f2;
        if (this.isPaused()) {
            f4 = 0.0f;
        }
        if (this.memory != null) {
            this.memory.advance(f4);
        }
        ((Memory)this.getCharacterData().getMemoryWithoutUpdate()).advance(f4);
        for (FactionAPI object : this.getFactionManager().getAllFactions()) {
            ((Faction)object).advance(f4);
        }
        if (this.isPaused() && this.getPlayerFleet() != null) {
            this.getPlayerFleet().updateSpeedBonus();
        }
        if (this.isInFastAdvance()) {
            if (!this.isPaused()) {
                this.animationManager.advanceAll(f2);
                this.clock.advance(f2);
                this.hyperspace.setActiveThisFrame(true);
                this.hyperspace.advanceEvenIfPaused(f2, b2);
                this.hyperspace.advance(f2, null);
                for (BaseLocation arrayList : this.starSystems) {
                    arrayList.setActiveThisFrame(true);
                    arrayList.advanceEvenIfPaused(f2, b2);
                    arrayList.advance(f2, null);
                }
            }
        } else {
            this.getCurrentLocation().advanceEvenIfPaused(f2, b2);
            if (!this.isPaused()) {
                Profiler.new((String)"Internal animationManager.advance()");
                this.animationManager.advanceAll(f2);
                Profiler.o00000();
                this.clock.advance(f2);
                Iterator<ActionIndicator> iterator = this.pings.iterator();
                while (iterator.hasNext()) {
                    ActionIndicator actionIndicator = iterator.next();
                    actionIndicator.advance(f2);
                    if (!actionIndicator.canCleanUp()) continue;
                    iterator.remove();
                }
            }
            int n3 = 30;
            n3 = 60;
            int n32 = 0;
            if (this.getCurrentLocation() != this.hyperspace) {
                if (this.frame % (long)n3 == (long)(n32 % n3)) {
                    this.hyperspace.setActiveThisFrame(true);
                    Profiler.new((String)"Non-current hyperspace advance");
                    this.hyperspace.advanceEvenIfPaused(f2 * (float)n3, b2);
                    if (!this.isPaused()) {
                        this.hyperspace.advance(f2 * (float)n3, null);
                    }
                    Profiler.o00000();
                } else {
                    this.hyperspace.setActiveThisFrame(false);
                }
            }
            ++n32;
            for (BaseLocation baseLocation : this.starSystems) {
                if (this.getCurrentLocation() != baseLocation) {
                    if (this.frame % (long)n3 == (long)(n32 % n3)) {
                        baseLocation.setActiveThisFrame(true);
                        Profiler.new((String)"Non-current star system advance");
                        baseLocation.advanceEvenIfPaused(f2 * (float)n3, b2);
                        if (!this.isPaused()) {
                            baseLocation.advance(f2 * (float)n3, null);
                        }
                        Profiler.o00000();
                    } else {
                        baseLocation.setActiveThisFrame(false);
                    }
                }
                ++n32;
            }
            if (!this.isPaused()) {
                Profiler.new((String)"Current location advance");
                this.getCurrentLocation().setActiveThisFrame(true);
                this.getCurrentLocation().advance(f2, b2);
                Profiler.o00000();
            }
        }
        Profiler.new((String)"Engine-level scripts");
        ArrayList<EveryFrameScript> arrayList = new ArrayList<EveryFrameScript>(this.scripts);
        for (EveryFrameScript everyFrameScript : arrayList) {
            if (everyFrameScript.isDone()) {
                this.scripts.remove(everyFrameScript);
                continue;
            }
            if (!everyFrameScript.runWhilePaused() && this.isPaused()) continue;
            Profiler.new((String)"advance()");
            everyFrameScript.advance(f2);
            Profiler.o00000();
            if (!everyFrameScript.isDone()) continue;
            this.scripts.remove(everyFrameScript);
        }
        ArrayList<EveryFrameScript> arrayList2 = new ArrayList<EveryFrameScript>(this.transientScripts);
        for (EveryFrameScript everyFrameScript : arrayList2) {
            if (everyFrameScript.isDone()) {
                this.transientScripts.remove(everyFrameScript);
                continue;
            }
            if (!everyFrameScript.runWhilePaused() && this.isPaused()) continue;
            everyFrameScript.advance(f2);
            if (!everyFrameScript.isDone()) continue;
            this.transientScripts.remove(everyFrameScript);
        }
        Profiler.o00000();
        if (this.campaignHelp != null && !this.isInFastAdvance()) {
            this.campaignHelp.advance(f2);
        }
        Profiler.o00000();
    }

    public boolean isInSectorGen() {
        return this.isInSectorGen;
    }

    public void setInSectorGen(boolean bl) {
        this.isInSectorGen = bl;
    }

    public boolean isInFastAdvance() {
        return this.isInFastAdvance;
    }

    public void setInFastAdvance(boolean bl) {
        this.isInFastAdvance = bl;
    }

    public boolean isInNewGameAdvance() {
        return this.isInNewGameAdvance;
    }

    public void setInNewGameAdvance(boolean bl) {
        this.isInNewGameAdvance = bl;
    }

    public CampaignEventManager getEventManager() {
        return this.eventManager;
    }

    public void addScript(EveryFrameScript everyFrameScript) {
        this.scripts.add(everyFrameScript);
    }

    public boolean hasScript(Class<?> clazz) {
        for (EveryFrameScript everyFrameScript : this.scripts) {
            if (!clazz.isInstance(everyFrameScript)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransientScript(Class<?> clazz) {
        for (EveryFrameScript everyFrameScript : this.transientScripts) {
            if (!clazz.isInstance(everyFrameScript)) continue;
            return true;
        }
        return false;
    }

    public void addTransientScript(EveryFrameScript everyFrameScript) {
        this.transientScripts.add(everyFrameScript);
    }

    public void addListener(CampaignEventListener campaignEventListener) {
        if (!this.listeners.contains(campaignEventListener)) {
            this.listeners.add(campaignEventListener);
        }
    }

    public void addListenerWithTimeout(CampaignEventListener campaignEventListener, float f2) {
        if (!this.listenersWithTimeout.contains((Object)campaignEventListener)) {
            this.listenersWithTimeout.set((Object)campaignEventListener, f2);
        }
    }

    public void addTransientListener(CampaignEventListener campaignEventListener) {
        if (!this.transientListeners.contains(campaignEventListener)) {
            this.transientListeners.add(campaignEventListener);
        }
    }

    public void removeListener(CampaignEventListener campaignEventListener) {
        this.listeners.remove(campaignEventListener);
        this.transientListeners.remove(campaignEventListener);
        this.listenersWithTimeout.remove((Object)campaignEventListener);
    }

    public void removeTransientScript(EveryFrameScript everyFrameScript) {
        Iterator<EveryFrameScript> iterator = this.transientScripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript2 = iterator.next();
            if (everyFrameScript2 != everyFrameScript) continue;
            iterator.remove();
        }
    }

    public List<EveryFrameScript> getScripts() {
        return this.scripts;
    }

    public List<EveryFrameScript> getTransientScripts() {
        return this.transientScripts;
    }

    public void removeScript(EveryFrameScript everyFrameScript) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript2 = iterator.next();
            if (everyFrameScript2 != everyFrameScript) continue;
            iterator.remove();
        }
    }

    public void removeScriptsOfClass(Class clazz) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript = iterator.next();
            if (everyFrameScript.getClass() != clazz) continue;
            iterator.remove();
        }
    }

    public void removeTransientScriptsOfClass(Class clazz) {
        Iterator<EveryFrameScript> iterator = this.transientScripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript = iterator.next();
            if (everyFrameScript.getClass() != clazz) continue;
            iterator.remove();
        }
    }

    public void removeFleet(CampaignFleet campaignFleet) {
        if (campaignFleet.getContainingLocation() != null) {
            campaignFleet.getContainingLocation().removeObject(campaignFleet);
        } else {
            this.getCurrentLocation().removeObject(campaignFleet);
        }
    }

    public void autoResolveBattle(CampaignFleet campaignFleet, CampaignFleet campaignFleet2) {
        Profiler.new((String)"Auto-resolving battle");
    }

    public boolean isPaused() {
        return this.paused;
    }

    public CampaignFleet getPlayerFleet() {
        return this.playerFleet;
    }

    public CharacterStats getPlayerStats() {
        return this.characterData.getPerson().getStats();
    }

    public PersonAPI getPlayerPerson() {
        return this.characterData.getPerson();
    }

    public ImportantPeople getImportantPeople() {
        return this.importantPeople;
    }

    public void setPlayerFleet(CampaignFleetAPI campaignFleetAPI) {
        this.playerFleet = (CampaignFleet)campaignFleetAPI;
        if (campaignFleetAPI != null) {
            campaignFleetAPI.setAI(null);
            if (campaignFleetAPI.getFlagship() != null) {
                campaignFleetAPI.getFlagship().setCaptain((PersonAPI)this.getCharacterData().getPerson());
            }
            campaignFleetAPI.setCommander((PersonAPI)this.getCharacterData().getPerson());
        }
    }

    public PlayerCharacterData getCharacterData() {
        return this.characterData;
    }

    public MemoryAPI getPlayerMemoryWithoutUpdate() {
        return this.characterData.getMemoryWithoutUpdate();
    }

    public void setCharacterData(PlayerCharacterData playerCharacterData) {
        this.characterData = playerCharacterData;
    }

    public GenericPluginManagerAPI getGenericPlugins() {
        return this.genericPlugins;
    }

    public IntelManager getIntelManager() {
        return this.intelManager;
    }

    public ListenerManagerAPI getListenerManager() {
        return this.listenerManager;
    }

    Object readResolve() {
        if (this.removeAsap == null) {
            this.removeAsap = new ArrayList<StarSystem>();
        }
        if (this.genericPlugins == null) {
            this.genericPlugins = new GenericPluginManager();
        }
        if (this.listenerManager == null) {
            this.listenerManager = new ListenerManager();
        }
        if (this.intelManager == null) {
            this.intelManager = new IntelManager();
        }
        this.tooltipManager = new return();
        this.transientScripts = new ArrayList<EveryFrameScript>();
        if (this.listeners == null) {
            this.listeners = new ArrayList<CampaignEventListener>();
        }
        this.transientListeners = new ArrayList<CampaignEventListener>();
        if (this.savedVariantData == null) {
            this.savedVariantData = new SavedVariantData();
        }
        if (this.importantPeople == null) {
            this.importantPeople = new ImportantPeople();
        }
        if (this.modAndPluginData == null) {
            this.modAndPluginData = new ModAndPluginData();
        }
        if (this.scripts == null) {
            this.scripts = new ArrayList<EveryFrameScript>();
        }
        if (this.campaignHelp == null) {
            this.campaignHelp = new CampaignHelpManager();
        }
        if (this.eventManager == null) {
            this.eventManager = new CampaignEventManager();
        }
        if (this.pings == null) {
            this.pings = new ArrayList<ActionIndicator>();
        }
        if (this.difficulty == null) {
            this.difficulty = "normal";
        }
        return this;
    }

    Object writeReplace() {
        return this;
    }

    public Hyperspace getHyperspace() {
        return this.hyperspace;
    }

    public void setCurrentLocation(LocationAPI locationAPI) {
        BaseLocation baseLocation = this.currentLocation;
        this.currentLocation = (BaseLocation)locationAPI;
        if (baseLocation != this.currentLocation) {
            ListenerUtil.reportCurrentLocationChanged((LocationAPI)baseLocation, (LocationAPI)this.currentLocation);
            if (this.getListener() != null) {
                this.getListener().reportCurrentLocationChanged(baseLocation, this.currentLocation);
            }
        }
    }

    public StarSystemAPI createStarSystem(String string) {
        StarSystem starSystem = new StarSystem(string);
        starSystem.getObjects().setListener((ObjectRepository.o)this);
        this.starSystems.add(starSystem);
        return starSystem;
    }

    public void removeStarSystem(StarSystemAPI starSystemAPI) {
        ((StarSystem)starSystemAPI).getObjects().setListener(null);
        this.starSystems.remove(starSystemAPI);
    }

    public void removeStarSystemNextFrame(StarSystemAPI starSystemAPI) {
        this.removeAsap.add((StarSystem)starSystemAPI);
    }

    public List<LocationAPI> getAllLocations() {
        ArrayList<StarSystemAPI> arrayList = new ArrayList<StarSystemAPI>(this.getStarSystems());
        arrayList.add((StarSystemAPI)this.hyperspace);
        return arrayList;
    }

    public List<StarSystemAPI> getStarSystems() {
        return new ArrayList<StarSystemAPI>(this.starSystems);
    }

    public StarSystemAPI getStarSystem(String string) {
        for (StarSystem starSystem : this.starSystems) {
            String string2 = starSystem.getOptionalUniqueId();
            string2 = string2 == null ? starSystem.getBaseName().toLowerCase() : string2.toLowerCase();
            if (string == null || !string.toLowerCase().equals(string2)) continue;
            return starSystem;
        }
        return null;
    }

    public List getAllWeaponIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : interface.Object()) {
            BaseWeaponSpec baseWeaponSpec = interface.\u00d400000(string);
            if (baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.SYSTEM) || baseWeaponSpec.getType() == WeaponAPI.WeaponType.SYSTEM) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List getAllEmptyVariantIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.super()) {
            HullVariantSpec hullVariantSpec = SpecStore.o00000(HullVariantSpec.class, string);
            if (hullVariantSpec.isFighter() || !hullVariantSpec.isEmptyHullVariant() || hullVariantSpec.getHullVariantId().equals("shuttlepod_xfer") || hullVariantSpec.getHullVariantId().equals("shuttlepod_Hull")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List getAllFighterWingIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : o0oO.\u00d200000()) {
            FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
            arrayList.add(string);
        }
        return arrayList;
    }

    public Faction getFaction(String string) {
        return this.getFactionManager().getFaction(string);
    }

    public Faction getPlayerFaction() {
        return this.getFaction("player");
    }

    public void addMessage(String string) {
        if (this.getCampaignUI() != null) {
            this.getCampaignUI().addMessage(string);
        }
    }

    public void addMessage(String string, Color color) {
        if (this.getCampaignUI() != null) {
            this.getCampaignUI().addMessage(string, color);
        }
    }

    public SavedVariantData getSavedVariantData() {
        return this.savedVariantData;
    }

    public AutofitVariantsAPI getAutofitVariants() {
        return this.savedVariantData;
    }

    public HullVariantSpec getSavedVariant(String string) {
        return this.savedVariantData.getSavedVariant(string);
    }

    public Collection<String> getAllSavedVariantIds() {
        return this.savedVariantData.getAllSavedVariantIds();
    }

    public CampaignEntity findClosest(float f2, float f3) {
        return this.findClosest(f2, f3, 0.0f);
    }

    public CampaignEntity findClosest(float f2, float f3, float f4) {
        BaseLocation baseLocation = CampaignEngine.getInstance().getCurrentLocation();
        if (baseLocation == null) {
            return null;
        }
        Vector2f vector2f = new Vector2f(f2, f3);
        List list = baseLocation.getObjects().getList(CampaignEntity.class);
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        CampaignEntity campaignEntity = null;
        for (CampaignEntity campaignEntity2 : list) {
            float f7;
            CustomCampaignEntity customCampaignEntity;
            RenderingAffectedByAbyssalDepth renderingAffectedByAbyssalDepth;
            if (campaignEntity2 == CampaignEngine.getInstance().getPlayerFleet() || campaignEntity2.hasTag("terrain") || campaignEntity2.hasTag("non_clickable") || !campaignEntity2.isVisibleToPlayerFleet() || campaignEntity2.isHidden() || campaignEntity2 instanceof RenderingAffectedByAbyssalDepth && (renderingAffectedByAbyssalDepth = (RenderingAffectedByAbyssalDepth)campaignEntity2).getAlphaMultFromAbyssalDepth() <= 0.0f || (renderingAffectedByAbyssalDepth = campaignEntity2.getVisibilityLevelToPlayerFleet()) == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT || renderingAffectedByAbyssalDepth == SectorEntityToken.VisibilityLevel.NONE || campaignEntity2 instanceof CustomCampaignEntity && !(customCampaignEntity = (CustomCampaignEntity)campaignEntity2).isShowInCampaign() || !((f7 = Utils.\u00d800000(vector2f, campaignEntity2.getLocation())) + campaignEntity2.getRadius() < f5 + f6) || !(f7 < Math.max(f4, campaignEntity2.getRadius()))) continue;
            f5 = f7;
            campaignEntity = campaignEntity2;
            f6 = campaignEntity2.getRadius();
        }
        return campaignEntity;
    }

    public FleetMemberAPI createFleetMember(FleetMemberType fleetMemberType, String string) {
        return new FleetMember(0, string, fleetMemberType);
    }

    public FleetMemberAPI createFleetMember(FleetMemberType fleetMemberType, ShipVariantAPI shipVariantAPI) {
        return new FleetMember(0, (HullVariantSpec)shipVariantAPI, fleetMemberType);
    }

    public CargoAPI createCargo(boolean bl) {
        return new CargoData(bl);
    }

    public CargoStackAPI createCargoStack(CargoAPI.CargoItemType cargoItemType, Object object, CargoAPI cargoAPI) {
        if (cargoAPI != null) {
            return new CargoItemStack(cargoItemType, object, (CargoData)cargoAPI);
        }
        return new CargoItemStack(cargoItemType, object, null);
    }

    public CrewCompositionAPI createCrewComposition() {
        return new CrewComposition();
    }

    public FleetStubAPI createStub() {
        FleetStub fleetStub = new FleetStub();
        return fleetStub;
    }

    public CommMessageAPI createMessage() {
        return new CommMessage();
    }

    public JumpPointAPI createJumpPoint(String string, String string2) {
        return new JumpPoint(string, string2);
    }

    public CampaignProgressIndicatorAPI createProgressIndicator(String string, SectorEntityToken sectorEntityToken, float f2) {
        return new CampaignProgressIndicator(string, sectorEntityToken, f2);
    }

    public OrbitAPI createCircularOrbit(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        return new CircularOrbit(null, sectorEntityToken, f3).setPeriod(f4).setCurrAngle(f2);
    }

    public OrbitAPI createCircularOrbitPointingDown(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        return new CircularOrbitPointDown(null, sectorEntityToken, f3).setPeriod(f4).setCurrAngle(f2);
    }

    public OrbitAPI createCircularOrbitWithSpin(SectorEntityToken sectorEntityToken, float f2, float f3, float f4, float f5) {
        return new CircularOrbitWithSpin(null, sectorEntityToken, f3, f2, f5, f5).setPeriod(f4);
    }

    public void doHyperspaceTransition(CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken, JumpPointAPI.JumpDestination jumpDestination) {
        this.doHyperspaceTransition(campaignFleetAPI, sectorEntityToken, jumpDestination, 0.0f);
    }

    public void doHyperspaceTransition(CampaignFleetAPI campaignFleetAPI, final SectorEntityToken sectorEntityToken, final JumpPointAPI.JumpDestination jumpDestination, final float f2) {
        final CampaignFleet campaignFleet = (CampaignFleet)campaignFleetAPI;
        if (campaignFleet.isInHyperspaceTransition()) {
            return;
        }
        campaignFleet.setInJumpTransition(true);
        campaignFleet.setJumpDestination(jumpDestination);
        campaignFleet.getIndicator().Object().fadeOut();
        final boolean bl = campaignFleet.isPlayerFleet();
        this.addScript(new BaseScript(){
            float untilCanWarpOut;
            boolean done;
            float elapsedWarpingOut;
            float elapsedWarpingIn;
            private TransitionState state;
            private Set<CampaignFleetMemberView> warping;
            private IntervalTracker tracker;
            private float elapsedForMove;
            private float warpRateMult;
            private Fader fader;
            {
                this.untilCanWarpOut = f22;
                this.done = false;
                this.elapsedWarpingOut = 0.0f;
                this.elapsedWarpingIn = 0.0f;
                this.state = TransitionState.START;
                this.warping = new HashSet<CampaignFleetMemberView>();
                this.tracker = new IntervalTracker(0.05f, 0.2f);
                this.elapsedForMove = 0.0f;
                this.warpRateMult = 1.0f;
                this.fader = new Fader(0.0f, 0.25f, 0.25f);
            }

            public boolean isDone() {
                if (this.done) {
                    campaignFleet.setInJumpTransition(false);
                    campaignFleet.setInJumpTransitionWarpOutStage(false);
                    campaignFleet.setJumpDestination(null);
                }
                return this.done;
            }

            private Color getColorForView(CampaignFleetMemberView campaignFleetMemberView) {
                return campaignFleetMemberView.getMember().getHullSpec().getHullStyle().if.super();
            }

            private float getVolumeForView(CampaignFleetMemberView campaignFleetMemberView) {
                ShipAPI.HullSize hullSize = campaignFleetMemberView.getMember().getHullSpec().getHullSize();
                switch (hullSize) {
                    case CAPITAL_SHIP: {
                        return 1.0f;
                    }
                    case CRUISER: {
                        return 0.8f;
                    }
                    case DESTROYER: {
                        return 0.7f;
                    }
                    case FRIGATE: {
                        return 0.6f;
                    }
                    case FIGHTER: {
                        return 0.5f;
                    }
                }
                return 1.0f;
            }

            private float getPitch() {
                return 1.0f + ((float)Math.random() - 0.5f) * 0.1f;
            }

            public void advance(float f22) {
                Collection<CampaignFleetMemberView> collection;
                block44: {
                    block45: {
                        block42: {
                            block43: {
                                Profiler.new((String)"Hyperspace transition script");
                                collection = campaignFleet.getFleetView().getViews();
                                campaignFleet.setNoEngaging(30.0f);
                                if (this.state == TransitionState.START) {
                                    if (jumpDestination.getDestination() instanceof JumpPoint) {
                                        ((JumpPoint)jumpDestination.getDestination()).open();
                                    }
                                    campaignFleet.getStats().addTemporaryModMult(0.1f, "going_through_jump_point", "Going through jump-point", 10.0f, campaignFleet.getStats().getAccelerationMult());
                                }
                                if (this.state == TransitionState.START && sectorEntityToken == null) {
                                    this.warping.clear();
                                    this.state = TransitionState.WARPING_OUT;
                                    this.tracker.forceIntervalElapsed();
                                } else if (this.state == TransitionState.START) {
                                    this.warpRateMult = 1.0f;
                                    this.warping.clear();
                                    this.state = TransitionState.MOVING_TO_POINT;
                                }
                                if (this.state == TransitionState.MOVING_TO_POINT) {
                                    this.untilCanWarpOut -= f22;
                                    campaignFleet.setMoveDestinationOverride(sectorEntityToken.getLocation().x, sectorEntityToken.getLocation().y);
                                    float f3 = Utils.\u00d800000(sectorEntityToken.getLocation(), campaignFleet.getLocation());
                                    f3 -= sectorEntityToken.getRadius() * 0.5f;
                                    float f4 = campaignFleet.getRadius();
                                    if (CampaignEngine.this.isInFastAdvance()) {
                                        f4 = 1000.0f;
                                    } else if (!campaignFleet.isInCurrentLocation()) {
                                        f4 = 500.0f;
                                    }
                                    if (f3 <= f4 && this.untilCanWarpOut <= 0.0f) {
                                        this.state = TransitionState.WARPING_OUT;
                                        this.tracker.forceIntervalElapsed();
                                    }
                                    this.elapsedForMove += f22;
                                    if ((this.elapsedForMove > 2.0f + f2 && !CampaignEngine.this.isInFastAdvance() || this.elapsedForMove > 30.0f) && this.state == TransitionState.MOVING_TO_POINT) {
                                        this.state = TransitionState.ABORT;
                                    }
                                }
                                if (this.state != TransitionState.WARPING_OUT) break block42;
                                this.elapsedWarpingOut += f22;
                                if (sectorEntityToken != null) {
                                    campaignFleet.setMoveDestinationOverride(sectorEntityToken.getLocation().x, sectorEntityToken.getLocation().y);
                                }
                                campaignFleet.setInJumpTransitionWarpOutStage(true);
                                if (this.warping.size() < collection.size()) break block43;
                                boolean bl2 = true;
                                for (CampaignFleetMemberView campaignFleetMemberView : this.warping) {
                                    if (campaignFleetMemberView.isJittering() && collection.contains(campaignFleetMemberView)) {
                                        bl2 = false;
                                        continue;
                                    }
                                    campaignFleetMemberView.setExtraAlphaMult(0.0f);
                                }
                                if (!bl2 && !(this.elapsedWarpingOut > 5.0f)) break block42;
                                this.warpRateMult = 1.0f;
                                this.warping.clear();
                                if (bl) {
                                    this.state = TransitionState.FADE_OUT;
                                    this.fader.fadeIn();
                                    CampaignEngine.getInstance().getCampaignUI().showNoise(0.5f, 0.25f, 1.5f);
                                } else {
                                    this.state = TransitionState.SWITCHING_LOCATIONS;
                                }
                                break block42;
                            }
                            this.tracker.advance(f22 * this.warpRateMult);
                            if (this.tracker.intervalElapsed()) {
                                for (CampaignFleetMemberView campaignFleetMemberView : collection) {
                                    if (this.warping.contains(campaignFleetMemberView)) continue;
                                    if (this.warping.isEmpty() && CampaignEngine.getInstance().getCurrentLocation() == campaignFleet.getContainingLocation()) {
                                        com.fs.starfarer.D.for.o00000("warp_out_start", 1.0f, 1.0f, campaignFleet.getLocation(), campaignFleet.getVelocity());
                                    }
                                    this.warping.add(campaignFleetMemberView);
                                    this.warpRateMult *= 1.1f;
                                    if (CampaignEngine.getInstance().getCurrentLocation() != campaignFleet.getContainingLocation()) break;
                                    campaignFleetMemberView.setJitter(1.0f, 0.0f, this.getColorForView(campaignFleetMemberView), 7, 15.0f);
                                    com.fs.starfarer.D.for.o00000("ship_warp_out", this.getPitch(), this.getVolumeForView(campaignFleetMemberView), campaignFleetMemberView.getAbsoluteLocation(), campaignFleetMemberView.getAbsoluteVelocity());
                                    break;
                                }
                            }
                        }
                        if (this.state == TransitionState.FADE_OUT) {
                            if (sectorEntityToken != null) {
                                campaignFleet.setMoveDestinationOverride(sectorEntityToken.getLocation().x, sectorEntityToken.getLocation().y);
                            }
                            this.fader.advance(f22);
                            if (StarfarerSettings.\u00d5\u00d40000 >= 1000.0f) {
                                CampaignEngine.this.viewport.setAlphaMult(0.0f);
                            } else {
                                CampaignEngine.this.viewport.setAlphaMult(1.0f - this.fader.getBrightness());
                            }
                            if (this.fader.isFadedIn()) {
                                this.state = TransitionState.SWITCHING_LOCATIONS;
                            }
                        }
                        if (this.state == TransitionState.SWITCHING_LOCATIONS) {
                            SectorEntityToken sectorEntityToken2 = jumpDestination.getDestination();
                            LocationAPI locationAPI = sectorEntityToken2.getContainingLocation();
                            LocationAPI locationAPI2 = campaignFleet.getContainingLocation();
                            if (bl) {
                                Global.getSector().setCurrentLocation(locationAPI);
                            }
                            locationAPI2.removeEntity((SectorEntityToken)campaignFleet);
                            locationAPI.addEntity((SectorEntityToken)campaignFleet);
                            campaignFleet.getIndicator().Object().forceOut();
                            campaignFleet.getIndicator().Object().fadeIn();
                            float f5 = (float)Math.random() * 360.0f;
                            float f6 = jumpDestination.getMinDistFromToken() + (float)Math.random() * (jumpDestination.getMaxDistFromToken() - jumpDestination.getMinDistFromToken());
                            float f7 = (float)Math.cos(Math.toRadians(f5)) * f6;
                            float f8 = (float)Math.sin(Math.toRadians(f5)) * f6;
                            campaignFleet.setOrbit(null);
                            campaignFleet.setLocation(sectorEntityToken2.getLocation().x + f7, sectorEntityToken2.getLocation().y + f8);
                            campaignFleet.setMoveDestinationOverride(sectorEntityToken2.getLocation().x + f7, sectorEntityToken2.getLocation().y + f8);
                            if (bl) {
                                this.state = TransitionState.FADE_IN;
                                this.fader.fadeOut();
                            } else {
                                this.state = TransitionState.WARPING_IN;
                                this.tracker.forceIntervalElapsed();
                            }
                        }
                        if (this.state == TransitionState.FADE_IN) {
                            this.fader.advance(f22);
                            if (StarfarerSettings.\u00d5\u00d40000 >= 1000.0f) {
                                CampaignEngine.this.viewport.setAlphaMult(1.0f);
                            } else {
                                CampaignEngine.this.viewport.setAlphaMult(1.0f - this.fader.getBrightness());
                            }
                            if (this.fader.isFadedOut()) {
                                this.state = TransitionState.WARPING_IN;
                                this.tracker.forceIntervalElapsed();
                            }
                        }
                        if (this.state != TransitionState.WARPING_IN) break block44;
                        this.elapsedWarpingIn += f22;
                        if (this.warping.size() < collection.size()) break block45;
                        boolean bl3 = true;
                        for (CampaignFleetMemberView campaignFleetMemberView : this.warping) {
                            if (!campaignFleetMemberView.isJittering() || !collection.contains(campaignFleetMemberView)) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3 && !(this.elapsedWarpingIn > 5.0f)) break block44;
                        this.warpRateMult = 1.0f;
                        this.warping.clear();
                        this.state = TransitionState.FINISH;
                        break block44;
                    }
                    campaignFleet.setMoveDestinationOverride(campaignFleet.getLocation().x, campaignFleet.getLocation().y);
                    this.tracker.advance(f22 * this.warpRateMult);
                    if (this.tracker.intervalElapsed()) {
                        for (CampaignFleetMemberView campaignFleetMemberView : collection) {
                            if (this.warping.contains(campaignFleetMemberView)) continue;
                            if (this.warping.isEmpty() && CampaignEngine.getInstance().getCurrentLocation() == campaignFleet.getContainingLocation()) {
                                com.fs.starfarer.D.for.o00000("warp_in_start", 1.0f, 1.0f, campaignFleet.getLocation(), campaignFleet.getVelocity());
                            }
                            this.warping.add(campaignFleetMemberView);
                            this.warpRateMult *= 1.1f;
                            if (CampaignEngine.getInstance().getCurrentLocation() == campaignFleet.getContainingLocation()) {
                                campaignFleetMemberView.setJitter(0.0f, 1.0f, this.getColorForView(campaignFleetMemberView), 7, 15.0f);
                                com.fs.starfarer.D.for.o00000("ship_warp_in", this.getPitch(), this.getVolumeForView(campaignFleetMemberView), campaignFleetMemberView.getAbsoluteLocation(), campaignFleetMemberView.getAbsoluteVelocity());
                            }
                            campaignFleetMemberView.setExtraAlphaMult(1.0f);
                            break;
                        }
                    }
                }
                if (this.state == TransitionState.FINISH) {
                    for (CampaignFleetMemberView campaignFleetMemberView : collection) {
                        campaignFleetMemberView.setExtraAlphaMult(1.0f);
                    }
                    CampaignEngine.this.viewport.setAlphaMult(1.0f);
                    campaignFleet.setNoEngaging(1.0f);
                    if (campaignFleet.getMoveDestinationSetWhileInLocation() == null || !campaignFleet.getMoveDestinationSetWhileInLocation().isCurrentLocation()) {
                        campaignFleet.setMoveDestinationOverride(campaignFleet.getLocation().x, campaignFleet.getLocation().y);
                    }
                    this.done = true;
                    CampaignEngine.this.reportFleetJumped(campaignFleet, sectorEntityToken, jumpDestination);
                }
                if (this.state == TransitionState.ABORT) {
                    for (CampaignFleetMemberView campaignFleetMemberView : collection) {
                        campaignFleetMemberView.setExtraAlphaMult(1.0f);
                    }
                    CampaignEngine.this.viewport.setAlphaMult(1.0f);
                    campaignFleet.setMoveDestinationOverride(campaignFleet.getLocation().x, campaignFleet.getLocation().y);
                    campaignFleet.setInJumpTransitionWarpOutStage(false);
                    campaignFleet.getIndicator().Object().fadeIn();
                    this.done = true;
                }
                Profiler.o00000();
            }
        });
    }

    public LocationAPI getRespawnLocation() {
        return this.respawnLocation;
    }

    public void setRespawnLocation(LocationAPI locationAPI) {
        this.respawnLocation = locationAPI;
    }

    public Vector2f getRespawnCoordinates() {
        return this.respawnCoordinates;
    }

    public void reportEventStage(CampaignEventPlugin campaignEventPlugin, String string, MessagePriority messagePriority) {
        this.reportEventStage(campaignEventPlugin, string, null, messagePriority);
    }

    public void reportEventStage(CampaignEventPlugin campaignEventPlugin, String string, SectorEntityToken sectorEntityToken, MessagePriority messagePriority) {
        this.reportEventStage(campaignEventPlugin, string, sectorEntityToken, messagePriority, null);
    }

    public void reportEventStage(CampaignEventPlugin campaignEventPlugin, String string, SectorEntityToken sectorEntityToken, MessagePriority messagePriority, OnMessageDeliveryScript onMessageDeliveryScript) {
    }

    public SectorEntityToken findNearestFactionOwnedAssetWithinRange(CampaignEventTarget campaignEventTarget, String string, float f2) {
        float f3;
        float f4 = StarfarerSettings.Object() * f2;
        Faction faction = this.getFaction(string);
        Vector2f vector2f = null;
        vector2f = campaignEventTarget.getEntity() == null && campaignEventTarget.getLocation().isHyperspace() ? new Vector2f(0.0f, 0.0f) : (campaignEventTarget.getLocation().isHyperspace() ? campaignEventTarget.getEntity().getLocation() : campaignEventTarget.getLocation().getLocation());
        SectorEntityToken starSystemAPI = null;
        float f5 = Float.MAX_VALUE;
        for (StarSystemAPI starSystemAPI2 : this.getStarSystems()) {
            SectorEntityToken sectorEntityToken2;
            f3 = Utils.\u00d800000(starSystemAPI2.getLocation(), vector2f);
            if (!(f3 < f5)) continue;
            Iterator iterator = starSystemAPI2.getEntitiesWithTag("station").iterator();
            if (iterator.hasNext() && (sectorEntityToken2 = (SectorEntityToken)iterator.next()).getFaction() == faction) {
                f5 = f3;
                starSystemAPI = sectorEntityToken2;
            }
            for (SectorEntityToken sectorEntityToken2 : starSystemAPI2.getPlanets()) {
                if (sectorEntityToken2.getFaction() != faction) continue;
                f5 = f3;
                starSystemAPI = sectorEntityToken2;
            }
        }
        for (SectorEntityToken sectorEntityToken : this.hyperspace.getEntitiesWithTag("station")) {
            if (sectorEntityToken.getFaction() != faction) continue;
            f5 = f3 = Utils.\u00d800000(sectorEntityToken.getLocation(), vector2f);
            starSystemAPI = sectorEntityToken;
        }
        for (PlanetAPI planetAPI : this.hyperspace.getPlanets()) {
            if (planetAPI.getFaction() != faction) continue;
            f5 = f3 = Utils.\u00d800000(planetAPI.getLocation(), vector2f);
            starSystemAPI = planetAPI;
        }
        if (f5 > f4) {
            return null;
        }
        return starSystemAPI;
    }

    public RulesAPI getRules() {
        return new RulesAPI(){

            public void setRandomForNextRulePick(Random random) {
                Rules.o00000 = random;
            }

            public RuleAPI getBestMatching(String string, String string2, InteractionDialogAPI interactionDialogAPI, Map<String, MemoryAPI> map) {
                return Rules.super(string, string2, interactionDialogAPI, map);
            }

            public List<RuleAPI> getAllMatching(String string, String string2, InteractionDialogAPI interactionDialogAPI, Map<String, MemoryAPI> map) {
                return Rules.\u00d200000(string, string2, interactionDialogAPI, map);
            }

            public void addTokenReplacementGenerator(RuleTokenReplacementGeneratorPlugin ruleTokenReplacementGeneratorPlugin) {
                if (CampaignEngine.this.ruleTokenGenerators == null) {
                    CampaignEngine.this.ruleTokenGenerators = new ArrayList<RuleTokenReplacementGeneratorPlugin>();
                }
                CampaignEngine.this.ruleTokenGenerators.add(ruleTokenReplacementGeneratorPlugin);
            }

            public Map<String, String> getTokenReplacements(String string, SectorEntityToken sectorEntityToken, Map<String, MemoryAPI> map) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (CampaignEngine.this.ruleTokenGenerators == null) {
                    CampaignEngine.this.ruleTokenGenerators = new ArrayList<RuleTokenReplacementGeneratorPlugin>();
                }
                for (RuleTokenReplacementGeneratorPlugin ruleTokenReplacementGeneratorPlugin : CampaignEngine.this.ruleTokenGenerators) {
                    hashMap.putAll(ruleTokenReplacementGeneratorPlugin.getTokenReplacements(string, (Object)sectorEntityToken, map));
                }
                return hashMap;
            }

            public String performTokenReplacement(String string, String string2, SectorEntityToken sectorEntityToken, Map<String, MemoryAPI> map) {
                Map<String, String> map2 = this.getTokenReplacements(string, sectorEntityToken, map);
                ArrayList<String> arrayList = new ArrayList<String>(map2.keySet());
                Profiler.new((String)"Sorting tokens");
                Collections.sort(arrayList, new Comparator<String>(){

                    public int o00000(String string, String string2) {
                        return string2.length() - string.length();
                    }
                });
                Profiler.o00000();
                for (String string3 : arrayList) {
                    String string4 = map2.get(string3);
                    if (string4 == null) {
                        string4 = "null";
                    }
                    string2 = string2.replaceAll("(?s)\\" + string3, string4);
                }
                if (map != null) {
                    string2 = Misc.replaceTokensFromMemory((String)string2, map);
                }
                return string2;
            }
        };
    }

    public MemoryAPI getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updateGlobalFacts((MemoryAPI)this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public MemoryAPI createMemory() {
        return new Memory();
    }

    public IntelDataAPI getIntel() {
        return this.getUIData().getIntelData();
    }

    public SectorEntityToken getEntityById(String string) {
        SectorEntityToken sectorEntityToken;
        if (this.idToEntity == null) {
            this.rebuildIDToEntityMap();
        }
        if (this.idToEntity.get(string) instanceof BaseCampaignEntity ? (sectorEntityToken = (BaseCampaignEntity)this.idToEntity.get(string)).getContainingLocation() != null && sectorEntityToken.getContainingLocation().getAllEntities().contains(sectorEntityToken) : this.idToEntity.get(string) instanceof BaseLocation.LocationToken && (sectorEntityToken = (BaseLocation.LocationToken)this.idToEntity.get(string)).getContainingLocation() != null && sectorEntityToken.getContainingLocation().getAllEntities().contains(sectorEntityToken)) {
            return sectorEntityToken;
        }
        sectorEntityToken = this.hyperspace.getEntityById(string);
        if (sectorEntityToken != null) {
            return (BaseCampaignEntity)sectorEntityToken;
        }
        for (LocationAPI locationAPI : this.starSystems) {
            sectorEntityToken = locationAPI.getEntityById(string);
            if (sectorEntityToken == null) continue;
            return (BaseCampaignEntity)sectorEntityToken;
        }
        return null;
    }

    private void rebuildIDToEntityMap() {
        this.idToEntity = new HashMap<String, SectorEntityToken>();
        for (SectorEntityToken sectorEntityToken : this.hyperspace.getAllEntities()) {
            this.idToEntity.put(sectorEntityToken.getId(), sectorEntityToken);
        }
        for (LocationAPI locationAPI : this.starSystems) {
            for (SectorEntityToken sectorEntityToken : locationAPI.getAllEntities()) {
                this.idToEntity.put(sectorEntityToken.getId(), sectorEntityToken);
            }
        }
    }

    public List<SectorEntityToken> getEntitiesWithTag(String string) {
        ArrayList<SectorEntityToken> arrayList = new ArrayList<SectorEntityToken>();
        arrayList.addAll(this.hyperspace.getEntitiesWithTag(string));
        for (LocationAPI locationAPI : this.starSystems) {
            arrayList.addAll(locationAPI.getEntitiesWithTag(string));
        }
        return arrayList;
    }

    public List<SectorEntityToken> getCustomEntitiesWithTag(String string) {
        ArrayList<SectorEntityToken> arrayList = new ArrayList<SectorEntityToken>();
        arrayList.addAll(this.hyperspace.getCustomEntitiesWithTag(string));
        for (LocationAPI locationAPI : this.starSystems) {
            arrayList.addAll(locationAPI.getCustomEntitiesWithTag(string));
        }
        return arrayList;
    }

    public MarketAPI createMarket(String string, String string2, int n2) {
        return new Market(string, string2, n2, this.economy);
    }

    public MarketAPI convertToRegularMarket(MarketAPI marketAPI) {
        if (marketAPI instanceof PlanetConditionMarket) {
            return ((PlanetConditionMarket)marketAPI).convertToRegular();
        }
        return marketAPI;
    }

    public MarketAPI createConditionMarket(String string, String string2, int n2) {
        return new PlanetConditionMarket(string, string2, n2, this.economy);
    }

    public CampaignFleetAIAPI createFleetAI(CampaignFleetAPI campaignFleetAPI) {
        return new ModularFleetAI((CampaignFleet)campaignFleetAPI);
    }

    public List<CampaignEventListener> getAllListeners() {
        ArrayList<CampaignEventListener> arrayList = new ArrayList<CampaignEventListener>(this.listeners);
        arrayList.addAll(this.transientListeners);
        arrayList.addAll(this.listenersWithTimeout.getItems());
        return arrayList;
    }

    public CampaignFleetAPI createEmptyFleet(FactionAPI factionAPI, boolean bl) {
        CampaignFleet campaignFleet = new CampaignFleet((Faction)factionAPI);
        if (bl) {
            campaignFleet.setAIModeNoSync(true);
        }
        return campaignFleet;
    }

    public CampaignFleetAPI createEmptyFleet(String string, String string2, boolean bl) {
        Faction faction = FactionManager.getInstance().getFaction(string);
        CampaignFleet campaignFleet = new CampaignFleet(faction);
        if (bl) {
            campaignFleet.setAIModeNoSync(true);
        }
        ModularFleetAI modularFleetAI = new ModularFleetAI(campaignFleet);
        campaignFleet.setAI(modularFleetAI);
        campaignFleet.setName(string2);
        campaignFleet.getCommander().setFaction(string);
        return campaignFleet;
    }

    public void reportPlayerMarketTransaction(PlayerMarketTransaction playerMarketTransaction) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerMarketTransaction(playerMarketTransaction);
        }
        ListenerUtil.reportPlayerMarketTransaction((PlayerMarketTransaction)playerMarketTransaction);
    }

    public void reportBattleOccurred(CampaignFleetAPI campaignFleetAPI, BattleAPI battleAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportBattleOccurred(campaignFleetAPI, battleAPI);
        }
        boolean bl = battleAPI.isPlayerInvolved();
        for (CampaignFleetAPI campaignFleetAPI2 : battleAPI.getSnapshotBothSides()) {
            for (FleetEventListener fleetEventListener : campaignFleetAPI2.getEventListeners()) {
                fleetEventListener.reportBattleOccurred(campaignFleetAPI2, campaignFleetAPI, battleAPI);
            }
            if (!bl || !campaignFleetAPI2.getMemoryWithoutUpdate().getBoolean("$cfai_makeAggressiveLastsOneBattle")) continue;
            campaignFleetAPI2.getMemoryWithoutUpdate().unset("$cfai_makeAggressive");
        }
        ListenerUtil.reportBattleOccurred(null, (CampaignFleetAPI)campaignFleetAPI, (BattleAPI)battleAPI);
    }

    public void reportBattleFinished(CampaignFleetAPI campaignFleetAPI, BattleAPI battleAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportBattleFinished(campaignFleetAPI, battleAPI);
        }
    }

    public void reportPlayerEngagement(EngagementResultAPI engagementResultAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerEngagement(engagementResultAPI);
        }
    }

    public void reportEncounterLootGenerated(FleetEncounterContextPlugin fleetEncounterContextPlugin, CargoAPI cargoAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportEncounterLootGenerated(fleetEncounterContextPlugin, cargoAPI);
        }
    }

    public void reportFleetDespawned(CampaignFleetAPI campaignFleetAPI, CampaignEventListener.FleetDespawnReason fleetDespawnReason, Object object) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportFleetDespawned(campaignFleetAPI, fleetDespawnReason, object);
        }
    }

    public void reportFleetSpawned(CampaignFleetAPI campaignFleetAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportFleetSpawned(campaignFleetAPI);
        }
    }

    public void reportFleetJumped(CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken, JumpPointAPI.JumpDestination jumpDestination) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportFleetJumped(campaignFleetAPI, sectorEntityToken, jumpDestination);
        }
    }

    public void reportFleetReachedEntity(CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportFleetReachedEntity(campaignFleetAPI, sectorEntityToken);
        }
    }

    public void reportShowInteractionDialog(InteractionDialogAPI interactionDialogAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportShownInteractionDialog(interactionDialogAPI);
        }
    }

    public void reportPlayerOpenedMarket(MarketAPI marketAPI) {
        this.getEconomy().nextStep();
        for (String string : this.getPlayerFleet().getAbilities().keySet()) {
            AbilityPlugin abilityPlugin = this.getPlayerFleet().getAbilities().get(string);
            abilityPlugin.fleetOpenedMarket(marketAPI);
        }
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerOpenedMarket(marketAPI);
        }
        ListenerUtil.reportPlayerOpenedMarket((MarketAPI)marketAPI);
        this.setCurrentlyOpenMarket(marketAPI);
    }

    public void reportPlayerClosedMarket(MarketAPI marketAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerClosedMarket(marketAPI);
        }
        ListenerUtil.reportPlayerClosedMarket((MarketAPI)marketAPI);
        this.setCurrentlyOpenMarket(null);
    }

    public void reportPlayerDumpedCargo(CargoAPI cargoAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerDumpedCargo(cargoAPI);
        }
    }

    public void reportEconomyTick(int n2) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportEconomyTick(n2);
        }
    }

    public void reportEconomyMonthEnd() {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportEconomyMonthEnd();
        }
    }

    public void reportPlayerDidNotTakeCargo(CargoAPI cargoAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerDidNotTakeCargo(cargoAPI);
        }
    }

    public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI marketAPI) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerOpenedMarketAndCargoUpdated(marketAPI);
        }
        ListenerUtil.reportPlayerOpenedMarketAndCargoUpdated((MarketAPI)marketAPI);
    }

    public void reportPlayerActivatedAbility(AbilityPlugin abilityPlugin, Object object) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerActivatedAbility(abilityPlugin, object);
        }
    }

    public void reportPlayerDeactivatedAbility(AbilityPlugin abilityPlugin, Object object) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerDeactivatedAbility(abilityPlugin, object);
        }
    }

    public void reportPlayerReputationChange(String string, float f2) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerReputationChange(string, f2);
        }
    }

    public void reportPlayerReputationChange(PersonAPI personAPI, float f2) {
        for (CampaignEventListener campaignEventListener : this.getAllListeners()) {
            campaignEventListener.reportPlayerReputationChange(personAPI, f2);
        }
    }

    public ReputationActionResponsePlugin.ReputationAdjustmentResult adjustPlayerReputation(Object object, String string) {
        if ("player".equals(string)) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        ReputationActionResponsePlugin reputationActionResponsePlugin = this.modAndPluginData.pickReputationActionResponsePlugin(object, string);
        if (reputationActionResponsePlugin == null) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        return reputationActionResponsePlugin.handlePlayerReputationAction(object, string);
    }

    public ReputationActionResponsePlugin.ReputationAdjustmentResult adjustPlayerReputation(Object object, PersonAPI personAPI) {
        ReputationActionResponsePlugin reputationActionResponsePlugin = this.modAndPluginData.pickReputationActionResponsePlugin(object, personAPI);
        if (reputationActionResponsePlugin == null) {
            return new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        }
        return reputationActionResponsePlugin.handlePlayerReputationAction(object, personAPI);
    }

    public PersonAPI createPerson() {
        return new Person("steady");
    }

    public OfficerDataAPI createOfficerData(PersonAPI personAPI) {
        return new OfficerData((Person)personAPI);
    }

    public BattleAPI createBattle(CampaignFleetAPI campaignFleetAPI, CampaignFleetAPI campaignFleetAPI2) {
        return new Battle(campaignFleetAPI, campaignFleetAPI2);
    }

    public NascentGravityWellAPI createNascentGravityWell(SectorEntityToken sectorEntityToken, float f2) {
        if (f2 <= 0.0f && (f2 = Math.max(40.0f, sectorEntityToken.getRadius() * 0.3f)) > 150.0f) {
            f2 = 150.0f;
        }
        NascentGravityWell nascentGravityWell = new NascentGravityWell(sectorEntityToken, f2);
        return nascentGravityWell;
    }

    public boolean isFastForwardIteration() {
        return this.isFastForwardIteration;
    }

    public void setFastForwardIteration(boolean bl) {
        this.isFastForwardIteration = bl;
    }

    public SectorEntityToken getMousedOverEntity() {
        return return_ = CampaignEngine.getInstance().getTooltipManager();
        if (return_ != null) {
            return return_.new();
        }
        return null;
    }

    public String getSaveDesc() {
        return this.saveDesc;
    }

    public void setSaveDesc(String string) {
        this.saveDesc = string;
    }

    public static interface o
    extends CampaignUIAPI {
        public void setEngine(CampaignEngine var1);

        public void addMessage(String var1);

        public void addMessage(String var1, Color var2);

        public void clearMessages();

        public boolean isShowingDialog();

        public void showAccidentReport(Oo0O var1);

        public void showNoise(float var1, float var2, float var3);

        public void followEntity(SectorEntityToken var1, boolean var2);

        public void setMovementDestination(float var1, float var2);

        public void startBattle(BattleCreationContext var1);

        public void setDialogType(CampaignState.o var1);

        public CampaignState.o getDialogType();

        public void dialogDismissed(oo0O var1, int var2);

        public o000OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO getDialogParent();

        public A getMessageList();

        public void setDisallowPlayerInteractionsForOneFrame();

        public float getZoomFactor();

        public void suppressMusic(float var1);

        public V getCourseWidget();

        public for getCore();

        public boolean isFollowingDirectCommand();

        public void setFollowingDirectCommand(boolean var1);

        public void setNextTransitionFast(boolean var1);
    }

    public static enum TransitionState implements DoNotObfuscate
    {
        START,
        MOVING_TO_POINT,
        WARPING_OUT,
        FADE_OUT,
        SWITCHING_LOCATIONS,
        FADE_IN,
        WARPING_IN,
        FINISH,
        ABORT;

    }
}

