/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.if;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FactionManager
implements DoNotObfuscate {
    private Faction playerFaction;
    private Faction pirateFaction;
    private Faction hegemonyFaction;
    private Map<String, Faction> factions = new HashMap<String, Faction>();
    private Map<String, Relation> relations = new HashMap<String, Relation>();

    @Deprecated
    public static FactionManager getInstance() {
        return CampaignEngine.getInstance().getFactionManager();
    }

    public FactionManager() {
        this.readResolve();
        this.playerFaction = this.factions.get("player");
    }

    protected Object readResolve() {
        for (String string : SpecStore.\u00d400000(if.class)) {
            if (!SpecStore.new(if.class, string) && StarfarerSettings.\u00d200000() || this.factions.containsKey(string)) continue;
            this.factions.put(string, new Faction(string));
        }
        return this;
    }

    public List<FactionAPI> getAllFactions() {
        return new ArrayList<FactionAPI>(this.factions.values());
    }

    public Relation getRelation(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = String.valueOf(string) + "_" + string2;
        Relation relation = this.relations.get(string3);
        if (relation != null) {
            return relation;
        }
        relation = new Relation();
        relation.factionIdOne = string;
        relation.factionIdTwo = string2;
        relation.value = relation.factionIdOne.equals(relation.factionIdTwo) ? 1.0f : 0.0f;
        string3 = String.valueOf(string) + "_" + string2;
        this.relations.put(string3, relation);
        string3 = String.valueOf(string2) + "_" + string;
        this.relations.put(string3, relation);
        return relation;
    }

    public Faction getFaction(String string) {
        return this.factions.get(string);
    }

    public Faction getPlayerFaction() {
        return this.playerFaction;
    }

    public Faction getPirateFaction() {
        return this.factions.get("pirates");
    }

    public static final class Relation
    implements DoNotObfuscate {
        private String factionIdOne;
        private String factionIdTwo;
        private float value = 0.0f;

        public float getValue() {
            return this.value;
        }

        public void setValue(float f2) {
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (f2 < -1.0f) {
                f2 = -1.0f;
            }
            this.value = f2;
        }
    }
}

