/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.loading.WingRole;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.String;
import com.fs.starfarer.campaign.command.float;
import com.fs.starfarer.campaign.command.for;
import com.fs.starfarer.campaign.command.oO0O;
import com.fs.starfarer.campaign.command.super;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.Y;
import com.fs.starfarer.campaign.ui.new;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.ui.H;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.util.super.Object;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FighterBlueprintBrowser
extends for
implements String,
UITable.Oo {
    public static java.lang.String ALL_TECHS = "All designs";
    public static java.lang.String ALL_TYPES = "All types";
    public static java.lang.String FIGHTER = "Fighter";
    public static java.lang.String BOMBER = "Bomber";
    public static java.lang.String INTERCEPTOR = "Interceptor";
    public static java.lang.String OTHER = "Other";
    private List<FighterWingSpec> \u00f8O\u00d3000 = new ArrayList<FighterWingSpec>();
    private CustomProductionPanel super.this$new;
    private TableColumns Oo\u00d3000 = null;

    public FighterBlueprintBrowser(CustomProductionPanel customProductionPanel, for.o o2) {
        super(o2, customProductionPanel);
        this.super.this$new = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableFighters() != null) {
            for (java.lang.String string : customProductionPanel.getDelegate().getAvailableFighters()) {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
                this.\u00f8O\u00d3000.add(fighterWingSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (java.lang.String string : faction.getKnownFighters()) {
                FighterWingSpec fighterWingSpec = SpecStore.o00000(FighterWingSpec.class, string);
                this.\u00f8O\u00d3000.add(fighterWingSpec);
            }
        }
    }

    public List<FighterWingSpec> getKnownFighters() {
        return this.\u00f8O\u00d3000;
    }

    @Override
    protected UITable createTable() {
        Y y2 = new Y(this.faction);
        y2.addColumn((java.lang.Object)TableColumns.NAME, "Fighter blueprint", 300.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TYPE, "Type", 163.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TECH, "Design type", 200.0f, true);
        y2.setTooltip(0, "Fighter name. Mouse over the icon for a detailed tooltip with its stats.");
        y2.setTooltip(1, "Fighter type - bomber, interceptor, heavy fighter, etc.");
        y2.setTooltip(2, "The originator of the design (such as a corporation or a faction), or, for more common designs, its general classification.");
        if (this.mode == for.o.\u00d300000) {
            y2.addColumn((java.lang.Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            y2.setTooltip(3, "Prioriziting a fighter will make it more likely to be used by your faction's fleets.");
        } else {
            y2.addColumn((java.lang.Object)TableColumns.COST, "Cost", 120.0f, true);
            y2.setTooltipAbove(3, new StandardTooltipV2Expandable(300.0f, false){

                @Override
                public void createImpl(boolean bl) {
                    this.addPara("Production cost.", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, float.ROW_HEIGHT, y2, this);
        uITable.setEmptyText("No matching fighter blueprints");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(float.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<java.lang.String> set = this.tags.getSelected();
        for (FighterWingSpec fighterWingSpec : this.\u00f8O\u00d3000) {
            if (!this.wingMatchesTags(fighterWingSpec, set)) continue;
            super super_ = new super(this.super.this$new, this.table.getHeader(), super.o.\u00d300000, fighterWingSpec.getId(), this.mode);
            this.table.addRow(super_);
            if (this.mode != for.o.\u00d200000) continue;
            super_.getButton().getLogic().o00000(H.Oo.\u00d400000);
        }
        this.table.resumeRecompute();
        this.table.sort((java.lang.Object)TableColumns.TYPE, false);
        super.updateTable();
    }

    protected boolean wingMatchesTags(FighterWingSpec fighterWingSpec, Set<java.lang.String> set) {
        if (fighterWingSpec.getRole() == WingRole.FIGHTER ? !set.contains(FIGHTER) : (fighterWingSpec.getRole() == WingRole.BOMBER ? !set.contains(BOMBER) : (fighterWingSpec.getRole() == WingRole.INTERCEPTOR ? !set.contains(INTERCEPTOR) : !set.contains(OTHER)))) {
            return false;
        }
        java.lang.String string = fighterWingSpec.getVariant().getHullSpec().getManufacturer();
        return string == null || set.contains(string);
    }

    @Override
    protected oO0O createTags() {
        oO0O oO0O2 = new oO0O(this.table.getWidth(), this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        CountingMap countingMap = new CountingMap();
        for (FighterWingSpec fighterWingSpec : this.\u00f8O\u00d3000) {
            countingMap.add((java.lang.Object)fighterWingSpec.getVariant().getHullSpec().getManufacturer());
            if (fighterWingSpec.getRole() == WingRole.FIGHTER) {
                ++n2;
            } else if (fighterWingSpec.getRole() == WingRole.BOMBER) {
                ++n3;
            } else if (fighterWingSpec.getRole() == WingRole.INTERCEPTOR) {
                ++n4;
            } else {
                ++n5;
            }
            ++n6;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            oO0O2.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (java.lang.String string : arrayList) {
                oO0O2.addTag(string, string, countingMap.getCount((java.lang.Object)string));
            }
            oO0O2.addGroup(0.0f);
        }
        oO0O2.beginGroup(false, ALL_TYPES, 120.0f);
        oO0O2.addTag(FIGHTER, n2);
        oO0O2.addTag(BOMBER, n3);
        oO0O2.addTag(INTERCEPTOR, n4);
        oO0O2.addTag(OTHER, n5);
        oO0O2.setTotalOverrideForCurrentGroup(n6);
        oO0O2.addGroup(f2);
        return oO0O2;
    }

    @Override
    public void tagsChanged(oO0O oO0O2) {
        TableColumns tableColumns = this.Oo\u00d3000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((java.lang.Object)tableColumns, null);
            this.table.sort((java.lang.Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<new> tableGetComparator(UITable uITable, final java.lang.Object object) {
        return new Comparator<new>(){

            public int o00000(new new_, new new_2) {
                int n2;
                super super_ = (super)new_;
                super super_2 = (super)new_2;
                BaseWeaponSpec baseWeaponSpec = super_.getWeaponSpec();
                FighterWingSpec fighterWingSpec = super_.getWingSpec();
                BaseWeaponSpec baseWeaponSpec2 = super_2.getWeaponSpec();
                FighterWingSpec fighterWingSpec2 = super_2.getWingSpec();
                FighterBlueprintBrowser.this.Oo\u00d3000 = (TableColumns)((java.lang.Object)object);
                if (object == TableColumns.TECH && (n2 = super_.getTechString().compareTo(super_2.getTechString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.TYPE && (n2 = super_.getTypeString().compareTo(super_2.getTypeString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.ENABLED) {
                    if (super_.isBlueprintEnabled() && !super_2.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (super_2.isBlueprintEnabled() && !super_.isBlueprintEnabled()) {
                        return 1;
                    }
                    n2 = super_.getSizeOrdinal() - super_2.getSizeOrdinal();
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if (object == TableColumns.COST && (n2 = super_.getCostValue() - super_2.getCostValue()) != 0) {
                    return n2;
                }
                return super_.getNameString().compareTo(super_2.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, new new_, java.lang.Object object) {
        super super_ = (super)new_;
        if (this.mode == for.o.\u00d300000) {
            super_.setBlueprintEnabled(!super_.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n2 = 1;
            boolean bl = true;
            if (object instanceof Object) {
                cloneable = (Object)object;
                if (((Object)cloneable).isCtrlDown()) {
                    n2 = 1000;
                } else if (((Object)cloneable).isShiftDown()) {
                    n2 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((Object)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.super.this$new.getProd();
            if (bl) {
                int n3 = this.super.this$new.getDelegate() == null ? 0 : (this.super.this$new.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId(), n2, n3);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId(), n2);
            }
            this.super.this$new.updatePlanTable(FactionProductionAPI.ProductionItemType.FIGHTER, super_.getWingSpec().getId());
            super_.getButton().flash(false, 0.1f, 0.9f);
        }
        super_.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, Y.o o2) {
    }

    @Override
    protected void selectAll() {
        for (new new_ : this.table.getRows()) {
            super super_ = (super)new_;
            super_.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (new new_ : this.table.getRows()) {
            super super_ = (super)new_;
            super_.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (java.lang.String string : faction.getKnownFighters()) {
            faction.removePriorityFighter(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityFighters().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownFighters(bl);
    }

    @Override
    protected java.lang.String getAutoEnableSubject() {
        return "fighter blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownFighters();
    }

    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

