/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.N;
import com.fs.starfarer.campaign.command.String;
import com.fs.starfarer.campaign.command.float;
import com.fs.starfarer.campaign.command.for;
import com.fs.starfarer.campaign.command.oO0O;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.Y;
import com.fs.starfarer.campaign.ui.new;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.g;
import com.fs.starfarer.ui.H;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.util.super.Object;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ShipBlueprintBrowser
extends for
implements String,
UITable.Oo {
    public static java.lang.String ALL_TECHS = "All designs";
    public static java.lang.String ALL_SIZES = "All sizes";
    public static java.lang.String ALL_TYPES = "All types";
    public static java.lang.String FRIGATES = "Frigates";
    public static java.lang.String DESTROYERS = "Destroyers";
    public static java.lang.String CRUISERS = "Cruisers";
    public static java.lang.String CAPITALS = "Capitals";
    public static java.lang.String COMBAT_SHIPS = "Warships";
    public static java.lang.String PHASE_SHIPS = "Phase ships";
    public static java.lang.String CARRIERS = "Carriers";
    public static java.lang.String CIVILIAN = "Civilian";
    private List<g> \u00f4O\u00d3000 = new ArrayList<g>();
    private CustomProductionPanel private.interface$super;
    private TableColumns \u00f5O\u00d3000 = null;

    public ShipBlueprintBrowser(CustomProductionPanel customProductionPanel, for.o o2) {
        super(o2, customProductionPanel);
        this.private.interface$super = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableShipHulls() != null) {
            for (java.lang.String string : customProductionPanel.getDelegate().getAvailableShipHulls()) {
                g g2 = SpecStore.o00000(g.class, string);
                this.\u00f4O\u00d3000.add(g2);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (java.lang.String string : faction.getKnownShips()) {
                g g3 = SpecStore.o00000(g.class, string);
                this.\u00f4O\u00d3000.add(g3);
            }
        }
    }

    public List<g> getKnownHulls() {
        return this.\u00f4O\u00d3000;
    }

    @Override
    protected UITable createTable() {
        Y y2 = new Y(this.faction);
        y2.addColumn((java.lang.Object)TableColumns.NAME, "Ship hull blueprint", 300.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.SIZE, "Size", 80.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TYPE, "Type", 80.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TECH, "Design type", 200.0f, true);
        y2.setTooltip(0, "Hull name. Mouse over the icon for a detailed tooltip with its stats.");
        y2.setTooltip(1, "Hull size.");
        y2.setTooltip(2, "Ship type - warship, carrier, phase ship, or civilian.");
        y2.setTooltip(3, "The originator of the design (such as a corporation or a faction), or, for more common designs, its general classification.");
        if (this.mode == for.o.\u00d300000) {
            y2.addColumn((java.lang.Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            y2.setTooltip(4, "Prioriziting a ship will make it more likely to be used in your faction's fleets.");
        } else {
            y2.addColumn((java.lang.Object)TableColumns.COST, "Cost", 120.0f, true);
            y2.setTooltipLeft(4, new StandardTooltipV2Expandable(300.0f, false){

                @Override
                public void createImpl(boolean bl) {
                    if (DebugFlags.WEAPONS_HAVE_COST) {
                        float f2 = 0.0f;
                        if (ShipBlueprintBrowser.this.private.interface$super == null || !ShipBlueprintBrowser.this.private.interface$super.isPickerMode()) {
                            this.addPara("Production cost. Does not include outfitting the ship with weapons and fighters.", f2);
                            f2 = 10.0f;
                            this.addPara("The cost of weapons and fighters installed on the ship will be deducted once it's produced and does not count against the monthly production capacity.", f2);
                        } else {
                            this.addPara("Cost to produce a hull of this ship type. The hull will not have any weapons or fighter LPCs mounted.", f2);
                        }
                    } else {
                        this.addPara("Production cost. Includes outfitting the ship with weapons and fighters.", 0.0f);
                    }
                }
            });
        }
        UITable uITable = new UITable(8000.0f, float.ROW_HEIGHT, y2, this);
        uITable.setEmptyText("No matching ship hull blueprints");
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(float.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        Set<java.lang.String> set = this.tags.getSelected();
        for (g g2 : this.\u00f4O\u00d3000) {
            if (!this.hullMatchesTags(g2, set)) continue;
            N n2 = new N(this.private.interface$super, this.table.getHeader(), g2.getHullId(), this.mode);
            this.table.addRow(n2);
            if (this.mode != for.o.\u00d200000) continue;
            n2.getButton().getLogic().o00000(H.Oo.\u00d400000);
        }
        this.table.resumeRecompute();
        this.table.sort((java.lang.Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean hullMatchesTags(g g2, Set<java.lang.String> set) {
        boolean bl;
        boolean bl2;
        ShipAPI.HullSize hullSize = g2.getHullSize();
        java.lang.String string = null;
        if (hullSize == ShipAPI.HullSize.FRIGATE) {
            string = FRIGATES;
        }
        if (hullSize == ShipAPI.HullSize.DESTROYER) {
            string = DESTROYERS;
        }
        if (hullSize == ShipAPI.HullSize.CRUISER) {
            string = CRUISERS;
        }
        if (hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
            string = CAPITALS;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        boolean bl3 = g2.isPhase() || g2.getHints().contains(ShipHullSpecAPI.ShipTypeHints.PHASE);
        boolean bl4 = bl2 = bl3 && g2.isCivilianNonCarrier();
        if (!bl2 && bl3 && !set.contains(PHASE_SHIPS)) {
            return false;
        }
        if (!bl2 && g2.isCivilianNonCarrier() && !set.contains(CIVILIAN)) {
            return false;
        }
        if (bl2 && !set.contains(PHASE_SHIPS) && !set.contains(CIVILIAN)) {
            return false;
        }
        if (g2.isCarrier() && !set.contains(CARRIERS)) {
            return false;
        }
        boolean bl5 = bl = !bl3 && !g2.isCarrier() && !g2.isCivilianNonCarrier();
        if (bl && !set.contains(COMBAT_SHIPS)) {
            return false;
        }
        java.lang.String string2 = g2.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected oO0O createTags() {
        oO0O oO0O2 = new oO0O(this.table.getWidth(), this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        CountingMap countingMap = new CountingMap();
        for (g g2 : this.\u00f4O\u00d3000) {
            boolean bl = g2.isPhase() || g2.getHints().contains(ShipHullSpecAPI.ShipTypeHints.PHASE);
            countingMap.add((java.lang.Object)g2.getManufacturer());
            if (g2.isCarrier()) {
                ++n2;
            } else if (g2.isCivilianNonCarrier()) {
                ++n3;
            } else if (bl) {
                ++n4;
            } else {
                ++n5;
            }
            if (g2.isCivilianNonCarrier() && bl) {
                ++n4;
            }
            if (g2.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                ++n6;
            } else if (g2.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                ++n7;
            } else if (g2.getHullSize() == ShipAPI.HullSize.CRUISER) {
                ++n8;
            } else if (g2.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                ++n9;
            }
            ++n10;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            oO0O2.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (java.lang.String string : arrayList) {
                oO0O2.addTag(string, string, countingMap.getCount((java.lang.Object)string));
            }
            oO0O2.addGroup(0.0f);
        }
        oO0O2.beginGroup(false, ALL_SIZES, 120.0f);
        oO0O2.addTag(FRIGATES, n6);
        oO0O2.addTag(DESTROYERS, n7);
        oO0O2.addTag(CRUISERS, n8);
        oO0O2.addTag(CAPITALS, n9);
        oO0O2.addGroup(f2 * 1.0f);
        oO0O2.beginGroup(false, ALL_TYPES, 120.0f);
        oO0O2.addTag(COMBAT_SHIPS, n5);
        oO0O2.addTag(PHASE_SHIPS, n4);
        oO0O2.addTag(CARRIERS, n2);
        oO0O2.addTag(CIVILIAN, n3);
        oO0O2.setTotalOverrideForCurrentGroup(n10);
        oO0O2.addGroup(f3);
        return oO0O2;
    }

    @Override
    public void tagsChanged(oO0O oO0O2) {
        TableColumns tableColumns = this.\u00f5O\u00d3000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((java.lang.Object)tableColumns, null);
            this.table.sort((java.lang.Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<new> tableGetComparator(UITable uITable, final java.lang.Object object) {
        return new Comparator<new>(){

            public int o00000(new new_, new new_2) {
                int n2;
                N n3 = (N)new_;
                N n4 = (N)new_2;
                g g2 = n3.getSpec();
                g g3 = n4.getSpec();
                ShipBlueprintBrowser.this.\u00f5O\u00d3000 = (TableColumns)((java.lang.Object)object);
                if (object == TableColumns.SIZE && (n2 = g2.getHullSize().ordinal() - g3.getHullSize().ordinal()) != 0) {
                    return n2;
                }
                if (object == TableColumns.TECH) {
                    return g2.getManufacturer().compareTo(g3.getManufacturer());
                }
                if (object == TableColumns.TYPE) {
                    return n3.getTypeString().compareTo(n4.getTypeString());
                }
                if (object == TableColumns.ENABLED) {
                    if (n3.isBlueprintEnabled() && !n4.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (n4.isBlueprintEnabled() && !n3.isBlueprintEnabled()) {
                        return 1;
                    }
                    n2 = g2.getHullSize().ordinal() - g3.getHullSize().ordinal();
                    if (n2 != 0) {
                        return -n2;
                    }
                }
                if (object == TableColumns.COST && (n2 = n3.getCostValue() - n4.getCostValue()) != 0) {
                    return n2;
                }
                return g2.getHullName().compareTo(g3.getHullName());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, new new_, java.lang.Object object) {
        N n2 = (N)new_;
        if (this.mode == for.o.\u00d300000) {
            n2.setBlueprintEnabled(!n2.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n3 = 1;
            boolean bl = true;
            if (object instanceof Object) {
                cloneable = (Object)object;
                if (((Object)cloneable).isCtrlDown()) {
                    n3 = 1000;
                } else if (((Object)cloneable).isShiftDown()) {
                    n3 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((Object)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.private.interface$super.getProd();
            if (bl) {
                int n4 = this.private.interface$super.getDelegate() == null ? 0 : (this.private.interface$super.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.SHIP, n2.getHullId(), n3, n4);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.SHIP, n2.getHullId(), n3);
            }
            this.private.interface$super.updatePlanTable(FactionProductionAPI.ProductionItemType.SHIP, n2.getHullId());
            n2.getButton().flash(false, 0.1f, 0.9f);
        }
        n2.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, Y.o o2) {
    }

    @Override
    protected void selectAll() {
        for (new new_ : this.table.getRows()) {
            N n2 = (N)new_;
            n2.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (new new_ : this.table.getRows()) {
            N n2 = (N)new_;
            n2.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (java.lang.String string : faction.getKnownShips()) {
            faction.removePriorityShip(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityShips().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownShips(bl);
    }

    @Override
    protected java.lang.String getAutoEnableSubject() {
        return "ship blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownShips();
    }

    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

