/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.command;

import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.command.CustomProductionPanel;
import com.fs.starfarer.campaign.command.String;
import com.fs.starfarer.campaign.command.float;
import com.fs.starfarer.campaign.command.for;
import com.fs.starfarer.campaign.command.oO0O;
import com.fs.starfarer.campaign.command.super;
import com.fs.starfarer.campaign.ui.UITable;
import com.fs.starfarer.campaign.ui.Y;
import com.fs.starfarer.campaign.ui.new;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.ui.H;
import com.fs.starfarer.ui.impl.StandardTooltipV2Expandable;
import com.fs.starfarer.util.super.Object;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeaponBlueprintBrowser
extends for
implements String,
UITable.Oo {
    public static java.lang.String ALL_TECHS = "All designs";
    public static java.lang.String ALL_SIZES = "All sizes";
    public static java.lang.String ALL_TYPES = "All types";
    public static java.lang.String SMALL = "Small";
    public static java.lang.String MEDIUM = "Medium";
    public static java.lang.String LARGE = "Large";
    public static java.lang.String BALLISTIC = "Ballistic";
    public static java.lang.String MISSILE = "Missile";
    public static java.lang.String ENERGY = "Energy";
    private List<BaseWeaponSpec> \u00d3o\u00d3000 = new ArrayList<BaseWeaponSpec>();
    private CustomProductionPanel String.this$new;
    private TableColumns \u00d2o\u00d3000 = null;

    public WeaponBlueprintBrowser(CustomProductionPanel customProductionPanel, for.o o2) {
        super(o2, customProductionPanel);
        this.String.this$new = customProductionPanel;
        if (customProductionPanel != null && customProductionPanel.isPickerMode() && customProductionPanel.getDelegate() != null && customProductionPanel.getDelegate().getAvailableWeapons() != null) {
            for (java.lang.String string : customProductionPanel.getDelegate().getAvailableWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.\u00d3o\u00d3000.add(baseWeaponSpec);
            }
        } else {
            Faction faction = CampaignEngine.getInstance().getPlayerFaction();
            for (java.lang.String string : faction.getKnownWeapons()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string);
                this.\u00d3o\u00d3000.add(baseWeaponSpec);
            }
        }
    }

    public List<BaseWeaponSpec> getKnownWeapons() {
        return this.\u00d3o\u00d3000;
    }

    @Override
    protected UITable createTable() {
        Y y2 = new Y(this.faction);
        java.lang.String string = "Weapon blueprint";
        java.lang.String string2 = "No matching weapon blueprints";
        if (this.String.this$new != null && this.String.this$new.isPickerMode() && this.String.this$new.getDelegate() != null) {
            if (this.String.this$new.getDelegate().getWeaponColumnNameOverride() != null) {
                string = this.String.this$new.getDelegate().getWeaponColumnNameOverride();
            }
            if (this.String.this$new.getDelegate().getNoMatchingBlueprintsLabelOverride() != null) {
                string2 = this.String.this$new.getDelegate().getNoMatchingBlueprintsLabelOverride();
            }
        }
        y2.addColumn((java.lang.Object)TableColumns.NAME, string, 300.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.SIZE, "Size", 80.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TYPE, "Type", 80.0f, true);
        y2.addColumn((java.lang.Object)TableColumns.TECH, "Design type", 200.0f, true);
        y2.setTooltip(0, "Weapon name. Mouse over the icon for a detailed tooltip with its stats.");
        y2.setTooltip(1, "Weapon size.");
        y2.setTooltip(2, "Weapon type - ballistic, energy, or missile.");
        y2.setTooltip(3, "The originator of the design (such as a corporation or a faction), or \"Common\" for designs found in use throughout the Sector.");
        if (this.mode == for.o.\u00d300000) {
            y2.addColumn((java.lang.Object)TableColumns.ENABLED, ENABLED_COL, 120.0f, true);
            y2.setTooltip(4, "Prioriziting a weapon will make it more likely to be used by your faction's fleets.");
        } else {
            y2.addColumn((java.lang.Object)TableColumns.COST, "Cost", 120.0f, true);
            y2.setTooltipAbove(4, new StandardTooltipV2Expandable(300.0f, false){

                @Override
                public void createImpl(boolean bl) {
                    this.addPara("Production cost.", 0.0f);
                }
            });
        }
        UITable uITable = new UITable(8000.0f, float.ROW_HEIGHT, y2, this);
        uITable.setEmptyText(string2);
        uITable.setWithBackground(true);
        uITable.autoSizeToRows(float.TABLE_ROWS);
        return uITable;
    }

    @Override
    public void updateTable() {
        this.table.clear();
        this.table.suspendRecompute();
        boolean bl = true;
        if (this.String.this$new != null && this.String.this$new.isPickerMode() && this.String.this$new.getDelegate() != null) {
            bl = this.String.this$new.getDelegate().isUseCreditSign();
        }
        Set<java.lang.String> set = this.tags.getSelected();
        for (BaseWeaponSpec baseWeaponSpec : this.\u00d3o\u00d3000) {
            if (!this.weaponMatchesTags(baseWeaponSpec, set)) continue;
            super super_ = new super(this.String.this$new, this.table.getHeader(), super.o.\u00d200000, baseWeaponSpec.getWeaponId(), this.mode);
            super_.setWithCreditSign(bl);
            this.table.addRow(super_);
            if (this.mode != for.o.\u00d200000) continue;
            super_.getButton().getLogic().o00000(H.Oo.\u00d400000);
        }
        this.table.resumeRecompute();
        this.table.sort((java.lang.Object)TableColumns.SIZE, false);
        super.updateTable();
    }

    protected boolean weaponMatchesTags(BaseWeaponSpec baseWeaponSpec, Set<java.lang.String> set) {
        WeaponAPI.WeaponSize weaponSize = baseWeaponSpec.getSize();
        java.lang.String string = null;
        if (weaponSize == WeaponAPI.WeaponSize.SMALL) {
            string = SMALL;
        }
        if (weaponSize == WeaponAPI.WeaponSize.MEDIUM) {
            string = MEDIUM;
        }
        if (weaponSize == WeaponAPI.WeaponSize.LARGE) {
            string = LARGE;
        }
        if (string != null && !set.contains(string)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC && !set.contains(BALLISTIC)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE && !set.contains(MISSILE)) {
            return false;
        }
        if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.ENERGY && !set.contains(ENERGY)) {
            return false;
        }
        java.lang.String string2 = baseWeaponSpec.getManufacturer();
        return string2 == null || set.contains(string2);
    }

    @Override
    protected oO0O createTags() {
        oO0O oO0O2 = new oO0O(this.table.getWidth(), this);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        CountingMap countingMap = new CountingMap();
        for (BaseWeaponSpec baseWeaponSpec : this.\u00d3o\u00d3000) {
            countingMap.add((java.lang.Object)baseWeaponSpec.getManufacturer());
            if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                ++n2;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                ++n3;
            } else if (baseWeaponSpec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                ++n4;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.BALLISTIC) {
                ++n5;
                continue;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE) {
                ++n6;
                continue;
            }
            if (baseWeaponSpec.getType() != WeaponAPI.WeaponType.ENERGY) continue;
            ++n7;
        }
        float f2 = 10.0f;
        float f3 = 3.0f;
        if (!countingMap.isEmpty()) {
            oO0O2.beginGroup(false, ALL_TECHS);
            ArrayList arrayList = new ArrayList(countingMap.keySet());
            Collections.sort(arrayList);
            for (java.lang.String string : arrayList) {
                oO0O2.addTag(string, string, countingMap.getCount((java.lang.Object)string));
            }
            oO0O2.addGroup(0.0f);
        }
        oO0O2.beginGroup(false, ALL_SIZES, 120.0f);
        oO0O2.addTag(SMALL, n2);
        oO0O2.addTag(MEDIUM, n3);
        oO0O2.addTag(LARGE, n4);
        oO0O2.addGroup(f2 * 1.0f);
        oO0O2.beginGroup(false, ALL_TYPES, 120.0f);
        oO0O2.addTag(BALLISTIC, n5);
        oO0O2.addTag(MISSILE, n6);
        oO0O2.addTag(ENERGY, n7);
        oO0O2.addGroup(f3);
        return oO0O2;
    }

    @Override
    public void tagsChanged(oO0O oO0O2) {
        TableColumns tableColumns = this.\u00d2o\u00d3000;
        this.updateTable();
        if (tableColumns != null) {
            this.table.sort((java.lang.Object)tableColumns, null);
            this.table.sort((java.lang.Object)tableColumns, null);
        }
    }

    @Override
    public Comparator<new> tableGetComparator(UITable uITable, final java.lang.Object object) {
        return new Comparator<new>(){

            public int o00000(new new_, new new_2) {
                int n2;
                super super_ = (super)new_;
                super super_2 = (super)new_2;
                WeaponBlueprintBrowser.this.\u00d2o\u00d3000 = (TableColumns)((java.lang.Object)object);
                if (object == TableColumns.SIZE && (n2 = super_.getSizeOrdinal() - super_2.getSizeOrdinal()) != 0) {
                    return n2;
                }
                if (object == TableColumns.TECH && (n2 = super_.getTechString().compareTo(super_2.getTechString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.TYPE && (n2 = super_.getTypeString().compareTo(super_2.getTypeString())) != 0) {
                    return n2;
                }
                if (object == TableColumns.ENABLED) {
                    if (super_.isBlueprintEnabled() && !super_2.isBlueprintEnabled()) {
                        return -1;
                    }
                    if (super_2.isBlueprintEnabled() && !super_.isBlueprintEnabled()) {
                        return 1;
                    }
                    n2 = super_.getSizeOrdinal() - super_2.getSizeOrdinal();
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if (object == TableColumns.COST && (n2 = super_.getCostValue() - super_2.getCostValue()) != 0) {
                    return n2;
                }
                return super_.getNameString().compareTo(super_2.getNameString());
            }
        };
    }

    @Override
    public void tableRowSelected(UITable uITable, new new_, java.lang.Object object) {
        super super_ = (super)new_;
        if (this.mode == for.o.\u00d300000) {
            super_.setBlueprintEnabled(!super_.isBlueprintEnabled());
        } else {
            Cloneable cloneable;
            int n2 = 1;
            boolean bl = true;
            if (object instanceof Object) {
                cloneable = (Object)object;
                if (((Object)cloneable).isCtrlDown()) {
                    n2 = 1000;
                } else if (((Object)cloneable).isShiftDown()) {
                    n2 = CustomProductionPanel.SHIFT_CLICK_QUANTITY;
                }
                if (((Object)cloneable).isRMBEvent()) {
                    bl = false;
                }
            }
            cloneable = this.String.this$new.getProd();
            if (bl) {
                int n3 = this.String.this$new.getDelegate() == null ? 0 : (this.String.this$new.getDelegate().withQuantityLimits() ? 0 : 1000);
                cloneable.addItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n2, n3);
            } else {
                cloneable.removeItem(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId(), n2);
            }
            this.String.this$new.updatePlanTable(FactionProductionAPI.ProductionItemType.WEAPON, super_.getWeaponSpec().getWeaponId());
            super_.getButton().flash(false, 0.1f, 0.9f);
        }
        super_.getButton().unhighlight();
    }

    @Override
    public void tableSortFinished(UITable uITable, Y.o o2) {
    }

    @Override
    protected void selectAll() {
        for (new new_ : this.table.getRows()) {
            super super_ = (super)new_;
            super_.setBlueprintEnabled(true);
        }
    }

    @Override
    protected void unselectAll() {
        for (new new_ : this.table.getRows()) {
            super super_ = (super)new_;
            super_.setBlueprintEnabled(false);
        }
    }

    @Override
    protected void unselectAllReally() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        for (java.lang.String string : faction.getKnownWeapons()) {
            faction.removePriorityWeapon(string);
        }
    }

    @Override
    protected int getNumPriority() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.getPriorityWeapons().size();
    }

    @Override
    protected void autoEnableSet(boolean bl) {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        faction.setAutoEnableKnownWeapons(bl);
    }

    @Override
    protected java.lang.String getAutoEnableSubject() {
        return "weapon blueprints";
    }

    @Override
    protected boolean isAutoEnableSet() {
        Faction faction = CampaignEngine.getInstance().getPlayerFaction();
        return faction.isAutoEnableKnownWeapons();
    }

    public static enum TableColumns implements DoNotObfuscate
    {
        NAME,
        SIZE,
        TYPE,
        TECH,
        ENABLED,
        COST;

    }
}

