/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.CommodityIconCounts;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.PriceCalculator;
import com.fs.starfarer.campaign.econ.contract.iter.MultiFrameTask;
import com.fs.starfarer.campaign.econ.reach.CommodityMarketData;
import com.fs.starfarer.campaign.econ.reach.MainWorkTask;
import com.fs.starfarer.campaign.econ.reach.ReachEconomy;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.return;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;

public class MainWorkTask2
extends MultiFrameTask
implements DoNotObfuscate {
    private ReachEconomy economy;
    private List<MarketAPI> markets = null;
    private List<String> commodities;
    private int index = 0;
    private boolean started = false;
    private int marketIndex = 0;
    private MainWorkTask.EconWorkParams params;

    public MainWorkTask2(List<MarketAPI> list, ReachEconomy reachEconomy, MainWorkTask.EconWorkParams econWorkParams) {
        this.economy = reachEconomy;
        this.params = econWorkParams;
        this.markets = new ArrayList<MarketAPI>(list);
    }

    public void initCommodityList() {
        this.commodities = new ArrayList<String>();
        for (CommoditySpecAPI commoditySpecAPI : Global.getSettings().getAllCommoditySpecs()) {
            if (commoditySpecAPI.hasTag("nonecon")) continue;
            this.commodities.add(commoditySpecAPI.getId());
        }
        Profiler.new((String)"Sorting commodities");
        Collections.sort(this.commodities, new Comparator<String>(){

            public int o00000(String string, String string2) {
                return return_ = SpecStore.o00000(return.class, string);
                return return_2 = SpecStore.o00000(return.class, string2);
                return (int)Math.signum(return_.getEconomyTier() - return_2.getEconomyTier());
            }
        });
        Profiler.o00000();
    }

    @Override
    public void doNextBatch() {
        if (!this.started) {
            this.initCommodityList();
            this.index = 0;
            this.started = true;
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (this.marketIndex < this.markets.size()) {
            Profiler.new((String)"Reapplying conditions and industries");
            MarketAPI marketAPI = this.markets.get(this.marketIndex);
            marketAPI.reapplyConditions();
            marketAPI.reapplyIndustries();
            ++this.marketIndex;
            Profiler.o00000();
        } else {
            String string = this.commodities.get(this.index);
            return return_ = SpecStore.o00000(return.class, string);
            ++this.index;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (MarketAPI object2 : this.markets) {
                String string2 = object2.getEconGroup();
                if (string2 == null) continue;
                linkedHashSet.add(string2);
            }
            Profiler.new((String)"Computing commodity data");
            new CommodityMarketData(string, null);
            for (String string3 : linkedHashSet) {
                new CommodityMarketData(string, string3);
            }
            Profiler.o00000();
            if (this.params.withStockpileUpdate) {
                Profiler.new((String)"Updating stockpiles and prices");
                for (MarketAPI marketAPI : this.markets) {
                    MainWorkTask2.updateStockpileAndPrice((Market)marketAPI, return_);
                }
            }
            Profiler.o00000();
            List list = Global.getSector().getEconomy().getUpdateListeners();
            for (Iterator<Object> iterator : new ArrayList(list)) {
                if (iterator.isEconomyListenerExpired()) {
                    Global.getSector().getEconomy().removeUpdateListener(iterator);
                    continue;
                }
                iterator.commodityUpdated(string);
            }
        }
    }

    public static void updateStockpileAndPrice(Market market, return return_) {
        MainWorkTask2.updateStockpileAndPriceV2(market, return_);
    }

    public static void updateStockpileAndPriceV2(Market market, return return_) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        CommodityIconCounts commodityIconCounts;
        float f10 = 0.0f;
        float f11 = 1.0f;
        Random random = new Random(market.getId().hashCode() + return_.getId().hashCode() + Global.getSector().getClock().getMonth() * 170000);
        List<CommodityOnMarket> list = market.getCommoditiesWithClass(return_.getDemandClass());
        float f12 = 0.0f;
        float f13 = Economy.ECONOMY_GREED_FRACTION;
        boolean bl = false;
        String string = "core";
        for (CommodityOnMarket commodityOnMarket : list) {
            if (!commodityOnMarket.getCommodity().isPrimary()) continue;
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            f9 = commodityIconCounts.production - commodityIconCounts.inFactionOnlyExport - commodityIconCounts.canNotExport;
            f8 = Math.max(f9, (float)commodityOnMarket.getMaxDemand()) + f10;
            if (f8 < 1.0f) {
                f8 = 1.0f;
            }
            bl = commodityOnMarket.getMaxDemand() <= 0 && commodityOnMarket.getMaxSupply() <= 0;
            f12 = MainWorkTask2.getStockpileQuantity(commodityOnMarket, f8) * f11 + (float)Economy.MIN_STOCKPILE_FOR_PRICING * 2.0f;
            f12 *= 0.95f + 0.1f * random.nextFloat();
            if (bl) {
                commodityOnMarket.getPlayerDemandPriceMod().modifyMult(string, Economy.ECONOMY_NO_DEMAND_PRICE_MULT);
            } else {
                commodityOnMarket.getPlayerDemandPriceMod().unmodifyMult(string);
            }
            commodityOnMarket.getDemand().getDemand().modifyFlat(string, f12 * (1.0f - f13));
            commodityOnMarket.getGreed().modifyFlat(string, f12 * f13);
            break;
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            if (commodityOnMarket.getCommodity().isPrimary()) continue;
            if (bl) {
                commodityOnMarket.getPlayerDemandPriceMod().modifyMult(string, Economy.ECONOMY_NO_DEMAND_PRICE_MULT);
            } else {
                commodityOnMarket.getPlayerDemandPriceMod().unmodifyMult(string);
            }
            commodityOnMarket.getGreed().modifyFlat(string, f12 * f13);
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            if (!commodityOnMarket.getCommodity().isPrimary()) continue;
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            f9 = commodityIconCounts.deficit;
            f8 = commodityIconCounts.inFactionOnlyExport + commodityIconCounts.canNotExport;
            f9 *= 1.0f;
            f8 *= 1.0f;
            int n2 = Math.min(commodityOnMarket.getAvailable(), commodityOnMarket.getMaxSupply());
            int n3 = 0;
            if (bl) {
                n3 = 1;
            }
            f7 = MainWorkTask2.getStockpileQuantity(commodityOnMarket, commodityOnMarket.getAvailable() + n3) * f11;
            f6 = 0.5f;
            f5 = (float)n2 * 0.025f;
            f4 = 10.0f;
            f3 = Math.max(3.0f, (float)commodityOnMarket.getCommodityMarketData().getMaxExportGlobal());
            f2 = 0.5f * f4 / f3;
            f5 = (float)n2 * f2;
            if (f5 > (f6 = f2 * f4)) {
                f5 = f6;
            }
            f7 += commodityOnMarket.getCommodity().getEconUnit() * f5;
            commodityOnMarket.setStockpile(f7 *= 0.95f + 0.1f * random.nextFloat());
        }
        for (CommodityOnMarket commodityOnMarket : list) {
            float f14;
            float f15;
            float f16;
            float f17;
            commodityOnMarket.updateCalc();
            commodityIconCounts = new CommodityIconCounts((CommodityOnMarketAPI)commodityOnMarket);
            PriceCalculator priceCalculator = commodityOnMarket.getDemandPrice();
            PriceCalculator priceCalculator2 = commodityOnMarket.getSupplyPrice();
            float f18 = commodityIconCounts.deficit;
            float f19 = commodityIconCounts.extra;
            f7 = commodityOnMarket.getStockpile();
            f6 = commodityOnMarket.getCommodity().getEconUnit();
            f5 = Economy.DEFICIT_PRICE_INCR_PER_UNIT;
            f3 = Economy.EXCESS_PRICE_DECR_PER_UNIT;
            f4 = Economy.DEFICIT_PRICE_MULT_MAX;
            f2 = Economy.EXCESS_PRICE_MULT_MIN;
            if (f18 > 0.0f) {
                f17 = f7 + f18 * f6;
                f16 = 1.0f + Math.max(1.0f, f18) * f5;
                if (f16 > f4) {
                    f16 = f4;
                }
                priceCalculator.setHighPriceThreshold(f17);
                priceCalculator.setHighPriceMult(f16);
                priceCalculator2.setHighPriceThreshold(f17);
                priceCalculator2.setHighPriceMult(f16);
            } else {
                priceCalculator.setHighPriceThreshold(-1.0f);
                priceCalculator.setHighPriceMult(1.0f);
                priceCalculator2.setHighPriceThreshold(-1.0f);
                priceCalculator2.setHighPriceMult(1.0f);
            }
            f17 = commodityOnMarket.getCombinedTradeModQuantity();
            f16 = commodityOnMarket.getModValueForQuantity(f17);
            if (f18 <= 0.0f && f16 > 0.0f && (f15 = commodityOnMarket.getTradeMod().getModifiedValue() + commodityOnMarket.getTradeModPlus().getModifiedValue()) > 0.0f) {
                f14 = Math.max(0.0f, f7 - f19 * f6);
                float f20 = 1.0f + Math.max(1.0f, 1.0f) * f5;
                if (f20 > f4) {
                    f20 = f4;
                }
                priceCalculator2.setHighPriceThreshold(f14);
                priceCalculator2.setHighPriceMult(f20);
            }
            if (f19 > 0.0f) {
                f15 = f7 - f19 * f6;
                if (f15 < 0.0f) {
                    f15 = 0.0f;
                }
                if ((f14 = 1.0f - Math.max(1.0f, f19) * f3) < f2) {
                    f14 = f2;
                }
                priceCalculator.setLowPriceThreshold(f15);
                priceCalculator.setLowPriceMult(f14);
                priceCalculator2.setLowPriceThreshold(f15);
                priceCalculator2.setLowPriceMult(f14);
                continue;
            }
            priceCalculator.setLowPriceThreshold(-1.0f);
            priceCalculator.setLowPriceMult(1.0f);
            priceCalculator2.setLowPriceThreshold(-1.0f);
            priceCalculator2.setLowPriceMult(1.0f);
        }
    }

    public static float getStockpileQuantity(CommodityOnMarketAPI commodityOnMarketAPI, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        float f3 = BaseIndustry.getSizeMult((float)f2);
        return commodityOnMarketAPI.getCommodity().getEconUnit() * f3;
    }

    @Override
    public boolean isDone() {
        return this.commodities != null && this.index >= this.commodities.size();
    }

    @Override
    public String getLoggingIdentifier() {
        return "MainWorkTask";
    }
}

