/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.util.HashMap;
import java.util.Map;

public class CombatDamageData {
    private Map<FleetMemberAPI, DealtByFleetMember> dealt = new HashMap<FleetMemberAPI, DealtByFleetMember>();

    public Map<FleetMemberAPI, DealtByFleetMember> getDealt() {
        return this.dealt;
    }

    public DealtByFleetMember getDealtBy(FleetMemberAPI member) {
        DealtByFleetMember dealtBy = this.dealt.get(member);
        if (dealtBy == null) {
            dealtBy = new DealtByFleetMember(member);
            this.dealt.put(member, dealtBy);
        }
        return dealtBy;
    }

    public void add(CombatDamageData other) {
        for (FleetMemberAPI member : other.dealt.keySet()) {
            DealtByFleetMember curr = this.getDealtBy(member);
            DealtByFleetMember adding = other.getDealtBy(member);
            for (FleetMemberAPI target : adding.damage.keySet()) {
                curr.addHullDamage(target, adding.getDamageTo((FleetMemberAPI)target).hullDamage);
            }
        }
    }

    public static class DamageToFleetMember {
        public float hullDamage;
    }

    public static class DealtByFleetMember {
        private FleetMemberAPI member;
        private Map<FleetMemberAPI, DamageToFleetMember> damage = new HashMap<FleetMemberAPI, DamageToFleetMember>();

        public DealtByFleetMember(FleetMemberAPI member) {
            this.member = member;
        }

        public DamageToFleetMember getDamageTo(FleetMemberAPI target) {
            DamageToFleetMember damageTo = this.damage.get(target);
            if (damageTo == null) {
                damageTo = new DamageToFleetMember();
                this.damage.put(target, damageTo);
            }
            return damageTo;
        }

        public void addHullDamage(FleetMemberAPI target, float damage) {
            this.getDamageTo((FleetMemberAPI)target).hullDamage += damage;
        }

        public FleetMemberAPI getMember() {
            return this.member;
        }

        public Map<FleetMemberAPI, DamageToFleetMember> getDamage() {
            return this.damage;
        }
    }
}

