/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.events;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import org.lwjgl.util.vector.Vector2f;

public class CampaignEventTarget {
    private Object custom;
    private LocationAPI location;
    private SectorEntityToken entity;
    private Object extra;

    public CampaignEventTarget(Object custom) {
        this.custom = custom;
    }

    public CampaignEventTarget(MarketAPI market) {
        this(market.getPrimaryEntity());
    }

    public CampaignEventTarget(SectorEntityToken entity) {
        this.location = entity.getContainingLocation();
        this.entity = entity;
    }

    public CampaignEventTarget(LocationAPI location) {
        this.location = location;
    }

    public MarketAPI getMarket() {
        if (this.entity != null) {
            return this.entity.getMarket();
        }
        return null;
    }

    public Vector2f getLocationInHyperspace() {
        boolean inHyper = this.location.isHyperspace();
        Vector2f locInHyper = inHyper && this.entity != null ? this.entity.getLocation() : this.location.getLocation();
        return locInHyper;
    }

    public LocationAPI getLocation() {
        return this.location;
    }

    public void setLocation(LocationAPI location) {
        this.location = location;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public void setEntity(SectorEntityToken entity) {
        this.entity = entity;
    }

    public Object getCustom() {
        return this.custom;
    }

    public void setCustom(Object custom) {
        this.custom = custom;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.custom != null) {
            result = 31 * result + (this.custom == null ? 0 : this.custom.hashCode());
        } else {
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            result = 31 * result + (this.extra == null ? 0 : this.extra.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CampaignEventTarget other = (CampaignEventTarget)obj;
        if (this.custom != null && this.custom.equals(other.custom)) {
            return true;
        }
        if (this.custom == null ? other.custom != null : !this.custom.equals(other.custom)) {
            return false;
        }
        if (this.entity == null ? other.entity != null : this.entity != other.entity) {
            return false;
        }
        if (this.location == null ? other.location != null : this.location != other.location) {
            return false;
        }
        return !(this.extra == null ? other.extra != null : !this.extra.equals(other.extra));
    }

    public FactionAPI getFaction() {
        if (this.entity != null) {
            return this.entity.getFaction();
        }
        return null;
    }
}

