/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class WormholeScannerPlugin
extends BaseSpecialItemPlugin {
    public static String PLAYER_CAN_USE_WORMHOLES = "$playerCanUseWormholes";

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        if (!Global.CODEX_TOOLTIP_MODE) {
            tooltip.addTitle(this.getName());
        } else {
            tooltip.addSpacer(-opad);
        }
        String design = this.getDesignType();
        if (design != null) {
            Misc.addDesignTypePara(tooltip, design, 10.0f);
        }
        if (!this.spec.getDesc().isEmpty()) {
            if (Global.CODEX_TOOLTIP_MODE) {
                tooltip.setParaSmallInsignia();
            }
            tooltip.addPara(this.spec.getDesc(), Misc.getTextColor(), opad);
        }
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (!Global.CODEX_TOOLTIP_MODE) {
            tooltip.addPara("Right-click to integrate the " + this.getName() + " with your fleet", b, opad);
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        return true;
    }

    @Override
    public void performRightClickAction() {
        Global.getSector().getMemoryWithoutUpdate().set(PLAYER_CAN_USE_WORMHOLES, true);
        Global.getSoundPlayer().playUISound(this.getSpec().getSoundId(), 1.0f, 1.0f);
        Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.valueOf(this.getName()) + " integrated - can transit wormholes");
    }

    public static boolean canPlayerUseWormholes() {
        if (Global.getSector().getMemoryWithoutUpdate().getBoolean(PLAYER_CAN_USE_WORMHOLES)) {
            return true;
        }
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        String id = "wormhole_scanner";
        return cargo.getQuantity(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData(id, null)) >= 1.0f;
    }
}

