/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.listeners;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.DetectedEntityListener;
import com.fs.starfarer.api.campaign.listeners.DiscoverEntityPlugin;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.listeners.ShowLootListener;
import com.fs.starfarer.api.campaign.listeners.SurveyPlanetListener;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.RemnantNexusIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.SalvorsTallyIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.WarningBeaconIntel;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CoreDiscoverEntityPlugin
implements DiscoverEntityPlugin,
CurrentLocationChangedListener,
SurveyPlanetListener,
DetectedEntityListener,
ShowLootListener {
    public static float SALVORS_TALLY_DELAY_SECONDS = 10.0f;

    @Override
    public void discoverEntity(SectorEntityToken entity) {
        SalvageEntityGenDataSpec salvageSpec;
        entity.setDiscoverable(null);
        entity.setSensorProfile(null);
        if (entity.hasTag("warning_beacon")) {
            WarningBeaconIntel intel = new WarningBeaconIntel(entity);
            Global.getSector().getIntelManager().addIntel(intel);
        } else {
            Color c = Global.getSector().getPlayerFaction().getBaseUIColor();
            MessageIntel intel = new MessageIntel("Discovered: " + entity.getName(), c, new String[]{entity.getName()}, c);
            intel.setSound("ui_discovered_entity");
            intel.setIcon(Global.getSettings().getSpriteName("intel", "discovered_entity"));
            Global.getSector().getCampaignUI().addMessage(intel);
        }
        float xp = 0.0f;
        if (entity.hasDiscoveryXP()) {
            xp = entity.getDiscoveryXP().floatValue();
        } else if (entity.getCustomEntityType() != null && (salvageSpec = (SalvageEntityGenDataSpec)Global.getSettings().getSpec(SalvageEntityGenDataSpec.class, entity.getCustomEntityType(), true)) != null) {
            xp = salvageSpec.getXpDiscover();
        }
        if (xp > 0.0f) {
            Global.getSector().getPlayerPerson().getStats().addXP((long)xp);
        }
        ListenerUtil.reportEntityDiscovered(entity);
        if (entity.hasTag("salvageable")) {
            CoreDiscoverEntityPlugin.addSalvorsTallyIfNeeded(entity.getStarSystem());
        }
    }

    @Override
    public int getHandlingPriority(Object params) {
        return 0;
    }

    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
        StarSystemAPI system;
        if (prev instanceof StarSystemAPI) {
            system = (StarSystemAPI)prev;
            this.removeSalvorsTallyIfNeeded(system);
        }
        if (curr instanceof StarSystemAPI) {
            system = (StarSystemAPI)curr;
            CoreDiscoverEntityPlugin.addSalvorsTallyIfNeeded(system);
        }
    }

    @Override
    public void reportPlayerSurveyedPlanet(PlanetAPI planet) {
        if (Misc.hasUnexploredRuins(planet.getMarket())) {
            CoreDiscoverEntityPlugin.addSalvorsTallyIfNeeded(planet.getStarSystem());
        }
    }

    @Override
    public void reportAboutToShowLootToPlayer(CargoAPI loot, InteractionDialogAPI dialog) {
        SectorEntityToken target = dialog.getInteractionTarget();
        if (target == null) {
            return;
        }
        if (!target.hasTag("salvageable")) {
            return;
        }
        if (target.getStarSystem() == null) {
            return;
        }
        CoreDiscoverEntityPlugin.addSalvorsTallyIfNeeded(target.getStarSystem());
    }

    @Override
    public void reportDetectedEntity(SectorEntityToken entity, SectorEntityToken.VisibilityLevel level) {
        CampaignFleetAPI fleet;
        if (entity instanceof CampaignFleetAPI && level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS && (fleet = (CampaignFleetAPI)entity).isStationMode() && fleet.getFaction().getId().equals("remnant")) {
            this.addRemnantNexusIntelIfNeeded(fleet);
        }
    }

    public void addRemnantNexusIntelIfNeeded(CampaignFleetAPI nexus) {
        if (RemnantNexusIntel.getNexusIntel(nexus) == null) {
            new RemnantNexusIntel(nexus);
        }
    }

    public static void addSalvorsTallyIfNeeded(StarSystemAPI system) {
        if (system == null) {
            return;
        }
        if (system.hasTag("theme_core")) {
            return;
        }
        if (system.getType() == StarSystemGenerator.StarSystemType.DEEP_SPACE) {
            return;
        }
        if (TutorialMissionIntel.isTutorialInProgress()) {
            return;
        }
        SalvorsTallyIntel intel = SalvorsTallyIntel.getSalvorsTallyIntel(system);
        if (intel == null) {
            for (EveryFrameScript curr : Global.getSector().getScripts()) {
                if (!(curr instanceof SalvorsTallyAdder)) continue;
                SalvorsTallyAdder adder = (SalvorsTallyAdder)curr;
                if (adder.intel.getSystem() != system) continue;
                adder.delay = SALVORS_TALLY_DELAY_SECONDS;
                return;
            }
            intel = new SalvorsTallyIntel(system);
            SalvorsTallyIntel.SalvorsTally tally = intel.computeTally();
            if (tally.value != SalvorsTallyIntel.SalvageValue.NONE) {
                SalvorsTallyAdder adder = new SalvorsTallyAdder(intel, SALVORS_TALLY_DELAY_SECONDS);
                Global.getSector().addScript(adder);
            }
        }
    }

    public void removeSalvorsTallyIfNeeded(StarSystemAPI system) {
        if (system == null) {
            return;
        }
        SalvorsTallyIntel intel = SalvorsTallyIntel.getSalvorsTallyIntel(system);
        if (intel != null) {
            SalvorsTallyIntel.SalvorsTally tally = intel.computeTally();
            if (tally.value == SalvorsTallyIntel.SalvageValue.NONE) {
                intel.endImmediately();
            }
        }
    }

    public static class SalvorsTallyAdder
    implements EveryFrameScript {
        protected float delay = 0.0f;
        protected boolean done = false;
        protected SalvorsTallyIntel intel;

        public SalvorsTallyAdder(SalvorsTallyIntel intel, float delay) {
            this.delay = delay;
            this.intel = intel;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void advance(float amount) {
            this.delay -= amount;
            if (this.delay <= 0.0f) {
                this.done = true;
                SalvorsTallyIntel.SalvorsTally tally = this.intel.computeTally();
                if (tally.value != SalvorsTallyIntel.SalvageValue.NONE) {
                    Global.getSector().getIntelManager().addIntel(this.intel);
                }
            }
        }
    }
}

