/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.characters;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.BaseSkillsChangeEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.plugins.impl.CoreAutofitPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashMap;
import java.util.Map;

public class SkillsChangeRemoveVentsCapsEffect
extends BaseSkillsChangeEffect {
    public void setMap(VentsCapsDataMap map, Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        dataMap.put(key, map);
    }

    public VentsCapsDataMap getMap(Map<String, Object> dataMap) {
        String key = this.getClass().getSimpleName();
        VentsCapsDataMap map = (VentsCapsDataMap)dataMap.get(key);
        if (map == null) {
            map = new VentsCapsDataMap();
            dataMap.put(key, map);
        }
        return map;
    }

    public static int getMaxVents(ShipAPI.HullSize size, MutableCharacterStatsAPI stats) {
        int maxVents = CoreAutofitPlugin.getBaseMax(size);
        if (stats != null) {
            maxVents = (int)stats.getMaxVentsBonus().computeEffective(maxVents);
        }
        return maxVents;
    }

    public static int getMaxCaps(ShipAPI.HullSize size, MutableCharacterStatsAPI stats) {
        int maxCapacitors = CoreAutofitPlugin.getBaseMax(size);
        if (stats != null) {
            maxCapacitors = (int)stats.getMaxCapacitorsBonus().computeEffective(maxCapacitors);
        }
        return maxCapacitors;
    }

    public VentsCapsDataMap getEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        VentsCapsDataMap result = new VentsCapsDataMap();
        for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
            VentsCapsEffectData data = new VentsCapsEffectData();
            int maxVentsPre = SkillsChangeRemoveVentsCapsEffect.getMaxVents(member.getHullSpec().getHullSize(), from);
            int maxCapsPre = SkillsChangeRemoveVentsCapsEffect.getMaxCaps(member.getHullSpec().getHullSize(), from);
            int maxVentsPost = SkillsChangeRemoveVentsCapsEffect.getMaxVents(member.getHullSpec().getHullSize(), to);
            int maxCapsPost = SkillsChangeRemoveVentsCapsEffect.getMaxCaps(member.getHullSpec().getHullSize(), to);
            int caps = member.getVariant().getNumFluxCapacitors();
            int vents = member.getVariant().getNumFluxVents();
            data.member = member;
            data.maxVents = maxVentsPost;
            data.maxCaps = maxCapsPost;
            boolean add = false;
            if (maxVentsPre > maxVentsPost && vents > maxVentsPost) {
                add = true;
            }
            if (maxCapsPre > maxCapsPost && caps > maxCapsPost) {
                add = true;
            }
            if (!add) continue;
            result.map.put(member, data);
        }
        return result;
    }

    @Override
    public boolean hasEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to) {
        return !this.getEffects((MutableCharacterStatsAPI)from, (MutableCharacterStatsAPI)to).map.isEmpty();
    }

    @Override
    public void printEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, TooltipMakerAPI info, Map<String, Object> dataMap) {
        super.prepare();
        VentsCapsDataMap map = this.getEffects(from, to);
        this.setMap(map, dataMap);
        info.addSectionHeading("Excess vents and capacitors", this.base, this.dark, Alignment.MID, 15.0f);
        info.addPara("Ships that have more than the new maximum number of flux vents and capacitors will have the excess vents and capacitors removed.", 10.0f, Misc.getNegativeHighlightColor(), "excess vents and capacitors removed");
    }

    @Override
    public void infoButtonPressed(ButtonAPI button, Object param, Map<String, Object> dataMap) {
    }

    @Override
    public void applyEffects(MutableCharacterStatsAPI from, MutableCharacterStatsAPI to, Map<String, Object> dataMap) {
        VentsCapsDataMap map = this.getMap(dataMap);
        for (VentsCapsEffectData data : map.map.values()) {
            SkillsChangeRemoveVentsCapsEffect.clampNumVentsAndCaps(data.member, to);
        }
    }

    public static void clampNumVentsAndCaps(FleetMemberAPI member, MutableCharacterStatsAPI stats) {
        int maxVents = SkillsChangeRemoveVentsCapsEffect.getMaxVents(member.getHullSpec().getHullSize(), stats);
        int maxCaps = SkillsChangeRemoveVentsCapsEffect.getMaxCaps(member.getHullSpec().getHullSize(), stats);
        ShipVariantAPI variant = member.getVariant();
        if (variant.getNumFluxVents() > maxVents || variant.getNumFluxCapacitors() > maxCaps) {
            variant = variant.clone();
            variant.setSource(VariantSource.REFIT);
            variant.setNumFluxVents(Math.min(variant.getNumFluxVents(), maxVents));
            variant.setNumFluxCapacitors(Math.min(variant.getNumFluxCapacitors(), maxCaps));
            member.setVariant(variant, false, false);
        }
    }

    public static class VentsCapsDataMap {
        Map<FleetMemberAPI, VentsCapsEffectData> map = new LinkedHashMap<FleetMemberAPI, VentsCapsEffectData>();
    }

    public static class VentsCapsEffectData {
        FleetMemberAPI member;
        int maxVents;
        int maxCaps;
    }
}

