/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.HullModEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.HullModItemManager;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BaseHullMod
implements HullModEffect {
    protected HullModSpecAPI spec;

    @Override
    public void init(HullModSpecAPI spec) {
        this.spec = spec;
    }

    public boolean isSMod(MutableShipStatsAPI stats) {
        if (stats == null || stats.getVariant() == null || this.spec == null) {
            return false;
        }
        return stats.getVariant().getSMods().contains(this.spec.getId()) || stats.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isSMod(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getVariant().getSMods().contains(this.spec.getId()) || ship.getVariant().getSModdedBuiltIns().contains(this.spec.getId());
    }

    public boolean isBuiltIn(ShipAPI ship) {
        if (ship == null || ship.getVariant() == null || this.spec == null) {
            return false;
        }
        return ship.getHullSpec().getBuiltInMods().contains(this.spec.getId());
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getDescriptionParam(index, hullSize);
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        return this.getSModDescriptionParam(index, hullSize);
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    @Override
    public void advanceInCampaign(FleetMemberAPI member, float amount) {
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return null;
    }

    @Override
    public boolean affectsOPCosts() {
        return false;
    }

    @Override
    public boolean canBeAddedOrRemovedNow(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return true;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return true;
        }
        if (marketOrNull == null) {
            return false;
        }
        if (mode == CampaignUIAPI.CoreUITradeMode.NONE || mode == null) {
            return false;
        }
        for (Industry ind : marketOrNull.getIndustries()) {
            if (ind.getSpec().hasTag("station")) {
                return true;
            }
            if (!ind.getSpec().hasTag("spaceport")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCanNotBeInstalledNowReason(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (this.spec == null) {
            return null;
        }
        boolean reqSpaceport = this.spec.hasTag("req_spaceport");
        if (!reqSpaceport) {
            return null;
        }
        boolean has = ship.getVariant().hasHullMod(this.spec.getId());
        String verb = "installed";
        if (has) {
            verb = "removed";
        }
        return "Can only be " + verb + " at a colony with a spaceport or an orbital station";
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return true;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
    }

    @Override
    public boolean hasSModEffectSection(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        if (!this.hasSModEffect()) {
            return false;
        }
        if (Misc.CAN_SMOD_BUILT_IN) {
            return !this.isBuiltIn(ship) || !this.isSModEffectAPenalty();
        }
        return !this.isBuiltIn(ship);
    }

    @Override
    public boolean isSModEffectAPenalty() {
        return false;
    }

    @Override
    public boolean hasSModEffect() {
        return this.spec != null && this.spec.getSModEffectFormat() != null && !this.spec.getSModEffectFormat().trim().isEmpty() && !this.spec.getSModEffectFormat().startsWith("#");
    }

    @Override
    public void addSModEffectSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        String[] params = new String[]{this.getSModDescriptionParam(0, hullSize, null), this.getSModDescriptionParam(1, hullSize, null), this.getSModDescriptionParam(2, hullSize, null), this.getSModDescriptionParam(3, hullSize, null), this.getSModDescriptionParam(4, hullSize, null), this.getSModDescriptionParam(5, hullSize, null), this.getSModDescriptionParam(6, hullSize, null), this.getSModDescriptionParam(7, hullSize, null), this.getSModDescriptionParam(8, hullSize, null), this.getSModDescriptionParam(9, hullSize, null)};
        tooltip.addPara(this.spec.getSModDescription(hullSize).replaceAll("\\%", "%%"), opad, h, params);
    }

    @Override
    public void addSModSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec, boolean isForBuildInList) {
        float opad = 10.0f;
        boolean sMod = this.isSMod(ship);
        Color s = Misc.getStoryOptionColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color darkBad = Misc.setAlpha(Misc.scaleColorOnly(bad, 0.4f), 175);
        if (!sMod || this.hasSModEffect()) {
            if (!this.isSModEffectAPenalty()) {
                if (isForBuildInList) {
                    tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + " bonus", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                } else {
                    tooltip.addSectionHeading("S-mod bonus", Misc.getStoryOptionColor(), Misc.getStoryDarkColor(), Alignment.MID, opad);
                }
            } else if (isForBuildInList) {
                tooltip.addSectionHeading(String.valueOf(this.spec.getDisplayName()) + " penalty", bad, darkBad, Alignment.MID, opad);
            } else {
                tooltip.addSectionHeading("S-mod penalty", bad, darkBad, Alignment.MID, opad);
            }
        }
        if (this.hasSModEffect()) {
            if (isForBuildInList) {
                tooltip.addSpacer(-5.0f);
            }
            this.addSModEffectSection(tooltip, hullSize, ship, width, isForModSpec, false);
            if (!sMod && !isForBuildInList) {
                boolean builtIn = this.isBuiltIn(ship);
                if (builtIn) {
                    tooltip.addPara("This effect only applies if this built-in hullmod is enhanced using a %s. Doing this does not count against the maximum number of s-mods a ship can have.", opad, s, "story point");
                } else {
                    String cheap = "Cheap hullmods have stronger effects.";
                    if (Global.CODEX_TOOLTIP_MODE) {
                        cheap = "Cheaper hullmods have stronger effects, more expensive hullmods may have penalties.";
                    }
                    tooltip.addPara("This effect only applies if this hullmod is built into the hull using a story point. " + cheap, opad, s, "story point");
                }
            }
        } else if (!sMod) {
            tooltip.addPara("Aside from removing its ordnance point cost, this hullmod gains no extra effect from being built into the hull using a story point.", opad, s, "story point");
        }
        if ((!sMod || this.hasSModEffect()) && isForModSpec) {
            tooltip.addSpacer(opad);
        }
    }

    @Override
    public void applyEffectsToFighterSpawnedByShip(ShipAPI fighter, ShipAPI ship, String id) {
    }

    public boolean shipHasOtherModInCategory(ShipAPI ship, String currMod, String category) {
        for (String id : ship.getVariant().getHullMods()) {
            HullModSpecAPI mod = Global.getSettings().getHullModSpec(id);
            if (!mod.hasTag(category) || id.equals(currMod)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPlayerFleet(MutableShipStatsAPI stats) {
        if (stats == null) {
            return false;
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    public boolean isInPlayerFleet(ShipAPI ship) {
        if (ship == null) {
            return false;
        }
        FleetMemberAPI member = ship.getFleetMember();
        if (member == null) {
            return false;
        }
        PersonAPI fc = member.getFleetCommanderForStats();
        if (fc == null) {
            fc = member.getFleetCommander();
        }
        if (fc == null) {
            return false;
        }
        return fc.isPlayer();
    }

    @Override
    public Color getBorderColor() {
        return null;
    }

    @Override
    public Color getNameColor() {
        return null;
    }

    @Override
    public int getDisplaySortOrder() {
        return 100;
    }

    @Override
    public int getDisplayCategoryIndex() {
        return -1;
    }

    @Override
    public float getTooltipWidth() {
        return 369.0f;
    }

    @Override
    public boolean showInRefitScreenModPickerFor(ShipAPI ship) {
        return true;
    }

    @Override
    public void addRequiredItemSection(TooltipMakerAPI tooltip, FleetMemberAPI member, ShipVariantAPI currentVariant, MarketAPI dockedAt, float width, boolean isForModSpec) {
        CargoStackAPI req = this.getRequiredItem();
        if (req != null) {
            float opad = 10.0f;
            if (isForModSpec || Global.CODEX_TOOLTIP_MODE) {
                Color color = Misc.getBasePlayerColor();
                if (isForModSpec) {
                    color = Misc.getHighlightColor();
                }
                String name = req.getDisplayName();
                String aOrAn = Misc.getAOrAnFor(name);
                tooltip.addPara("Requires " + aOrAn + " %s to install.", opad, color, name);
            } else if (currentVariant != null && member != null) {
                if (currentVariant.hasHullMod(this.spec.getId())) {
                    if (!currentVariant.getHullSpec().getBuiltInMods().contains(this.spec.getId())) {
                        Color color = Misc.getPositiveHighlightColor();
                        tooltip.addPara("Using item: " + req.getDisplayName(), color, opad);
                    }
                } else {
                    int available = HullModItemManager.getInstance().getNumAvailableMinusUnconfirmed(req, member, currentVariant, dockedAt);
                    Color color = Misc.getPositiveHighlightColor();
                    if (available < 1) {
                        color = Misc.getNegativeHighlightColor();
                    }
                    if (available < 0) {
                        available = 0;
                    }
                    tooltip.addPara("Requires item: " + req.getDisplayName() + " (" + available + " available)", color, opad);
                }
            }
        }
    }
}

