/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat.listeners;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.combat.listeners.DamageListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.combat.listeners.FighterOPCostModifier;
import com.fs.starfarer.api.combat.listeners.FleetMemberDeploymentListener;
import com.fs.starfarer.api.combat.listeners.HullDamageAboutToBeTakenListener;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.combat.listeners.WeaponOPCostModifier;
import com.fs.starfarer.api.combat.listeners.WeaponRangeModifier;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class CombatListenerUtil {
    public static List<String> modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        return CombatListenerUtil.modifyDamageDealt(Global.getCombatEngine().getListenerManager().getListeners(DamageDealtModifier.class), param, target, damage, point, shieldHit);
    }

    public static List<String> modifyDamageDealt(ShipAPI attacker, Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        if (attacker == null || attacker.getListenerManager() == null) {
            return null;
        }
        return CombatListenerUtil.modifyDamageDealt(attacker.getListeners(DamageDealtModifier.class), param, target, damage, point, shieldHit);
    }

    protected static List<String> modifyDamageDealt(List<DamageDealtModifier> mods, Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        ArrayList<String> ids = null;
        mods = new ArrayList<DamageDealtModifier>(mods);
        for (DamageDealtModifier x : mods) {
            String id = x.modifyDamageDealt(param, target, damage, point, shieldHit);
            if (id == null) continue;
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            ids.add(id);
        }
        return ids;
    }

    public static List<String> modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        return CombatListenerUtil.modifyDamageTaken(Global.getCombatEngine().getListenerManager().getListeners(DamageTakenModifier.class), param, target, damage, point, shieldHit);
    }

    public static List<String> modifyDamageTaken(ShipAPI ship, Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        if (ship == null || ship.getListenerManager() == null) {
            return null;
        }
        return CombatListenerUtil.modifyDamageTaken(ship.getListeners(DamageTakenModifier.class), param, target, damage, point, shieldHit);
    }

    protected static List<String> modifyDamageTaken(List<DamageTakenModifier> mods, Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        ArrayList<String> ids = null;
        mods = new ArrayList<DamageTakenModifier>(mods);
        for (DamageTakenModifier x : mods) {
            String id = x.modifyDamageTaken(param, target, damage, point, shieldHit);
            if (id == null) continue;
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            ids.add(id);
        }
        return ids;
    }

    public static void reportDamageApplied(ShipAPI ship, Object source, CombatEntityAPI target, ApplyDamageResultAPI result) {
        for (DamageListener x : new ArrayList<DamageListener>(Global.getCombatEngine().getListenerManager().getListeners(DamageListener.class))) {
            x.reportDamageApplied(source, target, result);
        }
        if (ship != null) {
            for (DamageListener x : new ArrayList<DamageListener>(ship.getListeners(DamageListener.class))) {
                x.reportDamageApplied(source, target, result);
            }
        }
    }

    public static boolean notifyAboutToTakeHullDamage(ShipAPI ship, Object source, Vector2f point, float damageAmount) {
        boolean result = false;
        for (HullDamageAboutToBeTakenListener x : new ArrayList<HullDamageAboutToBeTakenListener>(Global.getCombatEngine().getListenerManager().getListeners(HullDamageAboutToBeTakenListener.class))) {
            result |= x.notifyAboutToTakeHullDamage(source, ship, point, damageAmount);
        }
        for (HullDamageAboutToBeTakenListener x : new ArrayList<HullDamageAboutToBeTakenListener>(ship.getListeners(HullDamageAboutToBeTakenListener.class))) {
            result |= x.notifyAboutToTakeHullDamage(source, ship, point, damageAmount);
        }
        return result;
    }

    public static float getWeaponRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 0.0f;
        if (ship != null) {
            for (WeaponRangeModifier x : new ArrayList<WeaponRangeModifier>(ship.getListeners(WeaponRangeModifier.class))) {
                mod += x.getWeaponRangePercentMod(ship, weapon);
            }
        }
        return mod;
    }

    public static float getWeaponRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 1.0f;
        if (ship != null && ship.getListenerManager() != null) {
            for (WeaponRangeModifier x : new ArrayList<WeaponRangeModifier>(ship.getListeners(WeaponRangeModifier.class))) {
                mod *= x.getWeaponRangeMultMod(ship, weapon);
            }
        }
        return mod;
    }

    public static float getWeaponRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 0.0f;
        if (ship != null && ship.getListenerManager() != null) {
            for (WeaponRangeModifier x : new ArrayList<WeaponRangeModifier>(ship.getListeners(WeaponRangeModifier.class))) {
                mod += x.getWeaponRangeFlatMod(ship, weapon);
            }
        }
        return mod;
    }

    public static float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 0.0f;
        if (ship != null) {
            for (WeaponBaseRangeModifier x : new ArrayList<WeaponBaseRangeModifier>(ship.getListeners(WeaponBaseRangeModifier.class))) {
                mod += x.getWeaponBaseRangePercentMod(ship, weapon);
            }
        }
        return mod;
    }

    public static float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 1.0f;
        if (ship != null && ship.getListenerManager() != null) {
            for (WeaponBaseRangeModifier x : new ArrayList<WeaponBaseRangeModifier>(ship.getListeners(WeaponBaseRangeModifier.class))) {
                mod *= x.getWeaponBaseRangeMultMod(ship, weapon);
            }
        }
        return mod;
    }

    public static float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
        float mod = 0.0f;
        if (ship != null && ship.getListenerManager() != null) {
            for (WeaponBaseRangeModifier x : new ArrayList<WeaponBaseRangeModifier>(ship.getListeners(WeaponBaseRangeModifier.class))) {
                mod += x.getWeaponBaseRangeFlatMod(ship, weapon);
            }
        }
        return mod;
    }

    public static int getWeaponOPCost(MutableShipStatsAPI stats, WeaponSpecAPI weapon, int currCost) {
        int cost = currCost;
        if (stats != null && stats.getListenerManager() != null) {
            for (WeaponOPCostModifier x : new ArrayList<WeaponOPCostModifier>(stats.getListeners(WeaponOPCostModifier.class))) {
                cost = x.getWeaponOPCost(stats, weapon, cost);
            }
        }
        return cost;
    }

    public static int getFighterOPCost(MutableShipStatsAPI stats, FighterWingSpecAPI fighter, int currCost) {
        int cost = currCost;
        if (stats != null && stats.getListenerManager() != null) {
            for (FighterOPCostModifier x : new ArrayList<FighterOPCostModifier>(stats.getListeners(FighterOPCostModifier.class))) {
                cost = x.getFighterOPCost(stats, fighter, cost);
            }
        }
        return cost;
    }

    public static void reportFleetMemberDeployed(DeployedFleetMemberAPI member) {
        for (FleetMemberDeploymentListener x : Global.getCombatEngine().getListenerManager().getListeners(FleetMemberDeploymentListener.class)) {
            x.reportFleetMemberDeployed(member);
        }
    }
}

