/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseSharedJSONFile {
    protected JSONObject json = new JSONObject();
    protected Map<String, Set<String>> setCache = new HashMap<String, Set<String>>();

    protected abstract String getFilename();

    public void loadIfNeeded() {
        try {
            if (Global.getSettings().fileExistsInCommon(this.getFilename())) {
                this.json = Global.getSettings().readJSONFromCommon(this.getFilename(), true);
            }
        }
        catch (IOException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void saveIfNeeded() {
        try {
            Global.getSettings().writeJSONToCommon(this.getFilename(), this.json, true);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Set<String> getSet(String key) {
        if (this.setCache.containsKey(key)) {
            return this.setCache.get(key);
        }
        JSONArray arr = this.json.optJSONArray(key);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (arr != null) {
            int i = 0;
            while (i < arr.length()) {
                String curr = arr.optString(i);
                if (curr != null) {
                    set.add(curr);
                }
                ++i;
            }
        }
        this.setCache.put(key, set);
        return set;
    }

    public boolean doesSetContain(String key, String value) {
        Set<String> set = this.getSet(key);
        return set.contains(value);
    }

    public boolean addToSet(String key, String value) {
        Set<String> set = this.getSet(key);
        if (set.contains(value)) {
            return false;
        }
        set.add(value);
        this.setCache.put(key, set);
        JSONArray arr = new JSONArray();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(set);
        Collections.sort(list);
        for (String curr : list) {
            arr.put((Object)curr);
        }
        try {
            this.json.put(key, (Object)arr);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        return this.json.optBoolean(key, defaultValue);
    }

    public void setBoolean(String key, boolean value) {
        try {
            this.json.put(key, value);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public float optFloat(String key, float defaultValue) {
        return (float)this.json.optDouble(key, (double)defaultValue);
    }

    public void setFloat(String key, float value) {
        try {
            this.json.put(key, (double)value);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int optInt(String key, int defaultValue) {
        return this.json.optInt(key, defaultValue);
    }

    public void setInt(String key, int value) {
        try {
            this.json.put(key, value);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String optString(String key, String defaultValue) {
        return this.json.optString(key, defaultValue);
    }

    public void setString(String key, String value) {
        try {
            this.json.put(key, (Object)value);
        }
        catch (JSONException e) {
            Global.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unset(String key) {
        this.json.remove(key);
    }
}

