/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GenericFieldItemManager;
import com.fs.starfarer.api.util.Misc;

public class CargoPodsEntityPlugin
extends BaseCustomEntityPlugin {
    protected transient GenericFieldItemManager manager;
    protected float elapsed = 0.0f;
    protected float maxDays = 1.0f;
    protected float extraDays = 0.0f;
    protected Boolean neverExpire = null;

    public static float computeDetectionRange(float radius) {
        float range = 500.0f + radius * 20.0f;
        if (range > 2000.0f) {
            range = 2000.0f;
        }
        return range;
    }

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(0.5f));
        this.readResolve();
    }

    Object readResolve() {
        this.manager = new GenericFieldItemManager(this.entity);
        this.manager.category = "misc";
        this.manager.key = "cargoPods";
        this.manager.cellSize = 32;
        this.manager.minSize = 10.0f;
        this.manager.maxSize = 10.0f;
        return this;
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        float depth = Misc.getAbyssalDepth(this.entity);
        if (depth >= 1.0f) {
            days *= 5.0f;
        }
        this.elapsed += days;
        if (!this.isNeverExpire().booleanValue() && this.elapsed >= this.maxDays + this.extraDays && this.maxDays >= 0.0f) {
            boolean playerCanSee;
            SectorEntityToken.VisibilityLevel vis = this.entity.getVisibilityLevelToPlayerFleet();
            boolean bl = playerCanSee = this.entity.isInCurrentLocation() && (vis == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS);
            if (!playerCanSee) {
                this.maxDays = -1.0f;
                Misc.fadeAndExpire(this.entity);
                this.neverExpire = true;
            }
        }
        if (this.entity.isInCurrentLocation()) {
            this.updateBaseMaxDays();
            float radius = 10.0f + 10.0f * (float)Math.sqrt(this.manager.numPieces);
            float range = CargoPodsEntityPlugin.computeDetectionRange(radius);
            this.entity.getDetectedRangeMod().modifyFlat("gen", range);
        }
        this.manager.advance(amount);
    }

    public void updateBaseMaxDays() {
        boolean cryo;
        if (this.entity == null || this.entity.getCargo() == null) {
            return;
        }
        float totalCapacity = this.entity.getCargo().getSpaceUsed() + this.entity.getCargo().getFuel() + (float)this.entity.getCargo().getTotalPersonnel();
        int minPieces = 5;
        int numPieces = (int)(Math.sqrt(totalCapacity) / 1.0);
        if (numPieces < minPieces) {
            numPieces = minPieces;
        }
        if (numPieces > 40) {
            numPieces = 40;
        }
        boolean bl = cryo = (float)this.entity.getCargo().getTotalPersonnel() > this.entity.getCargo().getSpaceUsed() + this.entity.getCargo().getFuel();
        if (cryo) {
            this.entity.setCustomDescriptionId("cryopods");
            this.entity.setName("Cryo Pods");
        } else {
            this.entity.setCustomDescriptionId("cargo_pods");
            this.entity.setName("Cargo Pods");
        }
        this.manager.numPieces = numPieces;
        float radius = 10.0f + 10.0f * (float)Math.sqrt(this.manager.numPieces - (minPieces - 1));
        ((CustomCampaignEntityAPI)this.entity).setRadius(radius);
        this.maxDays = 5.0f + (float)(numPieces - minPieces);
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 100.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.manager.render(layer, viewport);
    }

    public void setNeverExpire(Boolean neverExpire) {
        this.neverExpire = neverExpire;
    }

    public Boolean isNeverExpire() {
        if (this.neverExpire != null && this.neverExpire.booleanValue()) {
            return true;
        }
        return false;
    }

    public float getDaysLeft() {
        return this.maxDays + this.extraDays - this.elapsed;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(float elapsed) {
        this.elapsed = elapsed;
    }

    public float getExtraDays() {
        return this.extraDays;
    }

    public void setExtraDays(float extraDays) {
        this.extraDays = extraDays;
    }
}

