/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.GenericPluginManagerAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.AssignmentModulePlugin;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.ai.StrategicModulePlugin;
import com.fs.starfarer.api.campaign.ai.TacticalModulePlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.listeners.CoreDiscoverEntityPlugin;
import com.fs.starfarer.api.campaign.listeners.ListenerManagerAPI;
import com.fs.starfarer.api.campaign.listeners.TestIndustryOptionProvider;
import com.fs.starfarer.api.characters.AdminData;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillsChangeOfficerEffect;
import com.fs.starfarer.api.characters.SkillsChangeRemoveExcessOPEffect;
import com.fs.starfarer.api.characters.SkillsChangeRemoveSmodsEffect;
import com.fs.starfarer.api.characters.SkillsChangeRemoveVentsCapsEffect;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.PlayerFleetPersonnelTracker;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.AbandonMarketPluginImpl;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.BaseGenericPlugin;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.CargoPodsResponse;
import com.fs.starfarer.api.impl.campaign.CommRelayEntityPlugin;
import com.fs.starfarer.api.impl.campaign.CoreCampaignPluginImpl;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.CoreRuleTokenReplacementGeneratorImpl;
import com.fs.starfarer.api.impl.campaign.CoreScript;
import com.fs.starfarer.api.impl.campaign.CoronalTapParticleScript;
import com.fs.starfarer.api.impl.campaign.CryosleeperEntityPlugin;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.impl.campaign.HasslePlayerScript;
import com.fs.starfarer.api.impl.campaign.HullModItemManager;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.MonthlyReportNodeTooltipCreator;
import com.fs.starfarer.api.impl.campaign.NavBuoyEntityPlugin;
import com.fs.starfarer.api.impl.campaign.SensorArrayEntityPlugin;
import com.fs.starfarer.api.impl.campaign.SmugglingScanScript;
import com.fs.starfarer.api.impl.campaign.StabilizeMarketPluginImpl;
import com.fs.starfarer.api.impl.campaign.TowCable;
import com.fs.starfarer.api.impl.campaign.WarningBeaconEntityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseAbilityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallAbility;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallResponseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.abilities.DistressCallResponsePirateAssignmentAI;
import com.fs.starfarer.api.impl.campaign.abilities.EmergencyBurnAbility;
import com.fs.starfarer.api.impl.campaign.abilities.FractureJumpAbility;
import com.fs.starfarer.api.impl.campaign.abilities.GoDarkAbility;
import com.fs.starfarer.api.impl.campaign.abilities.GraviticScanAbility;
import com.fs.starfarer.api.impl.campaign.abilities.GraviticScanData;
import com.fs.starfarer.api.impl.campaign.abilities.InterdictionPulseAbility;
import com.fs.starfarer.api.impl.campaign.abilities.RemoteSurveyAbility;
import com.fs.starfarer.api.impl.campaign.abilities.ScavengeAbility;
import com.fs.starfarer.api.impl.campaign.abilities.SensorBurstAbility;
import com.fs.starfarer.api.impl.campaign.abilities.SustainedBurnAbility;
import com.fs.starfarer.api.impl.campaign.abilities.TransponderAbility;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.EmergencyBurnAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.GoDarkAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.InterdictionPulseAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.SensorBurstAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.SustainedBurnAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.TransponderAbilityAI;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.AbandonedStation;
import com.fs.starfarer.api.impl.campaign.econ.BaseHazardCondition;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.econ.CottageIndustry;
import com.fs.starfarer.api.impl.campaign.econ.Decivilized;
import com.fs.starfarer.api.impl.campaign.econ.Dissident;
import com.fs.starfarer.api.impl.campaign.econ.FoodShortage;
import com.fs.starfarer.api.impl.campaign.econ.FreeMarket;
import com.fs.starfarer.api.impl.campaign.econ.Frontier;
import com.fs.starfarer.api.impl.campaign.econ.Headquarters;
import com.fs.starfarer.api.impl.campaign.econ.Hydroponics;
import com.fs.starfarer.api.impl.campaign.econ.LargeRefugeePopulation;
import com.fs.starfarer.api.impl.campaign.econ.LuddicMajority;
import com.fs.starfarer.api.impl.campaign.econ.OrbitalBurns;
import com.fs.starfarer.api.impl.campaign.econ.OrganizedCrime;
import com.fs.starfarer.api.impl.campaign.econ.Outpost;
import com.fs.starfarer.api.impl.campaign.econ.Population;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.econ.RegionalCapital;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.RuralPolity;
import com.fs.starfarer.api.impl.campaign.econ.ShipbreakingCenter;
import com.fs.starfarer.api.impl.campaign.econ.ShippingDisruption;
import com.fs.starfarer.api.impl.campaign.econ.Smuggling;
import com.fs.starfarer.api.impl.campaign.econ.StealthMinefields;
import com.fs.starfarer.api.impl.campaign.econ.SystemBounty;
import com.fs.starfarer.api.impl.campaign.econ.TradeDisruption;
import com.fs.starfarer.api.impl.campaign.econ.UrbanizedPolity;
import com.fs.starfarer.api.impl.campaign.econ.ViceDemand;
import com.fs.starfarer.api.impl.campaign.econ.WorldArid;
import com.fs.starfarer.api.impl.campaign.econ.WorldBarrenMarginal;
import com.fs.starfarer.api.impl.campaign.econ.WorldDesert;
import com.fs.starfarer.api.impl.campaign.econ.WorldIce;
import com.fs.starfarer.api.impl.campaign.econ.WorldJungle;
import com.fs.starfarer.api.impl.campaign.econ.WorldTerran;
import com.fs.starfarer.api.impl.campaign.econ.WorldTundra;
import com.fs.starfarer.api.impl.campaign.econ.WorldTwilight;
import com.fs.starfarer.api.impl.campaign.econ.WorldUninhabitable;
import com.fs.starfarer.api.impl.campaign.econ.WorldWater;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.Cryorevival;
import com.fs.starfarer.api.impl.campaign.econ.impl.Cryosanctum;
import com.fs.starfarer.api.impl.campaign.econ.impl.Farming;
import com.fs.starfarer.api.impl.campaign.econ.impl.FuelProduction;
import com.fs.starfarer.api.impl.campaign.econ.impl.GroundDefenses;
import com.fs.starfarer.api.impl.campaign.econ.impl.HeavyIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.LightIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.LionsGuardHQ;
import com.fs.starfarer.api.impl.campaign.econ.impl.MilitaryBase;
import com.fs.starfarer.api.impl.campaign.econ.impl.Mining;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.econ.impl.PlanetaryShield;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.impl.campaign.econ.impl.Refining;
import com.fs.starfarer.api.impl.campaign.econ.impl.ShipQuality;
import com.fs.starfarer.api.impl.campaign.econ.impl.Spaceport;
import com.fs.starfarer.api.impl.campaign.econ.impl.TechMining;
import com.fs.starfarer.api.impl.campaign.econ.impl.TradeCenter;
import com.fs.starfarer.api.impl.campaign.econ.impl.Waystation;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.StrandedGiveTJScript;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.CoreEventProbabilityManager;
import com.fs.starfarer.api.impl.campaign.events.FactionHostilityEvent;
import com.fs.starfarer.api.impl.campaign.events.FoodShortageEvent;
import com.fs.starfarer.api.impl.campaign.events.InvestigationEventGoodRepWithOther;
import com.fs.starfarer.api.impl.campaign.events.InvestigationEventSmugglingV2;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.events.PriceUpdate;
import com.fs.starfarer.api.impl.campaign.events.RecentUnrestEvent;
import com.fs.starfarer.api.impl.campaign.events.RepTrackerEvent;
import com.fs.starfarer.api.impl.campaign.events.TradeInfoUpdateEvent;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallNormalAssignmentAI;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallPirateAmbushAssignmentAI;
import com.fs.starfarer.api.impl.campaign.events.nearby.DistressCallPirateAmbushTrapAssignmentAI;
import com.fs.starfarer.api.impl.campaign.events.nearby.NearbyEventsEvent;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.BaseRouteFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.CustomFleets;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableAggroAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableLuddicPathFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.DisposablePirateFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.MercAssignmentAIV2;
import com.fs.starfarer.api.impl.campaign.fleets.MercFleetManagerV2;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAIV4;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManagerV2;
import com.fs.starfarer.api.impl.campaign.fleets.PersonalFleetHoracioCaden;
import com.fs.starfarer.api.impl.campaign.fleets.PersonalFleetOxanaHyder;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.SDFHegemony;
import com.fs.starfarer.api.impl.campaign.fleets.SDFLeague;
import com.fs.starfarer.api.impl.campaign.fleets.SDFLuddicChurch;
import com.fs.starfarer.api.impl.campaign.fleets.SDFTriTachyon;
import com.fs.starfarer.api.impl.campaign.fleets.SeededFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.SourceBasedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.graid.StandardGroundRaidObjectivesCreator;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.AnalyzeEntityIntelCreator;
import com.fs.starfarer.api.impl.campaign.intel.AnalyzeEntityMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.FactionCommissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.FactionHostilityIntel;
import com.fs.starfarer.api.impl.campaign.intel.FactionHostilityManager;
import com.fs.starfarer.api.impl.campaign.intel.GenericMissionManager;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.ProcurementMissionCreator;
import com.fs.starfarer.api.impl.campaign.intel.ProcurementMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.SurveyPlanetIntelCreator;
import com.fs.starfarer.api.impl.campaign.intel.SurveyPlanetMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.CorruptPLClerkSuppliesBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.CorruptPLClerkSuppliesBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryFailureConsequences;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DiktatLobsterBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DiktatLobsterBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicCraftBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicCraftBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicFarmerBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicFarmerBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.LuddicPathBaseBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.MercsOnTheRunBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.MercsOnTheRunBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PirateBaseRumorBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PlanetaryShieldBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.QuartermasterCargoSwapBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.QuartermasterCargoSwapBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.ScientistAICoreBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.ScientistAICoreBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.ScientistAICoreIntel;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.SpecBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachLoanIncentiveScript;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachMajorLoanBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.TriTachMajorLoanBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.DonationOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.FighterBlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianBarEventCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.ShipBlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.SpecialItemOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.WeaponBlueprintOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.WeaponBlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCells;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivity;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivityIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PlayerRelatedPirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivIntel;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivTracker;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.CommerceBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.events.DisposableHostileActivityFleetManager;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityManager;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTFactorTracker;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionManager;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntelV2;
import com.fs.starfarer.api.impl.campaign.intel.misc.CargoPodsIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.CommSnifferIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.CryosleeperIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.DistressCallIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.GateIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.HypershuntIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.LuddicShrineIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.ProductionReportIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.RemnantNexusIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.SalvorsTallyIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.SimUpdateIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.TradeFleetDepartureIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.WarningBeaconIntel;
import com.fs.starfarer.api.impl.campaign.intel.misc.WormholeIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.academy.GAAtTheGates;
import com.fs.starfarer.api.impl.campaign.missions.academy.GATransverseJump;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBounty;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseMissionHub;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionBarEventWrapper;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionTrigger;
import com.fs.starfarer.api.impl.campaign.missions.hub.TriggerFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.plog.OfficerSkillGainRecord;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCargo;
import com.fs.starfarer.api.impl.campaign.plog.PLStatColonies;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCredits;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCrew;
import com.fs.starfarer.api.impl.campaign.plog.PLStatFleet;
import com.fs.starfarer.api.impl.campaign.plog.PLStatFuel;
import com.fs.starfarer.api.impl.campaign.plog.PLStatLevel;
import com.fs.starfarer.api.impl.campaign.plog.PLStatMarines;
import com.fs.starfarer.api.impl.campaign.plog.PLStatSupplies;
import com.fs.starfarer.api.impl.campaign.plog.PLTextEntry;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.plog.SModRecord;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.SectorProcGen;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.OmegaOfficerGeneratorPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.PKDefenderPluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantOfficerGeneratorPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantStationFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RuinsFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ScavengerFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageGenFromSeed;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BlueprintSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.CargoManifestSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.DomainSurveyDerelictSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.SleeperPodsSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.SurveyDataSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TopographicDataSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.impl.campaign.shared.CommodityStatTracker;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeProfitabilityData;
import com.fs.starfarer.api.impl.campaign.shared.ReputationChangeTracker;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.skills.FieldRepairsScript;
import com.fs.starfarer.api.impl.campaign.submarkets.BlackMarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.LocalResourcesSubmarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.OpenMarketPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidBeltTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidImpact;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidSource;
import com.fs.starfarer.api.impl.campaign.terrain.AuroraRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.CRLossPerSecondBuff;
import com.fs.starfarer.api.impl.campaign.terrain.CRRecoveryBuff;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.EventHorizonPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.FlareManager;
import com.fs.starfarer.api.impl.campaign.terrain.HyperStormBoost;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MaxBurnBuff;
import com.fs.starfarer.api.impl.campaign.terrain.NebulaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.PeakPerformanceBuff;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.RadioChatterTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaAkaMainyuTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.CampaignTutorialScript;
import com.fs.starfarer.api.impl.campaign.tutorial.GalatiaMarketScript;
import com.fs.starfarer.api.impl.campaign.tutorial.GalatianAcademyStipend;
import com.fs.starfarer.api.impl.campaign.tutorial.RogueMinerMiscFleetManager;
import com.fs.starfarer.api.impl.campaign.tutorial.SaveNagScript;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLeashAssignmentAI;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionEvent;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.impl.campaign.velfield.BoundingBox;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamManager;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamVisibilityManager;
import com.fs.starfarer.api.impl.campaign.world.GateHaulerLocation;
import com.fs.starfarer.api.impl.campaign.world.Limbo;
import com.fs.starfarer.api.impl.campaign.world.NamelessRock;
import com.fs.starfarer.api.impl.campaign.world.TTBlackSite;
import com.fs.starfarer.api.impl.campaign.world.ZigLeashAssignmentAI;
import com.fs.starfarer.api.impl.codex.CodexUnlocker;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedEjectaAI;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedVortexAI;
import com.fs.starfarer.api.impl.combat.threat.DisposableThreatFleetManager;
import com.fs.starfarer.api.impl.combat.threat.ThreatSwarmAI;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.api.plugins.impl.CoreBuildObjectiveTypePicker;
import com.fs.starfarer.api.util.DelayedActionScript;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.FlickerUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RollingAverageTracker;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CoreLifecyclePluginImpl
extends BaseModPlugin {
    protected Map<SectorEntityToken, LocationAPI> asteroidList = new HashMap<SectorEntityToken, LocationAPI>();
    protected Map<SectorEntityToken, LocationAPI> junkList = new HashMap<SectorEntityToken, LocationAPI>();

    @Override
    public void onGameLoad(boolean newGame) {
        CoreLifecyclePluginImpl.econPostSaveRestore();
        StarSystemAPI limbo = Global.getSector().getStarSystem("Limbo");
        if (limbo == null || !limbo.hasTag("system_abyssal")) {
            new Limbo().generate(Global.getSector());
            new GateHaulerLocation().generate(Global.getSector());
            SectorProcGen.clearAbyssalHyperspaceAndSetSystemTags();
        }
        if (Global.getSector().getStarSystem("nameless_rock_location") == null) {
            new NamelessRock().generate(Global.getSector());
        }
        Global.getSector().getRules().addTokenReplacementGenerator(new CoreRuleTokenReplacementGeneratorImpl());
        if (!newGame) {
            this.addJunk();
            this.regenAsteroids();
        }
        this.addScriptsIfNeeded();
        CoreLifecyclePluginImpl.verifyFactionData();
        this.convertTo0951aSkillSystemIfNeeded();
        CoreLifecyclePluginImpl.addMissingPeople();
    }

    public static void addMissingPeople() {
        if (People.getPerson(People.REYNARD_HANNAN) == null) {
            People.addReynardHannan();
        }
    }

    public static void verifyFactionData() {
        for (FactionAPI faction : Global.getSector().getAllFactions()) {
            CoreLifecyclePluginImpl.verifyFactionData(faction);
        }
    }

    public static void verifyFactionData(FactionAPI faction) {
        for (String id : faction.getKnownShips()) {
            if (Global.getSettings().getHullSpec(id) != null) continue;
            throw new RuntimeException("Hull with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : faction.getKnownHullMods()) {
            if (Global.getSettings().getHullModSpec(id) != null) continue;
            throw new RuntimeException("Hullmod with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : faction.getKnownIndustries()) {
            if (Global.getSettings().getIndustrySpec(id) != null) continue;
            throw new RuntimeException("Industry with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : faction.getKnownFighters()) {
            if (Global.getSettings().getFighterWingSpec(id) != null) continue;
            throw new RuntimeException("Fighter wing with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : faction.getKnownWeapons()) {
            if (Global.getSettings().getWeaponSpec(id) != null) continue;
            throw new RuntimeException("Weapon with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : new ArrayList<String>(faction.getDoctrine().getCommanderSkills())) {
            if (Global.getSettings().getSkillSpec(id) != null) continue;
            if (id.equals("fighter_doctrine")) {
                faction.getDoctrine().getCommanderSkills().remove(id);
                continue;
            }
            throw new RuntimeException("Commander skill with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
        for (String id : new ArrayList<String>(faction.getDoctrine().getOfficerSkills())) {
            if (Global.getSettings().getSkillSpec(id) != null) continue;
            throw new RuntimeException("Officer skill with id [" + id + "] not found for faction [" + faction.getId() + "]");
        }
    }

    protected void addScriptsIfNeeded() {
        GenericMissionManager manager;
        GenericPluginManagerAPI plugins;
        ShipQuality.getInstance();
        SectorAPI sector = Global.getSector();
        ListenerManagerAPI listeners = sector.getListenerManager();
        if (Global.getSettings().isDevMode()) {
            listeners.addListener(new TestIndustryOptionProvider(), true);
        }
        if (!listeners.hasListenerOfClass(StandardGroundRaidObjectivesCreator.class)) {
            listeners.addListener(new StandardGroundRaidObjectivesCreator(), true);
        }
        if (!listeners.hasListenerOfClass(Cryorevival.CryosleeperFactor.class)) {
            listeners.addListener(new Cryorevival.CryosleeperFactor(), true);
        }
        if (!listeners.hasListenerOfClass(PopulationAndInfrastructure.CoronalTapFactor.class)) {
            listeners.addListener(new PopulationAndInfrastructure.CoronalTapFactor(), true);
        }
        if (!listeners.hasListenerOfClass(SlipstreamVisibilityManager.class)) {
            listeners.addListener(new SlipstreamVisibilityManager(), true);
        }
        if (!listeners.hasListenerOfClass(CodexUnlocker.class)) {
            listeners.addListener(new CodexUnlocker(), true);
        }
        if (!(plugins = sector.getGenericPlugins()).hasPlugin(PKDefenderPluginImpl.class)) {
            plugins.addPlugin(new PKDefenderPluginImpl(), true);
        }
        if (!plugins.hasPlugin(SalvageGenFromSeed.SalvageDefenderModificationPluginImpl.class)) {
            plugins.addPlugin(new SalvageGenFromSeed.SalvageDefenderModificationPluginImpl(), true);
        }
        CoreDiscoverEntityPlugin discoverPlugin = null;
        if (!plugins.hasPlugin(CoreDiscoverEntityPlugin.class)) {
            discoverPlugin = new CoreDiscoverEntityPlugin();
            plugins.addPlugin(discoverPlugin, true);
        } else {
            discoverPlugin = (CoreDiscoverEntityPlugin)plugins.getPluginsOfClass(CoreDiscoverEntityPlugin.class).get(0);
        }
        if (!listeners.hasListenerOfClass(CoreDiscoverEntityPlugin.class)) {
            listeners.addListener(discoverPlugin, true);
        }
        if (!plugins.hasPlugin(CoreBuildObjectiveTypePicker.class)) {
            plugins.addPlugin(new CoreBuildObjectiveTypePicker(), true);
        }
        if (!plugins.hasPlugin(AbandonMarketPluginImpl.class)) {
            plugins.addPlugin(new AbandonMarketPluginImpl(), true);
        }
        if (!plugins.hasPlugin(StabilizeMarketPluginImpl.class)) {
            plugins.addPlugin(new StabilizeMarketPluginImpl(), true);
        }
        if (!plugins.hasPlugin(RemnantOfficerGeneratorPlugin.class)) {
            plugins.addPlugin(new RemnantOfficerGeneratorPlugin(), true);
        }
        if (!plugins.hasPlugin(OmegaOfficerGeneratorPlugin.class)) {
            plugins.addPlugin(new OmegaOfficerGeneratorPlugin(), true);
        }
        PlayerFleetPersonnelTracker.getInstance();
        HullModItemManager.getInstance();
        if (!sector.hasScript(StrandedGiveTJScript.class)) {
            sector.addScript(new StrandedGiveTJScript());
        }
        if (!sector.hasScript(PersonalFleetHoracioCaden.class)) {
            sector.addScript(new PersonalFleetHoracioCaden());
        }
        if (!sector.hasScript(PersonalFleetOxanaHyder.class)) {
            sector.addScript(new PersonalFleetOxanaHyder());
        }
        if (!sector.hasScript(SDFHegemony.class)) {
            sector.addScript(new SDFHegemony());
        }
        if (!sector.hasScript(SDFLeague.class)) {
            sector.addScript(new SDFLeague());
        }
        if (!sector.hasScript(SDFTriTachyon.class)) {
            sector.addScript(new SDFTriTachyon());
        }
        if (!sector.hasScript(SDFLuddicChurch.class)) {
            sector.addScript(new SDFLuddicChurch());
        }
        if (!sector.hasScript(MiscFleetRouteManager.class)) {
            sector.addScript(new MiscFleetRouteManager());
        }
        if (!sector.hasScript(EncounterManager.class)) {
            sector.addScript(new EncounterManager());
        }
        if (!sector.hasScript(SlipstreamManager.class)) {
            sector.addScript(new SlipstreamManager());
        }
        if (!sector.hasScript(SensorGhostManager.class)) {
            sector.addScript(new SensorGhostManager());
        }
        if (!sector.hasScript(OfficerManagerEvent.class)) {
            sector.addScript(new OfficerManagerEvent());
        }
        if (!sector.hasScript(FieldRepairsScript.class)) {
            sector.addScript(new FieldRepairsScript());
        }
        if (!sector.hasScript(WarSimScript.class)) {
            sector.addScript(new WarSimScript());
        }
        if (!sector.hasScript(PersonBountyManager.class)) {
            sector.addScript(new PersonBountyManager());
        }
        if (!sector.hasScript(SystemBountyManager.class)) {
            sector.addScript(new SystemBountyManager());
        }
        if (!sector.hasScript(PirateBaseManager.class)) {
            sector.addScript(new PirateBaseManager());
        }
        if (!sector.hasScript(PlayerRelatedPirateBaseManager.class)) {
            sector.addScript(new PlayerRelatedPirateBaseManager());
        }
        if (!sector.hasScript(LuddicPathBaseManager.class)) {
            sector.addScript(new LuddicPathBaseManager());
        }
        if (!sector.hasScript(PunitiveExpeditionManager.class)) {
            sector.addScript(new PunitiveExpeditionManager());
        }
        if (!sector.hasScript(DecivTracker.class)) {
            sector.addScript(new DecivTracker());
        }
        if (!sector.hasScript(DisposableHostileActivityFleetManager.class)) {
            sector.addScript(new DisposableHostileActivityFleetManager());
        }
        if (!sector.hasScript(DisposableThreatFleetManager.class)) {
            sector.addScript(new DisposableThreatFleetManager());
        }
        if (!sector.hasScript(HostileActivityManager.class)) {
            sector.addScript(new HostileActivityManager());
        }
        if (!sector.hasScript(HTFactorTracker.class)) {
            sector.addScript(new HTFactorTracker());
        }
        if (!sector.hasScript(CommerceBountyManager.class)) {
            sector.addScript(new CommerceBountyManager());
        }
        if (!sector.hasScript(FactionHostilityManager.class)) {
            sector.addScript(new FactionHostilityManager());
            FactionHostilityManager.getInstance().startHostilities("hegemony", "tritachyon");
            FactionHostilityManager.getInstance().startHostilities("hegemony", "persean");
            FactionHostilityManager.getInstance().startHostilities("tritachyon", "luddic_church");
        }
        if (!sector.hasScript(GenericMissionManager.class)) {
            sector.addScript(new GenericMissionManager());
        }
        if (!(manager = GenericMissionManager.getInstance()).hasMissionCreator(AnalyzeEntityIntelCreator.class)) {
            manager.addMissionCreator(new AnalyzeEntityIntelCreator());
        }
        if (!manager.hasMissionCreator(SurveyPlanetIntelCreator.class)) {
            manager.addMissionCreator(new SurveyPlanetIntelCreator());
        }
        this.addBarEvents();
        if (!sector.hasScript(SmugglingScanScript.class)) {
            sector.addScript(new SmugglingScanScript());
        }
        if (!sector.hasScript(HasslePlayerScript.class)) {
            sector.addScript(new HasslePlayerScript());
        }
        PlaythroughLog.getInstance();
        sector.getListenerManager().addListener(new SkillsChangeRemoveExcessOPEffect(), true);
        sector.getListenerManager().addListener(new SkillsChangeRemoveVentsCapsEffect(), true);
        sector.getListenerManager().addListener(new SkillsChangeRemoveSmodsEffect(), true);
        sector.getListenerManager().addListener(new SkillsChangeOfficerEffect(), true);
    }

    protected void addBarEvents() {
        BarEventManager bar;
        SectorAPI sector = Global.getSector();
        if (!sector.hasScript(PortsideBarData.class)) {
            sector.addScript(new PortsideBarData());
        }
        if (!sector.hasScript(BarEventManager.class)) {
            sector.addScript(new BarEventManager());
        }
        if (!(bar = BarEventManager.getInstance()).hasEventCreator(LuddicFarmerBarEventCreator.class)) {
            bar.addEventCreator(new LuddicFarmerBarEventCreator());
        }
        if (!bar.hasEventCreator(LuddicCraftBarEventCreator.class)) {
            bar.addEventCreator(new LuddicCraftBarEventCreator());
        }
        if (!bar.hasEventCreator(DiktatLobsterBarEventCreator.class)) {
            bar.addEventCreator(new DiktatLobsterBarEventCreator());
        }
        if (!bar.hasEventCreator(CorruptPLClerkSuppliesBarEventCreator.class)) {
            bar.addEventCreator(new CorruptPLClerkSuppliesBarEventCreator());
        }
        if (!bar.hasEventCreator(QuartermasterCargoSwapBarEventCreator.class)) {
            bar.addEventCreator(new QuartermasterCargoSwapBarEventCreator());
        }
        if (!bar.hasEventCreator(TriTachLoanBarEventCreator.class)) {
            bar.addEventCreator(new TriTachLoanBarEventCreator());
        }
        if (!bar.hasEventCreator(TriTachMajorLoanBarEventCreator.class)) {
            bar.addEventCreator(new TriTachMajorLoanBarEventCreator());
        }
        if (!bar.hasEventCreator(ScientistAICoreBarEventCreator.class)) {
            bar.addEventCreator(new ScientistAICoreBarEventCreator());
        }
        if (!bar.hasEventCreator(DeliveryBarEventCreator.class)) {
            bar.addEventCreator(new DeliveryBarEventCreator());
        }
        if (!bar.hasEventCreator(PlanetaryShieldBarEventCreator.class)) {
            bar.addEventCreator(new PlanetaryShieldBarEventCreator());
        }
        if (!bar.hasEventCreator(HistorianBarEventCreator.class)) {
            bar.addEventCreator(new HistorianBarEventCreator());
        }
    }

    @Override
    public void onNewGame() {
        this.junkList.clear();
        new TTBlackSite().generate(Global.getSector());
        new Limbo().generate(Global.getSector());
        new GateHaulerLocation().generate(Global.getSector());
    }

    @Override
    public void onNewGameAfterTimePass() {
        new NamelessRock().generate(Global.getSector());
        new CustomFleets().spawn();
        EveryFrameScript script = new AnalyzeEntityIntelCreator().createMissionIntel();
        if (script instanceof BaseIntelPlugin) {
            ((BaseIntelPlugin)script).setPostingLocation(null);
            GenericMissionManager.getInstance().addActive(script);
        }
        if ((script = new SurveyPlanetIntelCreator().createMissionIntel()) instanceof BaseIntelPlugin) {
            ((BaseIntelPlugin)script).setPostingLocation(null);
            GenericMissionManager.getInstance().addActive(script);
        }
        for (EveryFrameScript s : PersonBountyManager.getInstance().getActive()) {
            PersonBountyIntel intel = (PersonBountyIntel)s;
            intel.setElapsedDays(intel.getElapsedDays() * (float)Math.random() * 0.25f);
        }
        boolean first = true;
        for (EveryFrameScript s : SystemBountyManager.getInstance().getActive()) {
            SystemBountyIntel intel = (SystemBountyIntel)s;
            if (intel.getMarket().getId().equals("ancyra_market") || intel.getMarket().getId().equals("jangala")) {
                intel.setElapsedDays(intel.getElapsedDays() * (float)Math.random() * 0.25f);
                continue;
            }
            if (first) {
                first = false;
                intel.setElapsedDays(intel.getElapsedDays() * (float)Math.random() * 0.25f);
                continue;
            }
            intel.endImmediately();
        }
        MarketAPI jangala = Global.getSector().getEconomy().getMarket("jangala");
        if (jangala != null) {
            SystemBountyManager.getInstance().addOrResetBounty(jangala);
        }
    }

    @Override
    public void onNewGameAfterEconomyLoad() {
        this.addJunk();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getContainingLocation() == null || market.getPrimaryEntity() == null) continue;
            float radius = 300.0f + (float)market.getSize() * 200.0f;
            market.getContainingLocation().addRadioChatter(market.getPrimaryEntity(), radius);
        }
        MarketAPI umbra = Global.getSector().getEconomy().getMarket("umbra");
        if (umbra != null && umbra.hasIndustry("spaceport")) {
            umbra.getIndustry("spaceport").setImproved(true);
        }
        this.createInitialPeople();
        this.addScriptsIfNeeded();
        this.updateKnownPlanets();
        this.markStoryCriticalMarketsEtc();
        this.tagLuddicShrines();
    }

    public void markStoryCriticalMarketsEtc() {
        String id = "gaKA";
        Misc.makeStoryCritical("eochu_bres", id);
        Misc.makeStoryCritical("port_tse", id);
        Misc.makeStoryCritical("new_maxios", id);
        Misc.makeStoryCritical("coatl", id);
        id = "gaFC";
        Misc.makeStoryCritical("laicaille_habitat", id);
        Misc.makeStoryCritical("eochu_bres", id);
        Misc.makeStoryCritical("fikenhild", id);
        Misc.makeStoryCritical("station_kapteyn", id);
        id = "gaPZ";
        Misc.makeStoryCritical("culann", id);
        Misc.makeStoryCritical("donn", id);
        Misc.makeStoryCritical("agreus", id);
        Misc.makeStoryCritical("eochu_bres", id);
        Misc.makeStoryCritical("port_tse", id);
        id = "gaATG";
        Misc.makeStoryCritical("kazeron", id);
        Misc.makeStoryCritical("chicomoztoc", id);
        Misc.makeStoryCritical("epiphany", id);
        Misc.makeStoryCritical("fikenhild", id);
        Misc.makeStoryCritical("kantas_den", id);
        id = "sdtu";
        Misc.makeStoryCritical("sindria", id);
        Misc.makeStoryCritical("volturn", id);
        Misc.makeStoryCritical("umbra", id);
        id = "lpp";
        Misc.makeStoryCritical("jangala", id);
        Misc.makeStoryCritical("hesperus", id);
        Misc.makeStoryCritical("gilead", id);
        Misc.makeStoryCritical("volturn", id);
        id = "lke";
        Misc.makeStoryCritical("gilead", id);
        Misc.makeStoryCritical("chalcedon", id);
        Misc.makeStoryCritical("mazalot", id);
        id = "bffi";
        Misc.makeStoryCritical("asher", id);
        Misc.makeStoryCritical("chalcedon", id);
        Misc.makeStoryCritical("olinadu", id);
        Misc.makeStoryCritical("kazeron", id);
        Misc.makeStoryCritical("gilead", id);
        Misc.makeStoryCritical("hesperus", id);
        Misc.makeStoryCritical("tartessus", id);
        id = "gaDHO";
        id = "pkl";
        Misc.makeStoryCritical("kantas_den", id);
    }

    public void tagLuddicShrines() {
        SectorEntityToken killa;
        Global.getSector().getEconomy().getMarket("volturn").addTag("luddic_shrine");
        Global.getSector().getEconomy().getMarket("hesperus").addTag("luddic_shrine");
        Global.getSector().getEconomy().getMarket("gilead").addTag("luddic_shrine");
        Global.getSector().getEconomy().getMarket("jangala").addTag("luddic_shrine");
        SectorEntityToken beholderStation = Global.getSector().getEntityById("beholder_station");
        if (beholderStation != null) {
            beholderStation.addTag("luddic_shrine");
        }
        if ((killa = Global.getSector().getEntityById("killa")) != null) {
            killa.addTag("luddic_shrine");
        }
    }

    protected void updateKnownPlanets() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isPlanetConditionMarketOnly() || !(market.getContainingLocation() instanceof StarSystemAPI)) continue;
            StarSystemAPI system = (StarSystemAPI)market.getContainingLocation();
            system.setEnteredByPlayer(true);
            Misc.setAllPlanetsSurveyed(system, true);
            market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        }
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            boolean galatia = system.getBaseName().toLowerCase().equals("galatia");
            if (!system.getTags().isEmpty() && !galatia) continue;
            if (Misc.getMarketsInLocation(system).isEmpty() && !galatia) {
                system.addTag("theme_core_unpopulated");
            } else {
                system.addTag("theme_core_populated");
            }
            system.addTag("theme_core");
        }
    }

    public static void addJunk(MarketAPI market) {
        SectorEntityToken entity = market.getPrimaryEntity();
        if (entity == null) {
            return;
        }
        LocationAPI location = entity.getContainingLocation();
        if (location == null) {
            return;
        }
        int numJunk = 5 + market.getSize() * 5;
        if (market.getSize() < 5) {
            numJunk = (int)Math.max(1.0f, (float)numJunk * 0.5f);
        }
        float radius = entity.getRadius() + 100.0f;
        float minOrbitDays = radius / 20.0f;
        float maxOrbitDays = minOrbitDays + 10.0f;
        location.addOrbitalJunk(entity, "orbital_junk", numJunk, 12.0f, 20.0f, radius, 110.0f, minOrbitDays, maxOrbitDays, 60.0f, 360.0f);
    }

    public static void addRuinsJunk(SectorEntityToken planet) {
        boolean r1 = planet.getMarket().hasCondition("ruins_scattered");
        boolean r2 = planet.getMarket().hasCondition("ruins_widespread");
        boolean r3 = planet.getMarket().hasCondition("ruins_extensive");
        boolean r4 = planet.getMarket().hasCondition("ruins_vast");
        if (!(r1 || r2 || r3 || r4)) {
            return;
        }
        int numJunk = 5;
        if (r2) {
            numJunk += 5;
        }
        if (r3) {
            numJunk += 15;
        }
        if (r4) {
            numJunk += 40;
        }
        float radius = planet.getRadius() + 100.0f;
        float minOrbitDays = radius / 20.0f;
        float maxOrbitDays = minOrbitDays + 10.0f;
        planet.getContainingLocation().addOrbitalJunk(planet, "orbital_junk", numJunk, 12.0f, 20.0f, radius, 110.0f, minOrbitDays, maxOrbitDays, 60.0f, 360.0f);
    }

    protected void addJunk() {
        this.junkList.clear();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            CoreLifecyclePluginImpl.addJunk(market);
        }
        for (SectorEntityToken planet : Global.getSector().getEntitiesWithTag("planet")) {
            LocationAPI location = planet.getContainingLocation();
            if (location == null || planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly()) continue;
            CoreLifecyclePluginImpl.addRuinsJunk(planet);
        }
    }

    protected void regenAsteroids() {
        for (LocationAPI loc : Global.getSector().getAllLocations()) {
            for (CampaignTerrainAPI terrain : loc.getTerrainCopy()) {
                if (!(terrain.getPlugin() instanceof AsteroidSource)) continue;
                AsteroidSource source = (AsteroidSource)((Object)terrain.getPlugin());
                source.regenerateAsteroids();
            }
        }
    }

    @Override
    public void beforeGameSave() {
        this.junkList.clear();
        for (LocationAPI loc : Global.getSector().getAllLocations()) {
            for (SectorEntityToken junk : loc.getEntitiesWithTag("orbital_junk")) {
                loc.removeEntity(junk);
                this.junkList.put(junk, loc);
            }
        }
        this.asteroidList.clear();
        for (LocationAPI loc : Global.getSector().getAllLocations()) {
            for (SectorEntityToken asteroid : new ArrayList<SectorEntityToken>(loc.getAsteroids())) {
                AsteroidSource source = Misc.getAsteroidSource(asteroid);
                if (source == null || !asteroid.getMemoryWithoutUpdate().isEmpty()) {
                    if (source == null) continue;
                    source.reportAsteroidPersisted(asteroid);
                    Misc.clearAsteroidSource(asteroid);
                    continue;
                }
                this.asteroidList.put(asteroid, loc);
                loc.removeEntity(asteroid);
            }
        }
        this.econPreSaveCleanup();
    }

    protected void econPreSaveCleanup() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            for (Industry ind : market.getIndustries()) {
                ind.doPreSaveCleanup();
            }
        }
    }

    public static void econPostSaveRestore() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            for (Industry ind : market.getIndustries()) {
                ind.doPostSaveRestore();
            }
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            market.reapplyConditions();
            market.reapplyIndustries();
        }
    }

    @Override
    public void afterGameSave() {
        this.restoreRemovedEntities();
        CoreLifecyclePluginImpl.econPostSaveRestore();
    }

    @Override
    public void onGameSaveFailed() {
        this.restoreRemovedEntities();
        CoreLifecyclePluginImpl.econPostSaveRestore();
    }

    protected void restoreRemovedEntities() {
        for (SectorEntityToken junk : this.junkList.keySet()) {
            this.junkList.get(junk).addEntity(junk);
        }
        this.junkList.clear();
        for (SectorEntityToken asteroid : this.asteroidList.keySet()) {
            this.asteroidList.get(asteroid).addEntity(asteroid);
        }
        this.asteroidList.clear();
    }

    private void initSlipstream() {
    }

    public static void createInitialPeople(MarketAPI market, Random random) {
        PersonAPI person;
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        boolean addedPerson = false;
        PersonAPI admin = null;
        LinkedHashSet<PersonAPI> randomPeople = new LinkedHashSet<PersonAPI>();
        if (market.hasIndustry("militarybase") || market.hasIndustry("highcommand")) {
            PersonAPI person2 = market.getFaction().createRandomPerson(StarSystemGenerator.random);
            String rankId = Ranks.GROUND_MAJOR;
            if (market.getSize() >= 6) {
                rankId = Ranks.GROUND_GENERAL;
            } else if (market.getSize() >= 4) {
                rankId = Ranks.GROUND_COLONEL;
            }
            person2.setRankId(rankId);
            person2.setPostId(Ranks.POST_BASE_COMMANDER);
            if (market.getSize() >= 8) {
                person2.setImportanceAndVoice(PersonImportance.VERY_HIGH, StarSystemGenerator.random);
            } else if (market.getSize() >= 6) {
                person2.setImportanceAndVoice(PersonImportance.HIGH, StarSystemGenerator.random);
            } else {
                person2.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            }
            person2.addTag("military");
            market.getCommDirectory().addPerson(person2);
            market.addPerson(person2);
            ip.addPerson(person2);
            ip.getData(person2).getLocation().setMarket(market);
            ip.checkOutPerson(person2, "permanent_staff");
            addedPerson = true;
            randomPeople.add(person2);
        }
        boolean hasStation = false;
        for (Industry curr : market.getIndustries()) {
            if (!curr.getSpec().hasTag("station")) continue;
            hasStation = true;
            break;
        }
        if (hasStation) {
            person = market.getFaction().createRandomPerson(StarSystemGenerator.random);
            String rankId = Ranks.SPACE_COMMANDER;
            if (market.getSize() >= 6) {
                rankId = Ranks.SPACE_ADMIRAL;
            } else if (market.getSize() >= 4) {
                rankId = Ranks.SPACE_CAPTAIN;
            }
            person.setRankId(rankId);
            person.setPostId(Ranks.POST_STATION_COMMANDER);
            if (market.getSize() >= 8) {
                person.setImportanceAndVoice(PersonImportance.VERY_HIGH, StarSystemGenerator.random);
            } else if (market.getSize() >= 6) {
                person.setImportanceAndVoice(PersonImportance.HIGH, StarSystemGenerator.random);
            } else {
                person.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            }
            person.addTag("military");
            market.getCommDirectory().addPerson(person);
            market.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market);
            ip.checkOutPerson(person, "permanent_staff");
            addedPerson = true;
            randomPeople.add(person);
            if (market.getPrimaryEntity().hasTag("station")) {
                admin = person;
            }
        }
        if (market.hasSpaceport()) {
            person = market.getFaction().createRandomPerson(StarSystemGenerator.random);
            person.setPostId(Ranks.POST_PORTMASTER);
            if (market.getSize() >= 8) {
                person.setImportanceAndVoice(PersonImportance.HIGH, StarSystemGenerator.random);
            } else if (market.getSize() >= 6) {
                person.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            } else if (market.getSize() >= 4) {
                person.setImportanceAndVoice(PersonImportance.LOW, StarSystemGenerator.random);
            } else {
                person.setImportanceAndVoice(PersonImportance.VERY_LOW, StarSystemGenerator.random);
            }
            person.addTag("trade");
            market.getCommDirectory().addPerson(person);
            market.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market);
            ip.checkOutPerson(person, "permanent_staff");
            addedPerson = true;
            randomPeople.add(person);
        }
        if (addedPerson) {
            person = market.getFaction().createRandomPerson(StarSystemGenerator.random);
            person.setRankId(Ranks.SPACE_COMMANDER);
            person.setPostId(Ranks.POST_SUPPLY_OFFICER);
            if (market.getSize() >= 6) {
                person.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            } else if (market.getSize() >= 4) {
                person.setImportanceAndVoice(PersonImportance.LOW, StarSystemGenerator.random);
            } else {
                person.setImportanceAndVoice(PersonImportance.VERY_LOW, StarSystemGenerator.random);
            }
            person.addTag("military");
            person.addTag("trade");
            if (StarSystemGenerator.random.nextFloat() < 0.2f) {
                person.addTag("underworld");
            }
            market.getCommDirectory().addPerson(person);
            market.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market);
            ip.checkOutPerson(person, "permanent_staff");
            addedPerson = true;
            randomPeople.add(person);
        }
        if (!addedPerson || admin == null) {
            person = market.getFaction().createRandomPerson(StarSystemGenerator.random);
            person.setRankId(Ranks.CITIZEN);
            person.setPostId(Ranks.POST_ADMINISTRATOR);
            if (market.getSize() >= 8) {
                person.setImportanceAndVoice(PersonImportance.VERY_HIGH, StarSystemGenerator.random);
            } else if (market.getSize() >= 6) {
                person.setImportanceAndVoice(PersonImportance.HIGH, StarSystemGenerator.random);
            } else {
                person.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            }
            person.addTag("trade");
            market.getCommDirectory().addPerson(person);
            market.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market);
            ip.checkOutPerson(person, "permanent_staff");
            admin = person;
            randomPeople.add(person);
        }
        if (admin != null) {
            CoreLifecyclePluginImpl.addSkillsAndAssignAdmin(market, admin);
        }
        ArrayList<PersonAPI> people = new ArrayList<PersonAPI>(randomPeople);
        Iterator iter = people.iterator();
        while (iter.hasNext()) {
            PersonAPI curr = (PersonAPI)iter.next();
            if (curr == null || curr.getFaction() == null) {
                iter.remove();
                continue;
            }
            if (!curr.isDefault() && !curr.isAICore() && !curr.isPlayer()) continue;
            iter.remove();
        }
        CoreLifecyclePluginImpl.dedupePortraits(people);
    }

    private void createInitialPeople() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getMemoryWithoutUpdate().getBoolean("$doNotInitCommListings")) continue;
            CoreLifecyclePluginImpl.createInitialPeople(market, StarSystemGenerator.random);
        }
        this.assignCustomAdmins();
        People.create();
    }

    public static void dedupePortraits(List<PersonAPI> people) {
        int i = 0;
        while (i < 10 * people.size()) {
            if (CoreLifecyclePluginImpl.hasDuplicatePortraits(people)) {
                for (PersonAPI person : people) {
                    int num;
                    if (person.isDefault() || person.isAICore() || person.isPlayer() || (num = CoreLifecyclePluginImpl.getPortraitCount(people, person)) <= 1) continue;
                    int j = 0;
                    while (j < 10) {
                        CoreLifecyclePluginImpl.regenPortrait(person);
                        num = CoreLifecyclePluginImpl.getPortraitCount(people, person);
                        if (num <= 1) break;
                        ++j;
                    }
                    Collections.shuffle(people, StarSystemGenerator.random);
                    break;
                }
            }
            ++i;
        }
    }

    public static void regenPortrait(PersonAPI person) {
        if (person == null || person.getFaction() == null) {
            return;
        }
        String curr = person.getPortraitSprite();
        if (curr == null) {
            curr = "";
        }
        int i = 0;
        while (i < 10) {
            String other = person.getFaction().createRandomPerson(person.getGender(), StarSystemGenerator.random).getPortraitSprite();
            if (!curr.equals(other)) {
                person.setPortraitSprite(other);
                break;
            }
            ++i;
        }
    }

    public static int getPortraitCount(List<PersonAPI> people, PersonAPI person) {
        String curr = person.getPortraitSprite();
        int count = 0;
        for (PersonAPI other : people) {
            String str = other.getPortraitSprite();
            if (str == null || !curr.equals(str)) continue;
            ++count;
        }
        return count;
    }

    public static boolean hasDuplicatePortraits(List<PersonAPI> people) {
        LinkedHashSet<String> used = new LinkedHashSet<String>();
        for (PersonAPI person : people) {
            String str = person.getPortraitSprite();
            if (used.contains(str)) {
                return true;
            }
            used.add(str);
        }
        return false;
    }

    protected void assignCustomAdmins() {
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        MarketAPI market2 = Global.getSector().getEconomy().getMarket("station_kapteyn");
        if (market2 != null) {
            PersonAPI person = market2.getFaction().createRandomPerson();
            person.setRankId(Ranks.CITIZEN);
            person.setPostId(Ranks.POST_ADMINISTRATOR);
            person.setImportanceAndVoice(PersonImportance.HIGH, StarSystemGenerator.random);
            person.getStats().setSkillLevel("industrial_planning", 1.0f);
            for (PersonAPI p : market2.getPeopleCopy()) {
                if (!Ranks.POST_ADMINISTRATOR.equals(p.getPostId())) continue;
                market2.removePerson(p);
                ip.removePerson(p);
                market2.getCommDirectory().removePerson(p);
                break;
            }
            market2.setAdmin(person);
            market2.getCommDirectory().addPerson(person, 0);
            market2.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market2);
            ip.checkOutPerson(person, "permanent_staff");
        }
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!"tritachyon".equals(market2.getFactionId()) || !market2.getId().equals("culann")) continue;
            PersonAPI person = market2.getFaction().createRandomPerson();
            person.setRankId(Ranks.CITIZEN);
            person.setPostId(Ranks.POST_ADMINISTRATOR);
            person.getStats().setSkillLevel("industrial_planning", 1.0f);
            person.getStats().setSkillLevel("hypercognition", 1.0f);
            person.setAICoreId("alpha_core");
            person.getMemoryWithoutUpdate().set("$suspectedAI", true);
            person.setImportanceAndVoice(PersonImportance.MEDIUM, StarSystemGenerator.random);
            for (PersonAPI p : market2.getPeopleCopy()) {
                if (!Ranks.POST_ADMINISTRATOR.equals(p.getPostId())) continue;
                market2.removePerson(p);
                ip.removePerson(p);
                market2.getCommDirectory().removePerson(p);
                break;
            }
            market2.setAdmin(person);
            market2.getCommDirectory().addPerson(person, 0);
            market2.addPerson(person);
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market2);
            ip.checkOutPerson(person, "permanent_staff");
        }
    }

    public static void addSkillsAndAssignAdmin(MarketAPI market, PersonAPI admin) {
        List<String> skills = Global.getSettings().getSortedSkillIds();
        if (!skills.contains("industrial_planning")) {
            return;
        }
        int size = market.getSize();
        int industries = 0;
        for (Industry curr : market.getIndustries()) {
            if (!curr.isIndustry()) continue;
            ++industries;
        }
        admin.getStats().setSkipRefresh(true);
        if (industries >= 2 || size >= 6) {
            admin.getStats().setSkillLevel("industrial_planning", 1.0f);
        }
        admin.getStats().setSkipRefresh(false);
        admin.getStats().refreshCharacterStatsEffects();
        market.setAdmin(admin);
    }

    @Override
    public void configureXStream(XStream x) {
        x.alias("AssignmentModulePlugin", AssignmentModulePlugin.class);
        x.alias("ModularFleetAIAPI", ModularFleetAIAPI.class);
        x.alias("NavigationModulePlugin", NavigationModulePlugin.class);
        x.alias("StrategicModulePlugin", StrategicModulePlugin.class);
        x.alias("TacticalModulePlugin", TacticalModulePlugin.class);
        x.alias("NTP", NebulaTerrainPlugin.class);
        x.alias("AuroraRenderer", AuroraRenderer.class);
        x.alias("CRLPSBuff", CRLossPerSecondBuff.class);
        x.aliasAttribute(CRLossPerSecondBuff.class, "id", "id");
        x.aliasAttribute(CRLossPerSecondBuff.class, "mult", "m");
        x.aliasAttribute(CRLossPerSecondBuff.class, "dur", "d");
        x.alias("PPBuff", PeakPerformanceBuff.class);
        x.aliasAttribute(PeakPerformanceBuff.class, "id", "id");
        x.aliasAttribute(PeakPerformanceBuff.class, "mult", "m");
        x.aliasAttribute(PeakPerformanceBuff.class, "dur", "d");
        x.alias("SlipParams", SlipstreamTerrainPlugin2.SlipstreamParams2.class);
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "spriteKey1", "sK1");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "spriteKey2", "sK2");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "spriteKey3", "sK3");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "edgeKey", "eK");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "spriteColor", "sC");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "windGlowColor", "wGC");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "edgeColor", "eC");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "baseWidth", "bW");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "widthForMaxSpeed", "wFMS");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "edgeWidth", "eW");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "areaPerParticle", "aPP");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "maxParticles", "maxP");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "minSpeed", "minS");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "maxSpeed", "maxS");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "minColor", "minC");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "maxColor", "maxC");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "mapColor", "mCol");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "minDur", "minD");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "maxDur", "maxD");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "particleFadeInTime", "pFIT");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "lineLengthFractionOfSpeed", "lLFOS");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "burnLevel", "bL");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "maxBurnLevelForTextureScroll", "mBLFTS");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "slowDownInWiderSections", "slow");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "widthForMaxSpeedMinMult", "wFMSMin");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "widthForMaxSpeedMaxMult", "wFMSMax");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "name", "name");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "texScrollMult0", "tSM0");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "texScrollMult1", "tSM1");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamParams2.class, "texScrollMult2", "tSM2");
        x.alias("SSeg", SlipstreamTerrainPlugin2.SlipstreamSegment.class);
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "locB", "B");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "loc", "l");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "width", "w");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "bMult", "m");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "discovered", "d");
        x.aliasAttribute(SlipstreamTerrainPlugin2.SlipstreamSegment.class, "fader", "f");
        x.alias("SlipTP2", SlipstreamTerrainPlugin2.class);
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "params", "p");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "segments", "s");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "totalLength", "tL");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "needsRecompute", "nR");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "bounds", "b");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "segmentsPerBox", "sPB");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "texProgress0", "tP0");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "texProgress1", "tP1");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "texProgress2", "tP2");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "despawnNoise", "dN");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "despawnDelay", "dDe");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "despawnDays", "dDa");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "despawnElapsed", "dE");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "spawnNoise", "sN");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "spawnDays", "sD");
        x.aliasAttribute(SlipstreamTerrainPlugin2.class, "spawnElapsed", "sE");
        x.alias("BBox", BoundingBox.class);
        x.aliasAttribute(BoundingBox.class, "box", "b");
        x.aliasAttribute(BoundingBox.class, "padding", "p");
        x.aliasAttribute(BoundingBox.class, "rotatedBox", "rB");
        x.aliasAttribute(BoundingBox.class, "angle", "a");
        x.aliasAttribute(BoundingBox.class, "boxComputed", "bC");
        x.aliasAttribute(BoundingBox.class, "center", "c");
        x.aliasAttribute(BoundingBox.class, "radius", "r");
        x.alias("FParams", FleetParamsV3.class);
        x.aliasAttribute(FleetParamsV3.class, "source", "srcL");
        x.aliasAttribute(FleetParamsV3.class, "locInHyper", "lIH");
        x.aliasAttribute(FleetParamsV3.class, "quality", "q");
        x.aliasAttribute(FleetParamsV3.class, "qualityMod", "qMod");
        x.aliasAttribute(FleetParamsV3.class, "qualityOverride", "qO");
        x.aliasAttribute(FleetParamsV3.class, "factionId", "fId");
        x.aliasAttribute(FleetParamsV3.class, "fleetType", "fT");
        x.aliasAttribute(FleetParamsV3.class, "combatPts", "cP");
        x.aliasAttribute(FleetParamsV3.class, "freighterPts", "fP");
        x.aliasAttribute(FleetParamsV3.class, "tankerPts", "taP");
        x.aliasAttribute(FleetParamsV3.class, "transportPts", "trP");
        x.aliasAttribute(FleetParamsV3.class, "linerPts", "lP");
        x.aliasAttribute(FleetParamsV3.class, "utilityPts", "uP");
        x.aliasAttribute(FleetParamsV3.class, "withOfficers", "wO");
        x.aliasAttribute(FleetParamsV3.class, "maxShipSize", "mSS");
        x.aliasAttribute(FleetParamsV3.class, "minShipSize", "minSS");
        x.aliasAttribute(FleetParamsV3.class, "averageSMods", "aSM");
        x.aliasAttribute(FleetParamsV3.class, "commander", "c");
        x.aliasAttribute(FleetParamsV3.class, "random", "r");
        x.aliasAttribute(FleetParamsV3.class, "ignoreMarketFleetSizeMult", "iMFSM");
        x.aliasAttribute(FleetParamsV3.class, "onlyApplyFleetSizeToCombatShips", "oAFSTCS");
        x.aliasAttribute(FleetParamsV3.class, "doNotPrune", "dNP");
        x.aliasAttribute(FleetParamsV3.class, "modeOverride", "mO");
        x.aliasAttribute(FleetParamsV3.class, "officerLevelBonus", "oLB");
        x.aliasAttribute(FleetParamsV3.class, "officerNumberBonus", "oNB");
        x.aliasAttribute(FleetParamsV3.class, "officerNumberMult", "oNM");
        x.aliasAttribute(FleetParamsV3.class, "officerLevelLimit", "oLL");
        x.aliasAttribute(FleetParamsV3.class, "commanderLevelLimit", "cLL");
        x.aliasAttribute(FleetParamsV3.class, "forceAllowPhaseShipsEtc", "fAPSE");
        x.aliasAttribute(FleetParamsV3.class, "treatCombatFreighterSettingAsFraction", "tCFSAF");
        x.aliasAttribute(FleetParamsV3.class, "doctrineOverride", "dOv");
        x.aliasAttribute(FleetParamsV3.class, "doctrineOverride", "ts");
        x.aliasAttribute(FleetParamsV3.class, "maxNumShips", "mNS");
        x.aliasAttribute(FleetParamsV3.class, "onlyRetainFlagship", "oRF");
        x.aliasAttribute(FleetParamsV3.class, "flagshipVariantId", "fVI");
        x.aliasAttribute(FleetParamsV3.class, "flagshipVariant", "fV");
        x.aliasAttribute(FleetParamsV3.class, "aiCores", "aiC");
        x.aliasAttribute(FleetParamsV3.class, "doNotIntegrateAICores", "dNIAIC");
        x.aliasAttribute(FleetParamsV3.class, "allWeapons", "aW");
        x.alias("MaxBurnBuff", MaxBurnBuff.class);
        x.alias("PeakPerformanceBuff", PeakPerformanceBuff.class);
        x.alias("RingSystemTerrainPlugin", RingSystemTerrainPlugin.class);
        x.alias("StarCoronaAkaMainyuTerrainPlugin", StarCoronaAkaMainyuTerrainPlugin.class);
        x.alias("StarCoronaTerrainPlugin", StarCoronaTerrainPlugin.class);
        x.alias("PulsarBeamTerrainPlugin", PulsarBeamTerrainPlugin.class);
        x.alias("EventHorizonPlugin", EventHorizonPlugin.class);
        x.alias("FlareManager", FlareManager.class);
        x.aliasAttribute(FlareManager.class, "flareTracker", "fT");
        x.aliasAttribute(FlareManager.class, "flares", "f");
        x.aliasAttribute(FlareManager.class, "delegate", "d");
        x.alias("Flare", FlareManager.Flare.class);
        x.aliasAttribute(FlareManager.Flare.class, "direction", "d");
        x.aliasAttribute(FlareManager.Flare.class, "arc", "a");
        x.aliasAttribute(FlareManager.Flare.class, "extraLengthMult", "eLM");
        x.aliasAttribute(FlareManager.Flare.class, "extraLengthFlat", "eLF");
        x.aliasAttribute(FlareManager.Flare.class, "shortenFlatMod", "sFM");
        x.aliasAttribute(FlareManager.Flare.class, "c", "c");
        x.aliasAttribute(FlareManager.Flare.class, "fader", "f");
        x.alias("MagneticFieldTerrainPlugin", MagneticFieldTerrainPlugin.class);
        x.aliasAttribute(MagneticFieldTerrainPlugin.class, "entity", "e");
        x.aliasAttribute(MagneticFieldTerrainPlugin.class, "renderer", "r");
        x.aliasAttribute(MagneticFieldTerrainPlugin.class, "flareManager", "fM");
        x.alias("MagneticFieldParams", MagneticFieldTerrainPlugin.MagneticFieldParams.class);
        x.aliasAttribute(MagneticFieldTerrainPlugin.MagneticFieldParams.class, "baseColor", "bC");
        x.aliasAttribute(MagneticFieldTerrainPlugin.MagneticFieldParams.class, "c", "c");
        x.aliasAttribute(MagneticFieldTerrainPlugin.MagneticFieldParams.class, "auroraFrequency", "aF");
        x.aliasAttribute(MagneticFieldTerrainPlugin.MagneticFieldParams.class, "innerRadius", "iR");
        x.aliasAttribute(MagneticFieldTerrainPlugin.MagneticFieldParams.class, "outerRadius", "oR");
        x.alias("", AuroraRenderer.class);
        x.aliasAttribute(AuroraRenderer.class, "phaseAngle", "a");
        x.aliasAttribute(AuroraRenderer.class, "delegate", "d");
        x.alias("FlickerUtil", FlickerUtil.class);
        x.aliasAttribute(FlickerUtil.class, "angle", "a");
        x.aliasAttribute(FlickerUtil.class, "brightness", "b");
        x.aliasAttribute(FlickerUtil.class, "currTime", "c");
        x.aliasAttribute(FlickerUtil.class, "currMaxBurstTime", "cMBT");
        x.aliasAttribute(FlickerUtil.class, "currMaxBrightness", "cMB");
        x.aliasAttribute(FlickerUtil.class, "maxBurstTime", "mBT");
        x.aliasAttribute(FlickerUtil.class, "peakTime", "pT");
        x.aliasAttribute(FlickerUtil.class, "peakDur", "pD");
        x.aliasAttribute(FlickerUtil.class, "stop", "s");
        x.alias("FUtil", FaderUtil.class);
        x.aliasAttribute(FaderUtil.class, "currBrightness", "b");
        x.aliasAttribute(FaderUtil.class, "durationIn", "i");
        x.aliasAttribute(FaderUtil.class, "durationOut", "o");
        x.aliasAttribute(FaderUtil.class, "state", "s");
        x.aliasAttribute(FaderUtil.class, "bounceDown", "d");
        x.aliasAttribute(FaderUtil.class, "bounceUp", "u");
        x.alias("IUtil", IntervalUtil.class);
        x.aliasAttribute(IntervalUtil.class, "minInterval", "i");
        x.aliasAttribute(IntervalUtil.class, "maxInterval", "a");
        x.aliasAttribute(IntervalUtil.class, "currInterval", "c");
        x.aliasAttribute(IntervalUtil.class, "elapsed", "e");
        x.aliasAttribute(IntervalUtil.class, "intervalElapsed", "ie");
        x.alias("TimeoutTracker", TimeoutTracker.class);
        x.alias("IDt", TimeoutTracker.ItemData.class);
        x.aliasAttribute(TimeoutTracker.ItemData.class, "item", "i");
        x.aliasAttribute(TimeoutTracker.ItemData.class, "remaining", "r");
        x.alias("TrA", TransponderAbility.class);
        x.alias("TrAI", TransponderAbilityAI.class);
        x.alias("EmB", EmergencyBurnAbility.class);
        x.alias("EmBAI", EmergencyBurnAbilityAI.class);
        x.alias("GoDA", GoDarkAbility.class);
        x.alias("GoDAAI", GoDarkAbilityAI.class);
        x.alias("SeBA", SensorBurstAbility.class);
        x.alias("SeBAAI", SensorBurstAbilityAI.class);
        x.alias("SuBA", SustainedBurnAbility.class);
        x.alias("SuBAAI", SustainedBurnAbilityAI.class);
        x.alias("InPA", InterdictionPulseAbility.class);
        x.alias("InPAAI", InterdictionPulseAbilityAI.class);
        x.alias("IPReactionScript", InterdictionPulseAbility.IPReactionScript.class);
        x.aliasAttribute(InterdictionPulseAbility.IPReactionScript.class, "delay", "e");
        x.aliasAttribute(InterdictionPulseAbility.IPReactionScript.class, "done", "d");
        x.aliasAttribute(InterdictionPulseAbility.IPReactionScript.class, "other", "o");
        x.aliasAttribute(InterdictionPulseAbility.IPReactionScript.class, "fleet", "f");
        x.aliasAttribute(InterdictionPulseAbility.IPReactionScript.class, "activationDays", "aD");
        x.alias("ScA", ScavengeAbility.class);
        x.alias("FJA", FractureJumpAbility.class);
        x.alias("RSA", RemoteSurveyAbility.class);
        x.alias("GScan", GraviticScanAbility.class);
        x.alias("GSDat", GraviticScanData.class);
        x.alias("GSPing", GraviticScanData.GSPing.class);
        x.aliasAttribute(GraviticScanData.GSPing.class, "arc", "a");
        x.aliasAttribute(GraviticScanData.GSPing.class, "angle", "n");
        x.aliasAttribute(GraviticScanData.GSPing.class, "grav", "g");
        x.aliasAttribute(GraviticScanData.GSPing.class, "fader", "f");
        x.aliasAttribute(GraviticScanData.GSPing.class, "withSound", "s");
        x.alias("ProcgenUsedNames", ProcgenUsedNames.class);
        x.alias("SmugglingScanScript", SmugglingScanScript.class);
        x.alias("HasslePlayerScript", HasslePlayerScript.class);
        x.aliasAttribute(BaseAbilityPlugin.class, "entity", "e");
        x.aliasAttribute(BaseAbilityPlugin.class, "id", "id");
        x.aliasAttribute(BaseAbilityPlugin.class, "disableFrames", "dF");
        x.aliasAttribute(BaseToggleAbility.class, "turnedOn", "tO");
        x.aliasAttribute(BaseToggleAbility.class, "cooldownLeft", "cL");
        x.aliasAttribute(BaseToggleAbility.class, "isActivateCooldown", "iAC");
        x.aliasAttribute(BaseToggleAbility.class, "level", "l");
        x.aliasAttribute(BaseDurationAbility.class, "turnedOn", "tO");
        x.aliasAttribute(BaseDurationAbility.class, "activeDaysLeft", "aDL");
        x.aliasAttribute(BaseDurationAbility.class, "cooldownLeft", "cL");
        x.aliasAttribute(BaseDurationAbility.class, "level", "l");
        x.aliasAttribute(BaseDurationAbility.class, "loopFadeLeft", "lFF");
        x.aliasAttribute(BaseDurationAbility.class, "fadingOut", "fO");
        x.aliasAttribute(BaseAbilityAI.class, "fleet", "f");
        x.aliasAttribute(BaseAbilityAI.class, "ability", "a");
        x.aliasAttribute(GoDarkAbilityAI.class, "interval", "i");
        x.aliasAttribute(TransponderAbilityAI.class, "interval", "i");
        x.aliasAttribute(EmergencyBurnAbilityAI.class, "interval", "i");
        x.aliasAttribute(SensorBurstAbilityAI.class, "interval", "i");
        x.alias("RAT", RollingAverageTracker.class);
        x.aliasAttribute(RollingAverageTracker.class, "timer", "t");
        x.aliasAttribute(RollingAverageTracker.class, "f", "f");
        x.aliasAttribute(RollingAverageTracker.class, "elaspedFractionOverride", "e");
        x.aliasAttribute(RollingAverageTracker.class, "curr", "c");
        x.aliasAttribute(RollingAverageTracker.class, "avg", "a");
        x.alias("PTDFS", PlayerTradeDataForSubmarket.class);
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "playerBought", "pB");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "playerSold", "pS");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "accumulatedPlayerTradeValueForPositive", "accP");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "accumulatedPlayerTradeValueForNegative", "accN");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "totalPlayerTradeValue", "tPV");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "tracker", "t");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "playerBoughtShips", "pBS");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "playerSoldShips", "pSS");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "market", "m");
        x.aliasAttribute(PlayerTradeDataForSubmarket.class, "submarket", "s");
        x.alias("MPFD", MilitaryBase.PatrolFleetData.class);
        x.aliasAttribute(MilitaryBase.PatrolFleetData.class, "type", "t");
        x.aliasAttribute(MilitaryBase.PatrolFleetData.class, "spawnFP", "fp");
        x.alias("PatrolFleetData", PatrolFleetManager.PatrolFleetData.class);
        x.alias("PatrolFleetManager", PatrolFleetManager.class);
        x.alias("PatrolFleetManagerV2", PatrolFleetManagerV2.class);
        x.alias("PatrolAssignmentAI", PatrolAssignmentAI.class);
        x.alias("SharedData", SharedData.class);
        x.alias("HyperspaceTerrainPlugin", HyperspaceTerrainPlugin.class);
        x.alias("FoodShortageEvent", FoodShortageEvent.class);
        x.alias("CoreEventProbabilityManager", CoreEventProbabilityManager.class);
        x.alias("BlackMarketPlugin", BlackMarketPlugin.class);
        x.alias("PlayerTradeDataForSubmarket", PlayerTradeDataForSubmarket.class);
        x.alias("PriceUpdate", PriceUpdate.class);
        x.alias("JumpDestination", JumpPointAPI.JumpDestination.class);
        x.alias("OpenMarketPlugin", OpenMarketPlugin.class);
        x.alias("CampaignEventTarget", CampaignEventTarget.class);
        x.alias("OfficerManagerEvent", OfficerManagerEvent.class);
        x.alias("AvailableOfficer", OfficerManagerEvent.AvailableOfficer.class);
        x.alias("ManagedFleetData", BaseLimitedFleetManager.ManagedFleetData.class);
        x.alias("TradeDisruption", TradeDisruption.class);
        x.alias("CommodityStats", CommodityStatTracker.CommodityStats.class);
        x.alias("TradeInfoUpdateEvent", TradeInfoUpdateEvent.class);
        x.alias("TransactionLineItem", PlayerMarketTransaction.TransactionLineItem.class);
        x.alias("Population", Population.class);
        x.alias("MercFleetManagerV2", MercFleetManagerV2.class);
        x.alias("InvestigationEventGoodRepWithOther", InvestigationEventGoodRepWithOther.class);
        x.alias("RepTrackerEvent", RepTrackerEvent.class);
        x.alias("Hydroponics", Hydroponics.class);
        x.alias("WorldUninhabitable", WorldUninhabitable.class);
        x.alias("ReputationChangeData", ReputationChangeTracker.ReputationChangeData.class);
        x.alias("FactionTradeRepData", RepTrackerEvent.FactionTradeRepData.class);
        x.alias("RecentUnrest", RecentUnrest.class);
        x.alias("Outpost", Outpost.class);
        x.alias("CellStateTracker", HyperspaceTerrainPlugin.CellStateTracker.class);
        x.alias("CoreScript", CoreScript.class);
        x.alias("CoronaParams", StarCoronaTerrainPlugin.CoronaParams.class);
        x.aliasAttribute(StarCoronaTerrainPlugin.CoronaParams.class, "windBurnLevel", "wBL");
        x.aliasAttribute(StarCoronaTerrainPlugin.CoronaParams.class, "flareProbability", "fP");
        x.aliasAttribute(StarCoronaTerrainPlugin.CoronaParams.class, "crLossMult", "crLM");
        x.alias("RingParams", BaseRingTerrain.RingParams.class);
        x.aliasAttribute(BaseRingTerrain.RingParams.class, "bandWidthInEngine", "bWIE");
        x.aliasAttribute(BaseRingTerrain.RingParams.class, "middleRadius", "mR");
        x.aliasAttribute(BaseRingTerrain.RingParams.class, "name", "n");
        x.aliasAttribute(BaseRingTerrain.RingParams.class, "relatedEntity", "e");
        x.alias("AsteroidBeltParams", AsteroidBeltTerrainPlugin.AsteroidBeltParams.class);
        x.aliasAttribute(AsteroidBeltTerrainPlugin.AsteroidBeltParams.class, "numAsteroids", "nA");
        x.aliasAttribute(AsteroidBeltTerrainPlugin.AsteroidBeltParams.class, "minOrbitDays", "minO");
        x.aliasAttribute(AsteroidBeltTerrainPlugin.AsteroidBeltParams.class, "maxOrbitDays", "maxO");
        x.aliasAttribute(AsteroidBeltTerrainPlugin.AsteroidBeltParams.class, "minSize", "minS");
        x.aliasAttribute(AsteroidBeltTerrainPlugin.AsteroidBeltParams.class, "maxSize", "maxS");
        x.alias("AsteroidFieldParams", AsteroidFieldTerrainPlugin.AsteroidFieldParams.class);
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "minRadius", "minR");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "maxRadius", "maxR");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "numAsteroids", "nA");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "minAsteroids", "minA");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "maxAsteroids", "maxA");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "minSize", "minS");
        x.aliasAttribute(AsteroidFieldTerrainPlugin.AsteroidFieldParams.class, "maxSize", "maxS");
        x.alias("AsteroidBeltTerrainPlugin", AsteroidBeltTerrainPlugin.class);
        x.aliasAttribute(AsteroidBeltTerrainPlugin.class, "needToCreateAsteroids", "nTCA");
        x.alias("AsteroidFieldTerrainPlugin", AsteroidFieldTerrainPlugin.class);
        x.alias("BaseTerrain", BaseTerrain.class);
        x.aliasAttribute(BaseTerrain.class, "terrainId", "tid");
        x.aliasAttribute(BaseTerrain.class, "name", "n");
        x.alias("BaseRingTerrain", BaseRingTerrain.class);
        x.alias("AbandonedStation", AbandonedStation.class);
        x.alias("WorldTundra", WorldTundra.class);
        x.alias("Frontier", Frontier.class);
        x.alias("RadioChatterTerrainPlugin", RadioChatterTerrainPlugin.class);
        x.alias("RadioChatterParams", RadioChatterTerrainPlugin.RadioChatterParams.class);
        x.alias("WorldBarrenMarginal", WorldBarrenMarginal.class);
        x.alias("UrbanizedPolity", UrbanizedPolity.class);
        x.alias("OrganizedCrime", OrganizedCrime.class);
        x.alias("Headquarters", Headquarters.class);
        x.alias("ViceDemand", ViceDemand.class);
        x.alias("SystemBounty", SystemBounty.class);
        x.alias("WorldTwilight", WorldTwilight.class);
        x.alias("RuralPolity", RuralPolity.class);
        x.alias("FreeMarket", FreeMarket.class);
        x.alias("WorldIce", WorldIce.class);
        x.alias("Dissident", Dissident.class);
        x.alias("TradeCenter", com.fs.starfarer.api.impl.campaign.econ.TradeCenter.class);
        x.alias("CottageIndustry", CottageIndustry.class);
        x.alias("LuddicMajority", LuddicMajority.class);
        x.alias("WorldArid", WorldArid.class);
        x.alias("Decivilized", Decivilized.class);
        x.alias("StealthMinefields", StealthMinefields.class);
        x.alias("Smuggling", Smuggling.class);
        x.alias("ShipbreakingCenter", ShipbreakingCenter.class);
        x.alias("FoodShortage", FoodShortage.class);
        x.alias("CRRecoveryBuff", CRRecoveryBuff.class);
        x.alias("LargeRefugeePopulation", LargeRefugeePopulation.class);
        x.alias("WorldWater", WorldWater.class);
        x.alias("RegionalCapital", RegionalCapital.class);
        x.alias("OrbitalBurns", OrbitalBurns.class);
        x.alias("WorldJungle", WorldJungle.class);
        x.alias("WorldDesert", WorldDesert.class);
        x.alias("BaseHazardCondition", BaseHazardCondition.class);
        x.alias("WorldTerran", WorldTerran.class);
        x.alias("DebrisFieldTerrainPlugin", DebrisFieldTerrainPlugin.class);
        x.alias("DebrisFieldParams", DebrisFieldTerrainPlugin.DebrisFieldParams.class);
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "density", "d");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "baseDensity", "bD");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "glowsDays", "gD");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "lastsDays", "lD");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "minSize", "min1");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "maxSize", "max1");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "glowColor", "gC");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "defFaction", "dF");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "defenderProb", "dP");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "minStr", "min2");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "maxStr", "max2");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "maxDefenderSize", "mDS");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "baseSalvageXP", "xp");
        x.aliasAttribute(DebrisFieldTerrainPlugin.DebrisFieldParams.class, "source", "s");
        x.alias("PlayerTradeProfitabilityData", PlayerTradeProfitabilityData.class);
        x.alias("CommodityData", PlayerTradeProfitabilityData.CommodityData.class);
        x.alias("CoreCampaignPluginImpl", CoreCampaignPluginImpl.class);
        x.alias("FactionHostilityEvent", FactionHostilityEvent.class);
        x.alias("FactionHostilityPairKey", FactionHostilityEvent.FactionHostilityPairKey.class);
        x.alias("InvestigationEventSmugglingV2", InvestigationEventSmugglingV2.class);
        x.alias("RecentUnrestEvent", RecentUnrestEvent.class);
        x.alias("AsteroidBeltParams", AsteroidBeltTerrainPlugin.AsteroidBeltParams.class);
        x.alias("DomainSurveyDerelictSpecial", DomainSurveyDerelictSpecial.class);
        x.alias("BaseCustomEntityPlugin", BaseCustomEntityPlugin.class);
        x.aliasAttribute(BaseCustomEntityPlugin.class, "entity", "e");
        x.alias("DerelictShipEntityPlugin", DerelictShipEntityPlugin.class);
        x.aliasAttribute(DerelictShipEntityPlugin.class, "data", "d");
        x.aliasAttribute(DerelictShipEntityPlugin.class, "elapsed", "el");
        x.aliasAttribute(DerelictShipEntityPlugin.class, "angVel", "aV");
        x.alias("DerelictShipData", DerelictShipEntityPlugin.DerelictShipData.class);
        x.aliasAttribute(DerelictShipEntityPlugin.DerelictShipData.class, "ship", "s");
        x.aliasAttribute(DerelictShipEntityPlugin.DerelictShipData.class, "durationDays", "d");
        x.aliasAttribute(DerelictShipEntityPlugin.DerelictShipData.class, "canHaveExtraCargo", "c");
        x.alias("PerShipData", ShipRecoverySpecial.PerShipData.class);
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "condition", "c");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "variantId", "vId");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "variant", "v");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "shipName", "sN");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "addDmods", "d");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "pruneWeapons", "p");
        x.aliasAttribute(ShipRecoverySpecial.PerShipData.class, "sModProb", "sMP");
        x.alias("ShipCondition", ShipRecoverySpecial.ShipCondition.class);
        x.alias("ShipRecoverySpecialData", ShipRecoverySpecial.ShipRecoverySpecialData.class);
        x.aliasAttribute(ShipRecoverySpecial.ShipRecoverySpecialData.class, "ships", "s");
        x.aliasAttribute(ShipRecoverySpecial.ShipRecoverySpecialData.class, "desc", "d");
        x.alias("BreadcrumbSpecialData", BreadcrumbSpecial.BreadcrumbSpecialData.class);
        x.aliasAttribute(BreadcrumbSpecial.BreadcrumbSpecialData.class, "targetId", "tI");
        x.aliasAttribute(BreadcrumbSpecial.BreadcrumbSpecialData.class, "targetName", "tN");
        x.alias("DerSpecialType", DomainSurveyDerelictSpecial.SpecialType.class);
        x.alias("DomainSurveyDerelictSpecialData", DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData.class);
        x.aliasAttribute(DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData.class, "type", "t");
        x.aliasAttribute(DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData.class, "entityId", "eI");
        x.aliasAttribute(DomainSurveyDerelictSpecial.DomainSurveyDerelictSpecialData.class, "secondaryId", "sI");
        x.alias("SleeperSpecialType", SleeperPodsSpecial.SleeperSpecialType.class);
        x.alias("SleeperPodsSpecialData", SleeperPodsSpecial.SleeperPodsSpecialData.class);
        x.aliasAttribute(SleeperPodsSpecial.SleeperPodsSpecialData.class, "type", "t");
        x.aliasAttribute(SleeperPodsSpecial.SleeperPodsSpecialData.class, "officer", "o");
        x.alias("SDSpecialType", SurveyDataSpecial.SurveyDataSpecialType.class);
        x.alias("SurveyDataSpecialData", SurveyDataSpecial.SurveyDataSpecialData.class);
        x.aliasAttribute(SurveyDataSpecial.SurveyDataSpecialData.class, "type", "t");
        x.aliasAttribute(SurveyDataSpecial.SurveyDataSpecialData.class, "entityId", "eI");
        x.aliasAttribute(SurveyDataSpecial.SurveyDataSpecialData.class, "secondaryId", "sI");
        x.aliasAttribute(SurveyDataSpecial.SurveyDataSpecialData.class, "includeRuins", "r");
        x.alias("TransmitterTrapSpecialData", TransmitterTrapSpecial.TransmitterTrapSpecialData.class);
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "prob", "c");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "fleetId", "fID");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "nearbyFleetFaction", "nFF");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "useClosestFleetInRange", "uCFIR");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "useAllFleetsInRange", "uAFIR");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "params", "p");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "minRange", "min");
        x.aliasAttribute(TransmitterTrapSpecial.TransmitterTrapSpecialData.class, "maxRange", "max");
        x.alias("CargoManifestSpecialData", CargoManifestSpecial.CargoManifestSpecialData.class);
        x.aliasAttribute(CargoManifestSpecial.CargoManifestSpecialData.class, "commodityId", "c");
        x.alias("DDOv", DefenderDataOverride.class);
        x.aliasAttribute(DefenderDataOverride.class, "probDefenders", "p");
        x.aliasAttribute(DefenderDataOverride.class, "minStr", "i");
        x.aliasAttribute(DefenderDataOverride.class, "maxStr", "a");
        x.aliasAttribute(DefenderDataOverride.class, "maxDefenderSize", "d");
        x.aliasAttribute(DefenderDataOverride.class, "minDefenderSize", "m");
        x.aliasAttribute(DefenderDataOverride.class, "probStation", "t");
        x.aliasAttribute(DefenderDataOverride.class, "stationRole", "s");
        x.aliasAttribute(DefenderDataOverride.class, "defFaction", "f");
        x.alias("SeededFleetManager", SeededFleetManager.class);
        x.aliasAttribute(SeededFleetManager.class, "fleets", "f");
        x.aliasAttribute(SeededFleetManager.class, "inflateRangeLY", "iRLY");
        x.aliasAttribute(SeededFleetManager.class, "system", "s");
        x.alias("SeededFleet", SeededFleetManager.SeededFleet.class);
        x.aliasAttribute(SeededFleetManager.SeededFleet.class, "seed", "s");
        x.aliasAttribute(SeededFleetManager.SeededFleet.class, "points", "p");
        x.aliasAttribute(SeededFleetManager.SeededFleet.class, "fleet", "f");
        x.alias("RemnantSeededFleetManager", RemnantSeededFleetManager.class);
        x.aliasAttribute(RemnantSeededFleetManager.class, "minPts", "i");
        x.aliasAttribute(RemnantSeededFleetManager.class, "maxPts", "a");
        x.aliasAttribute(RemnantSeededFleetManager.class, "activeChance", "c");
        x.alias("RFICGen", RemnantSeededFleetManager.RemnantFleetInteractionConfigGen.class);
        x.alias("RSICGen", RemnantThemeGenerator.RemnantStationInteractionConfigGen.class);
        x.alias("SourceBasedFleetManager", SourceBasedFleetManager.class);
        x.aliasAttribute(SourceBasedFleetManager.class, "fleets", "f");
        x.aliasAttribute(SourceBasedFleetManager.class, "thresholdLY", "t");
        x.aliasAttribute(SourceBasedFleetManager.class, "source", "s");
        x.aliasAttribute(SourceBasedFleetManager.class, "minFleets", "i");
        x.aliasAttribute(SourceBasedFleetManager.class, "maxFleets", "a");
        x.aliasAttribute(SourceBasedFleetManager.class, "respawnDelay", "r");
        x.aliasAttribute(SourceBasedFleetManager.class, "destroyed", "d");
        x.aliasAttribute(SourceBasedFleetManager.class, "sourceLocation", "sL");
        x.alias("RemnantStationFleetManager", RemnantStationFleetManager.class);
        x.aliasAttribute(RemnantStationFleetManager.class, "minPts", "iA");
        x.aliasAttribute(RemnantStationFleetManager.class, "maxPts", "aA");
        x.aliasAttribute(RemnantStationFleetManager.class, "totalLost", "tL");
        x.alias("RemnantAssignmentAI", RemnantAssignmentAI.class);
        x.aliasAttribute(RemnantAssignmentAI.class, "homeSystem", "h");
        x.aliasAttribute(RemnantAssignmentAI.class, "fleet", "f");
        x.aliasAttribute(RemnantAssignmentAI.class, "source", "s");
        x.alias("WarningBeaconEntityPlugin", WarningBeaconEntityPlugin.class);
        x.aliasAttribute(WarningBeaconEntityPlugin.class, "phase", "p");
        x.aliasAttribute(WarningBeaconEntityPlugin.class, "freqMult", "f");
        x.aliasAttribute(WarningBeaconEntityPlugin.class, "sincePing", "s");
        x.alias("RouteManager", RouteManager.class);
        x.aliasAttribute(RouteManager.class, "routes", "r");
        x.alias("RouteData", RouteManager.RouteData.class);
        x.aliasAttribute(RouteManager.RouteData.class, "extra", "x");
        x.aliasAttribute(RouteManager.RouteData.class, "delay", "a");
        x.aliasAttribute(RouteManager.RouteData.class, "source", "o");
        x.aliasAttribute(RouteManager.RouteData.class, "market", "m");
        x.aliasAttribute(RouteManager.RouteData.class, "seed", "s");
        x.aliasAttribute(RouteManager.RouteData.class, "timestamp", "t");
        x.aliasAttribute(RouteManager.RouteData.class, "segments", "e");
        x.aliasAttribute(RouteManager.RouteData.class, "activeFleet", "f");
        x.aliasAttribute(RouteManager.RouteData.class, "daysSinceSeenByPlayer", "d");
        x.aliasAttribute(RouteManager.RouteData.class, "custom", "c");
        x.aliasAttribute(RouteManager.RouteData.class, "current", "r");
        x.aliasAttribute(RouteManager.RouteData.class, "spawner", "p");
        x.alias("RouteFleetSpawner", RouteManager.RouteFleetSpawner.class);
        x.alias("BaseRouteFleetManager", BaseRouteFleetManager.class);
        x.aliasAttribute(BaseRouteFleetManager.class, "interval", "i");
        x.alias("RuinsFleetRouteManager", RuinsFleetRouteManager.class);
        x.aliasAttribute(RuinsFleetRouteManager.class, "system", "s");
        x.alias("BaseAssignmentAI", BaseAssignmentAI.class);
        x.aliasAttribute(BaseAssignmentAI.class, "capTracker", "cT");
        x.aliasAttribute(BaseAssignmentAI.class, "buildTracker", "bT");
        x.alias("RouteFleetAssignmentAI", RouteFleetAssignmentAI.class);
        x.aliasAttribute(RouteFleetAssignmentAI.class, "gaveReturnAssignments", "gRA");
        x.alias("ScavengerFleetAssignmentAI", ScavengerFleetAssignmentAI.class);
        x.alias("DistressCallNormalAssignmentAI", DistressCallNormalAssignmentAI.class);
        x.alias("DistressCallPirateAmbushAssignmentAI", DistressCallPirateAmbushAssignmentAI.class);
        x.alias("DistressCallPirateAmbushTrapAssignmentAI", DistressCallPirateAmbushTrapAssignmentAI.class);
        x.alias("DistressCallResponsePirateAssignmentAI", DistressCallResponsePirateAssignmentAI.class);
        x.alias("DistressCallResponseAssignmentAI", DistressCallResponseAssignmentAI.class);
        x.alias("TutorialLeashAssignmentAI", TutorialLeashAssignmentAI.class);
        x.alias("DistressResponseData", DistressCallAbility.DistressResponseData.class);
        x.alias("NESpawnData", NearbyEventsEvent.NESpawnData.class);
        x.alias("OptionalFleetData", RouteManager.OptionalFleetData.class);
        x.aliasAttribute(RouteManager.OptionalFleetData.class, "strength", "s");
        x.aliasAttribute(RouteManager.OptionalFleetData.class, "quality", "q");
        x.aliasAttribute(RouteManager.OptionalFleetData.class, "factionId", "f");
        x.aliasAttribute(RouteManager.OptionalFleetData.class, "fleetType", "t");
        x.aliasAttribute(RouteManager.OptionalFleetData.class, "damage", "d");
        x.aliasAttribute(BaseAssignmentAI.class, "fleet", "f");
        x.aliasAttribute(BaseAssignmentAI.class, "done", "d");
        x.aliasAttribute(RouteFleetAssignmentAI.class, "route", "r");
        x.aliasAttribute(ScavengerFleetAssignmentAI.class, "pirate", "p");
        x.aliasAttribute(ScavengerFleetAssignmentAI.class, "piracyCheck", "pC");
        x.aliasAttribute(DistressCallNormalAssignmentAI.class, "system", "s");
        x.aliasAttribute(DistressCallNormalAssignmentAI.class, "jumpPoint", "jP");
        x.aliasAttribute(DistressCallNormalAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(DistressCallNormalAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(DistressCallNormalAssignmentAI.class, "contactedPlayer", "cP");
        x.aliasAttribute(DistressCallPirateAmbushAssignmentAI.class, "system", "s");
        x.aliasAttribute(DistressCallPirateAmbushAssignmentAI.class, "jumpPoint", "jP");
        x.aliasAttribute(DistressCallPirateAmbushAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(DistressCallPirateAmbushAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(DistressCallPirateAmbushTrapAssignmentAI.class, "system", "s");
        x.aliasAttribute(DistressCallPirateAmbushTrapAssignmentAI.class, "jumpPoint", "jP");
        x.aliasAttribute(DistressCallPirateAmbushTrapAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(DistressCallPirateAmbushTrapAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "system", "s");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "contactedPlayer", "cP");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "inner", "i");
        x.aliasAttribute(DistressCallResponsePirateAssignmentAI.class, "outer", "o");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "system", "s");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "contactedPlayer", "cP");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "inner", "i");
        x.aliasAttribute(DistressCallResponseAssignmentAI.class, "outer", "o");
        x.aliasAttribute(TutorialLeashAssignmentAI.class, "system", "s");
        x.aliasAttribute(TutorialLeashAssignmentAI.class, "jumpPoint", "jP");
        x.aliasAttribute(TutorialLeashAssignmentAI.class, "elapsed", "e");
        x.aliasAttribute(TutorialLeashAssignmentAI.class, "dur", "dur");
        x.aliasAttribute(TutorialLeashAssignmentAI.class, "toGuard", "tG");
        x.alias("RtSeg", RouteManager.RouteSegment.class);
        x.aliasAttribute(RouteManager.RouteSegment.class, "id", "i");
        x.aliasAttribute(RouteManager.RouteSegment.class, "elapsed", "e");
        x.aliasAttribute(RouteManager.RouteSegment.class, "daysMax", "d");
        x.aliasAttribute(RouteManager.RouteSegment.class, "from", "f");
        x.aliasAttribute(RouteManager.RouteSegment.class, "to", "t");
        x.alias("TowCable", TowCable.class);
        x.alias("TowCableBuff", TowCable.TowCableBuff.class);
        x.aliasAttribute(TowCable.TowCableBuff.class, "buffId", "b");
        x.aliasAttribute(TowCable.TowCableBuff.class, "frames", "f");
        x.alias("TowCable", TowCable.class);
        x.alias("BaseEventPlugin", BaseEventPlugin.class);
        x.aliasAttribute(BaseEventPlugin.class, "id", "id");
        x.aliasAttribute(BaseEventPlugin.class, "eventType", "eTp");
        x.aliasAttribute(BaseEventPlugin.class, "eventTarget", "eTg");
        x.aliasAttribute(BaseEventPlugin.class, "market", "mk");
        x.aliasAttribute(BaseEventPlugin.class, "entity", "en");
        x.aliasAttribute(BaseEventPlugin.class, "faction", "fa");
        x.aliasAttribute(BaseEventPlugin.class, "statModId", "sMI");
        x.aliasAttribute(BaseEventPlugin.class, "started", "st");
        x.aliasAttribute(BaseEventPlugin.class, "memory", "mem");
        x.aliasAttribute(BaseEventPlugin.class, "startProbability", "sP");
        x.alias("MissionCompletionRep", CoreReputationPlugin.MissionCompletionRep.class);
        x.aliasAttribute(CoreReputationPlugin.MissionCompletionRep.class, "successDelta", "sD");
        x.aliasAttribute(CoreReputationPlugin.MissionCompletionRep.class, "successLimit", "sL");
        x.aliasAttribute(CoreReputationPlugin.MissionCompletionRep.class, "failureDelta", "fD");
        x.aliasAttribute(CoreReputationPlugin.MissionCompletionRep.class, "failureLimit", "fL");
        x.alias("NearbyEventsEvent", NearbyEventsEvent.class);
        x.aliasAttribute(NearbyEventsEvent.class, "derelictShipInterval", "dSI");
        x.aliasAttribute(NearbyEventsEvent.class, "distressCallInterval", "dCI");
        x.aliasAttribute(NearbyEventsEvent.class, "skipForDistressCalls", "sFDC");
        x.alias("CargoPodsEntityPlugin", CargoPodsEntityPlugin.class);
        x.aliasAttribute(CargoPodsEntityPlugin.class, "elapsed", "el");
        x.aliasAttribute(CargoPodsEntityPlugin.class, "maxDays", "mD");
        x.aliasAttribute(CargoPodsEntityPlugin.class, "extraDays", "eD");
        x.aliasAttribute(CargoPodsEntityPlugin.class, "neverExpire", "nE");
        x.alias("DistressCallAbility", DistressCallAbility.class);
        x.aliasAttribute(DistressCallAbility.class, "performed", "p");
        x.aliasAttribute(DistressCallAbility.class, "numTimesUsed", "nTU");
        x.aliasAttribute(DistressCallAbility.class, "lastUsed", "lU");
        x.aliasAttribute(DistressCallAbility.class, "uses", "u");
        x.alias("AbilityUseData", DistressCallAbility.AbilityUseData.class);
        x.aliasAttribute(DistressCallAbility.AbilityUseData.class, "timestamp", "t");
        x.aliasAttribute(DistressCallAbility.AbilityUseData.class, "location", "l");
        x.alias("DistressCallOutcome", DistressCallAbility.DistressCallOutcome.class);
        x.alias("DelayedActionScript", DelayedActionScript.class);
        x.aliasAttribute(DelayedActionScript.class, "daysLeft", "dL");
        x.aliasAttribute(DelayedActionScript.class, "done", "d");
        x.alias("GalatiaMarketScript", GalatiaMarketScript.class);
        x.aliasAttribute(GalatiaMarketScript.class, "market", "m");
        x.aliasAttribute(GalatiaMarketScript.class, "interval", "i");
        x.alias("CampaignTutorialStage", CampaignTutorialScript.CampaignTutorialStage.class);
        x.alias("CampaignTutorialScript", CampaignTutorialScript.class);
        x.aliasAttribute(CampaignTutorialScript.class, "askedPlayerToSave", "aPTS");
        x.aliasAttribute(CampaignTutorialScript.class, "playerSaved", "pS");
        x.aliasAttribute(CampaignTutorialScript.class, "elapsed", "e");
        x.aliasAttribute(CampaignTutorialScript.class, "lastCheckDistToAncyra", "lCDTA");
        x.aliasAttribute(CampaignTutorialScript.class, "system", "s");
        x.aliasAttribute(CampaignTutorialScript.class, "ancyra", "a");
        x.aliasAttribute(CampaignTutorialScript.class, "derinkuyu", "d");
        x.aliasAttribute(CampaignTutorialScript.class, "stage", "st");
        x.aliasAttribute(CampaignTutorialScript.class, "orbitalResetDone", "oRD");
        x.aliasAttribute(CampaignTutorialScript.class, "debrisField", "dF");
        x.aliasAttribute(CampaignTutorialScript.class, "pirateFleet", "pF");
        x.aliasAttribute(CampaignTutorialScript.class, "detachment", "det");
        x.aliasAttribute(CampaignTutorialScript.class, "intel", "i");
        x.alias("TutorialMissionIntel", TutorialMissionIntel.class);
        x.alias("TutorialMissionStage", TutorialMissionEvent.TutorialMissionStage.class);
        x.alias("RogueMinerMiscFleetManager", RogueMinerMiscFleetManager.class);
        x.alias("SaveNagScript", SaveNagScript.class);
        x.alias("ExSalv", BaseSalvageSpecial.ExtraSalvage.class);
        x.aliasAttribute(BaseSalvageSpecial.ExtraSalvage.class, "cargo", "c");
        x.alias("SpID", SpecialItemData.class);
        x.aliasAttribute(SpecialItemData.class, "id", "i");
        x.aliasAttribute(SpecialItemData.class, "data", "d");
        x.alias("BaseGenericPlugin", BaseGenericPlugin.class);
        x.alias("SalvageDefenderModificationPluginImpl", SalvageGenFromSeed.SalvageDefenderModificationPluginImpl.class);
        x.alias("PKDefenderPluginImpl", PKDefenderPluginImpl.class);
        x.alias("CampaignPingSpec", CampaignPingSpec.class);
        x.aliasAttribute(CampaignPingSpec.class, "id", "id");
        x.aliasAttribute(CampaignPingSpec.class, "sounds", "s");
        x.aliasAttribute(CampaignPingSpec.class, "color", "c");
        x.aliasAttribute(CampaignPingSpec.class, "minRange", "mR");
        x.aliasAttribute(CampaignPingSpec.class, "range", "r");
        x.aliasAttribute(CampaignPingSpec.class, "duration", "d");
        x.aliasAttribute(CampaignPingSpec.class, "delay", "de");
        x.aliasAttribute(CampaignPingSpec.class, "width", "w");
        x.aliasAttribute(CampaignPingSpec.class, "alphaMult", "aM");
        x.aliasAttribute(CampaignPingSpec.class, "inFraction", "iF");
        x.aliasAttribute(CampaignPingSpec.class, "useFactionColor", "uFC");
        x.aliasAttribute(CampaignPingSpec.class, "invert", "i");
        x.aliasAttribute(CampaignPingSpec.class, "num", "n");
        x.alias("ERDat", EconomyFleetAssignmentAI.EconomyRouteData.class);
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "cargoCap", "c");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "fuelCap", "f");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "personnelCap", "p");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "size", "s");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "smuggling", "m");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "from", "r");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "to", "t");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "cargoDeliver", "d");
        x.aliasAttribute(EconomyFleetAssignmentAI.EconomyRouteData.class, "cargoReturn", "u");
        x.alias("CQD", EconomyFleetAssignmentAI.CargoQuantityData.class);
        x.aliasAttribute(EconomyFleetAssignmentAI.CargoQuantityData.class, "cargo", "c");
        x.aliasAttribute(EconomyFleetAssignmentAI.CargoQuantityData.class, "units", "u");
        x.alias("CommRelayEP", CommRelayEntityPlugin.class);
        x.alias("NavBuoyEP", NavBuoyEntityPlugin.class);
        x.alias("SensorArrayEP", SensorArrayEntityPlugin.class);
        x.alias("PopulationAndInfrastructure", PopulationAndInfrastructure.class);
        x.aliasAttribute(BaseIndustry.class, "supply", "s");
        x.aliasAttribute(BaseIndustry.class, "demand", "d");
        x.aliasAttribute(BaseIndustry.class, "income", "i");
        x.aliasAttribute(BaseIndustry.class, "upkeep", "u");
        x.aliasAttribute(BaseIndustry.class, "market", "m");
        x.aliasAttribute(BaseIndustry.class, "id", "id");
        x.aliasAttribute(BaseIndustry.class, "buildProgress", "bP");
        x.aliasAttribute(BaseIndustry.class, "building", "b");
        x.aliasAttribute(BaseIndustry.class, "upgradeId", "uI");
        x.aliasAttribute(BaseIndustry.class, "aiCoreId", "aCI");
        x.aliasAttribute(BaseIndustry.class, "demandReduction", "dR");
        x.aliasAttribute(BaseIndustry.class, "supplyBonus", "sB");
        x.aliasAttribute(BaseIndustry.class, "wasDisrupted", "wD");
        x.alias("DFInfl", DefaultFleetInflater.class);
        x.alias("DFInflP", DefaultFleetInflaterParams.class);
        x.aliasAttribute(DefaultFleetInflaterParams.class, "seed", "s");
        x.aliasAttribute(DefaultFleetInflaterParams.class, "timestamp", "t");
        x.aliasAttribute(DefaultFleetInflaterParams.class, "persistent", "p");
        x.aliasAttribute(DefaultFleetInflaterParams.class, "quality", "q");
        x.aliasAttribute(DefaultFleetInflaterParams.class, "mode", "m");
        x.alias("MilRespScr", MilitaryResponseScript.class);
        x.aliasAttribute(MilitaryResponseScript.class, "tracker", "t");
        x.aliasAttribute(MilitaryResponseScript.class, "params", "p");
        x.aliasAttribute(MilitaryResponseScript.class, "elapsed", "e");
        x.alias("MilRespP", MilitaryResponseScript.MilitaryResponseParams.class);
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "type", "t");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "responseReason", "rR");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "faction", "f");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "actor", "a");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "target", "t");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "responseFraction", "rF");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "responseDuration", "rD");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "travelText", "tT");
        x.aliasAttribute(MilitaryResponseScript.MilitaryResponseParams.class, "actionText", "aT");
        x.alias("BaseMarketConditionPlugin", BaseMarketConditionPlugin.class);
        x.aliasAttribute(BaseMarketConditionPlugin.class, "market", "m");
        x.aliasAttribute(BaseMarketConditionPlugin.class, "condition", "c");
        x.alias("ResourceDepositsMC", ResourceDepositsCondition.class);
        x.alias("LuddicPathCells", LuddicPathCells.class);
        x.aliasAttribute(LuddicPathCells.class, "intel", "i");
        x.alias("LuddicPathCellsIntel", LuddicPathCellsIntel.class);
        x.aliasAttribute(LuddicPathCellsIntel.class, "sleeper", "s");
        x.aliasAttribute(LuddicPathCellsIntel.class, "sleeperTimeout", "sT");
        x.aliasAttribute(LuddicPathCellsIntel.class, "market", "m");
        x.aliasAttribute(LuddicPathCellsIntel.class, "incidentTracker", "iT");
        x.aliasAttribute(LuddicPathCellsIntel.class, "random", "r");
        x.aliasAttribute(LuddicPathCellsIntel.class, "numIncidentAttempts", "nIA");
        x.aliasAttribute(LuddicPathCellsIntel.class, "incidentDelay", "iD");
        x.aliasAttribute(LuddicPathCellsIntel.class, "incidentType", "iTy");
        x.aliasAttribute(LuddicPathCellsIntel.class, "smuggler", "sm");
        x.aliasAttribute(LuddicPathCellsIntel.class, "prevIncident", "pI");
        x.aliasAttribute(LuddicPathCellsIntel.class, "sincePrevIncident", "sPI");
        x.aliasAttribute(LuddicPathCellsIntel.class, "prevIncidentData", "pID");
        x.aliasAttribute(LuddicPathCellsIntel.class, "inertiaTime", "iTi");
        x.alias("Spaceport", Spaceport.class);
        x.alias("Mining", Mining.class);
        x.alias("GroundDefenses", GroundDefenses.class);
        x.alias("Refining", Refining.class);
        x.alias("MilitaryBase", MilitaryBase.class);
        x.alias("Farming", Farming.class);
        x.alias("LightIndustry", LightIndustry.class);
        x.alias("FuelProduction", FuelProduction.class);
        x.alias("HeavyIndustry", HeavyIndustry.class);
        x.alias("PlanetaryShield", PlanetaryShield.class);
        x.alias("TechMining", TechMining.class);
        x.alias("TradeCenter", com.fs.starfarer.api.impl.campaign.econ.TradeCenter.class);
        x.alias("LionsGuardHQ", LionsGuardHQ.class);
        x.alias("Waystation", Waystation.class);
        x.alias("Cryosanctum", Cryosanctum.class);
        x.alias("Cryorevival", Cryorevival.class);
        x.alias("TradeCenter2", TradeCenter.class);
        x.alias("OrbitalStation", OrbitalStation.class);
        x.aliasAttribute(OrbitalStation.class, "stationFleet", "sF");
        x.aliasAttribute(OrbitalStation.class, "usingExistingStation", "uES");
        x.aliasAttribute(OrbitalStation.class, "stationEntity", "sE");
        x.alias("EconomyFleetAssignmentAI", EconomyFleetAssignmentAI.class);
        x.aliasAttribute(EconomyFleetAssignmentAI.class, "origFaction", "oF");
        x.aliasAttribute(EconomyFleetAssignmentAI.class, "factionChangeTracker", "fCT");
        x.alias("MercAssignmentAIV2", MercAssignmentAIV2.class);
        x.alias("PatrolAssignmentAIV4", PatrolAssignmentAIV4.class);
        x.alias("DisposableAggroAssignmentAI", DisposableAggroAssignmentAI.class);
        x.alias("DisposableFleetManager", DisposableFleetManager.class);
        x.alias("DisposablePirateFleetManager", DisposablePirateFleetManager.class);
        x.alias("DisposableLuddicPathFleetManager", DisposableLuddicPathFleetManager.class);
        x.alias("PirateBaseIntel", PirateBaseIntel.class);
        x.aliasAttribute(PirateBaseIntel.class, "system", "s");
        x.aliasAttribute(PirateBaseIntel.class, "market", "m");
        x.aliasAttribute(PirateBaseIntel.class, "entity", "e");
        x.aliasAttribute(PirateBaseIntel.class, "elapsedDays", "eD");
        x.aliasAttribute(PirateBaseIntel.class, "duration", "d");
        x.aliasAttribute(PirateBaseIntel.class, "bountyData", "bD");
        x.aliasAttribute(PirateBaseIntel.class, "tier", "t");
        x.aliasAttribute(PirateBaseIntel.class, "matchedStationToTier", "mSTT");
        x.aliasAttribute(PirateBaseIntel.class, "monthlyInterval", "mI");
        x.aliasAttribute(PirateBaseIntel.class, "raidTimeoutMonths", "rTM");
        x.alias("BaseBountyData", PirateBaseIntel.BaseBountyData.class);
        x.aliasAttribute(PirateBaseIntel.BaseBountyData.class, "bountyElapsedDays", "bED");
        x.aliasAttribute(PirateBaseIntel.BaseBountyData.class, "bountyDuration", "bD");
        x.aliasAttribute(PirateBaseIntel.BaseBountyData.class, "baseBounty", "bB");
        x.aliasAttribute(PirateBaseIntel.BaseBountyData.class, "repChange", "rC");
        x.aliasAttribute(PirateBaseIntel.BaseBountyData.class, "bountyFaction", "bF");
        x.alias("LuddicPathBaseIntel", LuddicPathBaseIntel.class);
        x.aliasAttribute(LuddicPathBaseIntel.class, "system", "s");
        x.aliasAttribute(LuddicPathBaseIntel.class, "market", "m");
        x.aliasAttribute(LuddicPathBaseIntel.class, "entity", "e");
        x.aliasAttribute(LuddicPathBaseIntel.class, "elapsedDays", "eD");
        x.aliasAttribute(LuddicPathBaseIntel.class, "duration", "d");
        x.aliasAttribute(LuddicPathBaseIntel.class, "bountyData", "bD");
        x.aliasAttribute(LuddicPathBaseIntel.class, "monthlyInterval", "mI");
        x.aliasAttribute(LuddicPathBaseIntel.class, "monthsNoBounty", "mNB");
        x.aliasAttribute(LuddicPathBaseIntel.class, "large", "l");
        x.aliasAttribute(LuddicPathBaseIntel.class, "random", "r");
        x.alias("PirateActivity", PirateActivity.class);
        x.aliasAttribute(PirateActivity.class, "intel", "i");
        x.alias("PirateActivityIntel", PirateActivityIntel.class);
        x.aliasAttribute(PirateActivityIntel.class, "system", "sy");
        x.aliasAttribute(PirateActivityIntel.class, "source", "so");
        x.alias("LocalResourcesSubmarketPlugin", LocalResourcesSubmarketPlugin.class);
        x.alias("CryosleeperEntityPlugin", CryosleeperEntityPlugin.class);
        x.alias("BaseIntelPlugin", BaseIntelPlugin.class);
        x.aliasAttribute(BaseIntelPlugin.class, "important", "ii");
        x.aliasAttribute(BaseIntelPlugin.class, "timestamp", "tt");
        x.aliasAttribute(BaseIntelPlugin.class, "neverClicked", "nC");
        x.aliasAttribute(BaseIntelPlugin.class, "ended", "ended");
        x.aliasAttribute(BaseIntelPlugin.class, "ending", "ending");
        x.aliasAttribute(BaseIntelPlugin.class, "endingTimeRemaining", "eTR");
        x.aliasAttribute(BaseIntelPlugin.class, "postingLocation", "pLoc");
        x.aliasAttribute(BaseIntelPlugin.class, "postingRangeLY", "pRange");
        x.alias("BaseMissionIntel", BaseMissionIntel.class);
        x.aliasAttribute(BaseMissionIntel.class, "randomCancel", "rC");
        x.aliasAttribute(BaseMissionIntel.class, "randomCancelProb", "rCP");
        x.aliasAttribute(BaseMissionIntel.class, "missionResult", "mR");
        x.aliasAttribute(BaseMissionIntel.class, "missionState", "mS");
        x.aliasAttribute(BaseMissionIntel.class, "duration", "dur");
        x.aliasAttribute(BaseMissionIntel.class, "elapsedDays", "eD");
        x.alias("MissionResult", BaseMissionIntel.MissionResult.class);
        x.alias("PersonBountyIntel", PersonBountyIntel.class);
        x.alias("SystemBountyIntel", SystemBountyIntel.class);
        x.alias("TradeFleetDepartureIntel", TradeFleetDepartureIntel.class);
        x.alias("FactionHostilityIntel", FactionHostilityIntel.class);
        x.alias("ProcurementMissionIntel", ProcurementMissionIntel.class);
        x.alias("SurveyPlanetMissionIntel", SurveyPlanetMissionIntel.class);
        x.alias("AnalyzeEntityMissionIntel", AnalyzeEntityMissionIntel.class);
        x.alias("ProcurementMissionCreator", ProcurementMissionCreator.class);
        x.alias("AnalyzeEntityIntelCreator", AnalyzeEntityIntelCreator.class);
        x.alias("SurveyPlanetIntelCreator", SurveyPlanetIntelCreator.class);
        x.alias("DeliveryMissionIntel", DeliveryMissionIntel.class);
        x.alias("CoreDiscoverEntityPlugin", CoreDiscoverEntityPlugin.class);
        x.alias("CoreBuildObjectiveTypePicker", CoreBuildObjectiveTypePicker.class);
        x.alias("MonthlyReport", MonthlyReport.class);
        x.alias("FDNode", MonthlyReport.FDNode.class);
        x.aliasAttribute(MonthlyReport.FDNode.class, "children", "c");
        x.aliasAttribute(MonthlyReport.FDNode.class, "parent", "p");
        x.aliasAttribute(MonthlyReport.FDNode.class, "name", "n");
        x.aliasAttribute(MonthlyReport.FDNode.class, "icon", "i");
        x.aliasAttribute(MonthlyReport.FDNode.class, "income", "in");
        x.aliasAttribute(MonthlyReport.FDNode.class, "upkeep", "up");
        x.aliasAttribute(MonthlyReport.FDNode.class, "totalIncome", "tI");
        x.aliasAttribute(MonthlyReport.FDNode.class, "totalUpkeep", "tU");
        x.aliasAttribute(MonthlyReport.FDNode.class, "custom", "c1");
        x.aliasAttribute(MonthlyReport.FDNode.class, "custom2", "c2");
        x.aliasAttribute(MonthlyReport.FDNode.class, "mapEntity", "mE");
        x.aliasAttribute(MonthlyReport.FDNode.class, "tooltipCreator", "tC");
        x.aliasAttribute(MonthlyReport.FDNode.class, "tooltipParam", "tP");
        x.alias("MonthlyReportNodeTooltipCreator", MonthlyReportNodeTooltipCreator.class);
        x.alias("GalatianAcademyStipend", GalatianAcademyStipend.class);
        x.alias("WarSimScript", WarSimScript.class);
        x.alias("PersonBountyManager", PersonBountyManager.class);
        x.alias("SystemBountyManager", SystemBountyManager.class);
        x.alias("PirateBaseManager", PirateBaseManager.class);
        x.alias("PlayerRelatedPirateBaseManager", PlayerRelatedPirateBaseManager.class);
        x.alias("LuddicPathBaseManager", LuddicPathBaseManager.class);
        x.alias("HegemonyInspectionManager", HegemonyInspectionManager.class);
        x.alias("DecivTracker", DecivTracker.class);
        x.alias("MarketDecivData", DecivTracker.MarketDecivData.class);
        x.aliasAttribute(DecivTracker.MarketDecivData.class, "market", "m");
        x.aliasAttribute(DecivTracker.MarketDecivData.class, "stabilityHistory", "sH");
        x.alias("FactionHostilityManager", FactionHostilityManager.class);
        x.alias("FactionHostilityIntel", FactionHostilityIntel.class);
        x.alias("GenericMissionManager", GenericMissionManager.class);
        x.alias("PortsideBarData", PortsideBarData.class);
        x.alias("BarEventManager", BarEventManager.class);
        x.alias("PirateBaseRumorBarEvent", PirateBaseRumorBarEvent.class);
        x.alias("LuddicFarmerBarEvent", LuddicFarmerBarEvent.class);
        x.alias("LuddicFarmerBarEventCreator", LuddicFarmerBarEventCreator.class);
        x.alias("TriTachLoanBarEvent", TriTachLoanBarEvent.class);
        x.alias("TriTachLoanBarEventCreator", TriTachLoanBarEventCreator.class);
        x.alias("MercsOnTheRunBarEvent", MercsOnTheRunBarEvent.class);
        x.alias("MercsOnTheRunBarEventCreator", MercsOnTheRunBarEventCreator.class);
        x.alias("LuddicCraftBarEvent", LuddicCraftBarEvent.class);
        x.alias("LuddicCraftBarEventCreator", LuddicCraftBarEventCreator.class);
        x.alias("ScientistAICoreBarEvent", ScientistAICoreBarEvent.class);
        x.alias("ScientistAICoreBarEventCreator", ScientistAICoreBarEventCreator.class);
        x.alias("QuartermasterCargoSwapBarEvent", QuartermasterCargoSwapBarEvent.class);
        x.alias("QuartermasterCargoSwapBarEventCreator", QuartermasterCargoSwapBarEventCreator.class);
        x.alias("CorruptPLClerkSuppliesBarEvent", CorruptPLClerkSuppliesBarEvent.class);
        x.alias("CorruptPLClerkSuppliesBarEventCreator", CorruptPLClerkSuppliesBarEventCreator.class);
        x.alias("DiktatLobsterBarEvent", DiktatLobsterBarEvent.class);
        x.alias("DiktatLobsterBarEventCreator", DiktatLobsterBarEventCreator.class);
        x.alias("DeliveryBarEvent", DeliveryBarEvent.class);
        x.alias("DeliveryBarEventCreator", DeliveryBarEventCreator.class);
        x.alias("TriTachMajorLoanBarEvent", TriTachMajorLoanBarEvent.class);
        x.alias("TriTachMajorLoanBarEventCreator", TriTachMajorLoanBarEventCreator.class);
        x.alias("TriTachLoanIncentiveScript", TriTachLoanIncentiveScript.class);
        x.alias("DeliveryFailureConsequences", DeliveryFailureConsequences.class);
        x.alias("EconomyFleetRouteManager", EconomyFleetRouteManager.class);
        x.alias("ShippingDisruption", ShippingDisruption.class);
        x.alias("DistressCallIntel", DistressCallIntel.class);
        x.alias("HyperStormBoost", HyperStormBoost.class);
        x.alias("AsteroidImpact", AsteroidImpact.class);
        x.alias("CoronalTapParticleScript", CoronalTapParticleScript.class);
        x.alias("CargoPodsResponse", CargoPodsResponse.class);
        x.alias("GateData", GateEntityPlugin.GateData.class);
        x.alias("GateEntityPlugin", GateEntityPlugin.class);
        x.aliasAttribute(GateEntityPlugin.class, "beingUsedFader", "bUF");
        x.aliasAttribute(GateEntityPlugin.class, "glowFader", "gF");
        x.aliasAttribute(GateEntityPlugin.class, "madeActive", "mA");
        x.aliasAttribute(GateEntityPlugin.class, "addedIntel", "aI");
        x.aliasAttribute(GateEntityPlugin.class, "showBeingUsedDur", "sBUD");
        x.aliasAttribute(GateEntityPlugin.class, "accumulatedTransitDistLY", "aTDLY");
        x.aliasAttribute(GateEntityPlugin.class, "inUseAngle", "iUA");
        x.alias("BaseMissionHub", BaseMissionHub.class);
        x.aliasAttribute(BaseMissionHub.class, "timeout", "to");
        x.aliasAttribute(BaseMissionHub.class, "recentlyAcceptedTimeout", "rAT");
        x.aliasAttribute(BaseMissionHub.class, "creators", "cr");
        x.aliasAttribute(BaseMissionHub.class, "person", "p");
        x.aliasAttribute(BaseMissionHub.class, "seed", "seed");
        x.aliasAttribute(BaseMissionHub.class, "lastUpdated", "lU");
        x.aliasAttribute(BaseMissionHub.class, "lastUpdatedSeeds", "lUS");
        x.aliasAttribute(BaseMissionHub.class, "daysSinceLastUpdate", "dSLU");
        x.alias("BaseHubMissionCreator", BaseHubMissionCreator.class);
        x.aliasAttribute(BaseHubMissionCreator.class, "numCompleted", "nC");
        x.aliasAttribute(BaseHubMissionCreator.class, "numFailed", "nF");
        x.aliasAttribute(BaseHubMissionCreator.class, "seed", "seed");
        x.aliasAttribute(BaseHubMissionCreator.class, "specId", "sId");
        x.aliasAttribute(BaseHubMissionCreator.class, "wasAutoAdded", "wA");
        x.aliasAttribute(BaseHubMissionCreator.class, "isActive", "iA");
        x.alias("BlueprintSpecialData", BlueprintSpecial.BlueprintSpecialData.class);
        x.alias("HubMissionWithTriggers", HubMissionWithTriggers.class);
        x.alias("BaseHubMission", BaseHubMission.class);
        x.alias("GateIntel", GateIntel.class);
        x.alias("BreadcrumbIntel", BreadcrumbIntel.class);
        x.alias("BreadcrumbIntelV2", BreadcrumbIntelV2.class);
        x.alias("WarningBeaconIntel", WarningBeaconIntel.class);
        x.alias("DelayedFleetEncounter", DelayedFleetEncounter.class);
        x.alias("MissionTrigger", MissionTrigger.class);
        x.alias("PunitiveExpeditionManager", PunitiveExpeditionManager.class);
        x.alias("PunExData", PunitiveExpeditionManager.PunExData.class);
        x.alias("LuddicPathBaseBarEvent", LuddicPathBaseBarEvent.class);
        x.alias("HubMissionBarEventWrapper", HubMissionBarEventWrapper.class);
        x.alias("HistorianBarEvent", HistorianBarEvent.class);
        x.alias("RemnantNexusIntel", RemnantNexusIntel.class);
        x.alias("SalvorsTallyIntel", SalvorsTallyIntel.class);
        x.alias("CryosleeperIntel", CryosleeperIntel.class);
        x.alias("HypershuntIntel", HypershuntIntel.class);
        x.alias("SimUpdateIntel", SimUpdateIntel.class);
        x.alias("CargoPodsIntel", CargoPodsIntel.class);
        x.alias("WormholeIntel", WormholeIntel.class);
        x.alias("SpecBarEventCreator", SpecBarEventCreator.class);
        x.aliasAttribute(SpecBarEventCreator.class, "specId", "sId");
        x.aliasAttribute(SpecBarEventCreator.class, "wasAutoAdded", "wAA");
        x.alias("PlanetaryShieldBarEventCreator", PlanetaryShieldBarEventCreator.class);
        x.alias("HistorianBarEventCreator", HistorianBarEventCreator.class);
        x.alias("PLTextEntry", PLTextEntry.class);
        x.aliasAttribute(PLTextEntry.class, "text", "text");
        x.aliasAttribute(PLTextEntry.class, "timestamp", "ts");
        x.alias("PLStatLevel", PLStatLevel.class);
        x.alias("PLStatCredits", PLStatCredits.class);
        x.alias("PLStatFleet", PLStatFleet.class);
        x.alias("PLStatSupplies", PLStatSupplies.class);
        x.alias("PLStatFuel", PLStatFuel.class);
        x.alias("PLStatCargo", PLStatCargo.class);
        x.alias("PLStatCrew", PLStatCrew.class);
        x.alias("PLStatMarines", PLStatMarines.class);
        x.alias("PLStatColonies", PLStatColonies.class);
        x.alias("PlaythroughLog", PlaythroughLog.class);
        x.alias("BaseCustomBounty", BaseCustomBounty.class);
        x.alias("AggregateBountyData", BaseCustomBounty.AggregateBountyData.class);
        x.alias("HistorianData", HistorianData.class);
        x.alias("DonationOfferCreator", DonationOfferCreator.class);
        x.alias("ShipBlueprintOfferCreator", ShipBlueprintOfferCreator.class);
        x.alias("WeaponBlueprintOfferCreator", WeaponBlueprintOfferCreator.class);
        x.alias("FighterBlueprintOfferCreator", FighterBlueprintOfferCreator.class);
        x.alias("SpecialItemOfferCreator", SpecialItemOfferCreator.class);
        x.alias("StageConnection", BaseHubMission.StageConnection.class);
        x.alias("DecivIntel", DecivIntel.class);
        x.alias("PlayerFleetPersonnelTracker", PlayerFleetPersonnelTracker.class);
        x.alias("ContactIntel", ContactIntel.class);
        x.alias("ProductionReportIntel", ProductionReportIntel.class);
        x.alias("AdminData", AdminData.class);
        x.alias("FieldRepairsScript", FieldRepairsScript.class);
        x.alias("CommSnifferIntel", CommSnifferIntel.class);
        x.alias("PersonalFleetHoracioCaden", PersonalFleetHoracioCaden.class);
        x.alias("PersonalFleetOxanaHyder", PersonalFleetOxanaHyder.class);
        x.alias("MiscFleetRouteManager", MiscFleetRouteManager.class);
        x.alias("EncounterManager", EncounterManager.class);
        x.alias("AddedStream", SlipstreamManager.AddedStream.class);
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "terrain", "tn");
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "plugin", "p");
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "from", "f");
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "to", "t");
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "control", "c");
        x.aliasAttribute(SlipstreamManager.AddedStream.class, "timestamp", "ts");
        x.alias("FactionCommissionIntel", FactionCommissionIntel.class);
        x.alias("FCI-RepChangeData", FactionCommissionIntel.RepChangeData.class);
        x.alias("WeaponBlueprintOffer", WeaponBlueprintOffer.class);
        x.alias("HostileActivityEventIntel", HostileActivityEventIntel.class);
        x.alias("ScientistAICoreIntel", ScientistAICoreIntel.class);
        x.alias("GAAtTheGates", GAAtTheGates.class);
        x.alias("GATransverseJump", GATransverseJump.class);
        x.alias("LuddicShrineIntel", LuddicShrineIntel.class);
        x.alias("HyperspaceTopographyEventIntel", LuddicShrineIntel.class);
        x.alias("DisposableHostileActivityFleetManager", DisposableHostileActivityFleetManager.class);
        x.alias("TopographicDataSpecialData", TopographicDataSpecial.TopographicDataSpecialData.class);
        x.aliasAttribute(TopographicDataSpecial.TopographicDataSpecialData.class, "points", "p");
        x.alias("ZigLeashAssignmentAI", ZigLeashAssignmentAI.class);
        x.alias("ZigFIDConfig", TTBlackSite.ZigFIDConfig.class);
        x.alias("ShipQuality", ShipQuality.class);
        x.alias("TriggerFleetAssignmentAI", TriggerFleetAssignmentAI.class);
        x.alias("MissionFleetAutoDespawn", MissionFleetAutoDespawn.class);
        x.alias("BHM-DefeatTriggerAdded", BaseHubMission.DefeatTriggerAdded.class);
        x.alias("BHM-MakeNonStoryCriticalAction", HubMissionWithTriggers.MakeNonStoryCriticalAction.class);
        x.alias("BHM-SetFleetFlagAction", HubMissionWithTriggers.SetFleetFlagAction.class);
        x.alias("BHM-StageData", BaseHubMission.StageData.class);
        x.alias("BHM-ImportanceData", BaseHubMission.ImportanceData.class);
        x.alias("BHM-VS", BaseHubMission.VariableSet.class);
        x.alias("BaseEventIntel", BaseEventIntel.class);
        x.alias("BEI-EventStageData", BaseEventIntel.EventStageData.class);
        x.alias("OSGRec", OfficerSkillGainRecord.class);
        x.aliasAttribute(OfficerSkillGainRecord.class, "personId", "p");
        x.aliasAttribute(OfficerSkillGainRecord.class, "skillId", "s");
        x.aliasAttribute(OfficerSkillGainRecord.class, "elite", "e");
        x.alias("SModRec", SModRecord.class);
        x.aliasAttribute(SModRecord.class, "member", "m");
        x.aliasAttribute(SModRecord.class, "smods", "sm");
        x.aliasAttribute(SModRecord.class, "spSpent", "sp");
        x.aliasAttribute(SModRecord.class, "bonusXPFractionGained", "bxp");
        x.aliasAttribute(SModRecord.class, "timestamp", "ts");
        x.alias("RouteFleetAssignmentAI", RouteFleetAssignmentAI.class);
        x.alias("RaidIntel", RaidIntel.class);
        x.alias("SlipstreamManager-StreamData", SlipstreamManager.StreamData.class);
    }

    @Override
    public PluginPick<ShipAIPlugin> pickShipAI(FleetMemberAPI member, ShipAPI ship) {
        if (ship.isFighter()) {
            if (ship.getHullSpec().hasTag("threat_swarm_ai")) {
                return new PluginPick<ShipAIPlugin>(new ThreatSwarmAI(ship), CampaignPlugin.PickPriority.CORE_SPECIFIC);
            }
            if (ship.getHullSpec().hasTag("dweller_vortex")) {
                return new PluginPick<ShipAIPlugin>(new ShroudedVortexAI(ship), CampaignPlugin.PickPriority.CORE_SPECIFIC);
            }
            if (ship.getHullSpec().hasTag("dweller_ejecta")) {
                return new PluginPick<ShipAIPlugin>(new ShroudedEjectaAI(ship), CampaignPlugin.PickPriority.CORE_SPECIFIC);
            }
            return null;
        }
        if (ship.getHullSpec().hasTag("threat")) {
            ShipAIConfig config = new ShipAIConfig();
            if (ship.getHullSpec().hasTag("threat_timid")) {
                config.personalityOverride = "timid";
            } else if (ship.getHullSpec().hasTag("threat_cautious")) {
                config.personalityOverride = "cautious";
            } else if (ship.getHullSpec().hasTag("threat_aggressive")) {
                config.personalityOverride = "aggressive";
            } else if (ship.getHullSpec().hasTag("threat_reckless")) {
                config.personalityOverride = "reckless";
                config.alwaysStrafeOffensively = true;
                config.backingOffWhileNotVentingAllowed = false;
                config.turnToFaceWithUndamagedArmor = false;
                config.burnDriveIgnoreEnemies = true;
            } else {
                config.personalityOverride = "steady";
            }
            CampaignPlugin.PickPriority priority = CampaignPlugin.PickPriority.CORE_SET;
            return new PluginPick<ShipAIPlugin>(Global.getSettings().createDefaultShipAI(ship, config), priority);
        }
        if (ship.getHullSpec().hasTag("dweller")) {
            ShipAIConfig config = new ShipAIConfig();
            if (ship.getHullSpec().hasTag("dweller_timid")) {
                config.personalityOverride = "timid";
            } else if (ship.getHullSpec().hasTag("dweller_cautious")) {
                config.personalityOverride = "cautious";
            } else if (ship.getHullSpec().hasTag("dweller_aggressive")) {
                config.personalityOverride = "aggressive";
            } else if (ship.getHullSpec().hasTag("dweller_reckless")) {
                config.personalityOverride = "reckless";
                config.alwaysStrafeOffensively = true;
                config.backingOffWhileNotVentingAllowed = false;
                config.turnToFaceWithUndamagedArmor = false;
                config.burnDriveIgnoreEnemies = true;
            } else {
                config.personalityOverride = "steady";
            }
            CampaignPlugin.PickPriority priority = CampaignPlugin.PickPriority.CORE_SET;
            return new PluginPick<ShipAIPlugin>(Global.getSettings().createDefaultShipAI(ship, config), priority);
        }
        HashSet<String> derelicts = new HashSet<String>();
        derelicts.add("warden");
        derelicts.add("defender");
        derelicts.add("picket");
        derelicts.add("sentry");
        derelicts.add("berserker");
        derelicts.add("bastillion");
        boolean zigguratOnEnemySide = ship.getHullSpec().getHullId().equals("ziggurat") && (member == null || member.getFleetCommander() == null || !member.getFleetCommander().isPlayer());
        String hullId = ship.getHullSpec().getHullId();
        if (!(zigguratOnEnemySide || derelicts.contains(hullId) || Misc.isAutomated(ship.getVariant()))) {
            return null;
        }
        ShipAIConfig config = new ShipAIConfig();
        config.alwaysStrafeOffensively = true;
        config.backingOffWhileNotVentingAllowed = false;
        config.turnToFaceWithUndamagedArmor = false;
        config.burnDriveIgnoreEnemies = true;
        boolean carrier = false;
        if (ship != null && ship.getVariant() != null) {
            boolean bl = carrier = ship.getVariant().isCarrier() && !ship.getVariant().isCombat();
        }
        if (carrier) {
            config.personalityOverride = "aggressive";
            config.backingOffWhileNotVentingAllowed = true;
        } else {
            config.personalityOverride = "reckless";
        }
        CampaignPlugin.PickPriority priority = CampaignPlugin.PickPriority.CORE_SET;
        if (zigguratOnEnemySide) {
            priority = CampaignPlugin.PickPriority.CORE_SPECIFIC;
        }
        return new PluginPick<ShipAIPlugin>(Global.getSettings().createDefaultShipAI(ship, config), priority);
    }

    public void convertTo0951aSkillSystemIfNeeded() {
        if (Global.getSector().getCharacterData().getSavefileVersion() != null) {
            return;
        }
        SectorAPI engine = Global.getSector();
        engine.getCharacterData().setSavefileVersion("0.95.1a");
        for (AdminData admin : engine.getCharacterData().getAdmins()) {
            this.convertPersonSkillsTo0951a(admin.getPerson());
        }
        ArrayList<LocationAPI> all = new ArrayList<LocationAPI>();
        all.add(engine.getHyperspace());
        all.addAll(engine.getStarSystems());
        for (LocationAPI curr : all) {
            for (CampaignFleetAPI fleet : curr.getFleets()) {
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    this.convertPersonSkillsTo0951a(member.getCaptain());
                    if (!fleet.isPlayerFleet() || !member.getCaptain().isAICore()) continue;
                    String aiCoreId = member.getCaptain().getAICoreId();
                    boolean alpha = "alpha_core".equals(aiCoreId);
                    boolean beta = "beta_core".equals(aiCoreId);
                    boolean gamma = "gamma_core".equals(aiCoreId);
                    int points = 0;
                    float mult = 1.0f;
                    if (alpha) {
                        points = AICoreOfficerPluginImpl.ALPHA_POINTS;
                        mult = AICoreOfficerPluginImpl.ALPHA_MULT;
                    } else if (beta) {
                        points = AICoreOfficerPluginImpl.BETA_POINTS;
                        mult = AICoreOfficerPluginImpl.BETA_MULT;
                    } else if (gamma) {
                        points = AICoreOfficerPluginImpl.GAMMA_POINTS;
                        mult = AICoreOfficerPluginImpl.GAMMA_MULT;
                    }
                    member.getCaptain().getMemoryWithoutUpdate().unset("$autoPointsValue");
                    member.getCaptain().getMemoryWithoutUpdate().set("$autoPointsMult", Float.valueOf(mult));
                }
            }
        }
        for (LocationAPI curr : all) {
            for (SectorEntityToken entity : curr.getAllEntities()) {
                CampaignFleetAPI fleet;
                if (entity.getMarket() != null && entity.getMarket().getAdmin() != null) {
                    this.convertPersonSkillsTo0951a(entity.getMarket().getAdmin());
                }
                if (entity.getMemoryWithoutUpdate() == null || !entity.getMemoryWithoutUpdate().contains("$defenderFleet") || (fleet = (CampaignFleetAPI)entity.getMemoryWithoutUpdate().get("$defenderFleet")) == null) continue;
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    this.convertPersonSkillsTo0951a(member.getCaptain());
                }
            }
        }
        MutableCharacterStatsAPI stats = engine.getPlayerStats();
        int skillPoints = 0;
        int storyPoints = 0;
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : stats.getSkillsCopy()) {
            int level = (int)sl.getLevel();
            if (level > 0) {
                ++skillPoints;
            }
            if (level > 1) {
                ++storyPoints;
            }
            int i = 0;
            while (i < level) {
                stats.decreaseSkill(sl.getSkill().getId());
                ++i;
            }
        }
        stats.setPoints(stats.getPoints() + skillPoints);
        stats.setStoryPoints(stats.getStoryPoints() + storyPoints);
        stats.refreshCharacterStatsEffects();
        stats.refreshAllOutpostsEffectsForPlayerOutposts();
        engine.addTransientScript(new EveryFrameScript(){
            int frames = 0;
            boolean done = false;

            @Override
            public boolean runWhilePaused() {
                return true;
            }

            @Override
            public boolean isDone() {
                return this.done;
            }

            @Override
            public void advance(float amount) {
                ++this.frames;
                if (this.frames > 2 && !Global.getSector().getCampaignUI().isShowingDialog()) {
                    Global.getSector().getCampaignUI().showConfirmDialog("Your skills have been reset to accomodate the new skill system. Skill and story points have been refunded.\n\nOfficer, administrator, and AI core skills have been adjusted for the new system.", "Ok", null, null, null);
                    this.done = true;
                }
            }
        });
    }

    public void convertPersonSkillsTo0951a(PersonAPI person) {
        if (person == null || person.isPlayer() || person.isDefault()) {
            return;
        }
        MutableCharacterStatsAPI stats = person.getStats();
        stats.setSkipRefresh(true);
        this.convertSkill("shield_modulation", "field_modulation", person);
        this.convertSkill("reliability_engineering", "combat_endurance", person);
        this.convertSkill("strike_commander", "helmsmanship", person);
        this.convertSkill("strike_commander", "polarized_armor", person);
        this.convertSkill("ranged_specialization", "target_analysis", person);
        this.convertSkill("ranged_specialization", "ballistic_mastery", person);
        this.convertSkill("phase_mastery", "field_modulation", person);
        this.convertSkill("phase_mastery", "ordnance_expert", person);
        this.convertSkill("weapon_drills", "tactical_drills", person);
        this.convertSkill("special_modifications", "best_of_the_best", person);
        this.removeSkill("colony_management", person);
        this.removeSkill("space_operations", person);
        this.removeSkill("planetary_operations", person);
        this.removeSkill("auxiliary_support", person);
        if (person.isAICore() && stats.hasSkill("industrial_planning")) {
            stats.setSkillLevel("hypercognition", 1.0f);
        }
        stats.setSkipRefresh(false);
    }

    public void removeSkill(String id, PersonAPI person) {
        int i = 0;
        while (i < 10) {
            person.getStats().decreaseSkill(id);
            ++i;
        }
    }

    public void convertSkill(String from, String to, PersonAPI person) {
        int level = (int)person.getStats().getSkillLevel(from);
        if (level > 0) {
            int i = 0;
            while (i < level) {
                person.getStats().decreaseSkill(from);
                ++i;
            }
            person.getStats().setSkillLevel(to, level);
        }
    }
}

