/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.world.ZigLeashAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CoronalTapParticleScript
implements EveryFrameScript {
    protected SectorEntityToken tap;
    protected IntervalUtil spawn = new IntervalUtil(0.05f, 0.1f);

    public CoronalTapParticleScript(SectorEntityToken tap) {
        this.tap = tap;
    }

    @Override
    public void advance(float amount) {
        if (this.tap.isDiscoverable()) {
            return;
        }
        if (!this.tap.getMemoryWithoutUpdate().contains("$usable")) {
            return;
        }
        if (!this.tap.isInCurrentLocation()) {
            return;
        }
        if (this.spawn == null) {
            this.spawn = new IntervalUtil(0.05f, 0.1f);
        }
        float days = Misc.getDays(amount);
        this.spawn.advance(days * 5.0f);
        if (this.spawn.intervalElapsed()) {
            float minSize = 10.0f;
            float maxSize = 20.0f;
            float sizeMult = 30.0f;
            minSize *= sizeMult;
            maxSize *= sizeMult;
            if ((float)Math.random() < 0.01f) {
                ZigLeashAssignmentAI.spawnMote(this.tap);
            }
            ArrayList<PlanetAPI> stars = new ArrayList<PlanetAPI>();
            PlanetAPI closest = null;
            float minDist = Float.MAX_VALUE;
            for (PlanetAPI star : this.tap.getContainingLocation().getPlanets()) {
                float ctcDist;
                float dist;
                if (!star.isStar() || (dist = (ctcDist = Misc.getDistance(this.tap.getLocation(), star.getLocation())) - star.getRadius() - this.tap.getRadius()) > 2000.0f) continue;
                if (ctcDist < minDist) {
                    minDist = ctcDist;
                    closest = star;
                }
                stars.add(star);
            }
            for (PlanetAPI star : stars) {
                float dirToTap = Misc.getAngleInDegrees(star.getLocation(), this.tap.getLocation());
                Vector2f unitToTap = Misc.getUnitVectorAtDegreeAngle(dirToTap);
                Vector2f focusLoc = new Vector2f((ReadableVector2f)unitToTap);
                focusLoc.scale(100.0f + star.getRadius() + this.tap.getRadius());
                Vector2f.add((Vector2f)star.getLocation(), (Vector2f)focusLoc, (Vector2f)focusLoc);
                float ctcDist = Misc.getDistance(focusLoc, star.getLocation());
                float dist = ctcDist - star.getRadius() - this.tap.getRadius();
                int glows = 3;
                float minRadius = dist + star.getRadius() * 0.2f;
                float maxRadius = dist + star.getRadius() * 0.4f;
                Color color = star.getSpec().getCoronaColor();
                float colorScale = 0.25f;
                colorScale = 0.1f + 0.15f / (float)stars.size();
                if (closest == star) {
                    colorScale = 0.25f;
                }
                color = Misc.scaleColor(color, colorScale);
                float dirToStar = Misc.getAngleInDegrees(focusLoc, star.getLocation());
                float arc = star.getRadius() / ((float)Math.PI * (ctcDist - this.tap.getRadius())) * 360.0f;
                int i = 0;
                while (i < glows) {
                    float radius = minRadius + (float)Math.random() * (maxRadius - minRadius);
                    float angle = dirToStar - arc / 2.0f + arc * (float)Math.random();
                    Vector2f unit = Misc.getUnitVectorAtDegreeAngle(angle);
                    float x = unit.x * radius + focusLoc.x;
                    float y = unit.y * radius + focusLoc.y;
                    Vector2f loc = new Vector2f(x, y);
                    Vector2f vel = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(loc, focusLoc));
                    float travelDist = Misc.getDistance(loc, focusLoc) - this.tap.getRadius() * 0.7f - 100.0f;
                    travelDist = Math.min(travelDist, maxRadius - minRadius + 100.0f);
                    float speed = 100.0f + 100.0f * (float)Math.random();
                    float dur = travelDist / speed;
                    vel.scale(speed);
                    float size = minSize + (float)Math.random() * (maxSize - minSize);
                    float rampUp = 0.5f;
                    this.tap.getContainingLocation().addParticle(loc, vel, size, 0.4f, rampUp, dur, color);
                    this.tap.getContainingLocation().addParticle(loc, vel, size * 0.25f, 0.4f, rampUp, dur, color);
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

