/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class GenericCampaignEntitySprite {
    protected SpriteAPI shadowMask;
    protected SpriteAPI sprite;
    protected SpriteAPI glow;
    protected SpriteAPI overlay;
    private float overlayAngleOffset = 0.0f;
    private float scale;
    protected SectorEntityToken entity;

    public GenericCampaignEntitySprite(SectorEntityToken entity, String spriteName, float scale) {
        this.entity = entity;
        this.scale = scale;
        this.sprite = Global.getSettings().getSprite(spriteName);
        float width = this.sprite.getWidth() * scale;
        float height = this.sprite.getHeight() * scale;
        this.sprite.setSize(width, height);
        this.shadowMask = Global.getSettings().getSprite("graphics/fx/ship_shadow_mask.png");
        float max = Math.max(width, height);
        this.shadowMask.setSize(max * 1.5f, max * 1.5f);
    }

    public SpriteAPI getGlow() {
        return this.glow;
    }

    public void setGlow(SpriteAPI glow) {
        this.glow = glow;
    }

    public SpriteAPI getOverlay() {
        return this.overlay;
    }

    public void setOverlay(SpriteAPI overlay) {
        this.overlay = overlay;
    }

    public float getOverlayAngleOffset() {
        return this.overlayAngleOffset;
    }

    public void setOverlayAngleOffset(float overlayAngleOffset) {
        this.overlayAngleOffset = overlayAngleOffset;
    }

    public void render(float cx, float cy, float facing, float alphaMult) {
        float h;
        float w;
        if (alphaMult <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.entity.getLocation().x, (float)this.entity.getLocation().y, (float)0.0f);
        SectorEntityToken lightSource = this.entity.getLightSource();
        if (lightSource != null && this.entity.getLightColor() != null) {
            this.sprite.setColor(this.entity.getLightColor());
            if (this.overlay != null) {
                this.overlay.setColor(this.entity.getLightColor());
            }
        } else {
            this.sprite.setColor(Color.white);
            if (this.overlay != null) {
                this.overlay.setColor(Color.white);
            }
        }
        this.sprite.setAngle(facing - 90.0f);
        this.sprite.setNormalBlend();
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.renderAtCenter(cx, cy);
        if (this.glow != null) {
            this.glow.setAngle(facing - 90.0f);
            this.glow.setAdditiveBlend();
            this.glow.setAlphaMult(alphaMult);
            this.glow.renderAtCenter(cx, cy);
        }
        if (this.overlay != null) {
            h = w = this.overlay.getWidth() * 1.41f;
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            Misc.renderQuadAlpha(0.0f - w / 2.0f - 1.0f, 0.0f - h / 2.0f - 1.0f, w + 2.0f, h + 2.0f, Misc.zeroColor, 0.0f);
            this.sprite.setBlendFunc(1, 0);
            this.sprite.renderAtCenter(cx, cy);
            this.overlay.setAlphaMult(alphaMult);
            this.overlay.setAngle(facing - 90.0f + this.overlayAngleOffset);
            this.overlay.setBlendFunc(0, 770);
            this.overlay.renderAtCenter(cx, cy);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.overlay.setBlendFunc(772, 773);
            this.overlay.renderAtCenter(cx, cy);
        }
        if (lightSource != null && !this.entity.getLightSource().hasTag("ambient_ls")) {
            h = w = this.shadowMask.getWidth() * 1.41f;
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            Misc.renderQuadAlpha(0.0f - w / 2.0f - 1.0f, 0.0f - h / 2.0f - 1.0f, w + 2.0f, h + 2.0f, Misc.zeroColor, 0.0f);
            this.sprite.setBlendFunc(1, 0);
            this.sprite.renderAtCenter(cx, cy);
            float lightDir = Misc.getAngleInDegreesStrict(this.entity.getLocation(), lightSource.getLocation());
            this.shadowMask.setAlphaMult(alphaMult);
            this.shadowMask.setAngle(lightDir);
            this.shadowMask.setBlendFunc(0, 770);
            this.shadowMask.renderAtCenter(cx, cy);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.shadowMask.setBlendFunc(772, 773);
            this.shadowMask.renderAtCenter(cx, cy);
        }
        GL11.glPopMatrix();
    }
}

