/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GenericFieldItemSprite {
    protected SpriteAPI shadowMask;
    protected SpriteAPI sprite;
    protected SpriteAPI glow;
    protected float width;
    protected float height;
    protected SectorEntityToken entity;
    protected Vector2f loc = new Vector2f();
    protected Vector2f vel = new Vector2f();
    protected float timeLeft = 0.0f;
    protected float facing = 0.0f;
    protected float angVel = 0.0f;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.2f, 0.2f);

    public GenericFieldItemSprite(SectorEntityToken entity, String category, String key, float cellSize, float size, float spawnRadius) {
        this.entity = entity;
        this.sprite = Global.getSettings().getSprite(category, key);
        this.height = this.width = size;
        float w = this.sprite.getWidth();
        float h = this.sprite.getHeight();
        int cols = (int)(w / cellSize);
        int rows = (int)(h / cellSize);
        float cellX = (int)(Math.random() * (double)cols);
        float cellY = (int)(Math.random() * (double)rows);
        float ctw = this.sprite.getTextureWidth() / (float)cols;
        float cth = this.sprite.getTextureHeight() / (float)rows;
        this.sprite.setTexX(cellX * ctw);
        this.sprite.setTexY(cellY * cth);
        this.sprite.setTexWidth(ctw);
        this.sprite.setTexHeight(cth);
        if (this.glow != null) {
            this.glow.setTexX(cellX * ctw);
            this.glow.setTexY(cellY * cth);
            this.glow.setTexWidth(ctw);
            this.glow.setTexHeight(cth);
            this.glow.setSize(this.width, this.height);
        }
        this.sprite.setSize(this.width, this.height);
        this.shadowMask = Global.getSettings().getSprite("graphics/fx/ship_shadow_mask.png");
        this.shadowMask.setSize(this.width * 1.5f, this.height * 1.5f);
        this.fader.fadeIn();
        this.facing = (float)Math.random() * 360.0f;
        this.angVel = (float)Math.random() * 360.0f - 180.0f;
        float r = (float)Math.random();
        r = (float)Math.sqrt(r);
        float dist = r * spawnRadius;
        this.loc = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        this.loc.scale(dist);
        this.vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        this.vel = Misc.getPerp(this.loc);
        float off = 0.25f;
        this.vel.x += off - (float)Math.random() * 0.5f * off;
        this.vel.y += off - (float)Math.random() * 0.5f * off;
        if ((float)Math.random() > 0.5f) {
            this.vel.negate();
        }
        Misc.normalise(this.vel);
        float speed = 10.0f + (float)Math.random() * 10.0f;
        this.vel.scale(speed);
        this.timeLeft = 1.0f + (float)Math.random();
    }

    public void render(float alphaMult) {
        if (alphaMult <= 0.0f) {
            return;
        }
        SectorEntityToken lightSource = this.entity.getLightSource();
        if (lightSource != null && this.entity.getLightColor() != null) {
            this.sprite.setColor(this.entity.getLightColor());
        } else {
            this.sprite.setColor(Color.white);
        }
        this.sprite.setAngle(this.facing - 90.0f);
        this.sprite.setNormalBlend();
        this.sprite.setAlphaMult(alphaMult * this.fader.getBrightness());
        this.sprite.renderAtCenter(this.loc.x, this.loc.y);
        if (lightSource != null && !this.entity.getLightSource().hasTag("ambient_ls")) {
            float w;
            float h = w = this.shadowMask.getWidth() * 1.41f;
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.loc.x, (float)this.loc.y, (float)0.0f);
            Misc.renderQuadAlpha(0.0f - w / 2.0f - 1.0f, 0.0f - h / 2.0f - 1.0f, w + 2.0f, h + 2.0f, Misc.zeroColor, 0.0f);
            GL11.glPopMatrix();
            this.sprite.setBlendFunc(1, 0);
            this.sprite.renderAtCenter(this.loc.x, this.loc.y);
            float lightDir = Misc.getAngleInDegreesStrict(this.entity.getLocation(), lightSource.getLocation());
            this.shadowMask.setAlphaMult(alphaMult);
            this.shadowMask.setAngle(lightDir);
            this.shadowMask.setBlendFunc(0, 770);
            this.shadowMask.renderAtCenter(this.loc.x, this.loc.y);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.shadowMask.setBlendFunc(772, 773);
            this.shadowMask.renderAtCenter(this.loc.x, this.loc.y);
        }
    }

    public void advance(float days) {
        this.fader.advance(days);
        this.facing += this.angVel * days;
        this.loc.x += this.vel.x * days;
        this.loc.y += this.vel.y * days;
        this.timeLeft -= days;
        if (this.timeLeft < 0.0f) {
            this.fader.fadeOut();
        }
    }

    public boolean isDone() {
        return this.fader.isFadedOut();
    }
}

