/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.RefitScreenListener;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

public class HullModItemManager
implements RefitScreenListener {
    protected ListMap<HullModInstallData> map = new ListMap();

    public static HullModItemManager getInstance() {
        String key = "$hullModItemManager";
        HullModItemManager manager = (HullModItemManager)Global.getSector().getMemoryWithoutUpdate().get(key);
        if (manager == null) {
            manager = new HullModItemManager();
            Global.getSector().getMemoryWithoutUpdate().set(key, manager);
        }
        return manager;
    }

    public HullModItemManager() {
        Global.getSector().getListenerManager().addListener(this);
    }

    protected Object readResolve() {
        return this;
    }

    public boolean isRequiredItemAvailable(String modId, FleetMemberAPI member, ShipVariantAPI currentVariant, MarketAPI dockedAt) {
        if (Global.getCurrentState() == GameState.TITLE) {
            return true;
        }
        if (member == null || currentVariant == null) {
            return true;
        }
        HullModSpecAPI mod = Global.getSettings().getHullModSpec(modId);
        CargoStackAPI req = mod.getEffect().getRequiredItem();
        if (req == null) {
            return true;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null) {
            return true;
        }
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        ArrayList<String> installedIds = new ArrayList<String>();
        for (HullModInstallData data : installed) {
            installedIds.add(data.modId);
        }
        if (installedIds.contains(modId)) {
            return true;
        }
        int available = this.getNumAvailableMinusUnconfirmed(req, member, currentVariant, dockedAt);
        return available >= 1;
    }

    public int getNumAvailableMinusUnconfirmed(CargoStackAPI req, FleetMemberAPI member, ShipVariantAPI currentVariant, MarketAPI dockedAt) {
        int requiredAlreadyByUnconfirmed = this.getNumUnconfirmed(req, member, currentVariant);
        int available = this.getNumAvailable(req, dockedAt);
        return available - requiredAlreadyByUnconfirmed;
    }

    public int getNumUnconfirmed(CargoStackAPI req, FleetMemberAPI member, ShipVariantAPI currentVariant) {
        CargoStackAPI otherReq;
        HullModSpecAPI otherMod;
        if (member == null || currentVariant == null) {
            return 0;
        }
        HullModDiff diff = this.getHullmodDiff(member, currentVariant);
        int requiredAlreadyByUnconfirmed = 0;
        for (String otherModId : diff.needItems) {
            otherMod = Global.getSettings().getHullModSpec(otherModId);
            otherReq = otherMod.getEffect().getRequiredItem();
            if (otherReq == null || req.getType() != otherReq.getType() || req.getData() == null || !req.getData().equals(otherReq.getData())) continue;
            ++requiredAlreadyByUnconfirmed;
        }
        for (String otherModId : diff.noLongerNeedItems) {
            otherMod = Global.getSettings().getHullModSpec(otherModId);
            otherReq = otherMod.getEffect().getRequiredItem();
            if (otherReq == null || req.getType() != otherReq.getType() || req.getData() == null || !req.getData().equals(otherReq.getData())) continue;
            --requiredAlreadyByUnconfirmed;
        }
        return requiredAlreadyByUnconfirmed;
    }

    public int getNumAvailable(CargoStackAPI req, MarketAPI dockedAt) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null) {
            return 0;
        }
        CargoAPI cargo = fleet.getCargo();
        float quantity = Math.round(cargo.getQuantity(req.getType(), req.getData()));
        if (dockedAt != null && (cargo = Misc.getStorageCargo(dockedAt)) != null) {
            quantity += (float)Math.round(cargo.getQuantity(req.getType(), req.getData()));
        }
        return Math.round(quantity);
    }

    public CargoAPI getItemsInUseBy(FleetMemberAPI member) {
        CargoAPI cargo = Global.getFactory().createCargo(true);
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        for (HullModInstallData data : installed) {
            cargo.addItems(data.item.getType(), data.item.getData(), 1.0f);
        }
        cargo.sort();
        return cargo;
    }

    public void giveBackAllItems(FleetMemberAPI member) {
        this.giveBackAllItems(member, null);
    }

    public void giveBackAllItems(FleetMemberAPI member, CargoAPI cargo) {
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        ArrayList<String> installedIds = new ArrayList<String>();
        for (HullModInstallData data : installed) {
            installedIds.add(data.modId);
        }
        for (String modId : installedIds) {
            this.giveBackRequiredItems(modId, member, cargo);
        }
        this.map.cleanupEmptyLists();
    }

    @Override
    public void reportFleetMemberVariantSaved(FleetMemberAPI member, MarketAPI dockedAt) {
        HullModDiff diff = this.getHullmodDiff(member, member.getVariant());
        for (String modId : diff.needItems) {
            this.takeRequiredItems(modId, member, dockedAt);
        }
        for (String modId : diff.noLongerNeedItems) {
            this.giveBackRequiredItems(modId, member, null);
        }
        this.map.cleanupEmptyLists();
    }

    public HullModDiff getHullmodDiff(FleetMemberAPI member, ShipVariantAPI currentVariant) {
        HullModDiff diff = new HullModDiff();
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        ArrayList<String> installedIds = new ArrayList<String>();
        for (HullModInstallData data : installed) {
            installedIds.add(data.modId);
        }
        for (String modId : currentVariant.getHullMods()) {
            HullModSpecAPI mod;
            CargoStackAPI req;
            if (member.getHullSpec().isBuiltInMod(modId) || (req = (mod = Global.getSettings().getHullModSpec(modId)).getEffect().getRequiredItem()) == null) continue;
            if (!installedIds.contains(modId)) {
                diff.needItems.add(modId);
            }
            installedIds.remove(modId);
        }
        diff.noLongerNeedItems.addAll(installedIds);
        return diff;
    }

    public void takeRequiredItems(String modId, FleetMemberAPI member, MarketAPI dockedAt) {
        HullModSpecAPI mod = Global.getSettings().getHullModSpec(modId);
        CargoStackAPI req = mod.getEffect().getRequiredItem();
        if (req == null) {
            return;
        }
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        for (HullModInstallData data : installed) {
            if (!data.modId.equals(modId)) continue;
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null) {
            return;
        }
        CargoAPI cargo = fleet.getCargo();
        boolean removed = false;
        if (cargo.getQuantity(req.getType(), req.getData()) >= 1.0f) {
            cargo.removeItems(req.getType(), req.getData(), 1.0f);
            removed = true;
        }
        if (!removed && dockedAt != null && (cargo = Misc.getStorageCargo(dockedAt)) != null && cargo.getQuantity(req.getType(), req.getData()) >= 1.0f) {
            cargo.removeItems(req.getType(), req.getData(), 1.0f);
            removed = true;
        }
        if (!removed) {
            return;
        }
        HullModInstallData data = new HullModInstallData();
        data.modId = modId;
        data.item = req;
        this.map.add(memberId, data);
    }

    public void giveBackRequiredItems(String modId, FleetMemberAPI member, CargoAPI cargo) {
        HullModSpecAPI mod = Global.getSettings().getHullModSpec(modId);
        CargoStackAPI req = mod.getEffect().getRequiredItem();
        if (req == null) {
            return;
        }
        if (cargo == null) {
            CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
            if (fleet == null) {
                return;
            }
            cargo = fleet.getCargo();
        }
        String memberId = member.getId();
        List<HullModInstallData> installed = this.map.getList(memberId);
        for (HullModInstallData data : installed) {
            if (!data.modId.equals(modId)) continue;
            this.map.remove(memberId, data);
            cargo.addItems(data.item.getType(), data.item.getData(), 1.0f);
            break;
        }
    }

    public static class HullModDiff {
        public List<String> needItems = new ArrayList<String>();
        public List<String> noLongerNeedItems = new ArrayList<String>();
    }

    public static class HullModInstallData {
        public String modId;
        public CargoStackAPI item;
    }
}

