/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantThemeGenerator;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class WarningBeaconEntityPlugin
extends BaseCustomEntityPlugin {
    public static String GLOW_COLOR_KEY = "$core_beaconGlowColor";
    public static String PING_COLOR_KEY = "$core_beaconPingColor";
    public static String PING_ID_KEY = "$core_beaconPingId";
    public static String PING_FREQ_KEY = "$core_beaconPingFreq";
    public static float GLOW_FREQUENCY = 1.0f;
    private transient SpriteAPI sprite;
    private transient SpriteAPI glow;
    private float phase = 0.0f;
    private float freqMult = 1.0f;
    private float sincePing = 10.0f;

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(0.75f));
        this.readResolve();
    }

    Object readResolve() {
        this.sprite = Global.getSettings().getSprite("campaignEntities", "warning_beacon");
        this.glow = Global.getSettings().getSprite("campaignEntities", "warning_beacon_glow");
        return this;
    }

    @Override
    public void advance(float amount) {
        this.phase += amount * GLOW_FREQUENCY * this.freqMult;
        while (this.phase > 1.0f) {
            this.phase -= 1.0f;
        }
        if (this.entity.isInCurrentLocation()) {
            this.sincePing += amount;
            if (this.sincePing >= 6.0f && this.phase > 0.1f && this.phase < 0.2f) {
                this.sincePing = 0.0f;
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                if (playerFleet != null && this.entity.getVisibilityLevelTo(playerFleet) == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS) {
                    String pingId = "warning_beacon1";
                    this.freqMult = 1.0f;
                    if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.SUPPRESSED.getBeaconFlag())) {
                        pingId = "warning_beacon2";
                        this.freqMult = 1.25f;
                    } else if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.RESURGENT.getBeaconFlag())) {
                        pingId = "warning_beacon3";
                        this.freqMult = 1.5f;
                    }
                    if (this.entity.getMemoryWithoutUpdate().contains(PING_ID_KEY)) {
                        pingId = this.entity.getMemoryWithoutUpdate().getString(PING_ID_KEY);
                    }
                    if (this.entity.getMemoryWithoutUpdate().contains(PING_FREQ_KEY)) {
                        this.freqMult = this.entity.getMemoryWithoutUpdate().getFloat(PING_FREQ_KEY);
                    }
                    Color pingColor = null;
                    if (this.entity.getMemoryWithoutUpdate().contains(PING_COLOR_KEY)) {
                        pingColor = (Color)this.entity.getMemoryWithoutUpdate().get(PING_COLOR_KEY);
                    }
                    Global.getSector().addPing(this.entity, pingId, pingColor);
                }
            }
        }
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 100.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        CustomEntitySpecAPI spec = this.entity.getCustomEntitySpec();
        if (spec == null) {
            return;
        }
        float w = spec.getSpriteWidth();
        float h = spec.getSpriteHeight();
        Vector2f loc = this.entity.getLocation();
        this.sprite.setAngle(this.entity.getFacing() - 90.0f);
        this.sprite.setSize(w, h);
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.setNormalBlend();
        this.sprite.renderAtCenter(loc.x, loc.y);
        float glowAlpha = 0.0f;
        if (this.phase < 0.5f) {
            glowAlpha = this.phase * 2.0f;
        }
        if (this.phase >= 0.5f) {
            glowAlpha = 1.0f - (this.phase - 0.5f) * 2.0f;
        }
        float glowAngle1 = (this.phase * 1.3f % 1.0f - 0.5f) * 12.0f;
        float glowAngle2 = (this.phase * 1.9f % 1.0f - 0.5f) * 12.0f;
        boolean glowAsLayer = true;
        if (glowAsLayer) {
            Color glowColor = new Color(255, 200, 0, 255);
            if (this.entity.getMemoryWithoutUpdate().contains(GLOW_COLOR_KEY)) {
                glowColor = (Color)this.entity.getMemoryWithoutUpdate().get(GLOW_COLOR_KEY);
            }
            this.glow.setColor(glowColor);
            this.glow.setSize(w, h);
            this.glow.setAlphaMult(alphaMult * glowAlpha);
            this.glow.setAdditiveBlend();
            this.glow.setAngle(this.entity.getFacing() - 90.0f + glowAngle1);
            this.glow.renderAtCenter(loc.x, loc.y);
            this.glow.setAngle(this.entity.getFacing() - 90.0f + glowAngle2);
            this.glow.setAlphaMult(alphaMult * glowAlpha * 0.5f);
            this.glow.renderAtCenter(loc.x, loc.y);
        } else {
            this.glow.setAngle(this.entity.getFacing() - 90.0f);
            this.glow.setColor(new Color(255, 165, 100));
            float gs = w * 3.0f;
            this.glow.setSize(gs, gs);
            this.glow.setAdditiveBlend();
            float spacing = 10.0f;
            this.glow.setAlphaMult(alphaMult * glowAlpha * 0.5f);
            this.glow.renderAtCenter(loc.x - spacing, loc.y);
            this.glow.renderAtCenter(loc.x + spacing, loc.y);
            this.glow.setAlphaMult(alphaMult * glowAlpha);
            this.glow.setSize(gs * 0.25f, gs * 0.25f);
            this.glow.renderAtCenter(loc.x - spacing, loc.y);
            this.glow.renderAtCenter(loc.x + spacing, loc.y);
        }
    }

    @Override
    public void createMapTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color color;
        String post = "";
        Color postColor = color = this.entity.getFaction().getBaseUIColor();
        if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.DESTROYED.getBeaconFlag())) {
            post = " - Low";
            postColor = Misc.getPositiveHighlightColor();
        } else if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.SUPPRESSED.getBeaconFlag())) {
            post = " - Medium";
            postColor = Misc.getHighlightColor();
        } else if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.RESURGENT.getBeaconFlag())) {
            post = " - High";
            postColor = Misc.getNegativeHighlightColor();
        }
        tooltip.addPara(String.valueOf(this.entity.getName()) + post, 0.0f, color, postColor, post.replaceFirst(" - ", ""));
    }

    @Override
    public boolean hasCustomMapTooltip() {
        return true;
    }

    @Override
    public void appendToCampaignTooltip(TooltipMakerAPI tooltip, SectorEntityToken.VisibilityLevel level) {
        if (level == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || level == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS) {
            Color color;
            String post = "";
            Color postColor = color = Misc.getTextColor();
            if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.DESTROYED.getBeaconFlag())) {
                post = "low";
                postColor = Misc.getPositiveHighlightColor();
            } else if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.SUPPRESSED.getBeaconFlag())) {
                post = "medium";
                postColor = Misc.getHighlightColor();
            } else if (this.entity.getMemoryWithoutUpdate().getBoolean(RemnantThemeGenerator.RemnantSystemType.RESURGENT.getBeaconFlag())) {
                post = "high";
                postColor = Misc.getNegativeHighlightColor();
            }
            if (!post.isEmpty()) {
                tooltip.setParaFontDefault();
                tooltip.addPara("    - Danger level: " + post, 10.0f, color, postColor, post);
            }
        }
    }
}

