/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlanetSpecAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseAbilityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.DurationAbilityWithCost2;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class GenerateSlipsurgeAbility
extends DurationAbilityWithCost2 {
    public static boolean REQUIRE_GIANT_STARS_OR_STRONGER = true;
    public static Map<String, Float> SLIPSURGE_STRENGTH = new LinkedHashMap<String, Float>();
    public static float SLIPSURGE_STRENGTH_MULT;
    public static float TRANSIT_MUSIC_SUPPRESSION;
    public static String TRANSIT_SOUND_LOOP;
    public static float FUEL_COST_MULT;
    public static float CR_COST_MULT;
    public static float SENSOR_RANGE_MULT;
    public static String SENSOR_MOD_ID;
    protected Boolean primed = null;
    protected Vector2f startLoc = null;
    protected JumpPointAPI well = null;

    static {
        SLIPSURGE_STRENGTH.put("black_hole", Float.valueOf(1.0f));
        SLIPSURGE_STRENGTH.put("star_neutron", Float.valueOf(0.9f));
        SLIPSURGE_STRENGTH.put("star_blue_supergiant", Float.valueOf(0.8f));
        SLIPSURGE_STRENGTH.put("star_red_supergiant", Float.valueOf(0.8f));
        SLIPSURGE_STRENGTH.put("star_red_giant", Float.valueOf(0.6f));
        SLIPSURGE_STRENGTH.put("star_blue_giant", Float.valueOf(0.6f));
        SLIPSURGE_STRENGTH.put("star_orange_giant", Float.valueOf(0.6f));
        SLIPSURGE_STRENGTH.put("star_orange", Float.valueOf(0.4f));
        SLIPSURGE_STRENGTH.put("star_yellow", Float.valueOf(0.4f));
        SLIPSURGE_STRENGTH.put("star_white", Float.valueOf(0.25f));
        SLIPSURGE_STRENGTH.put("star_red_dwarf", Float.valueOf(0.2f));
        SLIPSURGE_STRENGTH.put("star_browndwarf", Float.valueOf(0.1f));
        SLIPSURGE_STRENGTH.put("gas_giant", Float.valueOf(0.0f));
        SLIPSURGE_STRENGTH.put("ice_giant", Float.valueOf(0.0f));
        SLIPSURGE_STRENGTH_MULT = 1.3f;
        TRANSIT_MUSIC_SUPPRESSION = 1.0f;
        TRANSIT_SOUND_LOOP = "ui_slipsurge_travel_loop";
        FUEL_COST_MULT = 5.0f;
        CR_COST_MULT = 0.25f;
        SENSOR_RANGE_MULT = 0.1f;
        SENSOR_MOD_ID = "slipsurge_sensor_penalty";
    }

    @Override
    public float getFuelCostMult() {
        return FUEL_COST_MULT;
    }

    @Override
    public float getCRCostMult() {
        return CR_COST_MULT;
    }

    @Override
    public Misc.FleetMemberDamageLevel getActivationDamageLevel() {
        return Misc.FleetMemberDamageLevel.MEDIUM;
    }

    @Override
    public boolean canRecoverCRWhileActive() {
        return true;
    }

    @Override
    protected void activateImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        this.primed = true;
        this.well = this.findGravityWell();
        if (this.well == null) {
            return;
        }
        float angle = Misc.getAngleInDegrees(this.well.getLocation(), fleet.getLocation());
        float offset = 100.0f;
        Vector2f from = Misc.getUnitVectorAtDegreeAngle(angle);
        from.scale(offset + fleet.getRadius());
        Vector2f.add((Vector2f)from, (Vector2f)fleet.getLocation(), (Vector2f)from);
        this.startLoc = from;
        SectorEntityToken token = fleet.getContainingLocation().createToken(this.startLoc);
        Global.getSector().addPing(token, "slipsurge");
        this.well.getContainingLocation().addScript(new ExpandStormRadiusScript(16000.0f));
        this.deductCost();
    }

    @Override
    protected void applyStatsEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (level > 0.0f && level < 1.0f && amount > 0.0f) {
            fleet.goSlowOneFrame();
            return;
        }
        if (level == 1.0f && this.primed != null) {
            this.generateSlipstream();
            this.primed = null;
            this.startLoc = null;
            this.well = null;
        }
    }

    protected void generateSlipstream() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        JumpPointAPI jp = this.well;
        if (jp == null) {
            return;
        }
        float strength = this.getStrengthForGravityWell(jp);
        strength *= SLIPSURGE_STRENGTH_MULT;
        float angle = Misc.getAngleInDegrees(jp.getLocation(), this.startLoc);
        float offset = 100.0f;
        Vector2f from = this.startLoc;
        SlipstreamTerrainPlugin2.SlipstreamParams2 params = new SlipstreamTerrainPlugin2.SlipstreamParams2();
        params.enteringSlipstreamTextOverride = "Entering slipsurge";
        params.enteringSlipstreamTextDurationOverride = Float.valueOf(0.1f);
        params.forceNoWindVisualEffectOnFleets = true;
        float width = 600.0f;
        float length = 1000.0f;
        length += strength * 500.0f;
        params.burnLevel = Math.round(400.0f + strength * strength * 500.0f);
        params.accelerationMult = 20.0f + strength * strength * 280.0f;
        params.baseWidth = width;
        params.widthForMaxSpeed = 400.0f;
        params.widthForMaxSpeedMinMult = 0.34f;
        params.slowDownInWiderSections = true;
        params.minSpeed = Misc.getSpeedForBurnLevel(params.burnLevel - params.burnLevel / 8);
        params.maxSpeed = Misc.getSpeedForBurnLevel(params.burnLevel + params.burnLevel / 8);
        params.lineLengthFractionOfSpeed = 2000.0f / ((params.maxSpeed + params.minSpeed) * 0.5f);
        float lineFactor = 0.1f;
        params.minSpeed *= lineFactor;
        params.maxSpeed *= lineFactor;
        params.maxBurnLevelForTextureScroll = (int)((float)params.burnLevel * 0.1f);
        params.particleFadeInTime = 0.01f;
        params.areaPerParticle = 1000.0f;
        Vector2f to = Misc.getUnitVectorAtDegreeAngle(angle);
        to.scale(offset + fleet.getRadius() + length);
        Vector2f.add((Vector2f)to, (Vector2f)this.startLoc, (Vector2f)to);
        CampaignTerrainAPI slipstream = (CampaignTerrainAPI)this.well.getContainingLocation().addTerrain("slipstream", params);
        slipstream.addTag("slipstream_visible_in_abyss");
        slipstream.setLocation(from.x, from.y);
        SlipstreamTerrainPlugin2 plugin = (SlipstreamTerrainPlugin2)slipstream.getPlugin();
        float spacing = 100.0f;
        float incr = spacing / length;
        Vector2f diff = Vector2f.sub((Vector2f)to, (Vector2f)from, (Vector2f)new Vector2f());
        float f = 0.0f;
        while (f <= 1.0f) {
            Vector2f curr = new Vector2f((ReadableVector2f)diff);
            curr.scale(f);
            Vector2f.add((Vector2f)curr, (Vector2f)from, (Vector2f)curr);
            plugin.addSegment(curr, width - Math.min(300.0f, 300.0f * (float)Math.sqrt(f)));
            f += incr;
        }
        plugin.recomputeIfNeeded();
        plugin.despawn(1.5f, 0.2f, new Random());
        slipstream.addScript(new SlipsurgeFadeInScript(plugin));
        fleet.addScript(new SlipsurgeEffectScript(fleet, plugin));
    }

    @Override
    protected void unapplyStatsEffect() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        this.primed = null;
        this.startLoc = null;
        this.well = null;
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        return super.isUsable() && this.getFleet() != null && this.getFleet().isInHyperspace() && this.findGravityWell() != null;
    }

    @Override
    public void addInitialDescription(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color text = Misc.getTextColor();
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        float pad = 10.0f;
        String extra = "";
        if (REQUIRE_GIANT_STARS_OR_STRONGER) {
            extra = "and availability ";
        }
        tooltip.addPara("Overload and modulate the fleet's drive field to induce an extremely powerful, short-duration slipstream flowing away from the nearest gravity well, its strength " + extra + "based on the stellar object's mass, density, and some other poorly-understood factors. " + "Largely ineffective inside abyssal hyperspace.", pad);
        FactionAPI player = Global.getSector().getFaction("player");
        Color starColor = Misc.getBasePlayerColor();
        float tw = this.getTooltipWidth();
        float strW = 150.0f;
        if (Global.CODEX_TOOLTIP_MODE) {
            tw = 500.0f;
            strW = 220.0f;
        }
        tooltip.beginTable(player, 20.0f, "Stellar object type", Float.valueOf(tw - strW), "Surge strength", Float.valueOf(strW));
        if (REQUIRE_GIANT_STARS_OR_STRONGER) {
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Black holes, neutron stars", Alignment.MID, highlight, "Extreme"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Supergiant stars", Alignment.MID, highlight, "High"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Giant stars", Alignment.MID, highlight, "Average"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Smaller stars / stellar objects", Alignment.MID, highlight, "---"});
        } else {
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Black holes, neutron stars", Alignment.MID, highlight, "Extreme"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Supergiant stars", Alignment.MID, highlight, "Very high"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Giant stars", Alignment.MID, highlight, "High"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Sol-like stars", Alignment.MID, highlight, "Average"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Dwarf stars", Alignment.MID, highlight, "Low"});
            tooltip.addRow(new Object[]{Alignment.LMID, starColor, "Gas giants", Alignment.MID, highlight, "Very low"});
        }
        tooltip.addTable("", 0, pad);
        if (Global.CODEX_TOOLTIP_MODE) {
            float tw2 = tooltip.getWidthSoFar();
            float xOff = (int)((tw2 - tw) / 2.0f);
            tooltip.getPrev().getPosition().setXAlignOffset(xOff);
            tooltip.addSpacer(0.0f).getPosition().setXAlignOffset(-xOff);
        }
        tooltip.addSpacer(5.0f);
        tooltip.addPara("A stronger surge can allow the fleet to rapidly travel up to %s light-years. Attempting to %s during the transit will decelerate the fleet quickly. Fleet sensor range is reduced by %s during the transit.", pad, highlight, "15", "move slowly", Math.round((1.0f - SENSOR_RANGE_MULT) * 100.0f) + "%");
    }

    @Override
    public boolean addNotUsableReasonBeforeFuelCost(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return false;
        }
        Color bad = Misc.getNegativeHighlightColor();
        float pad = 10.0f;
        if (!fleet.isInHyperspace()) {
            tooltip.addPara("Can only be used in hyperspace.", bad, pad);
            return true;
        }
        if (this.findGravityWell() == null) {
            if (REQUIRE_GIANT_STARS_OR_STRONGER) {
                tooltip.addPara("Must be near a powerful gravity well.", bad, pad);
            } else {
                tooltip.addPara("Must be near a gravity well.", bad, pad);
            }
            return true;
        }
        return false;
    }

    public JumpPointAPI findGravityWell() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return null;
        }
        JumpPointAPI closest = null;
        float minDist = Float.MAX_VALUE;
        for (SectorEntityToken curr : fleet.getContainingLocation().getJumpPoints()) {
            float dist;
            float min;
            float str;
            JumpPointAPI jp = (JumpPointAPI)curr;
            if (!jp.isStarAnchor() && !jp.isGasGiantAnchor() || jp.getDestinationVisualEntity() == null || REQUIRE_GIANT_STARS_OR_STRONGER && (str = this.getStrengthForGravityWell(jp)) <= (min = SLIPSURGE_STRENGTH.get("star_yellow").floatValue()) || (dist = Misc.getDistance(fleet, jp) - jp.getRadius()) > jp.getRadius() + 150.0f || !(dist < minDist)) continue;
            closest = jp;
            minDist = dist;
        }
        return closest;
    }

    public float getStrengthForGravityWell(JumpPointAPI jp) {
        return this.getStrengthForStellarObject(jp.getDestinationVisualEntity());
    }

    public float getStrengthForStellarObject(SectorEntityToken object) {
        if (!(object instanceof PlanetAPI)) {
            return 0.0f;
        }
        PlanetAPI star = (PlanetAPI)object;
        PlanetSpecAPI spec = star.getSpec();
        Float val = SLIPSURGE_STRENGTH.get(spec.getPlanetType());
        if (val != null) {
            return val.floatValue();
        }
        if (spec.isGasGiant()) {
            return 0.0f;
        }
        String key = "star_yellow";
        String name = spec.getName().toLowerCase();
        if (name.contains("neutron") || spec.isPulsar()) {
            key = "star_neutron";
        } else if (name.contains("dwarf")) {
            key = "star_white";
        } else if (name.contains("supergiant")) {
            key = "star_blue_supergiant";
        } else if (name.contains("giant")) {
            key = "star_blue_giant";
        } else if (name.contains(" hole")) {
            key = "black_hole";
        } else if (name.contains("brown")) {
            key = "star_browndwarf";
        }
        val = SLIPSURGE_STRENGTH.get(key);
        if (val != null) {
            return val.floatValue();
        }
        return 0.4f;
    }

    public static class ExpandStormRadiusScript
    implements EveryFrameScript {
        protected float elapsed = 0.0f;
        protected float extraRadius;

        public ExpandStormRadiusScript(float extraRadius) {
            this.extraRadius = extraRadius;
        }

        @Override
        public void advance(float amount) {
            this.elapsed += amount;
            CampaignTerrainAPI terrain = Misc.getHyperspaceTerrain();
            if (terrain != null) {
                HyperspaceTerrainPlugin htp = (HyperspaceTerrainPlugin)terrain.getPlugin();
                htp.setExtraDistanceAroundPlayerToAdvanceStormCells(this.extraRadius);
                htp.setStormCellTimeMultOutsideBaseArea(5.0f);
            }
        }

        @Override
        public boolean isDone() {
            return this.elapsed >= 10.0f;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }

    public static class SlipsurgeEffectScript
    implements EveryFrameScript {
        protected CampaignFleetAPI fleet;
        protected boolean triggered = false;
        protected boolean done = false;
        protected boolean didTempCleanup = false;
        protected float elapsed = 0.0f;
        protected SlipstreamTerrainPlugin2 plugin;

        public SlipsurgeEffectScript(CampaignFleetAPI fleet, SlipstreamTerrainPlugin2 plugin) {
            this.fleet = fleet;
            this.plugin = plugin;
        }

        public void abort() {
            this.done = true;
            this.didTempCleanup = true;
            this.fleet.fadeInIndicator();
            this.fleet.setNoEngaging(0.0f);
            this.fleet.getStats().getSensorRangeMod().unmodifyMult(SENSOR_MOD_ID);
            for (FleetMemberViewAPI view : this.fleet.getViews()) {
                view.endJitter();
            }
            if (this.fleet.isPlayerFleet()) {
                Global.getSector().getCampaignUI().setFollowingDirectCommand(false);
            }
        }

        @Override
        public void advance(float amount) {
            block20: {
                float b;
                if (this.done) {
                    return;
                }
                if (this.fleet.isInHyperspaceTransition() || this.plugin.getEntity().getContainingLocation() != this.fleet.getContainingLocation()) {
                    if (!this.didTempCleanup) {
                        this.abort();
                    }
                    this.done = false;
                    return;
                }
                this.elapsed += amount;
                if (!(this.triggered || !(this.elapsed >= 30.0f) && this.plugin.getEntity().isAlive())) {
                    this.done = true;
                    return;
                }
                float burn = Misc.getBurnLevelForSpeed(this.fleet.getVelocity().length());
                if (burn > 50.0f && this.plugin.containsEntity(this.fleet)) {
                    this.triggered = true;
                }
                if (!this.triggered) break block20;
                if (burn < 50.0f) {
                    this.plugin.despawn(0.0f, 0.2f, new Random());
                    this.abort();
                    return;
                }
                AbilityPlugin gs = this.fleet.getAbility("generate_slipsurge");
                if (gs instanceof BaseAbilityPlugin) {
                    BaseAbilityPlugin base = (BaseAbilityPlugin)gs;
                    for (AbilityPlugin curr : this.fleet.getAbilities().values()) {
                        if (curr == this || base.isCompatible(curr)) continue;
                        if (curr.isActiveOrInProgress()) {
                            curr.deactivate();
                        }
                        curr.forceDisable();
                    }
                }
                float decelMult = Misc.getAbyssalDepth(this.fleet) * 1.0f;
                if (this.fleet.getGoSlowOneFrame()) {
                    decelMult = 1.0f;
                }
                if (decelMult > 0.0f && !this.plugin.containsEntity(this.fleet)) {
                    float angle = Misc.getAngleInDegrees(this.fleet.getVelocity());
                    Vector2f decelDir = Misc.getUnitVectorAtDegreeAngle(angle + 180.0f);
                    float targetDecelSeconds = 0.5f;
                    float speed = this.fleet.getVelocity().length();
                    float decelAmount = amount * speed / targetDecelSeconds;
                    decelDir.scale(decelAmount * decelMult);
                    Vector2f vel = this.fleet.getVelocity();
                    this.fleet.setVelocity(vel.x + decelDir.x, vel.y + decelDir.y);
                }
                this.fleet.fadeOutIndicator();
                this.fleet.setNoEngaging(0.1f);
                this.fleet.setInteractionTarget(null);
                if (this.fleet.isPlayerFleet()) {
                    Global.getSector().getCampaignUI().setFollowingDirectCommand(true);
                }
                this.fleet.getMemoryWithoutUpdate().set("$noHighBurnTopographyReadings", true, 0.1f);
                this.fleet.getStats().getSensorRangeMod().modifyMult(SENSOR_MOD_ID, SENSOR_RANGE_MULT, "Extreme burn level");
                this.didTempCleanup = false;
                float angle = Misc.getAngleInDegrees(this.fleet.getVelocity());
                Vector2f jitterDir = Misc.getUnitVectorAtDegreeAngle(angle + 180.0f);
                Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(angle);
                float windIntensity = (burn - 50.0f) / 250.0f;
                if (windIntensity < 0.0f) {
                    windIntensity = 0.0f;
                }
                if ((b = (burn - 50.0f) / 450.0f) < 0.0f) {
                    b = 0.0f;
                }
                if (b > 1.0f) {
                    b = 1.0f;
                }
                if (b > 0.0f) {
                    if (this.fleet.isPlayerFleet()) {
                        float volume = b;
                        Global.getSector().getCampaignUI().suppressMusic(TRANSIT_MUSIC_SUPPRESSION * volume);
                        Global.getSoundPlayer().setNextLoopFadeInAndOut(0.05f, 0.5f);
                        Global.getSoundPlayer().playLoop(TRANSIT_SOUND_LOOP, this.fleet, 1.0f, volume, this.fleet.getLocation(), this.fleet.getVelocity());
                    }
                    for (FleetMemberViewAPI view : this.fleet.getViews()) {
                        Color c = view.getMember().getHullSpec().getHyperspaceJitterColor();
                        c = Misc.setAlpha(c, 60);
                        view.setJitter(0.1f, 1.0f, c, 10 + Math.round(40.0f * b), 20.0f);
                        view.setUseCircularJitter(true);
                        view.setJitterDirection(jitterDir);
                        view.setJitterLength(30.0f * b);
                        view.setJitterBrightness(b);
                    }
                } else {
                    for (FleetMemberViewAPI view : this.fleet.getViews()) {
                        view.endJitter();
                    }
                }
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }

    public static class SlipsurgeFadeInScript
    implements EveryFrameScript {
        protected SlipstreamTerrainPlugin2 plugin;
        protected boolean done = false;
        protected int index = 0;
        protected float elapsed = 0.0f;
        protected float maxElapsed = 0.0f;

        public SlipsurgeFadeInScript(SlipstreamTerrainPlugin2 plugin) {
            this.plugin = plugin;
            float fadeInLength = 300.0f;
            float lengthSoFar = 0.0f;
            float durIn = 0.2f;
            this.maxElapsed = durIn * (float)plugin.getSegments().size() * 0.34f + 3.0f;
            for (SlipstreamTerrainPlugin2.SlipstreamSegment seg : plugin.getSegments()) {
                seg.fader.setDurationIn(durIn);
                seg.fader.forceOut();
                seg.bMult = Math.min(1.0f, lengthSoFar / fadeInLength);
                lengthSoFar += seg.lengthToNext;
            }
        }

        @Override
        public void advance(float amount) {
            if (this.done) {
                return;
            }
            if (!this.plugin.getEntity().isInCurrentLocation()) {
                for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : this.plugin.getSegments()) {
                    curr.fader.fadeIn();
                }
                this.done = true;
                return;
            }
            this.elapsed += amount;
            if (this.index >= this.plugin.getSegments().size() || this.elapsed > this.maxElapsed) {
                this.done = true;
                return;
            }
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = this.plugin.getSegments().get(this.index);
            if (curr.fader.isFadedIn()) {
                ++this.index;
                return;
            }
            curr.fader.fadeIn();
            if (curr.fader.getBrightness() > 0.33f && this.index < this.plugin.getSegments().size() - 1) {
                this.plugin.getSegments().get((int)(this.index + 1)).fader.fadeIn();
            }
            if (curr.fader.getBrightness() > 0.67f && this.index < this.plugin.getSegments().size() - 2) {
                this.plugin.getSegments().get((int)(this.index + 2)).fader.fadeIn();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }
}

