/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseToggleAbility;
import com.fs.starfarer.api.impl.campaign.abilities.GraviticScanData;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GraviticScanAbility
extends BaseToggleAbility {
    public static float SLIPSTREAM_DETECTION_RANGE = 20000.0f;
    public static String COMMODITY_ID = "volatiles";
    public static float COMMODITY_PER_DAY = 1.0f;
    public static float DETECTABILITY_PERCENT = 50.0f;
    protected float phaseAngle;
    protected GraviticScanData data = null;
    protected transient SpriteAPI texture;

    @Override
    protected String getActivationText() {
        if (COMMODITY_ID != null && this.getFleet() != null && this.getFleet().getCargo().getCommodityQuantity(COMMODITY_ID) <= 0.0f && (!Global.getSettings().isDevMode() || Global.getSettings().getBoolean("playtestingMode"))) {
            return null;
        }
        return "Neutrino detector activated";
    }

    @Override
    protected String getDeactivationText() {
        return null;
    }

    @Override
    protected void activateImpl() {
    }

    @Override
    public boolean showProgressIndicator() {
        return false;
    }

    @Override
    public boolean showActiveIndicator() {
        return this.isActive();
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color bad = Misc.getNegativeHighlightColor();
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (off)";
        if (this.turnedOn) {
            status = " (on)";
        }
        if (!Global.CODEX_TOOLTIP_MODE) {
            LabelAPI title = tooltip.addTitle(String.valueOf(this.spec.getName()) + status);
            title.highlightLast(status);
            title.setHighlightColor(gray);
        } else {
            tooltip.addSpacer(-10.0f);
        }
        float pad = 10.0f;
        tooltip.addPara("Reconfigures the fleet's drive field to act as a neutrino detector, allowing detection of human-made artifacts - and occasionally fleets - at extreme ranges. ", pad);
        tooltip.addSectionHeading("Normal space", Alignment.MID, pad);
        tooltip.addPara("High-emission sources such as stars, planets, jump-points, or space stations produce constant streams. Average sources produce periodic bursts. Low-emission sources produce occasional bursts.", pad);
        tooltip.addPara("Notoriously unreliable and almost guaranteed to produce numerous false readings.", pad);
        if (COMMODITY_ID != null) {
            String unit = "unit";
            if (COMMODITY_PER_DAY != 1.0f) {
                unit = "units";
            }
            CommoditySpecAPI spec = this.getCommodity();
            unit = String.valueOf(unit) + " of " + spec.getName().toLowerCase();
            tooltip.addPara("Increases the range at which the fleet can be detected by %s and consumes %s " + unit + " per day.", pad, highlight, (int)DETECTABILITY_PERCENT + "%", Misc.getRoundedValueMaxOneAfterDecimal(COMMODITY_PER_DAY));
        } else {
            tooltip.addPara("Increases the range at which the fleet can be detected by %s.", pad, highlight, (int)DETECTABILITY_PERCENT + "%");
        }
        int maxRange = Math.round(SLIPSTREAM_DETECTION_RANGE / Misc.getUnitsPerLightYear());
        tooltip.addSectionHeading("Hyperspace", Alignment.MID, pad);
        tooltip.addPara("Reliably detects the presence of slipstreams out to a range of %s light-years. Except for abyssal areas, the background noise levels are such that it is unable to detect any other neutrino sources. When the fleet is traversing a slipstream, the detector is overwhelmed and shuts down.", pad, highlight, "" + maxRange);
        if (!Global.CODEX_TOOLTIP_MODE && Misc.isInsideSlipstream(this.getFleet())) {
            tooltip.addPara("Cannot activate while inside slipstream.", bad, pad);
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return EnumSet.of(CampaignEngineLayers.ABOVE);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.data != null && !this.isActive() && this.getProgressFraction() <= 0.0f) {
            this.data = null;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().modifyPercent(this.getModId(), DETECTABILITY_PERCENT * level, "Gravimetric scan");
        float days = Global.getSector().getClock().convertToDays(amount);
        this.phaseAngle += days * 360.0f * 10.0f;
        this.phaseAngle = Misc.normalizeAngle(this.phaseAngle);
        if (this.data == null) {
            this.data = new GraviticScanData(this);
        }
        this.data.advance(days);
        if (COMMODITY_ID != null) {
            float cost = days * COMMODITY_PER_DAY;
            if (fleet.getCargo().getCommodityQuantity(COMMODITY_ID) > 0.0f || Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
                fleet.getCargo().removeCommodity(COMMODITY_ID, cost);
            } else {
                CommoditySpecAPI spec = this.getCommodity();
                fleet.addFloatingText("Out of " + spec.getName().toLowerCase(), Misc.setAlpha(this.entity.getIndicatorColor(), 255), 0.5f);
                this.deactivate();
            }
        }
        if (Misc.isInsideSlipstream(fleet)) {
            this.deactivate();
        }
    }

    public CommoditySpecAPI getCommodity() {
        return Global.getSettings().getCommoditySpec(COMMODITY_ID);
    }

    @Override
    public boolean isUsable() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return false;
        }
        return !Misc.isInsideSlipstream(fleet);
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
    }

    public float getRingRadius() {
        return this.getFleet().getRadius() + 75.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (this.data == null) {
            return;
        }
        float level = this.getProgressFraction();
        if (level <= 0.0f) {
            return;
        }
        if (this.getFleet() == null) {
            return;
        }
        if (!this.getFleet().isPlayerFleet()) {
            return;
        }
        float alphaMult = viewport.getAlphaMult() * level;
        float bandWidthInTexture = 256.0f;
        float radStart = this.getRingRadius();
        float radEnd = radStart + 75.0f;
        float circ = (float)(Math.PI * 2 * (double)(radStart + radEnd) / 2.0);
        float pixelsPerSegment = circ / 360.0f;
        float segments = Math.round(circ / pixelsPerSegment);
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Math.abs(endRad - startRad);
        float anglePerSegment = spanRad / segments;
        Vector2f loc = this.getFleet().getLocation();
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glEnable((int)3553);
        if (this.texture == null) {
            this.texture = Global.getSettings().getSprite("abilities", "neutrino_detector");
        }
        this.texture.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        boolean outlineMode = false;
        if (outlineMode) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        float thickness = (radEnd - radStart) * 1.0f;
        float radius = radStart;
        float texProgress = 0.0f;
        float texHeight = this.texture.getTextureHeight();
        float imageHeight = this.texture.getHeight();
        float texPerSegment = pixelsPerSegment * texHeight / imageHeight * bandWidthInTexture / thickness;
        float totalTex = Math.max(1.0f, (float)Math.round((texPerSegment *= 1.0f) * segments));
        texPerSegment = totalTex / segments;
        float texWidth = this.texture.getTextureWidth();
        float imageWidth = this.texture.getWidth();
        Color color = new Color(25, 215, 255, 255);
        int iter = 0;
        while (iter < 2) {
            float bandIndex;
            if (iter == 0) {
                bandIndex = 1.0f;
            } else {
                bandIndex = 0.0f;
                texProgress = segments / 2.0f * texPerSegment;
            }
            if (iter == 1) {
                GL11.glBlendFunc((int)770, (int)1);
            }
            float leftTX = bandIndex * texWidth * bandWidthInTexture / imageWidth;
            float rightTX = (bandIndex + 1.0f) * texWidth * bandWidthInTexture / imageWidth - 0.001f;
            GL11.glBegin((int)8);
            float i = 0.0f;
            while (i < segments + 1.0f) {
                float segIndex = i % (float)((int)segments);
                float phaseAngleRad = iter == 0 ? (float)Math.toRadians(this.phaseAngle) + segIndex * anglePerSegment * 29.0f : (float)Math.toRadians(-this.phaseAngle) + segIndex * anglePerSegment * 17.0f;
                float angle = (float)Math.toDegrees(segIndex * anglePerSegment);
                float pulseSin = (float)Math.sin(phaseAngleRad);
                float pulseMax = thickness * 0.5f;
                pulseMax = thickness * 0.2f;
                pulseMax = 10.0f;
                float pulseAmount = pulseSin * pulseMax;
                float pulseInner = pulseAmount * 0.1f;
                float r = radius;
                float theta = anglePerSegment * segIndex;
                float cos = (float)Math.cos(theta);
                float sin = (float)Math.sin(theta);
                float rInner = r - pulseInner;
                float rOuter = r + thickness - pulseAmount;
                float grav = this.data.getDataAt(angle);
                if (grav > 750.0f) {
                    grav = 750.0f;
                }
                grav *= 0.33333334f;
                float alpha = alphaMult;
                float x1 = cos * rInner;
                float y1 = sin * rInner;
                float x2 = cos * (rOuter += (grav *= level));
                float y2 = sin * rOuter;
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult * (alpha *= 0.25f + Math.min(grav / 100.0f, 0.75f)))));
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)(x2 += (float)(Math.cos(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f)), (float)(y2 += (float)(Math.sin(phaseAngleRad) * (double)pixelsPerSegment * (double)0.33f)));
                texProgress += texPerSegment * 1.0f;
                i += 1.0f;
            }
            GL11.glEnd();
            ++iter;
        }
        GL11.glPopMatrix();
        if (outlineMode) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }
}

