/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitalStationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.abilities.GraviticScanAbility;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class GraviticScanData {
    private GraviticScanAbility ability;
    private int resolution = 360;
    private transient float[] data;
    private List<GSPing> pings = new ArrayList<GSPing>();
    private IntervalUtil planetInterval = new IntervalUtil(0.01f, 0.01f);
    private IntervalUtil specialInterval = new IntervalUtil(0.075f, 0.125f);
    private int initialCount = 0;
    private List<SectorEntityToken> special = new ArrayList<SectorEntityToken>();

    public GraviticScanData(GraviticScanAbility ability) {
        this.ability = ability;
    }

    public void advance(float days) {
        if (this.ability.getFleet() == null || this.ability.getFleet().getContainingLocation() == null) {
            return;
        }
        Iterator<GSPing> iter = this.pings.iterator();
        while (iter.hasNext()) {
            GSPing ping = iter.next();
            ping.advance(days);
            if (!ping.isDone()) continue;
            iter.remove();
        }
        this.planetInterval.advance(days);
        if (this.planetInterval.intervalElapsed()) {
            this.maintainHighSourcePings();
        }
        this.specialInterval.advance(days);
        if (this.specialInterval.intervalElapsed()) {
            this.doSpecialPings();
        }
        this.updateData();
    }

    public void updateData() {
        this.data = new float[this.resolution];
        float max = 0.0f;
        float incr = 360.0f / (float)this.resolution;
        for (GSPing ping : this.pings) {
            float b = ping.fader.getBrightness();
            if (b <= 0.0f) continue;
            float arc = ping.arc;
            float mid = ping.angle;
            float half = (float)Math.ceil(0.5f * arc / incr);
            float i = -half;
            while (i <= half) {
                float curr = mid + incr * i;
                int index = this.getIndex(curr);
                float intensity = 1.0f - Math.abs(i / half);
                intensity *= intensity;
                float value = ping.grav * intensity * b;
                int n = index;
                this.data[n] = this.data[n] + value;
                i += 1.0f;
            }
        }
    }

    public float getDataAt(float angle) {
        if (this.data == null) {
            return 0.0f;
        }
        int index = this.getIndex(angle);
        return this.data[index];
    }

    public int getIndex(float angle) {
        angle = Misc.normalizeAngle(angle);
        int index = (int)Math.floor((float)this.resolution * angle / 360.0f);
        return index;
    }

    public void doSpecialPings() {
        CampaignFleetAPI fleet = this.ability.getFleet();
        boolean abyss = Misc.isInAbyss(fleet);
        if (fleet.isInHyperspace() && !abyss) {
            return;
        }
        Vector2f loc = fleet.getLocation();
        LocationAPI location = fleet.getContainingLocation();
        float neutrinoLowSkipProb = 0.8f;
        if (this.special.isEmpty()) {
            for (Object object : location.getEntities(CustomCampaignEntityAPI.class)) {
                SectorEntityToken entity;
                boolean neutrinoHigh;
                if (!(object instanceof SectorEntityToken) || (neutrinoHigh = (entity = (SectorEntityToken)object).hasTag("neutrino_high")) || abyss && !Misc.isInAbyss(entity)) continue;
                boolean neutrino = entity.hasTag("neutrino");
                boolean neutrinoLow = entity.hasTag("neutrino_low");
                boolean station = entity.hasTag("station");
                if (!neutrino && !neutrinoLow && !station || neutrinoLow && (float)Math.random() < neutrinoLowSkipProb) continue;
                this.special.add(entity);
            }
            for (CampaignFleetAPI curr : location.getFleets()) {
                boolean neutrinoHigh;
                if (fleet == curr || (neutrinoHigh = curr.hasTag("neutrino_high")) || abyss && !Misc.isInAbyss(fleet) || (float)Math.random() < neutrinoLowSkipProb) continue;
                this.special.add(curr);
            }
            this.initialCount = this.special.size();
        }
        int batch = (int)Math.ceil((float)this.initialCount / 1.0f);
        int i = 0;
        while (i < batch) {
            if (this.special.isEmpty()) break;
            SectorEntityToken curr = this.special.remove(0);
            float dist = Misc.getDistance(loc, curr.getLocation());
            float arc = Misc.computeAngleSpan(curr.getRadius(), dist);
            if ((arc *= 2.0f) < 15.0f) {
                arc = 15.0f;
            }
            if (arc > 150.0f) {
                arc = 150.0f;
            }
            float angle = Misc.getAngleInDegrees(loc, curr.getLocation());
            float g = this.getGravity(curr);
            float in = 0.05f + 0.1f * (float)Math.random();
            float out = in *= 0.25f;
            GSPing ping = new GSPing(angle, arc, g *= this.getRangeGMult(dist), in, out *= 2.0f);
            ping.withSound = true;
            this.pings.add(ping);
            ++i;
        }
        long seed = (long)(location.getLocation().x * 1300000.0f + location.getLocation().y * 3700000.0f + 1.2133242E12f);
        Random random = new Random(seed);
        int numFalse = random.nextInt(5);
        int i2 = 0;
        while (i2 < numFalse) {
            boolean constant;
            boolean bl = constant = random.nextFloat() > 0.25f;
            if (!constant && (float)Math.random() < neutrinoLowSkipProb) {
                random.nextFloat();
                random.nextFloat();
            } else {
                float arc = 15.0f;
                float angle = random.nextFloat() * 360.0f;
                float in = 0.05f + 0.1f * (float)Math.random();
                float out = in *= 0.25f;
                float g = 80.0f + random.nextFloat() * 60.0f;
                GSPing ping = new GSPing(angle, arc, g, in, out *= 2.0f);
                ping.withSound = true;
                this.pings.add(ping);
            }
            ++i2;
        }
    }

    public float getRangeGMult(float range) {
        float max;
        if ((range -= 3000.0f) < 0.0f) {
            range = 0.0f;
        }
        if (range > (max = 15000.0f)) {
            range = max;
        }
        return 1.0f - 0.85f * range / max;
    }

    public void maintainSlipstreamPings() {
        CampaignFleetAPI fleet = this.ability.getFleet();
        Vector2f loc = fleet.getLocation();
        LocationAPI location = fleet.getContainingLocation();
        float range = GraviticScanAbility.SLIPSTREAM_DETECTION_RANGE;
        if (Misc.isInsideSlipstream(fleet) || Misc.isInAbyss(fleet)) {
            return;
        }
        for (CampaignTerrainAPI ter : location.getTerrainCopy()) {
            float dist;
            SlipstreamTerrainPlugin2 plugin;
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2) || (plugin = (SlipstreamTerrainPlugin2)ter.getPlugin()).containsEntity(fleet)) continue;
            ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment> inRange = new ArrayList<SlipstreamTerrainPlugin2.SlipstreamSegment>();
            List<SlipstreamTerrainPlugin2.SlipstreamSegment> near = plugin.getSegmentsNear(loc, range);
            int skip = 0;
            for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : near) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (curr.bMult <= 0.0f || !((dist = Misc.getDistance(loc, curr.loc)) < range)) continue;
                inRange.add(curr);
                skip = 5;
            }
            if (inRange.isEmpty()) continue;
            for (SlipstreamTerrainPlugin2.SlipstreamSegment curr : inRange) {
                float in;
                dist = Misc.getDistance(loc, curr.loc);
                float arc = Misc.computeAngleSpan(curr.width, dist);
                if ((arc *= 2.0f) > 150.0f) {
                    arc = 150.0f;
                }
                if (arc < 20.0f) {
                    arc = 20.0f;
                }
                float angle = Misc.getAngleInDegrees(loc, curr.loc);
                float g = 500.0f;
                g *= 0.1f;
                float out = in = this.planetInterval.getIntervalDuration() * 5.0f;
                GSPing ping = new GSPing(angle, arc, g *= this.getRangeGMult(dist), in, out);
                this.pings.add(ping);
            }
        }
    }

    public void maintainHighSourcePings() {
        SectorEntityToken entity;
        CampaignFleetAPI fleet = this.ability.getFleet();
        Vector2f loc = fleet.getLocation();
        LocationAPI location = fleet.getContainingLocation();
        this.maintainSlipstreamPings();
        boolean abyss = Misc.isInAbyss(fleet);
        if (fleet.isInHyperspace() && !abyss) {
            return;
        }
        ArrayList<PlanetAPI> all = new ArrayList<PlanetAPI>(location.getPlanets());
        for (Object e : location.getEntities(CustomCampaignEntityAPI.class)) {
            boolean neutrinoHigh;
            if (!(e instanceof SectorEntityToken)) continue;
            entity = (SectorEntityToken)e;
            if (abyss && !Misc.isInAbyss(entity) || !(neutrinoHigh = entity.hasTag("neutrino_high"))) continue;
            all.add((PlanetAPI)entity);
        }
        for (CampaignFleetAPI campaignFleetAPI : location.getFleets()) {
            boolean neutrinoHigh;
            if (fleet == campaignFleetAPI || abyss && !Misc.isInAbyss(fleet) || !(neutrinoHigh = campaignFleetAPI.hasTag("neutrino_high"))) continue;
            all.add((PlanetAPI)((Object)campaignFleetAPI));
        }
        for (Object object : location.getEntities(OrbitalStationAPI.class)) {
            if (!(object instanceof SectorEntityToken)) continue;
            entity = (SectorEntityToken)object;
            if (abyss && !Misc.isInAbyss(entity)) continue;
            all.add((PlanetAPI)entity);
        }
        for (Object object : location.getJumpPoints()) {
            if (!(object instanceof SectorEntityToken)) continue;
            entity = (SectorEntityToken)object;
            if (abyss && !Misc.isInAbyss(entity)) continue;
            all.add((PlanetAPI)entity);
        }
        for (SectorEntityToken sectorEntityToken : all) {
            float in;
            PlanetAPI planet;
            if (sectorEntityToken instanceof PlanetAPI && (planet = (PlanetAPI)sectorEntityToken).getSpec().isNebulaCenter() || sectorEntityToken.getRadius() <= 0.0f) continue;
            float dist = Misc.getDistance(loc, sectorEntityToken.getLocation());
            float arc = Misc.computeAngleSpan(sectorEntityToken.getRadius(), dist);
            if ((arc *= 2.0f) > 150.0f) {
                arc = 150.0f;
            }
            if (arc < 20.0f) {
                arc = 20.0f;
            }
            float angle = Misc.getAngleInDegrees(loc, sectorEntityToken.getLocation());
            float g = this.getGravity(sectorEntityToken);
            g *= 0.1f;
            if (sectorEntityToken.hasTag("neutrino_high") || sectorEntityToken instanceof OrbitalStationAPI) {
                g *= 2.0f;
            }
            float out = in = this.planetInterval.getIntervalDuration() * 5.0f;
            GSPing ping = new GSPing(angle, arc, g *= this.getRangeGMult(dist), in, out);
            this.pings.add(ping);
        }
    }

    public float getGravity(SectorEntityToken entity) {
        float g = entity.getRadius();
        if (entity instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)entity;
            g *= 2.0f;
            if (planet.getSpec().isBlackHole()) {
                g *= 2.0f;
            }
        }
        if (entity instanceof OrbitalStationAPI && (g *= 4.0f) > 200.0f) {
            g = 200.0f;
        }
        if (entity instanceof CustomCampaignEntityAPI && (g *= 4.0f) > 200.0f) {
            g = 200.0f;
        }
        if (entity instanceof CampaignFleetAPI && (g *= 2.0f) > 200.0f) {
            g = 200.0f;
        }
        return g;
    }

    public static class GSPing {
        public float arc;
        public float angle;
        public float grav;
        public FaderUtil fader;
        public boolean withSound = false;

        public GSPing(float angle, float arc, float grav, float in, float out) {
            this.arc = arc;
            this.angle = angle;
            this.grav = grav;
            this.fader = new FaderUtil(0.0f, in, out, false, true);
            this.fader.fadeIn();
        }

        public void advance(float days) {
            this.fader.advance(days);
            if (this.withSound && this.fader.getBrightness() >= 0.5f) {
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(this.angle);
                float dist = 1000.0f + (1.0f - Math.min(1.0f, this.grav / 200.0f)) * 1450.0f;
                loc.scale(dist);
                Vector2f.add((Vector2f)loc, (Vector2f)Global.getSector().getPlayerFleet().getLocation(), (Vector2f)loc);
                Global.getSoundPlayer().playSound("ui_neutrino_detector_ping", 1.0f, 1.0f, loc, new Vector2f());
                this.withSound = false;
            }
        }

        public boolean isDone() {
            return this.fader.isFadedOut();
        }
    }
}

